#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#include "stdfile.h"

#define MAX_OPEN_FILE 16

//#define USE_DEBUGLOG

static int first_init = 1;
void DEBUGLOG( char * str , ... );
char * BaseDirectory;

typedef struct _FILE_HANDLE {
	int    use;
	HANDLE fp;
	int    eof;
	int    error;
} FILE_HANDLE;
	
FILE_HANDLE	FH[MAX_OPEN_FILE];

FILE * ngs_fopen(const char * name, const char * type)
{
	int i;
	int dwDesiredAccess;
	int dwCreationDispostion;
	wchar_t	wname[512];

	DEBUGLOG("ngs_fopen start name[%s]\n",name);

	if( first_init ){
		first_init = 0;
		memset( FH, '\0', sizeof(FILE_HANDLE) * MAX_OPEN_FILE );
	}

	if (type[0]=='w' ) { 
		DEBUGLOG("ngs_fopen type[w] \n");
		dwDesiredAccess = GENERIC_WRITE;	
		dwCreationDispostion = OPEN_ALWAYS;		
	}else if( type[0]=='r' ){
		DEBUGLOG("ngs_fopen type[r] \n");
		dwDesiredAccess = GENERIC_READ;
		dwCreationDispostion = OPEN_EXISTING;
	}else if (type[0]=='a' ) { 
		DEBUGLOG("ngs_fopen type[a] \n");
		dwDesiredAccess = GENERIC_WRITE;
		dwCreationDispostion = OPEN_ALWAYS;
	}else{
		DEBUGLOG("ngs_fopen type[unknown] \n");
		return NULL;
	}

	for( i =1;i<MAX_OPEN_FILE;i++ ){
		if( !FH[i].use ) break;
	}
	DEBUGLOG("ngs_fopen FH[%d] \n", i);

	mbstowcs( wname, name, 512 );

	FH[i].fp = CreateFile( wname, 
				dwDesiredAccess,
				0,					// no shared
				NULL,				// set NULL
				dwCreationDispostion,
				FILE_ATTRIBUTE_NORMAL |	FILE_FLAG_RANDOM_ACCESS,
				0 );

	if( FH[i].fp != NULL ){
		FH[i].use=1;
		FH[i].eof=0;
		FH[i].error=0;
	}

	if( type[0]=='a' ) {
		ngs_fseek( (FILE *)i, 0, SEEK_END );
	}

	DEBUGLOG("ngs_fopen end\n");
	return (FILE *) i;
}

int ngs_fclose(FILE * fp)
{
	DEBUGLOG("ngs_fclose start FH[%d]\n", (int)fp );
	CloseHandle( FH[(int)fp].fp );
	FH[(int)fp].use = 0;
	FH[(int)fp].eof = 0;
	FH[(int)fp].error = 0;
	DEBUGLOG("ngs_fclose end \n");
	return 0;
}

size_t ngs_fread(void *buffer, size_t size, size_t count, FILE * fp )
{
	BOOL ret;
	DWORD rcount;
	DEBUGLOG("ngs_fread start FH[%d]\n", (int)fp );

	ret = ReadFile( FH[(int)fp].fp , buffer, size * count, &rcount, NULL );
	if( ret ){
		DEBUGLOG("ngs_fread normal end ret[%d]\n", (size_t)rcount/size );
		return (size_t)rcount/size;
	}else{
		DEBUGLOG("ngs_fread error? end ret[0]\n" );
		return 0;
	}
}

size_t ngs_fwrite( const void *buffer, size_t size, size_t count, FILE *fp )
{
	BOOL ret;
	DWORD rcount;

	DEBUGLOG("ngs_fwrite start ret[%d]\n", (int)fp );

	ret = WriteFile( FH[(int)fp].fp, buffer, size * count, &rcount, NULL ); 
	if( ret ){
		DEBUGLOG("ngs_fwrite normal end ret[%d]\n", (size_t)rcount/size );
		return (size_t)rcount/size;
	}else{
		DEBUGLOG("ngs_fwrite error? end ret[0]\n");
		return 0;
	}
}

int ngs_fseek( FILE *stream, long offset, int origin )
{
	DWORD ret;
	DWORD mmethod; 

	DEBUGLOG("ngs_fseek start FH[%d]\n", (int)stream );
	
	switch( origin ){
		case SEEK_SET : mmethod = FILE_BEGIN;	break;
		case SEEK_CUR : mmethod = FILE_CURRENT;	break;
		case SEEK_END : mmethod = FILE_END;		break;
	}

	ret = SetFilePointer( FH[(int)stream].fp, offset, NULL, mmethod );

	if( ret != 0xFFFFFFFF ){	
		DEBUGLOG("ngs_fseek normal end ret[0]\n" );
		FH[(int)stream].eof = 0;
		FH[(int)stream].error = 0;
		return 0;
	}else{
		DEBUGLOG("ngs_fseek error end ret[1]\n" );
		return 1;
	}
}

int ngs_fscanf(FILE * fp, const char * first , ...)
{
	DEBUGLOG( "fscanf function is not impliment.\n" );
	return 0;
}

int ngs_fprintf(FILE * fp, const char * first, ...)
{
	va_list marker;
	char buf[1024];
	DEBUGLOG("ngs_fprintf start FH[%d]\n",(int)fp );

	va_start( marker, first );     /* ό̈̏ */
	vsprintf( buf,first,marker );
	va_end( marker );

	ngs_fwrite( buf, 1, strlen(buf),fp );
	DEBUGLOG("ngs_fprintf end\n" );
	return 0;
}

int ngs_fgetc( FILE * fp )
{
	DWORD ret;
	DWORD rcount;
	char buffer;

	DEBUGLOG("ngs_fgetc start FH[%d]\n",(int)fp );
	
	ret = ReadFile( FH[(int)fp].fp , &buffer, 1, &rcount, NULL );
	if( ret ){
		if(rcount > 0){
			DEBUGLOG("ngs_fgetc end ret[%d]\n", (int)buffer );
			return (int)buffer;
		} else {
			DEBUGLOG("ngs_fgetc end ret[EOF]\n" );
		}
	}else{
		DEBUGLOG("ngs_fgetc error end\n" );
		FH[(int)fp].error = 1;
	}
	FH[(int)fp].eof = 1;
	return EOF;
}

char * ngs_fgets( char * str , int n, FILE * fp )
{
	DWORD ret;
	int i;
	unsigned long rcount;

	DEBUGLOG("ngs_fgets start FH[%d]\n",(int)fp );

	str[0] = '\0';
	for(i=0;i<n;i++){
		ret = ReadFile( FH[(int)fp].fp , &str[i], 1, &rcount, NULL );
		if( ret ){
			if(str[i]=='\n'){
				str[i+1] = '\0';
				break;
			}else if(rcount==0){
				str[i]='\0';
				FH[(int)fp].eof = 1;
				break;
			}
		}else{
			str[0]='\0';
			FH[(int)fp].error = 1;
			break;
		}
	}			
	DEBUGLOG("ngs_fgets end ret[%s]\n",str );
	if( str[0] == '\0' ) return NULL;
					else return str;
}

int ngs_fputc(int c,  FILE * fp )
{
	int ret;
	unsigned long rcount;
	unsigned char buf = (unsigned char)c;

	ret = WriteFile( FH[(int)fp].fp , &buf, 1, &rcount, NULL );
	if( ret ){
		if( rcount ){
			return c;
		}
	}
	return EOF;
}

int ngs_ftell( FILE * fp )
{
	return SetFilePointer(FH[(int)fp].fp, 0,NULL,FILE_CURRENT );
}

int ngs_feof( FILE * fp )
{
	return FH[(int)fp].eof;
}

int ngs_ferror( FILE * fp )
{
	return FH[(int)fp].error;
}

void DEBUGLOG( char * str , ... )
{
#ifdef USE_DEBUGLOG
	HANDLE fp;
	int ret;
	int rcount;
	va_list marker;
	char buf[1024];

#ifdef POPOPE
	fp = CreateFile( _T("\\MultiMedia Card\\nes\\debug.log"), 
#else
	fp = CreateFile( _T("\\storage card\\debug.log"), 
#endif
				GENERIC_WRITE,
				0,					// no shared
				NULL,				// set NULL
				OPEN_ALWAYS,
				FILE_ATTRIBUTE_NORMAL |	FILE_FLAG_RANDOM_ACCESS,
				0 );

	SetFilePointer(fp, 0,NULL,FILE_END );

	va_start( marker, str );     /* ό̈̏ */
	vsprintf( buf,str,marker );
	va_end( marker );

	ret = WriteFile( fp, buf, strlen(buf), &rcount, NULL ); 

	CloseHandle( fp );

#endif
}

//==========================================================
// GetOpenFileName
// USE CDQ.DLL
//==========================================================
HINSTANCE g_hModuleCDQ = 0;
int (pascal *FileDialog) (HWND,TCHAR*,TCHAR*,int);
int CDQ_LoadLibrary();
void CDQ_FreeLibrary();

int ngs_GetOpenFileName(HWND hWnd, LPTSTR fname )
{
	TCHAR name2[MAX_PATH];
	int ret;

	DEBUGLOG( "OpenNewGame Start\n" );

	name2[0] = 0;

//	if( fname == 0 ){
		// CDQ [h
		if (!CDQ_LoadLibrary()) {
			CDQ_FreeLibrary();
			MessageBox (hWnd, _T("CDQ[hł܂"), NULL, MB_OK);
		}

		DEBUGLOG( "OpenNewGame 1\n" );

		// convert default rom dir
//		for(i = 0; gDefaultDir[i] != 0; i++)
//			name2[i] = (TCHAR)gDefaultDir[i];
//		name2[i] = 0;
		wcscat( name2, _T("\\") );

		DEBUGLOG( "OpenNewGame 2\n" );

	    ret = FileDialog (		//߂lFIDOK/IDCANCEL
			hWnd, 				//(i):eEChEEnh
			_T("ROM Select"),//(i):^Cg
			name2,			//(i/o):t@C
			1 );			//(i):݂t@Ĉ=1

		// CDQ J
		CDQ_FreeLibrary();
//	}else{
//		ret=IDOK;
//		wcscpy( name2, fname );
//	}
	DEBUGLOG( "OpenNewGame 3 FileDialog ret =[%d]\n", ret );
    
	if( ret==IDOK ){
		DEBUGLOG( "OpenNewGame 4\n" );
//		len = wcslen(name2);
//		wcstombs(fname, name2, len + 1);
		wcscpy( fname, name2 );
	};
	DEBUGLOG( "OpenNewGame END\n" );
	return (ret==IDOK?1:0); 
}


//---------------------------------------------------------------
// CDQ 
int CDQ_LoadLibrary()
{
	// DLL擾iWindowsfBNgɖƂ̓tpXŎw肷j
	g_hModuleCDQ = LoadLibrary (_T("CDQ.DLL"));
	if (g_hModuleCDQ == 0) {
		return FALSE;
	}

  FileDialog = (int (pascal *) (HWND,TCHAR*,TCHAR*,int)) 
			GetProcAddress (g_hModuleCDQ, TEXT("FileDialog"));
	if (FileDialog == 0) return FALSE;	//G[

	return TRUE;
}


//---------------------------------------------------------------
// CDQ ㏈
void CDQ_FreeLibrary()
{
	// DLLJ
	if (g_hModuleCDQ)
		FreeLibrary (g_hModuleCDQ);
	g_hModuleCDQ = 0;
}
//---------------------------------------------------------------
