/*===================================================================*/
/*                                                                   */
/*  InfoNES_System_Wce.cpp : WindowsCE specific File                 */
/*                                                                   */
/*  2001/12/08  Mopeo                                                */
/*                                                                   */
/*===================================================================*/

#define VK_CASSIOPEIA_SLIDER	0x86
#define VK_CASSIOPEIA_ESC		0xC1
#define VK_CASSIOPEIA_REC		0xC2
#define VK_CASSIOPEIA_B1		0xC3
#define VK_CASSIOPEIA_B2		0xC4
#define VK_CASSIOPEIA_B3		0xC5
#define VK_CASSIOPEIA_LEFT		37
#define VK_CASSIOPEIA_UP		38
#define VK_CASSIOPEIA_RIGHT		39
#define VK_CASSIOPEIA_DOWN		40

/*-------------------------------------------------------------------*/
/*  Include files                                                    */
/*-------------------------------------------------------------------*/

#include <windows.h>
//#include <aygshell.h>
#include <Commctrl.h>
#include <Commdlg.h>
#include <stdlib.h>
#include <stdio.h>
#include <mmsystem.h>

//#include "gx.h"
//#pragma comment(lib, "gx.lib")

#include "InfoNES.h"
#include "InfoNES_System.h"
#include "InfoNES_pAPU.h"
#include "resource.h"

#include "stdfile.h"

/*-------------------------------------------------------------------*/
/*  ROM image file information                                       */
/*-------------------------------------------------------------------*/

char szRomName[ 256 ];
char szSaveName[ 256 ];
int nSRAM_SaveFlag;

/*-------------------------------------------------------------------*/
/*  Global Variables                                                 */
/*-------------------------------------------------------------------*/

TCHAR szAppName[] = TEXT("InfoNES Pocket PC Application");
TCHAR szTitle[]   = TEXT("InfoNES");

HWND m_hwnd;
HINSTANCE hinst;
//GXDisplayProperties g_gxdp;
HANDLE hthread = NULL;
DWORD threadid;
BOOL threadrun;
int Infones_Status = 0;
//static SHACTIVATEINFO s_sai;

#define N_BUFS 4
BYTE * final_wave[N_BUFS];
WAVEHDR hdr[N_BUFS];
BYTE * buf;
int cur_buf;

/*-------------------------------------------------------------------*/
/*  Function prototypes                                              */
/*-------------------------------------------------------------------*/

LRESULT CALLBACK MainWndproc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp);
int LoadSRAM();
int SaveSRAM();

/* Palette data */
WORD NesPalette[ 64 ];

DWORD NesPalette24[64] = { /* Matthew Conte's Palette */
	0x808080, 0x0000bb, 0x3700bf, 0x8400a6,
	0xbb006a, 0xb7001e, 0xb30000, 0x912600,
	0x7b2b00, 0x003e00, 0x00480d, 0x003c22,
	0x002f66, 0x000000, 0x050505, 0x050505,

	0xc8c8c8, 0x0059ff, 0x443cff, 0xb733cc,
	0xff33aa, 0xff375e, 0xff371a, 0xd54b00,
	0xc46200, 0x3c7b00, 0x1e8415, 0x009566,
	0x0084c4, 0x111111, 0x090909, 0x090909,

	0xffffff, 0x0095ff, 0x6f84ff, 0xd56fff,
	0xff77cc, 0xff6f99, 0xff7b59, 0xff915f,
	0xffa233, 0xa6bf00, 0x51d96a, 0x4dd5ae,
	0x00d9ff, 0x666666, 0x0d0d0d, 0x0d0d0d,

	0xffffff, 0x84bfff, 0xbbbbff, 0xd0bbff,
	0xffbfea, 0xffbfcc, 0xffc4b7, 0xffccae,
	0xffd9a2, 0xcce199, 0xaeeeb7, 0xaaf7ee,
	0xb3eeff, 0xdddddd, 0x111111, 0x111111
};

/*===================================================================*/
/*                                                                   */
/*                WinMain() : Application main                       */
/*                                                                   */
/*===================================================================*/

WORD *  g_vram;
HBITMAP g_hbitmap;

void GDIOpenDisplay()
{

	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;
	HANDLE  g_hDIB;

	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= NES_DISP_WIDTH;
	bi.biHeight			= -NES_DISP_HEIGHT;
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	g_hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( g_hDIB );
#else
	g_hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( g_hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	g_hbitmap = CreateDIBSection( NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&g_vram, NULL, 0 );

#if _WIN32_WCE >= 300
	GlobalUnlock( g_hDIB );
	GlobalFree( g_hDIB );
#else
	LocalUnlock( g_hDIB );
	LocalFree( g_hDIB );
#endif

}

void GDICloseDisplay()
{

	DeleteObject( g_hbitmap );
	
}

/* Application main */
int WINAPI WinMain(HINSTANCE hInstance,
				   HINSTANCE hPrevInstance,
				   LPWSTR lpCmdLine,
				   int CmdShow)
{
	MSG msg;
	WNDCLASS wc;
	OPENFILENAME ofn;
	TCHAR szFileName[256];
	HWND hwnd_infones = NULL;
	int i, y, x;
	BYTE r, g, b;
	DWORD temp;
	unsigned short *pusLine, *pusDest;

	/* łɎsĂ邩`FbN */
	hwnd_infones = FindWindow(szAppName, szTitle);
	if(hwnd_infones){
		SetForegroundWindow(hwnd_infones);
		return 0;
	}

	hinst = hInstance;
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = (WNDPROC)MainWndproc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hIcon = 0;
	wc.hInstance = hInstance;
	wc.hCursor = NULL;
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = szAppName;
	if(!RegisterClass(&wc)){
		return FALSE;
	}

	m_hwnd = CreateWindow(szAppName,
					szTitle,
					WS_VISIBLE,
					0,
					0,
					GetSystemMetrics(SM_CXSCREEN),
					GetSystemMetrics(SM_CYSCREEN),
					NULL, NULL, hInstance, NULL);
	if(!m_hwnd){
		return FALSE;
	}

#ifndef POPOPE
	/* t@C_CAOJ */
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.lpstrFilter = TEXT("NES files (*.nes)\0*.nes\0All files (*.*)\0*.*\0");
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = 256;
	ofn.Flags = OFN_EXPLORER;
	if(!GetOpenFileName(&ofn)){
		MessageBox(m_hwnd, TEXT("t@CIĂ"), szTitle, MB_ICONEXCLAMATION);
		return FALSE;
	}
	wcstombs(szRomName, szFileName, 256); /* UnicodeANSI */
#else
	if(!ngs_GetOpenFileName(m_hwnd,szFileName)){
		MessageBox(m_hwnd, TEXT("t@CIĂ"), szTitle, MB_ICONEXCLAMATION);
		return FALSE;
	}
	wcstombs(szRomName, szFileName, 256); /* UnicodeANSI */
#endif


	/* NESt@CJ */
	if(InfoNES_Load(szRomName) != 0){
		MessageBox(m_hwnd, TEXT("Ή̃t@Cł"), szTitle, MB_ICONEXCLAMATION);
		return FALSE;
	}
	LoadSRAM();

	ShowWindow(m_hwnd, CmdShow);
	UpdateWindow(m_hwnd);

	/* GAPI */
	GDIOpenDisplay();
/*
	if(!GXOpenDisplay(m_hwnd, GX_FULLSCREEN)){
		MessageBox(m_hwnd, TEXT("GXOpenDisplayG["), szTitle, MB_ICONEXCLAMATION);
		return FALSE;
	}
	g_gxdp = GXGetDisplayProperties();
	if(g_gxdp.cxWidth != 240 || g_gxdp.cyHeight != 320){
		MessageBox(m_hwnd, TEXT("gpłȂʃ[hł"), szTitle, MB_ICONEXCLAMATION);
		return FALSE;
	}
	if(g_gxdp.cBPP != 16 || !(g_gxdp.ffFormat & kfDirect565)){
		MessageBox(m_hwnd, TEXT("gpłȂʃ[hł"), szTitle, MB_ICONEXCLAMATION);
		return FALSE;
	}
	if (!GXOpenInput()){ // n[hEFAL[Ɛ肷邽߂Ƀ[hĂ 
		MessageBox(m_hwnd, TEXT("GXOpenInputG["), szTitle, MB_ICONEXCLAMATION);
		return FALSE;
	}
*/
	/* ʂ̃NA */
/*
	pusLine = (unsigned short *)GXBeginDraw();
	for(y = 0; y < 320; y++){
		pusDest = pusLine;
		for(x = 0; x < 240; x++){
			*pusDest = 0xffff;
			pusDest += g_gxdp.cbxPitch >> 1;
		}
		pusLine += g_gxdp.cbyPitch >> 1;
	}
	GXEndDraw();
*/
	/* pbg̃Zbg */
	for(i = 0; i < 64; i++){
		temp = NesPalette24[i];
		r = (BYTE)(temp >> 16);
		g = (BYTE)(((WORD)(temp)) >> 8);
		b = (BYTE)(temp);
		NesPalette[i] = (((WORD)r << 8) & 0xf800) | 
		(((WORD)g << 3) & 0x0fe0) | 
		((WORD)b >> 3); /* 5-6-5 */
	}

	/* G~[V̊Jn */
//	threadrun = TRUE;
	Infones_Status = 0;
	hthread = CreateThread((LPSECURITY_ATTRIBUTES)NULL,
		(DWORD)0, (LPTHREAD_START_ROUTINE)InfoNES_Main, (LPVOID)NULL,
		(DWORD)0, &threadid);
	SetThreadPriority( hthread, THREAD_PRIORITY_HIGHEST ); 

	/* bZ[W[v */
	while(GetMessage(&msg, NULL, 0, 0) == TRUE){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

/*
	GXCloseDisplay();
	GXCloseInput();
*/
	GDICloseDisplay();

	return msg.wParam;
}

/*===================================================================*/
/*                                                                   */
/*            MainWndproc() : EBhEvV[W֐             */
/*                                                                   */
/*===================================================================*/

LRESULT CALLBACK MainWndproc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{
	POINT  pt;
	HMENU  hMenu;
	HMENU  hSubMenu;
	DWORD thread_sts;
	int wt_cnt = 100;
	switch(msg){
		case WM_COMMAND:
			switch(LOWORD(wp)){
				case IDM_MAIN_RESUME:
					Infones_Status = 0;
					break;
				case IDM_MAIN_END:
					Infones_Status = -1;
					while(1){
						wt_cnt --;
						if( GetExitCodeThread(hthread,&thread_sts) != 0 ) break;		// error
						if( thread_sts != STILL_ACTIVE ) break;						// thread exit
						if( !wt_cnt ) break;										// time_out
					}
					CloseHandle(hthread);
					hthread = NULL;
					PostQuitMessage(0);
					break;
				case IDM_MAIN_RESET:
					Infones_Status = -1;
					while(1){
						wt_cnt --;
						if( GetExitCodeThread(hthread,&thread_sts) != 0 ) break;		// error
						if( thread_sts != STILL_ACTIVE ) break;						// thread exit
						if( !wt_cnt ) break;										// time_out
					}
					CloseHandle(hthread);
					hthread = NULL;
					if(InfoNES_Load(szRomName) == 0){
						LoadSRAM();
//						threadrun = TRUE;
						Infones_Status = 0;
						hthread = CreateThread((LPSECURITY_ATTRIBUTES)NULL,
							(DWORD)0, (LPTHREAD_START_ROUTINE)InfoNES_Main, (LPVOID)NULL,
							(DWORD)0, &threadid);
					}
					break;
				case IDM_MAIN_FRAME_0:
				case IDM_MAIN_FRAME_1:
				case IDM_MAIN_FRAME_2:
				case IDM_MAIN_FRAME_3:
				case IDM_MAIN_FRAME_4:
				case IDM_MAIN_FRAME_5:
				case IDM_MAIN_FRAME_6:
				case IDM_MAIN_FRAME_7:
				case IDM_MAIN_FRAME_8:
				case IDM_MAIN_FRAME_9:
				case IDM_MAIN_FRAME_10:
					FrameCnt = 0;
					FrameSkip = LOWORD(wp) - IDM_MAIN_FRAME_0;
					Infones_Status = 0;
					break;
			}
			break;
		case WM_INITMENUPOPUP:
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_0, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_1, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_2, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_3, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_4, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_5, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_6, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_7, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_8, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_9, MF_UNCHECKED);
			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_10,MF_UNCHECKED);

			CheckMenuItem(HMENU(wp), IDM_MAIN_FRAME_0 + FrameSkip, MF_CHECKED);
			break;
		case WM_LBUTTONDOWN:
			if(Infones_Status == 0){
				Infones_Status = 1;
			}
			pt.x = LOWORD(lp);
			pt.y = HIWORD(lp);
			ClientToScreen(hwnd, &pt);
			hMenu = LoadMenu(hinst, MAKEINTRESOURCE(IDR_MENU));
			hSubMenu = GetSubMenu (hMenu, 0);
			TrackPopupMenu(hSubMenu, TPM_LEFTALIGN, 
				pt.x, pt.y, 0, hwnd, NULL);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
/*
		case WM_SETTINGCHANGE:
//			SHHandleWMSettingChange(hwnd, wp, lp, &s_sai);
     		break;
		case WM_KILLFOCUS:
//			GXSuspend();
			break;
		case WM_SETFOCUS:
//			GXResume();
			break;
*/
		default:
			return DefWindowProc(hwnd, msg, wp, lp);
	}

	return 0;
}

char *  strrchr(const char * buf, int chr)
{
	size_t cnt;
	char *p;

	if( (cnt = strlen(buf)) ==(size_t)0 ) return NULL;
	p =(char*)buf + cnt;
	while(p>=buf){
		if(*p == chr) return p;
		p--;
	}
	return NULL;
}

/*===================================================================*/
/*                                                                   */
/*           LoadSRAM() : Load a SRAM                                */
/*                                                                   */
/*===================================================================*/
int LoadSRAM()
{
/*
 *  Load a SRAM
 *
 *  Return values
 *     0 : Normally
 *    -1 : SRAM data couldn't be read
 */

	FILE *fp;
	unsigned char pSrcBuf[ SRAM_SIZE ];
	unsigned char chData;
	unsigned char chTag;
	int nRunLen;
	int nDecoded;
	int nDecLen;
	int nIdx;

	// It doesn't need to save it
	nSRAM_SaveFlag = 0;

	// It is finished if the ROM doesn't have SRAM
	if ( !ROM_SRAM )
		return 0;

	// There is necessity to save it
	nSRAM_SaveFlag = 1;

	// The preparation of the SRAM file name
	strcpy( szSaveName, szRomName );
	strcpy( strrchr( szSaveName, '.' ) + 1, "srm" );

	/*-------------------------------------------------------------------*/
	/*  Read a SRAM data                                                 */
	/*-------------------------------------------------------------------*/

	// Open SRAM file
	fp = fopen( szSaveName, "rb" );
	if ( fp == NULL )
		return -1;

	// Read SRAM data
	fread( pSrcBuf, SRAM_SIZE, 1, fp );

	// Close SRAM file
	fclose( fp );

	/*-------------------------------------------------------------------*/
	/*  Extract a SRAM data                                              */
	/*-------------------------------------------------------------------*/

	nDecoded = 0;
	nDecLen = 0;

	chTag = pSrcBuf[ nDecoded++ ];

	while ( nDecLen < 8192 )
	{
		chData = pSrcBuf[ nDecoded++ ];

		if ( chData == chTag )
		{
			chData = pSrcBuf[ nDecoded++ ];
			nRunLen = pSrcBuf[ nDecoded++ ];
			for ( nIdx = 0; nIdx < nRunLen + 1; ++nIdx )
			{
				SRAM[ nDecLen++ ] = chData;
			}
		}
		else
		{
			SRAM[ nDecLen++ ] = chData;
		}
	}

	// Successful
	return 0;
}

/*===================================================================*/
/*                                                                   */
/*           SaveSRAM() : Save a SRAM                                */
/*                                                                   */
/*===================================================================*/
int SaveSRAM()
{
/*
 *  Save a SRAM
 *
 *  Return values
 *     0 : Normally
 *    -1 : SRAM data couldn't be written
 */
	FILE *fp;
	int nUsedTable[ 256 ];
	unsigned char chData;
	unsigned char chPrevData;
	unsigned char chTag;
	int nIdx;
	int nEncoded;
	int nEncLen;
	int nRunLen;
	unsigned char pDstBuf[ SRAM_SIZE ];

	if ( !nSRAM_SaveFlag )
		return 0;  // It doesn't need to save it

	/*-------------------------------------------------------------------*/
	/*  Compress a SRAM data                                             */
	/*-------------------------------------------------------------------*/

	memset( nUsedTable, 0, sizeof nUsedTable );

	for ( nIdx = 0; nIdx < SRAM_SIZE; ++nIdx )
	{
		++nUsedTable[ SRAM[ nIdx++ ] ];
	}
	for ( nIdx = 1, chTag = 0; nIdx < 256; ++nIdx )
	{
		if ( nUsedTable[ nIdx ] < nUsedTable[ chTag ] )
			chTag = nIdx;
	}

	nEncoded = 0;
	nEncLen = 0;
	nRunLen = 1;

	pDstBuf[ nEncLen++ ] = chTag;

	chPrevData = SRAM[ nEncoded++ ];

	while ( nEncoded < SRAM_SIZE && nEncLen < SRAM_SIZE - 133 )
	{
		chData = SRAM[ nEncoded++ ];

		if ( chPrevData == chData && nRunLen < 256 )
			++nRunLen;
		else
		{
			if ( nRunLen >= 4 || chPrevData == chTag )
			{
				pDstBuf[ nEncLen++ ] = chTag;
				pDstBuf[ nEncLen++ ] = chPrevData;
				pDstBuf[ nEncLen++ ] = nRunLen - 1;
			}
			else
			{
			for ( nIdx = 0; nIdx < nRunLen; ++nIdx )
				pDstBuf[ nEncLen++ ] = chPrevData;
			}

			chPrevData = chData;
			nRunLen = 1;
		}

	}
	if ( nRunLen >= 4 || chPrevData == chTag )
	{
		pDstBuf[ nEncLen++ ] = chTag;
		pDstBuf[ nEncLen++ ] = chPrevData;
		pDstBuf[ nEncLen++ ] = nRunLen - 1;
	}
	else
	{
		for ( nIdx = 0; nIdx < nRunLen; ++nIdx )
			pDstBuf[ nEncLen++ ] = chPrevData;
		}

	/*-------------------------------------------------------------------*/
	/*  Write a SRAM data                                                */
	/*-------------------------------------------------------------------*/

	// Open SRAM file
	fp = fopen( szSaveName, "wb" );
	if ( fp == NULL )
		return -1;

	// Write SRAM data
	fwrite( pDstBuf, nEncLen, 1, fp );

	// Close SRAM file
	fclose( fp );

	// Successful
	return 0;
}


/*===================================================================*/
/*                                                                   */
/*                  InfoNES_Menu() : Menu screen                     */
/*                                                                   */
/*===================================================================*/
int InfoNES_Menu()
{
/*
 *  Menu screen
 *
 *  Return values
 *     0 : Normally
 *    -1 : Exit InfoNES
 */

	while( Infones_Status == 1 ){
		Sleep(0);
		
	}
	return Infones_Status;
}

/*===================================================================*/
/*                                                                   */
/*               InfoNES_ReadRom() : Read ROM image file             */
/*                                                                   */
/*===================================================================*/
int InfoNES_ReadRom( const char *pszFileName )
{
/*
 *  Read ROM image file
 *
 *  Parameters
 *    const char *pszFileName          (Read)
 *
 *  Return values
 *     0 : Normally
 *    -1 : Error
 */

	FILE *fp;

	/* Open ROM file */
	fp = fopen( pszFileName, "rb" );
	if ( fp == NULL )
	return -1;

	/* Read ROM Header */
	fread( &NesHeader, sizeof NesHeader, 1, fp );
	if ( memcmp( NesHeader.byID, "NES\x1a", 4 ) != 0 )
	{
		/* not .nes file */
		fclose( fp );
		return -1;
	}

	/* Clear SRAM */
	memset( SRAM, 0, SRAM_SIZE );

	/* If trainer presents Read Triner at 0x7000-0x71ff */
	if ( NesHeader.byInfo1 & 4 )
	{
		fread( &SRAM[ 0x1000 ], 512, 1, fp );
	}

	/* Allocate Memory for ROM Image */
	ROM = (BYTE *)malloc( NesHeader.byRomSize * 0x4000 );

	/* Read ROM Image */
	fread( ROM, 0x4000, NesHeader.byRomSize, fp );

	if ( NesHeader.byVRomSize > 0 )
	{
		/* Allocate Memory for VROM Image */
		VROM = (BYTE *)malloc( NesHeader.byVRomSize * 0x2000 );

		/* Read VROM Image */
		fread( VROM, 0x2000, NesHeader.byVRomSize, fp );
	}

	/* File close */
	fclose( fp );

	/* Successful */
	return 0;
}

/*===================================================================*/
/*                                                                   */
/*           InfoNES_ReleaseRom() : Release a memory for ROM         */
/*                                                                   */
/*===================================================================*/
void InfoNES_ReleaseRom()
{
/*
 *  Release a memory for ROM
 *
 */

	if ( ROM )
	{
		free( ROM );
		ROM = NULL;
	}

	if ( VROM )
	{
		free( VROM );
		VROM = NULL;
	}
}

/*===================================================================*/
/*                                                                   */
/*             InfoNES_MemoryCopy() : memcpy                         */
/*                                                                   */
/*===================================================================*/
void *InfoNES_MemoryCopy( void *dest, const void *src, int count )
{
/*
 *  memcpy
 *
 *  Parameters
 *    void *dest                       (Write)
 *      Points to the starting address of the copied block's destination
 *
 *    const void *src                  (Read)
 *      Points to the starting address of the block of memory to copy
 *
 *    int count                        (Read)
 *      Specifies the size, in bytes, of the block of memory to copy
 *
 *  Return values
 *    Pointer of destination
 */

	memcpy( dest, src, count );
	return dest;
}

/*===================================================================*/
/*                                                                   */
/*             InfoNES_MemorySet() : memset                          */
/*                                                                   */
/*===================================================================*/
void *InfoNES_MemorySet( void *dest, int c, int count )
{
/*
 *  memset
 *
 *  Parameters
 *    void *dest                       (Write)
 *      Points to the starting address of the block of memory to fill
 *
 *    int c                            (Read)
 *      Specifies the byte value with which to fill the memory block
 *
 *    int count                        (Read)
 *      Specifies the size, in bytes, of the block of memory to fill
 *
 *  Return values
 *    Pointer of destination
 */

	memset( dest, c, count);  
	return dest;
}

/*===================================================================*/
/*                                                                   */
/*      InfoNES_LoadFrame() :                                        */
/*           Transfer the contents of work frame on the screen       */
/*                                                                   */
/*===================================================================*/
void InfoNES_LoadFrame()
{
/*
 *  Transfer the contents of work frame on the screen
 *
 */
/*
	unsigned short *pusLine, *pusDest, *pusSrc;
	int x, y, xp, yp;

	pusSrc = WorkFrame;
	xp = g_gxdp.cbxPitch >> 1;
	yp = g_gxdp.cbyPitch >> 1;
	pusLine = (unsigned short *)GXBeginDraw();

	for(y = 0; y < NES_DISP_HEIGHT; y++){
		pusDest = pusLine;
		for(x = 0; x < 240; x++){
			*pusDest = *pusSrc;
			pusDest += xp;
			pusSrc++;
		}
		pusSrc += 16;
		pusLine += yp;
	}
	
	GXEndDraw();
*/

	int x,y;
	HDC	hDC;
	HDC	hbDC;

	hDC = GetDC(m_hwnd);
	hbDC = CreateCompatibleDC(hDC);
	SelectObject( hbDC, g_hbitmap );
	
	memcpy( g_vram, WorkFrame, NES_DISP_WIDTH * NES_DISP_HEIGHT *2 );
    
	BitBlt( hDC, 0, 0, NES_DISP_WIDTH, NES_DISP_HEIGHT, hbDC,0,0, SRCCOPY ); 

	ReleaseDC( m_hwnd, hDC );
	DeleteDC( hbDC );


}

/*===================================================================*/
/*                                                                   */
/*             InfoNES_PadState() : Get a joypad state               */
/*                                                                   */
/*===================================================================*/
void InfoNES_PadState( DWORD *pdwPad1, DWORD *pdwPad2, DWORD *pdwSystem )
{
/*
 *  Get a joypad state
 *
 *  Parameters
 *    DWORD *pdwPad1                   (Write)
 *      Joypad 1 State
 *
 *    DWORD *pdwPad2                   (Write)
 *      Joypad 2 State
 *
 *    DWORD *pdwSystem                 (Write)
 *      Input for InfoNES
 *
 */

	/* Transfer joypad state */
	*pdwPad1 = (GetAsyncKeyState('X')       < 0 )        | // A 
		  	  ((GetAsyncKeyState('Z')       < 0 ) << 1 ) | // B 
			  ((GetAsyncKeyState(VK_TAB)    < 0 ) << 2 ) | // Select 
			  ((GetAsyncKeyState(VK_RETURN) < 0 ) << 3 ) | // Start 
			  ((GetAsyncKeyState(VK_UP)     < 0 ) << 4 ) | // Up 
			  ((GetAsyncKeyState(VK_DOWN)   < 0 ) << 5 ) | // Down 
			  ((GetAsyncKeyState(VK_LEFT)   < 0 ) << 6 ) | // Left 
			  ((GetAsyncKeyState(VK_RIGHT)  < 0 ) << 7 );  // Right 

	*pdwPad2   = 0;
	*pdwSystem = 0;
}

/*===================================================================*/
/*                                                                   */
/*        InfoNES_SoundInit() : Sound Emulation Initialize           */
/*                                                                   */
/*===================================================================*/
void InfoNES_SoundInit( void ) 
{
}

/*===================================================================*/
/*                                                                   */
/*        InfoNES_SoundOpen() : Sound Open                           */
/*                                                                   */
/*===================================================================*/

static HWAVEOUT wout;
static int s_p_s;
int InfoNES_SoundOpen( int samples_per_sync, int sample_rate ) 
{

	WAVEFORMATEX format;
	int i;
	BYTE * buf;

	int nChannels = 1;
	int wBitsPerSample = 8;
	s_p_s = samples_per_sync;

	format.wFormatTag		= WAVE_FORMAT_PCM;
	format.nChannels		= nChannels;
	format.nSamplesPerSec	= sample_rate;
	format.wBitsPerSample	= wBitsPerSample;
	format.nAvgBytesPerSec	= ( wBitsPerSample / 8 ) * nChannels * sample_rate;
	format.nBlockAlign		= ( wBitsPerSample / 8 ) * nChannels ; 
	format.cbSize			= 0;

	Sleep(1000);
	if (waveOutOpen(&wout, WAVE_MAPPER, &format,
					(DWORD) NULL, NULL , CALLBACK_NULL)
					!= MMSYSERR_NOERROR){
		return 0;	
	}

	buf = (BYTE*) malloc( samples_per_sync * N_BUFS );


	for (i = 0; i < N_BUFS; i++) {
		final_wave[i] = (buf + samples_per_sync * i);
		hdr[i].lpData = (LPSTR) final_wave[i];
		hdr[i].dwBufferLength = samples_per_sync;
		hdr[i].dwBytesRecorded = 0;
		hdr[i].dwUser = 0;
		hdr[i].dwFlags = 0;
		hdr[i].dwLoops = 0;
		hdr[i].lpNext = NULL;
		hdr[i].reserved = 0;
		waveOutPrepareHeader(wout, &hdr[i], sizeof WAVEHDR);
	}

	cur_buf = 0;
	/* Successful */
	return 1;
}

/*===================================================================*/
/*                                                                   */
/*        InfoNES_SoundClose() : Sound Close                         */
/*                                                                   */
/*===================================================================*/
void InfoNES_SoundClose( void ) 
{
	int i;

	waveOutReset(wout);
	for (i = 0; i < N_BUFS; i++)
		waveOutUnprepareHeader(wout, &hdr[i], sizeof WAVEHDR);
	waveOutClose(wout);

	if (buf) free(buf);
}

/*===================================================================*/
/*                                                                   */
/*            InfoNES_SoundOutput4() : Sound Output 4 Waves          */           
/*                                                                   */
/*===================================================================*/
void InfoNES_SoundOutput4( int samples, BYTE *wave1, BYTE *wave2, BYTE *wave3, BYTE *wave4 ) 
{
  int i;

//  if (hthread == NULL) return ;
 
  for (i = 0; i < samples ; i++) 
  {
     final_wave[cur_buf][ i ] = ( wave1[i] + wave2[i] + wave3[i] + wave4[i] ) >> 2;
  }

  waveOutWrite(wout, &hdr[cur_buf], sizeof WAVEHDR);
  cur_buf = (cur_buf + 1) % N_BUFS;

}

/*===================================================================*/
/*                                                                   */
/*            InfoNES_Wait() : Wait Emulation if required            */
/*                                                                   */
/*===================================================================*/
void InfoNES_Wait()
{
	while( Infones_Status == 1 ){
		Sleep(0);
		
	}
//	return Infones_Status;

}

