# LIB Makefile (INC)
#
# Time-stamp: <27/04/02 17:46:13 keuchel@netwave.de>

CELIBDIR   = H:/src/wince/celib-palm-3.0
WCEROOT    = N:\Windows CE Tools
SDKROOT    = N:\Windows CE Tools
EVC        = N:\Programme\Microsoft eMbedded Tools\EVC

!if "$(CFG)" == ""
#CFG = WINCE_RELEASESHARED
CFG = WINCE_DEBUGSHARED
!endif

!if "$(TARGET)" == ""
#TARGET=wince-arm-hpc-wce300
#TARGET=wince-x86-hpc-wce300

#TARGET=wince-arm-hpc-wce211
#TARGET=wince-sh3-hpc-wce211
#TARGET=wince-mips-hpc-wce211

#TARGET=wince-arm-pocket-wce300
#TARGET=wince-sh3-pocket-wce300
#TARGET=wince-mips-pocket-wce300
#TARGET=wince-x86em-pocket-wce300

#TARGET=wince-sh3-palm-wce211
#TARGET=wince-mips-palm-wce211
#TARGET=wince-x86em-palm-wce211

#TARGET=wince-mips-hpc-wce200
#TARGET=wince-sh3-hpc-wce200

!endif

!if "$(TARGET)" == "wince-arm-hpc-wce300"
CC         = clarm.exe
PLATFORM   = HPC2000
TARGETCPU  = arm
MACHFLAGS  = -D ARM -D _ARM_ -D arm -D _arm_ -D _MT -D _DLL
OSVERSION  = WCE300
CEVERSION  = 300
CESUBSYS   = windowsce,3.00 -machine:arm
!endif

!if "$(TARGET)" == "wince-x86-hpc-wce300"
CC         = cl.exe
PLATFORM   = HPC2000
TARGETCPU  = arm
MACHFLAGS  = -D X86 -D _X86_ -D x86 -D _x86_ -D _MT -D _DLL
OSVERSION  = WCE300
CEVERSION  = 300
CESUBSYS   = windowsce,3.00 -machine:x86
!endif

!if "$(TARGET)" == "wince-arm-hpc-wce211"
CC         = clarm.exe
PLATFORM   = MS HPC Pro
TARGETCPU  = arm
MACHFLAGS  = -D ARM -D _ARM_ -D arm -D _arm_ -D _MT -D _DLL
OSVERSION  = WCE211
CEVERSION  = 211
CESUBSYS   = windowsce,2.11 -machine:arm
!endif

!if "$(TARGET)" == "wince-sh3-hpc-wce211"
CC         = shcl.exe
PLATFORM   = MS HPC Pro
TARGETCPU  = sh3
MACHFLAGS  = -D SHx -D SH3 -D_SH3_ -D _DLL -D _MT
OSVERSION  = WCE211
CEVERSION  = 211
CESUBSYS   = windowsce,2.11 -machine:sh3
!endif

!if "$(TARGET)" == "wince-mips-hpc-wce211"
CC         = clmips.exe
PLATFORM   = MS HPC Pro
TARGETCPU  = mips
MACHFLAGS  = -D MIPS -D _mips_ -D _DLL -D _MT
OSVERSION  = WCE211
CEVERSION  = 211
CESUBSYS   = windowsce,2.11 -machine:mips
!endif

!if "$(TARGET)" == "wince-x86em-pocket-wce300"
CC         = cl.exe
PLATFORM   = MS Pocket PC
TARGETCPU  = x86em
MACHFLAGS  = -D _X86_ -D_WIN32_WCE_EMULATION -D_MT -D_DLL
OSVERSION  = WCE300
CEVERSION  = 300
CESUBSYS   = windows
!endif

!if "$(TARGET)" == "wince-arm-pocket-wce300"
CC         = clarm.exe
PLATFORM   = MS Pocket PC
TARGETCPU  = arm
MACHFLAGS  = -D _ARM_ -D ARM -D _DLL -D _MT
OSVERSION  = WCE300
CEVERSION  = 300
CESUBSYS   = windowsce,3.00 -machine:arm
!endif

!if "$(TARGET)" == "wince-sh3-pocket-wce300"
CC         = shcl.exe
PLATFORM   = MS Pocket PC
TARGETCPU  = sh3
MACHFLAGS  = -D _SHx_ -D SHx -D _DLL -D _MT
OSVERSION  = WCE300
CEVERSION  = 300
CESUBSYS   = windowsce,3.00 -machine:sh3
!endif

!if "$(TARGET)" == "wince-mips-pocket-wce300"
CC         = clmips.exe
PLATFORM   = MS Pocket PC
TARGETCPU  = mips
MACHFLAGS  = -D MIPS -D mips -D _MIPS_ -D _mips_ -D _DLL -D _MT
OSVERSION  = WCE300
CEVERSION  = 300
CESUBSYS   = windowsce,3.00 -machine:mips
!endif

!if "$(TARGET)" == "wince-mips-palm-wce211"
CC         = clmips.exe
PLATFORM   = MS Palm Size PC
TARGETCPU  = mips
MACHFLAGS  = -D _MT -D _DLL -D MIPS -D _MIPS_ -D mips -D _mips_
OSVERSION  = WCE211
CEVERSION  = 211
CESUBSYS   = windowsce,2.11 -machine:mips
!endif

!if "$(TARGET)" == "wince-sh3-palm-wce211"
CC         = shcl.exe
PLATFORM   = MS Palm Size PC
TARGETCPU  = sh3
MACHFLAGS  = -D _MT -D _DLL -D _SHx_ -D SHx
OSVERSION  = WCE211
CEVERSION  = 211
CESUBSYS   = windowsce,2.11 -machine:sh3
!endif

!if "$(TARGET)" == "wince-x86em-palm-wce211"
CC         = cl.exe
PLATFORM   = MS Palm Size PC
TARGETCPU  = x86em
MACHFLAGS  = -D _MT -D _DLL -D _X86_ -D_WIN32_WCE_EMULATION
OSVERSION  = WCE211
CEVERSION  = 211
CESUBSYS   = windows
!endif

!if "$(TARGET)" == "wince-mips-hpc-wce200"
CC         = clmips.exe
PLATFORM   = MS HPC
TARGETCPU  = MIPS
# MUST USE -MD to get the right FPE stuff...
MACHFLAGS  = -D _MT -D _DLL -MD -D MIPS -D mips -D _MIPS_ -D _mips_
OSVERSION  = WCE200
CEVERSION  = 200
CESUBSYS   = windowsce,2.00 -machine:mips
!endif

!if "$(TARGET)" == "wince-sh3-hpc-wce200"
CC         = shcl.exe
PLATFORM   = MS HPC
TARGETCPU  = SH3
# MUST USE -MD to get the right FPE stuff...
MACHFLAGS  = -D _MT -D _DLL -MD -D SH3 -D sh3 -D _SH3_ -D _sh3_ -D SHx
OSVERSION  = WCE200
CEVERSION  = 200
CESUBSYS   = windowsce,2.00 -machine:sh3
!endif

######################################################################
CELIB      = $(CELIBDIR)/$(TARGET)-release/celib.lib
######################################################################

# old sdk
#CCPATH=$(WCEROOT)\bin;$(WCEROOT)\$(OSVERSION)\bin;$(PATH)

# embedded tools sdk
#CCPATH=$(EVC)\$(OSVERSION)\BIN;$(PATH)
CCPATH=$(EVC)\WCE300\BIN

INCLUDE=$(WCEROOT)/$(OSVERSION)/$(PLATFORM)/include
LIB=$(WCEROOT)/$(OSVERSION)/$(PLATFORM)/lib/$(TARGETCPU)
PATH=$(CCPATH);$(PATH)

!message *****************************************************************
!message Building for $(TARGETCPU) $(PLATFORM) $(OSVERSION)
!message INCLUDE = $(INCLUDE)
!message LIB     = $(LIB)
!message CCPATH  = $(CCPATH)
!message *****************************************************************
!message

######################################################################
SRCDIR    = .
TARGETDIR = $(TARGET)
######################################################################

INC            = -I. -I.. -I $(CELIBDIR)/inc
COMMONCFLAGS   = -nologo $(DEFS) $(INC) -DPOCKET_SIZE -DPALM_SIZE \
                 $(MACHFLAGS)
COMMONCEDEFS   = -D_WINCE -DUNDER_CE=$(CEVERSION)
LIBFLAGS       = -nologo
LDFLAGS        = -nologo -incremental:no -nodefaultlib \
                 -subsystem:$(CESUBSYS)
CELIBS         = corelibc.lib coredll.lib winsock.lib

######################################################################

!if "$(CFG)" == "WINCE_RELEASESHARED"
CFLAGS  = $(COMMONCFLAGS) $(COMMONCEDEFS) -O2 
!endif

!if "$(CFG)" == "WINCE_DEBUGSHARED"
CFLAGS  = $(COMMONCFLAGS) $(COMMONCEDEFS) -Od -Zi
LDFLAGS = $(LDFLAGS) -debug:full -pdb:none
!endif

######################################################################

$(TARGETDIR):
	mkdir $(TARGETDIR)

{$(SRCDIR)}.c{$(TARGETDIR)}.obj:
	$(CC) -c $(CFLAGS) -Fo$(TARGETDIR)\ $<

{$(SRCDIR)}.cpp{$(TARGETDIR)}.obj:
	$(CC) -c $(CPPFLAGS) -Fo$(TARGETDIR)\ $<

######################################################################
