<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output method="html" version="4.0" />

   <!-- $Revision: 1.1 $ $Date: 2002/04/15 16:48:42 $ $Author: Stephane $ -->

   <xsl:key name="addr_key" match="function" use="@addr" />

   <xsl:template name="get_function_name">
      <xsl:param name="addr" />
      <xsl:param name="length" />
      <xsl:choose>
         <xsl:when test="count(key('addr_key', $addr))=0">
            <b><xsl:value-of select="substring('?? Unknown function ??', 1, $length)" /></b>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="substring(key('addr_key', $addr)/name, 1, $length)" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
</xsl:stylesheet>

