<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:import href="xfnutils.xsl" />
   <xsl:import href="xtime.xsl" />

   <!-- $Revision: 1.1 $ $Date: 2002/04/15 16:48:45 $ $Author: Stephane $ -->

   <xsl:output method="html" version="4.0" />
   <xsl:param name="cell-color">#ccccff</xsl:param>
   <xsl:param name="name-length">40</xsl:param>
   <xsl:param name="sort-key">time</xsl:param>
   <xsl:param name="sort-order">descending</xsl:param>
   <xsl:param name="sort-limit">2</xsl:param>

   <xsl:variable name="sort-type">
      <xsl:choose>
         <xsl:when test="$sort-key='name'">text</xsl:when>
         <xsl:otherwise>number</xsl:otherwise>
      </xsl:choose>
   </xsl:variable>

   <!-- This stylesheet is meant to be included in an html page; so no header/footer here. -->

   <xsl:template match="/">
      <style>
         td { font-family:arial; font-size:10pt }
         tr { vertical-align:top }
      </style>
      <table width="100%" cellspacing="0" cellpadding="3">
         <thead>
            <!-- You must provide your own SortParent - see xmain.htm -->
            <tr align="right">
               <th align="left" width="50%">
               <a href="javascript:SortParent('name')">Function</a>
               </th>
               <th>%</th>
               <th><a href="javascript:SortParent('count')">Count</a></th>
               <th><a href="javascript:SortParent('time')">Total</a></th>
               <th>Avg.</th>
               <th><a href="javascript:SortParent('nochild')">Alone</a></th>
               <th>%</th>
               <th>Avg</th>
            </tr>
         </thead>
         <tbody>
            <!-- Must be some 'hack' to do without the choose! -->
            <xsl:choose>
               <xsl:when test="$sort-key='name'">
                  <xsl:apply-templates select="/Profile/Results/*[position() &lt;= $sort-limit]">
                     <xsl:sort select="key('addr_key', @addr)/name" data-type="{$sort-type}" order="{$sort-order}" />
                  </xsl:apply-templates>
               </xsl:when>
               <xsl:when test="$sort-key='nochild'">
                  <xsl:apply-templates select="/Profile/Results/*[position() &lt;= $sort-limit]">
                     <xsl:sort select="@time - @childtime" data-type="{$sort-type}" order="{$sort-order}" />
                  </xsl:apply-templates>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="/Profile/Results/*[position() &lt;= $sort-limit]">
                     <xsl:sort select="./@*[local-name()=$sort-key]" data-type="{$sort-type}" order="{$sort-order}" />
                  </xsl:apply-templates>
               </xsl:otherwise>
            </xsl:choose>
         </tbody>
      </table>
   </xsl:template>
   <xsl:template match="function-ref">
      <tr align="right">
         <xsl:if test="position() mod 2 != 0">
            <xsl:attribute name="bgcolor">
               <xsl:value-of select="$cell-color" />
            </xsl:attribute>
         </xsl:if>
         <td align="left">
            <a><xsl:attribute name="name"><xsl:value-of select="@addr" /></xsl:attribute></a>
            <a><xsl:attribute name="href">javascript:parent.SelectParent('<xsl:value-of select="@addr" />')</xsl:attribute>
            <xsl:call-template name="get_function_name">
               <xsl:with-param name="addr" select="@addr" />
               <xsl:with-param name="length" select="$name-length" />
            </xsl:call-template></a>
         </td>
         <td><xsl:value-of select="format-number((@time) div $total-time, '0.00%')" /></td>
         <td><xsl:value-of select="@count" /></td>
         <td><xsl:value-of select="format-number(@time div $time-div, '0.00')" /></td>
         <td><xsl:value-of select="format-number(@time div (@count * $time-div), '0.00')" /></td>
         <td><xsl:value-of select="format-number((@time - @childtime) div $time-div, '0.00')" /></td>
         <td><xsl:value-of select="format-number(((@time - @childtime)) div $total-time, '0.00%')" /></td>
         <td><xsl:value-of select="format-number((@time - @childtime) div (@count * $time-div), '0.00')" /></td>
      </tr>
   </xsl:template>
</xsl:stylesheet>

