	AREA ArmGfxLib,CODE,READONLY
	EXPORT ScreenCopyPort38
	EXPORT ScreenCopyLand38
	EXPORT ScreenCopyLand38r
;	EXPORT ScreenCopyPort36
;	EXPORT ScreenCopyLand36

;============================================================================================

; Portrait blitter for iPAQ 38xx
ScreenCopyPort38
	stmfd   sp!, {r4-r12,lr}

	; r0 = pBuffer
	; r1 = pDisplay (should be 0xAC0755A0)
	; r2 = xPitch (should be -640)
	; r3 = yPitch (should be 2)

	; subtract xPitch*240 from yPitch, add 2
	sub r3, r3, r2, LSL #8		; r3 -= r2 * 256
	add r3, r3, r2, LSL #4		; r3 += r2 * 16
	add r3, r3, #2				; r3 += 2

	; r4 = sourcelinestop
	; r5 = sourceallstop
	add r5, r0, #107520			; r5 = r0 + 240*224*2

	mov r12, #512				; r12 = 256*2

port38_outer

	add r4, r0, #480			; r4 = r0 + 240*2

port38_inner

	ldrh r7, [r0, r12]			; r7 = (hword) *(r0+r12)
	ldrh r6, [r0], #2			; r6 = (hword) *r0, r0 += 2

	ldrh r9, [r0, r12]			; r9 = (hword) *(r0+r12)
	ldrh r14, [r0], #2			; r14 = (hword) *r0, r0 += 2

	ldrh r11, [r0, r12]			; r11 = (hword) *(r0+r12)
	ldrh r10, [r0], #2			; r10 = (hword) *r0, r0 += 2

	add r8, r6, r7, LSL #16		; r8 = r6 + (r7 << 16)
	str r8, [r1], r2			; *r1 = r8, r1 += r2

	add r8, r14, r9, LSL #16	; r8 = r14 + (r9 << 16)
	str r8, [r1], r2			; *r1 = r8, r1 += r2

	add r8, r10, r11, LSL #16	; r8 = r10 + (r11 << 16)
	str r8, [r1], r2			; *r1 = r8, r1 += r2

	cmp r0, r4					; if (r0 != r4)
	bne port38_inner			;	go to port38_inner

	add r1, r1, r3				; r1 += r3
	add r0, r0, #544			; r0 += 256*2+256*2-240*2
	
	cmp r0, r5					; if (r0 != r5)
	bne port38_outer			;	go to port38_outer

	ldmfd   sp!, {r4-r12,pc}

;============================================================================================


;============================================================================================

; Landscape blitter for iPAQ 38xx
ScreenCopyLand38
	stmfd   sp!, {r4-r9,lr}

	; r0 = pBuffer
	; r1 = pDisplay (should be 0xAC0755A0)
	; r2 = xPitch (should be -640)
	; r3 = yPitch (should be 2)

	sub r1, r1, #2				; r1 -= 2

	; r4 = sourcelinestop
	; r5 = sourceallstop
	add r5, r0, #114688			; r5 = r0 + 256*224*2

land38_outer

	add r4, r0, #512			; r4 = r0 + 256*2

land38_inner

	ldmia r0!, {r6-r9}			; load 8 pixels

	mov r6, r6, ROR #16			; reverse byte order
	mov r7, r7, ROR #16			; of each pixel set
	mov r8, r8, ROR #16
	mov r9, r9, ROR #16

	str r6, [r1], #-4			; *r1 = r6, r1 += r3
	str r7, [r1], #-4			; *r1 = r7, r1 += r3
	str r8, [r1], #-4			; *r1 = r8, r1 += r3
	str r9, [r1], #-4			; *r1 = r9, r1 += r3

	cmp r0, r4					; if (r0 != r4)
	bne land38_inner			; go to land38_inner

	sub r1, r1, #128			; r1 -= 640-512
	
	cmp r0, r5					; if (r0 != r5)
	bne land38_outer			; go to land38_outer

	ldmfd   sp!, {r4-r9,pc}

;============================================================================================
; Landscape blitter for iPAQ 38xx, rotated right
ScreenCopyLand38r
	stmfd   sp!, {r4-r9,lr}

	; r0 = pBuffer
	; r1 = pDisplay (should be 0xAC0755A0)
	; r2 = xPitch (should be -640)
	; r3 = yPitch (should be 2)

	sub r1, r1, #2				; r1 -= 2

	; r4 = sourcelinestop
	; r5 = sourceallstop
	add r5, r0, #114688			; r5 = r0 + 256*224*2

land38r_outer

	add r4, r0, #512			; r4 = r0 + 256*2

land38r_inner

	ldmia r0!, {r6-r9}			; load 8 pixels, inc. r0
	stmia r1!, {r6-r9}			; draw them to the screen, inc. r1

	cmp r0, r4					; if (r0 != r4)
	bne land38r_inner			; go to land38r_inner

	add r1, r1, #128			; r1 += 640-512
	
	cmp r0, r5					; if (r0 != r5)
	bne land38r_outer			; go to land38r_outer

	ldmfd   sp!, {r4-r9,pc}

	END