<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:import href="xfnutils.xsl" />
   <xsl:import href="xtime.xsl" />

   <!-- $Revision: 1.1 $ $Date: 2002/04/15 16:48:41 $ $Author: Stephane $ -->

   <xsl:output method="html" version="4.0" />
   <xsl:param name="cell-color">#ccccff</xsl:param>
   <xsl:param name="name-length">50</xsl:param>
   <xsl:param name="parent-length">100</xsl:param>
   <xsl:param name="parent-prototype">255</xsl:param>
   <xsl:param name="parent-addr"></xsl:param>

   <!-- This stylesheet is meant to be included in an html page; so no header/footer here. -->

   <xsl:template match="/">
      <style>
         td { font-family:arial; font-size:10pt; vertical-align:top }
         tr { text-align:left; vertical-align:top }
         th { text-align:left; vertical-align:top }
      </style>
      <xsl:if test="not($parent-addr)">
         <table width="100%" height="100%">
            <tr align="middle">
               <td><i>Select a function name above to view its children.</i></td>
            </tr>
         </table>
      </xsl:if>
      <xsl:apply-templates select="/Profile/Results/function-ref[@addr=$parent-addr]" />
   </xsl:template>

   <xsl:template match="function-ref">
      <!-- Function header -->
      <xsl:apply-templates select="key('addr_key', $parent-addr)" />
      <!-- All children of this function -->
      <table width="100%" cellspacing="0" cellpadding="3">
         <thead>
            <tr align="right">
               <th align="left" width="50%">Child Functions</th>
               <th>%</th>
               <th>Count</th>
               <th>Total</th>
               <th>Avg.</th>
            </tr>
         </thead>
         <tbody>
            <xsl:apply-templates select="child-ref">
               <xsl:sort select="@time" order="descending" data-type="number" />
            </xsl:apply-templates>
         </tbody>
      </table>
   </xsl:template>
   <xsl:template match="child-ref">
      <!-- Display information on children -->
      <tr align="right">
         <xsl:if test="position() mod 2 != 0">
            <xsl:attribute name="bgcolor">
               <xsl:value-of select="$cell-color" />
            </xsl:attribute>
         </xsl:if>
         <td align="left">
            <a><xsl:attribute name="href">javascript:parent.SelectParentFromChild('<xsl:value-of select="@addr" />')</xsl:attribute>
            <xsl:call-template name="get_function_name">
               <xsl:with-param name="addr" select="@addr" />
               <xsl:with-param name="length" select="$name-length" />
            </xsl:call-template></a>
         </td>
         <td><xsl:value-of select="format-number(@time div sum(../@time), '0.00%')" /></td>
         <td><xsl:value-of select="@count" /></td>
         <td><xsl:value-of select="format-number(@time div $time-div, '0.00')" /></td>
         <td><xsl:value-of select="format-number(@time div (@count * $time-div), '0.00')" /></td>
      </tr>
   </xsl:template>
   <xsl:template match="function">
      <!-- Display information on parent -->
      <table width="100%" cellspacing="0" cellpadding="2">
         <tr>
            <td width="5%"><b>Function</b></td>
            <td>
               <xsl:value-of select="substring(name, 1, $parent-length)" />
            </td>
            <td align="right">
               <b>Total:
               <xsl:value-of select="format-number(
                  /Profile/Results/function-ref[@addr=$parent-addr]/@time div
                  $time-div, '0.00')" /> (<xsl:value-of
                  select="format-number(
                  /Profile/Results/function-ref[@addr=$parent-addr]/@time div
                  $total-time, '0.00%')" />)
               </b>
            </td>
         </tr>
         <xsl:if test="$parent-prototype!=0">
            <tr>
               <td><b>Prototype</b></td>
               <td colspan="2">
                  <xsl:value-of select="substring(prototype, 1, $parent-prototype)" />
               </td>
            </tr>
         </xsl:if>
         <tr>
            <td><b>File</b></td>
            <td colspan="2">
               <xsl:value-of select="file" />
            </td>
         </tr>
      </table>
      <br />
   </xsl:template>
</xsl:stylesheet>
