<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="time-scale">1000</xsl:param>

   <!-- $Revision: 1.1 $ $Date: 2002/04/15 16:48:49 $ $Author: Stephane $ -->

   <xsl:variable name="timer-resolution">
      <xsl:value-of select="/Profile/TimerFrequency" />
   </xsl:variable>

   <xsl:variable name="time-div">
      <xsl:choose>
         <xsl:when test="$timer-resolution!=0">
            <xsl:value-of select="$timer-resolution div $time-scale" />
         </xsl:when>
         <xsl:otherwise>1</xsl:otherwise>
      </xsl:choose>
   </xsl:variable>

   <!-- Compute total time for the avg; this is not affected by the sort-limit -->
   <xsl:variable name="total-time" select="sum(/Profile/Results/function-ref/@time)" />
</xsl:stylesheet>
