#include "StdAfx.h"
#include "CE.h"
#include "CEkey.h"
#include "ppp_stdio.h"

#define KeyRCFile     "\\KeyBind.cfg"

#ifdef WIN32_PLATFORM_PSPC
KEYBIND Keys[64] = { 0x0026,0x0028,0x0025,0x0027,0x0058,0x005A,0x0008,0x000D,0x0041,0x0053,0x0000 };
#else
KEYBIND Keys[64] = { 0x0026,0x0028,0x0025,0x0027,0x0058,0x005A,0x0008,0x000D,0x0041,0x0053,0x0000 };
#endif

int g_keystat = 0;
char g_keyfilename[128];

void CEKey_Init( char * fn )
{
	FILE * fp;
	int i;
	char * ret;
	char fname[128];
	char buf[256];

	strcpy( fname, GetModulePath() );
	strcat( fname, fn );
    strcpy( g_keyfilename, fname );
	fp = fopen(fname, "r");
    if ( !fp ){
        LOG("Key setting file not found [%s]\n",fname);
        return;
    }
	i = 0;	
	while( 1 ){
		ret = fgets( buf , 256, fp );
		if( ret == NULL ) break;
		Keys[i].Code = atoi(buf);
//   	DEBUGLOG( "key Code [%X]\n",kb[i].Code );
		i++;
	}
	fclose( fp );
    LOG("Key Initialize OK\n");
}

void CEKey_Trash(void)
{

    FILE * fp = fopen( g_keyfilename, "w" );
    if ( !fp ) return;
    fprintf( fp, "0x%02X\n",Keys[KEY_UP    ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_DOWN  ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_LEFT  ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_RIGHT ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_A     ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_B     ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_SELECT].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_START ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_L     ].Code);
    fprintf( fp, "0x%02X\n",Keys[KEY_R     ].Code);
    fclose(fp);    
}

int check_key( int num )
{
    return ( GetAsyncKeyState(Keys[num].Code)&0x8000 ); 
}
    
/***********************************************************************/
/* Key Event for H/PC and Pocket PC */
/***********************************************************************/
int CEKey_Update( void )
{
    int ret=0;

#ifdef WIN32_PLATFORM_PSPC
    return g_keystat;
#endif

    /* Check player 1 input keys */
    if(check_key(KEY_UP    ))  ret |= 0x0040;
    if(check_key(KEY_DOWN  ))  ret |= 0x0080;
    if(check_key(KEY_LEFT  ))  ret |= 0x0020;
    if(check_key(KEY_RIGHT ))  ret |= 0x0010;
    if(check_key(KEY_A     ))  ret |= 0x0001;
    if(check_key(KEY_B     ))  ret |= 0x0002;
    if(check_key(KEY_SELECT))  ret |= 0x0004;
    if(check_key(KEY_START ))  ret |= 0x0008;
    if(check_key(KEY_L     ))  ret |= 0x0100;
    if(check_key(KEY_R     ))  ret |= 0x0200;

    return ret;

}
/***********************************************************************/
/* KEYDOWN Event for Pocket PC */
/***********************************************************************/
void CEKey_Down(int key)
{
	if     (key == Keys[KEY_UP    ].Code) g_keystat |= 0x0040;
	else if(key == Keys[KEY_DOWN  ].Code) g_keystat |= 0x0080;
	else if(key == Keys[KEY_LEFT  ].Code) g_keystat |= 0x0020;
	else if(key == Keys[KEY_RIGHT ].Code) g_keystat |= 0x0010;
	else if(key == Keys[KEY_A     ].Code) g_keystat |= 0x0001;
	else if(key == Keys[KEY_B     ].Code) g_keystat |= 0x0002;
	else if(key == Keys[KEY_SELECT].Code) g_keystat |= 0x0004;
	else if(key == Keys[KEY_START ].Code) g_keystat |= 0x0008;
	else if(key == Keys[KEY_L     ].Code) g_keystat |= 0x0100;
	else if(key == Keys[KEY_R     ].Code) g_keystat |= 0x0200;
}

/***********************************************************************/
/* KEYUP Event for Pocket PC */
/***********************************************************************/
void CEKey_Up(int key)
{
    if     (key == Keys[KEY_UP    ].Code) g_keystat &= ~0x0040;
    else if(key == Keys[KEY_DOWN  ].Code) g_keystat &= ~0x0080;
    else if(key == Keys[KEY_LEFT  ].Code) g_keystat &= ~0x0020;
    else if(key == Keys[KEY_RIGHT ].Code) g_keystat &= ~0x0010;
    else if(key == Keys[KEY_A     ].Code) g_keystat &= ~0x0001;
    else if(key == Keys[KEY_B     ].Code) g_keystat &= ~0x0002;
    else if(key == Keys[KEY_SELECT].Code) g_keystat &= ~0x0004;
    else if(key == Keys[KEY_START ].Code) g_keystat &= ~0x0008;
    else if(key == Keys[KEY_L     ].Code) g_keystat &= ~0x0100;
    else if(key == Keys[KEY_R     ].Code) g_keystat &= ~0x0200;
}
