/***************************************************************************
    Windows CE GAPI Video Routine
 ***************************************************************************/
#ifdef WIN32_PLATFORM_PSPC

#include <windows.h>
#include "gx.h"

#include "ce.h"
#include "CEVideo.h"
#include "system.h"
#include "ppp_stdio.h"

/*************************************************************/
/* GAPI : video initialize */
/*************************************************************/
int CEVideo_Init_GAPI( int width, int height )
{
    
    GXDisplayProperties dp;

    LOG( "GAPI video initialize : " );
    if (GXOpenDisplay(g_hWnd, GX_FULLSCREEN) == 0){
        LOG( "failed\n" );
        return 0;
    }
    LOG( "OK\n" );

    dp = GXGetDisplayProperties();        
    g_screen_width  = dp.cbyPitch / 2;
    g_screen_height = dp.cyHeight;
    g_width  = width;
    g_height = height;

    if(videomode==3){
        LOG( "GAPI video buffer allocate : " );
        g_vbuf = (char*)malloc( g_width * g_height * 2 );
        if( g_vbuf == NULL ){
            LOG( "failed\n" );
            return 0;
        }          
        LOG( "OK\n" );
    }
    
    return 1;
    
}
/*************************************************************/
/*************************************************************/
void systemDrawScreen_GAPI_NOBUF(void)
{
    DEBUGLOG( "systemDrawScreen\n" );
    GXEndDraw();
    if( scanlineflip ) scanlineflip = 0;
    else scanlineflip = 1;
}

/*************************************************************/
/*************************************************************/
void systemDrawScreen_GAPI_USEBUF(void)
{
    u8 * delta = 0;
    char * buf;
//    int w;

    DEBUGLOG( "systemDrawScreen\n" );
    buf = (char*)GXBeginDraw();

    if(filterFunction) {
        filterFunction(   (u8*)g_vbuf,
                          g_width * 2,
                          (u8*)delta,
                          (u8*)buf + (g_screen_width * systemScrPosY + systemScrPosX) * 2,
                          (g_screen_width - ((systemScrPosX<0)?-systemScrPosX:systemScrPosX)) * 2,
                          ( ( g_screen_width > g_width )?g_width:g_screen_width ),
                          ( ( g_screen_height> g_height)?g_height:g_screen_height) 
						 );
    }
    GXEndDraw();
    if( scanlineflip ) scanlineflip = 0;
    else scanlineflip = 1;
/*
    FILE * fp;
	fp = fopen( "\\disp.dat","wb" );
	if( fp != NULL ){
		fwrite( g_vbuf, 1, g_width * g_height * 2 , fp );
	};
	fclose( fp );
*/
}

/*************************************************************/
/*************************************************************/
void CEVideo_Trash_GAPI(void)
{
    GXCloseDisplay();
    LOG( "GAPI video trash OK\n" );
}

int ClipWidthSize(int s1,int sW,int dW)
{
	int s2 = s1 + sW;
	return ((dW>s2)?s2:dW) - ((0>s1)?0:s1) ;
}

/*************************************************************/
/*************************************************************/
char * CEVideo_GetBufferPtrLine_FULL_GAPI_NOBUF(int line)
{
	systemWidth = ClipWidthSize( systemScrPosX, 240 , g_screen_width );
    if( line == 1 ) g_vram =(char*) GXBeginDraw() + g_screen_width * systemScrPosY * 2 + systemScrPosX;    
    return (char *)g_vram + g_screen_width * (line) * 2;
}

char * CEVideo_GetBufferPtrLine_FULL_GAPI_USEBUF(int line)
{
	systemWidth = 240;
    return (char *)g_vbuf + g_width * (line) * 2;
}

/*************************************************************/
/*************************************************************/
char * CEVideo_GetBufferPtrLine_HALF_GAPI_NOBUF(int line)
{
    if( (line&1)==1 ) return NULL;
    if( line == 2 ) g_vram =(char*) GXBeginDraw() + g_screen_width * systemScrPosY * 2 + systemScrPosX;
	systemWidth = ClipWidthSize( systemScrPosX, 240 , g_screen_width );
    return (char *)g_vram + g_screen_width * (line) * 2;
}

char * CEVideo_GetBufferPtrLine_HALF_GAPI_USEBUF(int line)
{
    if( (line&1)==1 ) return NULL;
	systemWidth = 240;
    return (char *)g_vbuf + g_width * (line) * 2;
}

/*************************************************************/
/*************************************************************/
char * CEVideo_GetBufferPtrLine_INTERLESS_GAPI_NOBUF(int line)
{
    if( line == 1 ) g_vram =(char*) GXBeginDraw() + g_screen_width * systemScrPosY * 2 + systemScrPosX;

    if( scanlineflip == 0 ){
        if( (line&1)==1 ) return NULL;
    }else{
        if( (line&1)==0 ) return NULL;
    }
	systemWidth = ClipWidthSize( systemScrPosX, 240 , g_screen_width );
    return (char *)g_vram + g_screen_width * (line) * 2;
}

char * CEVideo_GetBufferPtrLine_INTERLESS_GAPI_USEBUF(int line)
{
    if( scanlineflip == 0 ){
        if( (line&1)==1 ) return NULL;
    }else{
        if( (line&1)==0 ) return NULL;
    }
	systemWidth = 240;
    return (char *)g_vbuf + g_width * (line) * 2;
}

/*************************************************************/
/*************************************************************/
char * CEVideo_GetBufferPtr_GAPI_NOBUF(void)
{
    g_vram =(char*) GXBeginDraw();    
    return g_vram;
}

char * CEVideo_GetBufferPtr_GAPI_USEBUF(void)
{
    return g_vbuf;
}

/*************************************************************/
/*************************************************************/
void CEVideo_CleanBuffer_GAPI_NOBUF(void)
{
    GXEndDraw();    
    g_vram =(char*) GXBeginDraw();    
    memset( g_vram,0, g_screen_width * g_screen_height * 2 );
    GXEndDraw();    
}

void CEVideo_CleanBuffer_GAPI_USEBUF(void)
{
    memset( g_vbuf,0, g_width * g_height * 2 );
    GXEndDraw();    
    g_vram =(char*) GXBeginDraw();    
    memset( g_vram,0, g_screen_width * g_screen_height * 2 );
    GXEndDraw();    
}

/*************************************************************/
/*************************************************************/
void CEVideo_FreeBufferPtr_GAPI_NOBUF(void)
{
}

void CEVideo_FreeBufferPtr_GAPI_USEBUF(void)
{
    free(g_vbuf);
}

#endif
