#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <stdlib.h>
#include <tchar.h>
#include "fceu\driver.h"
#include "fceu\svga.h"
#include "CESound.h"
#include "key.h"

#include "stdfile.h"

unsigned short color_palette[256];
int opt_FrameSkip       = 1;
int opt_FrameSkipCnt    = 4;
int opt_SampleRate      = 22100;
int opt_SampleBit       = 8;
int opt_SleepAfterSound = 100;
int opt_TurboSpeed      = 3;
int opt_ScreenTop       = 0;
int opt_ScreenLeft      = 192;
int opt_AutoStateLoading= 0;
int opt_AutoStateTiming = 500;
int opt_DoubleSize      = 0;

int AutoStateLoading= 0;

static void *InputDPtr[2];
uint32 JSreturn;
int JoySwap=0;
static int framecount;
int SoundExit;

int TurboSW[4];

int gametype;

extern HWND hWndNES;
extern HWND hwndCB;
extern int CommandBarVis;
extern char gDefaultDir[512];

#include "fceu\state.h"

//int SoundThread(void *pArg);

#define N_BUFS 8
#define BUF_SIZ 512
#define MAX_SND_BUFSIZE	2048

// standerd functions
///////////////////////////////////////////
#if _WIN32_WCE < 300
int isgraph( int c )
{
  if(c<0x20) return 0x20; 
  if(c<0x7f) return c;
  if(c<0xa1) return 0x20;
  if(c<0xe0) return c;
  return 0x20;
}
#endif
void unlink( char * ptr )
{
	DeleteFile( (LPCTSTR)ptr );
}

///////////////////////////////////////////
void * __cdecl calloc(size_t num, size_t siz)
{
	void * p;
	p = malloc(num*siz);
	memset( p, 0, num*siz);
	return p;
}

///////////////////////////////////////////
char *  strrchr(const char * buf, int chr)
{
	size_t cnt;
	char *p;

	if( (cnt = strlen(buf)) ==(size_t)0 ) return NULL;
	p =(char*)buf + cnt;
	while(p>=buf){
		if(*p == chr) return p;
		p--;
	}
	return NULL;
}

///////////////////////////////////////////
//	Called to send messages to the driver code to express what kind of
//	system(or what extra hardware) is being emulated
//	(NSF player, FDS, VS Unisystem, etc.).
void FCEUD_SendMessage(int msg)
{
	switch( msg ){
	  case DSM_SPECIALSYSTEM_VSUNISYSTEM	: gametype = 1;break;// Game is a VS Unisystem game.
	  case DSM_SPECIALSYSTEM_NSF			    : gametype = 2;break;// File loaded is an NSF.
	  case DSM_SPECIALSYSTEM_FDS			    : gametype = 3;break;// Game uses the FDS.
	  case DSM_RESETSPECIAL				        : gametype = 0;break;// Sent after a new game is loaded.
	};
}

void KeyBoardInit()
{
	int x;
	
	DriverInputInterface(DII_SETMULTI,0,0,0);

	for(x=0;x<2;x++)
	{
		InputDPtr[x]=((uint8 *)&JSreturn)+(x<<1);
		DriverInputInterface(DII_SETCONTROL,x,DII_SETCONTROL_GAMEPAD,InputDPtr[x]);
	}

	setDefaultKeyTable();
}

void ToggleTurboSW( int btn )
{
	char str[128];
	
	TurboSW[btn] = !TurboSW[btn];
	switch( btn ){
	case 0: sprintf( str, "Player1 A Button Turbo %s", (TurboSW[btn]?"ON":"OFF") ); break;
	case 1: sprintf( str, "Player1 B Button Turbo %s", (TurboSW[btn]?"ON":"OFF") ); break;
	case 2: sprintf( str, "Player2 A Button Turbo %s", (TurboSW[btn]?"ON":"OFF") ); break;
	case 3: sprintf( str, "Player2 B Button Turbo %s", (TurboSW[btn]?"ON":"OFF") ); break;
	}
	FCEU_DispMessage(str);
}

int TurboPad( int btn )
{
	static int btnsts[4] = {0,0,0,0};
	static int btncnt[4] = {0,0,0,0};
	if( TurboSW[btn] ){
		btncnt[btn]=(btncnt[btn]+1)%opt_TurboSpeed;
		if(btncnt[btn]==0)btnsts[btn]=!btnsts[btn];
		return btnsts[btn];
	}else{
		return 1;
	}
}

///////////////////////////////////////////
//	Called when the data pointed to by pointers passed to 
//	FCEUD_DriverInputInterface() needs to be updated.
void FCEUD_UpdateInput(void)
{
	uint32 JS;
	int x,y;
	int i;
	x=y=JS=0;

//	for( i = 0;i<0xFF;i++ ){
//		if ( GetAsyncKeyState(i)!=0 ) printf( "%X\n", i );
//	}

	if( GetAsyncKeyState(KeyTable[QUIT])   & 0x8000 ) { 

		CurrentState = 99;
		SaveState();
		
		FCEUI_CloseGame();
		CommandBarVis = CommandBar_Show( hwndCB, CommandBarVis );
		Sleep(0);
	}
	if( GetAsyncKeyState(KeyTable[KEY_P1_UP])    & 0x8000 )  y|= JOY_UP;
	if( GetAsyncKeyState(KeyTable[KEY_P1_DOWN])  & 0x8000 )  y|= JOY_DOWN;
	if( GetAsyncKeyState(KeyTable[KEY_P1_LEFT])  & 0x8000 )  x|= JOY_LEFT;
	if( GetAsyncKeyState(KeyTable[KEY_P1_RIGHT]) & 0x8000 )  x|= JOY_RIGHT;
    if( y!=(JOY_DOWN|JOY_UP))     JS|= y<<JoySwap;
    if( x!=(JOY_LEFT|JOY_RIGHT))  JS|= x<<JoySwap;
    if((GetAsyncKeyState(KeyTable[KEY_P1_A]) & 0x8000) && TurboPad(0) )
		JS|= JOY_A<<JoySwap;
    if((GetAsyncKeyState(KeyTable[KEY_P1_B]) & 0x8000) && TurboPad(1) )
		JS|= JOY_B<<JoySwap;
    if( GetAsyncKeyState(KeyTable[KEY_START])& 0x8000 ) JS|= JOY_START<<JoySwap;
    if( GetAsyncKeyState(KeyTable[KEY_SELECT])   & 0x8000 ) JS|= JOY_SELECT<<JoySwap;

	JSreturn=(JS&0xFF000000)|(JS&0xFF)|((JS&0xFF0000)>>8)|((JS&0xFF00)<<8);

}

///////////////////////////////////////////
//	Set palette entry "index" to specified RGB values(value: min=0, max=255).
void FCEUD_SetPalette(uint8 index, uint8 r, uint8 g, uint8 b)
{
	color_palette[index] =  (((unsigned short)r << 8) & 0xf800) | 
							(((unsigned short)g << 3) & 0x0fe0) | 
							((unsigned short)b >> 3);
}

///////////////////////////////////////////
//	Get palette entry "index" data.
void FCEUD_GetPalette(uint8 index, uint8 *r, uint8 *g, uint8 *b)
{
	*r = (unsigned char)((color_palette[index] >> 8) & 0xf8);
	*g = (unsigned char)((color_palette[index] >> 3) & 0xfc);
	*b = (unsigned char)((color_palette[index] << 3) & 0xf8);
}

//	Copy contents of XBuf over to video memory(or whatever needs to be done
//	to make the contents of XBuf visible on screen).
//	Each line is 256 pixels(and bytes) in width, and there can be 240
//	lines.  The pitch for each line is 272 bytes.  
void FCEUD_BlitScreen(uint8 *XBuf)
{
	int x, y; 
//	int i,j;

	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;
	HBITMAP	hbitmap;
	HDC		hDC;
	HDC		hbDC;
	HANDLE	hDIB;
	WORD * lpBits;
	
	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= 272;
	bi.biHeight			= -240;
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( hDIB );
#else
	hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	hDC = GetDC(hWndNES);
	hbDC = CreateCompatibleDC(hDC);
	hbitmap = CreateDIBSection( hbDC, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&lpBits, NULL, 0 );
	SelectObject( hbDC, hbitmap );
	if( hbDC && hbitmap ){

		for(y = 0; y < 272*240; y++ ) *lpBits++ = color_palette[*XBuf++];

		if( opt_DoubleSize ){	    
			StretchBlt( hDC, opt_ScreenLeft, opt_ScreenTop, 512,480, hbDC, 0, 8, 256, 240,SRCCOPY ); 
		}else{
			BitBlt( hDC, opt_ScreenLeft, opt_ScreenTop, 256, 240, hbDC, 0, 8,SRCCOPY ); 
		}
		ReleaseDC( hWndNES, hDC );

	}		
	DeleteDC( hbDC );
	DeleteObject( hbitmap );

#if _WIN32_WCE >= 300
	GlobalUnlock( hDIB );
	GlobalFree( hDIB );
#else
	LocalUnlock( hDIB );
	LocalFree( hDIB );
#endif
	if(opt_FrameSkip){ 
		framecount--;
		if(!framecount){	
			FCEUI_FrameSkip(opt_FrameSkipCnt);
			framecount = opt_FrameSkip;
		}
	}
}

//////////////
//	Print/Display an error message string pointed to by "s".
void FCEUD_PrintError(char *s)
{
	int i;
	TCHAR szError[256];

	for(i = 0; s[i] != 0; i++) szError[i] = (TCHAR)s[i];

	szError[i] = 0;

	MessageBox(NULL, szError, _T("Fatal Error"), MB_ICONERROR | MB_OK | MB_SETFOREGROUND | MB_TOPMOST);
}


//	Initialize a network connection.  Return 0 if an error occurs.
int FCEUD_NetworkConnect(void)
{
	return 1;
}

//	Send a byte of data pointed to by "Value".
//	Return 0 on failure.
int FCEUD_NetworkRecvByte(uint8 *Value)
{
	return 1;
}


//	Receive a byte of data into the memory location pointed to by "Value".
//	Return 0 on failure.
int FCEUD_NetworkSendByte(uint8 *Value)
{
	return 1;
}
	
//	Close the network connection.
void FCEUD_NetworkClose(void)
{
}

/*
 * splitline is a destructive argument parser, much like a very primitive
 * form of a shell parser. it supports quotes for embedded spaces and
 * literal quotes with the backslash escape.
 */

char *splitnext(char **pos)
{
	char *a, *d, *s;

	d = s = *pos;
	while (*s) if(*s=='\r'||*s=='\n')*s = '\0' ; else s++;
	d = s = *pos;
	while (*s == ' ' || *s == '\t') s++;
	a = s;
	while (*s && *s != ' ' && *s != '\t')
	{
		if (*s == '"')
		{
			s++;
			while (*s && *s != '"')
			{
				if (*s == '\\')
					s++;
				if (*s)
					*(d++) = *(s++);
			}
			if (*s == '"') s++;
		}
		else
		{
			if (*s == '\\')
				s++;
			*(d++) = *(s++);
		}
	}
	while (*s == ' ' || *s == '\t') s++;
	*d = 0;
	*pos = s;
	return a;
}

int splitline(char **argv, int max, char *line)
{
	char *s;
	int i;

	DEBUGLOG( "splitline start" );

	s = line;
	for (i = 0; *s && i < max + 1; i++)
		argv[i] = splitnext(&s);
	argv[i] = 0;
	return i;
}

void ReadIniFile(HINSTANCE hInst)
{
	FILE * fp;
	int ret;
	char * argv[10];
	char * bufptr;
	TCHAR cmd[256];	
	char  cmdline[256];	
	char  cmdline1[256];	
	char linebuf[256];

	DEBUGLOG( "ReadIniFile Start\n" );

	ret = GetModuleFileName(hInst,cmd,256);
	ret = wcstombs(cmdline,cmd,256); 
	strcpy(cmdline1,cmdline);	
	if ((bufptr=strrchr( cmdline1, '\\' )) != NULL )*bufptr = '\0';
	DEBUGLOG( "BaseDir [%s]\n",cmdline1 );
	FCEUI_SetBaseDirectory(cmdline1);
	if ((bufptr=strrchr( cmdline, '.' )) != NULL ) *bufptr = '\0';
	strcat( cmdline , ".cfg" );
	DEBUGLOG( "ReadFileName[%s]\n",cmdline );
	if ( (fp = fopen( cmdline ,"r" ))!=NULL ){
		while(1){
//			DEBUG_Print( "Read\n");
			if( fgets( linebuf,256,fp )== NULL ) break;	
			DEBUGLOG( "Read linebuf[%s]\n",linebuf );
			if( (linebuf[0]=='#')||(linebuf[0]=='\r')||(linebuf[0]=='\n')  ) continue;
			ret = splitline(argv,2,linebuf);
//			DEBUGLOG( "Read splitline ret[%d]\n",ret);
			DEBUGLOG( "Read argv[0]=%s  argv[1]=%s argv[2]=%s \n",argv[0],argv[1],argv[2] );
			if      (!strcmp(argv[0],"RomDir"        ))	strcpy(gDefaultDir,argv[1]);
			else if (!strcmp(argv[0],"FrameSkip"     )) opt_FrameSkip = atoi(argv[1]);
			else if (!strcmp(argv[0],"FrameSkipCount")) opt_FrameSkipCnt = atoi(argv[1]);
			else if (!strcmp(argv[0],"SpriteLimit"   )) FCEUI_DisableSpriteLimitation(atoi(argv[1]));
			else if (!strcmp(argv[0],"SaveUnderBase" )) FCEUI_SaveExtraDataUnderBase(atoi(argv[1]));
			else if (!strcmp(argv[0],"SampleRate"    )) opt_SampleRate= atoi(argv[1]);
			else if (!strcmp(argv[0],"SampleBit"     )) opt_SampleBit = atoi(argv[1]);
			else if (!strcmp(argv[0],"TurboSpeed"    )) opt_TurboSpeed= atoi(argv[1]);
			else if (!strcmp(argv[0],"Bind"          )) DefineKey( argv[1], argv[2] );
			else if (!strcmp(argv[0],"ScreenTop"     )) opt_ScreenTop   = atoi(argv[1]);
			else if (!strcmp(argv[0],"ScreenLeft"    )) opt_ScreenLeft = atoi(argv[1]);
			else if (!strcmp(argv[0],"AutoStateLoad" )) opt_AutoStateLoading = atoi(argv[1]);
			else if (!strcmp(argv[0],"AutoStateTime" )) opt_AutoStateTiming = atoi(argv[1]);
			else if (!strcmp(argv[0],"DoubleSize"    )) opt_DoubleSize = atoi(argv[1]);
		}
		DEBUGLOG( "Read END\n" );
		fclose(fp);	
	}else{
		DEBUGLOG( "ReadIniFile  NO Ini FILE\n" );
		strcpy(gDefaultDir ,"\\My Documents\\");
		opt_FrameSkip    = 1;
		opt_FrameSkipCnt = 2;
	};
	framecount  = opt_FrameSkip;	
	DEBUGLOG( "ReadIniFile End\n" );

	


}

// initialize sound. Return 0 for no sound, otherwise return the rate. (11025?)
int InitSound(void)
{
	DWORD rc;
//	HANDLE hSoundThread;

	DEBUGLOG( "Call InitSound %d\n", opt_SampleRate );

	if(!opt_SampleRate)return 0;

		
	if(CESound_init(opt_SampleRate,opt_SampleBit)){
		DEBUGLOG( "InitSound Error End\n" );
		return 0; // error
	}
	else
	{
		SoundExit = 0;

		// set full volume
//		CESound_set_volume(0xffff, 0xffff);

/*		hSoundThread = CreateThread(NULL, 
			0,		// stack size (ignored)
			(LPTHREAD_START_ROUTINE)SoundThread,	// Thread function
			0,		// 32 bit parameter passed to thread
			0,		// Creation flags (0 = start thread immediately)
			&rc);	// Receives thread ID

		CloseHandle(hSoundThread);
*/
		FCEUI_Sound(opt_SampleRate);
		DEBUGLOG( "InitSound Normal End\n" );
		return opt_SampleRate; // return the sample rate
	}
}

void TrashSound(void)
{
	// signal the sound thread to stop
	SoundExit = 1;

//	while(SoundExit != 2)
//		;

	CESound_exit();
}

byte SoundBuf[MAX_SND_BUFSIZE];
/*
int SoundThread(void *pArg)
{
	for(;;)
	{
		if(SoundExit)
			break;

		FillSoundBuffer(SoundBuf);
		
		CESound_play_sample(SoundBuf, opt_SampleRate);
		Sleep(opt_SleepAfterSound);
	}

	SoundExit = 2;

	return 0;
}
*/