/*
 * palette.c
 *
 * generic palette code
 */

#include <stdlib.h>
#include "palette.h"
#include "types.h"
#include "video.h"

void set_palette_8(palette this, int index, int value)
{
    ((u8*)this->base_palette)[index] = ((u8*)this->translate)[value];
}

palette new_palette_8(int num_palettes, int palette_size)
{
    palette retval;
    int i;

    retval = malloc(sizeof(*retval) + (num_palettes * palette_size * sizeof(u8)) + (num_palettes * sizeof(void *)));

    if (!retval) {
	return NULL;
    }

    retval->set = set_palette_8;
    retval->translate = vid_pre_xlat;
    retval->base_palette = &retval->palettes[num_palettes];

    for (i = 0; i < num_palettes; i++) {
	retval->palettes[i] = &(((u8 *)retval->base_palette)[palette_size * i]);
    }
    
    return retval;
}

void set_palette_16(palette this, int index, int value)
{
    ((u16*)this->base_palette)[index] = ((u16*)this->translate)[value];
}

palette new_palette_16(int num_palettes, int palette_size)
{
    palette retval;
    int i;

    retval = malloc(sizeof(*retval) + (num_palettes * palette_size * sizeof(u16)) + (num_palettes * sizeof(void *)));

    if (!retval) {
	return NULL;
    }

    retval->set = set_palette_16;
    retval->translate = vid_pre_xlat;
    retval->base_palette = &retval->palettes[num_palettes];

    for (i = 0; i < num_palettes; i++) {
	retval->palettes[i] = &(((u16*)retval->base_palette)[palette_size * i]);
    }
    
    return retval;
}

void set_palette_32(palette this, int index, int value)
{
    ((u32*)this->base_palette)[index] = ((u32*)this->translate)[value];
}

palette new_palette_32(int num_palettes, int palette_size)
{
    palette retval;
    int i;

    retval = malloc(sizeof(*retval) + (num_palettes * palette_size * sizeof(u32)) + (num_palettes * sizeof(void *)));

    if (!retval) {
	return NULL;
    }

    retval->set = set_palette_32;
    retval->translate = vid_pre_xlat;
    retval->base_palette = &retval->palettes[num_palettes];

    for (i = 0; i < num_palettes; i++) {
	retval->palettes[i] = &(((u32*)retval->base_palette)[palette_size * i]);
    }
    
    return retval;
}
