/*
 * snd_ce.c
 *
 * allegro sound interface
 */

#include <windows.h>
#include <mmsystem.h>
#include "ui.h"
#include "snd.h"

#define N_BUFS 32
char * final_wave[N_BUFS];
WAVEHDR hdr[N_BUFS];
BYTE * buf;
int cur_buf;
static HWAVEOUT wout;

void snd_output_4_waves(int samples, u8 *wave1, u8 *wave2, u8 *wave3, u8 *wave4)
{
  int i;

  for (i = 0; i < samples; i++) 
  {
     final_wave[cur_buf][ i ] = ( wave1[i] + wave2[i] + wave3[i] + wave4[i] ) >> 2;
  }

  waveOutWrite(wout, &hdr[cur_buf], sizeof(WAVEHDR) );
  cur_buf = (cur_buf + 1) % N_BUFS;

}

void snd_init(void)
{
}

int snd_open(int samples_per_sync, int sample_rate)
{
	WAVEFORMATEX format;
	int i;
	BYTE * buf;

	format.wFormatTag = WAVE_FORMAT_PCM;
	format.nChannels = 1;
	format.nSamplesPerSec = sample_rate;
	format.wBitsPerSample = 8;
	format.nBlockAlign = format.nChannels * format.wBitsPerSample / 8; 
	format.nAvgBytesPerSec = format.nSamplesPerSec * format.nBlockAlign;
	format.cbSize = 0;

	Sleep(1000);
	if (waveOutOpen(&wout, WAVE_MAPPER, &format,
					(DWORD) NULL, NULL , CALLBACK_NULL)
					!= MMSYSERR_NOERROR){
		return 0;	
	}

	buf = (BYTE*) malloc( samples_per_sync * N_BUFS );

	for (i = 0; i < N_BUFS; i++) {
		final_wave[i] = (buf + samples_per_sync * i);
		hdr[i].lpData = (LPSTR) final_wave[i];
		hdr[i].dwBufferLength = samples_per_sync;
		hdr[i].dwBytesRecorded = 0;
		hdr[i].dwUser = 0;
		hdr[i].dwFlags = 0;
		hdr[i].dwLoops = 0;
		hdr[i].lpNext = NULL;
		hdr[i].reserved = 0;
		waveOutPrepareHeader(wout, &hdr[i], sizeof(WAVEHDR) );
	}

	cur_buf = 0;
    return 1;
}

void snd_close(void)
{
	int i;

	waveOutReset(wout);
	for (i = 0; i < N_BUFS; i++)
		waveOutUnprepareHeader(wout, &hdr[i], sizeof(WAVEHDR) );
	waveOutClose(wout);

	if (buf) free(buf);
}

