/*
 * ui_ce.c
 */

#include <windows.h>
#include <stdio.h>
#include "ui.h"
#include "system.h"
#include "video.h"
#include "tool.h"
#include "menu.h"

/* the joypad (only one, I could care less about more) */
struct joypad *ui_joypad;

void run_system(void);
shutdown_t dn_shutdown;

int DarcNES_main( char *argv )
{
    extern int nes_psg_quality; /* FIXME: cheap hack, copied from nes_psg.h */
    rom_file romfile;
    int system_type;
    
    video_init();

    nes_psg_quality = 2;

    romfile = read_romimage( argv );

    if (romfile) {
	system_type = guess_system(romfile);
	activate_system(system_type, romfile);
    } else {
	printf("error reading romfile.\n");
	return 0x41;
    }
	 
    run_system();

    return 0;
}

/* keyboard emulation */

void kb_init(void)
{
    /* FIXME: dummy function. keyboards don't work */
}


/* keypad emulation */

int keypad_register(struct keypad *pad)
{
    /* FIXME: dummy function. keypads don't work */
    return 0;
}


/* joypad emulation */

int ui_register_joypad(struct joypad *pad)
{
    if (!ui_joypad) {
	ui_joypad = pad;
	return 1;
    } else {
	return 0;
    }
}

void ui_update_joypad(struct joypad *pad)
{
    /* NOTE: does nothing. may want to do stuff when using real gamepads */
}

void video_events(void)
{

	if (GetAsyncKeyState(VK_ESCAPE)&0x8000){
		system_flags |=  F_QUIT;
		PostQuitMessage(0);
	}
	else system_flags &= ~F_QUIT;

	if (ui_joypad) {
		switch (ui_joypad->button_template->num_buttons) {
		case 8:	if (GetAsyncKeyState(VK_RETURN)     &0x8000) 
				      ui_joypad->data |=  ui_joypad->button_template->buttons[7];
			    else  ui_joypad->data &= ~ui_joypad->button_template->buttons[7];
		case 7:	if (GetAsyncKeyState(VK_TAB)        &0x8000)
					  ui_joypad->data |=  ui_joypad->button_template->buttons[6];
				else  ui_joypad->data &= ~ui_joypad->button_template->buttons[6];
		case 6:	if (GetAsyncKeyState('Z')           &0x8000)
					  ui_joypad->data |=  ui_joypad->button_template->buttons[5];
			    else  ui_joypad->data &= ~ui_joypad->button_template->buttons[5];
		case 5:	if (GetAsyncKeyState('X')           &0x8000)
					  ui_joypad->data |=  ui_joypad->button_template->buttons[4];
				else  ui_joypad->data &= ~ui_joypad->button_template->buttons[4];
		case 4: if (GetAsyncKeyState(VK_RIGHT)      &0x8000)
					  ui_joypad->data |=  ui_joypad->button_template->buttons[3];
				else  ui_joypad->data &= ~ui_joypad->button_template->buttons[3];
		case 3: if (GetAsyncKeyState(VK_LEFT)       &0x8000)
					  ui_joypad->data |=  ui_joypad->button_template->buttons[2];
				else  ui_joypad->data &= ~ui_joypad->button_template->buttons[2];
		case 2: if (GetAsyncKeyState(VK_DOWN)       &0x8000)
					  ui_joypad->data |=  ui_joypad->button_template->buttons[1];
				else  ui_joypad->data &= ~ui_joypad->button_template->buttons[1];
		case 1: if (GetAsyncKeyState(VK_UP)         &0x8000)
					  ui_joypad->data |=  ui_joypad->button_template->buttons[0];
				else  ui_joypad->data &= ~ui_joypad->button_template->buttons[0];
		default:
			break;
		}
    }
}


/* per-driver menus */

void menu_init(struct ui_menu *menu)
{
    /* dummy implementation */
}

void menu_rename_item(struct ui_menu *item)
{
    /* dummy implementation */
}

void menu_disable_item(struct ui_menu *item)
{
    /* dummy implementation */
}

void menu_enable_item(struct ui_menu *item)
{
    /* dummy implementation */
}

void menu_file_open_box(ui_open_callback callback, void *data, char *filter)
{
    /* dummy implementation */
}


/* emulation timeslicing */

void (*timeslice)(void *) = NULL;
void *timeslice_data;

void set_timeslice(void (*proc)(void *), void *data)
{
    timeslice = proc;
    timeslice_data = data;
}

void unset_timeslice(void)
{
    timeslice = NULL;
}

void run_system(void)
{
	while ((!(system_flags & F_QUIT)) && timeslice) {
		video_events();
		timeslice(timeslice_data);
    }
	if (dn_shutdown) {
		dn_shutdown();
    }
}

