/*
 * video_ce.c
 *
 * display screen management
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "video.h"
#include "tool.h"

int video_active = 0;
int deblevel = 0;

HBITMAP g_hbitmap;
HANDLE  g_hDIB;
char * vram;
unsigned char * nes_bitmap;
int WIDTH = 256;
int HEIGHT = 240;

unsigned short color_palette[128];

extern HINSTANCE hInst;
extern HWND g_hWnd;


//typedef void ((*xlatfunc)(BITMAP *, char *));

//unsigned char *vbpfunc8(int line);

unsigned char *vid_pre_xlat;
//void init_xlate8(int colors, int *red, int *green, int *blue);

void video_init()
{

	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;

	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= WIDTH;
	bi.biHeight			= -HEIGHT;
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	g_hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( g_hDIB );
#else
	g_hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( g_hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	g_hbitmap = CreateDIBSection( NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&vram, NULL, 0 );

#if _WIN32_WCE >= 300
	GlobalUnlock( g_hDIB );
	GlobalFree( g_hDIB );
#else
	LocalUnlock( g_hDIB );
	LocalFree( g_hDIB );
#endif

	nes_bitmap = malloc(WIDTH * HEIGHT);

	memset( color_palette, 0, 256 );

	//    install_keyboard();
}

void video_shutdown(void)
{
}

void video_enter_deb(void)
{
    if (video_active && (!deblevel)) {

    }
    deblevel++;
}

void video_leave_deb(void)
{
    deblevel--;
    if (video_active && (!deblevel)) {

    }
}

void video_setsize(int x, int y)
{
    /* FIXME: add real implimentation */
}

void video_display_buffer()
{
	HDC	hDC;
	HDC	hbDC;
	unsigned short * vram_buf =(unsigned short *) vram;
	unsigned char * nes_bitmap_buf = nes_bitmap;
	int i;

	hDC = GetDC(g_hWnd);
	hbDC = CreateCompatibleDC(hDC);
	SelectObject( hbDC, g_hbitmap );

	
	for( i = 0;i<WIDTH*HEIGHT;i++ ){
		*vram_buf++ = color_palette[*nes_bitmap_buf++];
//		*vram_buf++ = *nes_bitmap_buf++;
	}
	

	BitBlt( hDC, 0, 0, WIDTH, HEIGHT, hbDC,0,0,SRCCOPY ); 

	ReleaseDC( g_hWnd, hDC );
	DeleteDC( hbDC );
}

unsigned char *video_get_vbp(int line)
{
    return nes_bitmap + (line * WIDTH);
}

void video_setpal(int colors, int *red, int *green, int *blue)
{
    int i;

//    RGB color;
    
    vid_pre_xlat = malloc(colors);
    
	for (i = 0; i < 64; i++) {
//		color.r = red[i] >> 2;
//		color.g = green[i] >> 2;
//		color.b = blue[i] >> 2;
//		set_color(i + 64, &color);
		color_palette[i+64] =((red[i]   << 8) & 0xf800) | 
							 ((green[i] << 3) & 0x07e0) | 
							  (blue[i]  >> 3);
		vid_pre_xlat[i] = i + 64;
    }

}

