#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#include "stdfile.h"

#define MAX_OPEN_FILE 16

//#define USE_DEBUGLOG

#define DEBUGLOG deb_printf

static int first_init = 1;
char * BaseDirectory;

typedef struct _FILE_HANDLE {
	int    use;
	HANDLE fp;
	int    eof;
	int    error;
} FILE_HANDLE;
	
FILE_HANDLE	FH[MAX_OPEN_FILE];


// standerd functions
///////////////////////////////////////////
#if _WIN32_WCE < 300
int isgraph( int c )
{
  if(c<0x20) return 0x20; 
  if(c<0x7f) return c;
  if(c<0xa1) return 0x20;
  if(c<0xe0) return c;
  return 0x20;
}
#endif

void abort(void)
{
	exit(0);
}

int strcasecmp(const char *s1, const char *s2)
{
	int ret;
	TCHAR * ss1;
	TCHAR * ss2;
	ss1 = malloc( (strlen(s1)+1) * sizeof(TCHAR) );
	ss2 = malloc( (strlen(s2)+1) * sizeof(TCHAR) );
	mbstowcs(ss1,s1,strlen(s1)+1);
	mbstowcs(ss2,s2,strlen(s2)+1);
	ret = lstrcmpi( ss1, ss2 );
	free(ss1);
	free(ss2);
	return ret;

}


char * strdup(const char *src)
{
//	printf( "strdup [%s]\n", src );
	char * dst = (char*)malloc( strlen( src )+1 );
	strcpy( dst, src );
	return dst;
}

void unlink( char * ptr )
{
	DeleteFile( (LPCTSTR)ptr );
}

///////////////////////////////////////////
void * __cdecl calloc(size_t num, size_t siz)
{
	void * p;
	p = malloc(num*siz);
	memset( p, 0, num*siz);
	return p;
}

///////////////////////////////////////////
char *  strrchr(const char * buf, int chr)
{
	size_t cnt;
	char *p;

	if( (cnt = strlen(buf)) ==(size_t)0 ) return NULL;
	p =(char*)buf + cnt;
	while(p>=buf){
		if(*p == chr) return p;
		p--;
	}
	return NULL;
}

FILE * ngs_fopen(const char * name, const char * type)
{
	int i;
	int dwDesiredAccess;
	int dwCreationDispostion;
	wchar_t	wname[512];

	DEBUGLOG("ngs_fopen start name[%s]\n",name);

	if( first_init ){
		first_init = 0;
		memset( FH, '\0', sizeof(FILE_HANDLE) * MAX_OPEN_FILE );
	}

	if (type[0]=='w' ) { 
		DEBUGLOG("ngs_fopen type[w] \n");
		dwDesiredAccess = GENERIC_WRITE;	
		dwCreationDispostion = OPEN_ALWAYS;		
	}else if( type[0]=='r' ){
		DEBUGLOG("ngs_fopen type[r] \n");
		dwDesiredAccess = GENERIC_READ;
		dwCreationDispostion = OPEN_EXISTING;
	}else if (type[0]=='a' ) { 
		DEBUGLOG("ngs_fopen type[a] \n");
		dwDesiredAccess = GENERIC_WRITE;
		dwCreationDispostion = OPEN_ALWAYS;
	}else{
		DEBUGLOG("ngs_fopen type[unknown] \n");
		return NULL;
	}

	for( i =1;i<MAX_OPEN_FILE;i++ ){
		if( !FH[i].use ) break;
	}
	DEBUGLOG("ngs_fopen FH[%d] \n", i);

	mbstowcs( wname, name, 512 );

	FH[i].fp = CreateFile( wname, 
				dwDesiredAccess,
				0,					// no shared
				NULL,				// set NULL
				dwCreationDispostion,
				FILE_ATTRIBUTE_NORMAL |	FILE_FLAG_RANDOM_ACCESS,
				0 );

	if( FH[i].fp != NULL ){
		FH[i].use=1;
		FH[i].eof=0;
		FH[i].error=0;
	}

	if( type[0]=='a' ) {
		ngs_fseek( (FILE *)i, 0, SEEK_END );
	}

	DEBUGLOG("ngs_fopen end\n");
	return (FILE *) i;
}

int cdecl ngs_fclose(FILE * fp)
{
	DEBUGLOG("ngs_fclose start FH[%d]\n", (int)fp );
	CloseHandle( FH[(int)fp].fp );
	FH[(int)fp].use = 0;
	FH[(int)fp].eof = 0;
	FH[(int)fp].error = 0;
	DEBUGLOG("ngs_fclose end \n");
	return 0;
}

size_t ngs_fread(void *buffer, size_t size, size_t count, FILE * fp )
{
	BOOL ret;
	DWORD rcount;
	DEBUGLOG("ngs_fread start FH[%d]\n", (int)fp );

	ret = ReadFile( FH[(int)fp].fp , buffer, size * count, &rcount, NULL );
	if( ret ){
		DEBUGLOG("ngs_fread normal end ret[%d]\n", (size_t)rcount/size );
		return (size_t)rcount/size;
	}else{
		DEBUGLOG("ngs_fread error? end ret[0]\n" );
		return 0;
	}
}

size_t ngs_fwrite( const void *buffer, size_t size, size_t count, FILE *fp )
{
	BOOL ret;
	DWORD rcount;

	DEBUGLOG("ngs_fwrite start ret[%d]\n", (int)fp );

	ret = WriteFile( FH[(int)fp].fp, buffer, size * count, &rcount, NULL ); 
	if( ret ){
		DEBUGLOG("ngs_fwrite normal end ret[%d]\n", (size_t)rcount/size );
		return (size_t)rcount/size;
	}else{
		DEBUGLOG("ngs_fwrite error? end ret[0]\n");
		return 0;
	}
}

int ngs_fseek( FILE *stream, long offset, int origin )
{
	DWORD ret;
	DWORD mmethod; 

	DEBUGLOG("ngs_fseek start FH[%d]\n", (int)stream );
	
	switch( origin ){
		case SEEK_SET : mmethod = FILE_BEGIN;	break;
		case SEEK_CUR : mmethod = FILE_CURRENT;	break;
		case SEEK_END : mmethod = FILE_END;		break;
	}

	ret = SetFilePointer( FH[(int)stream].fp, offset, NULL, mmethod );

	if( ret != 0xFFFFFFFF ){	
		DEBUGLOG("ngs_fseek normal end ret[0]\n" );
		FH[(int)stream].eof = 0;
		FH[(int)stream].error = 0;
		return 0;
	}else{
		DEBUGLOG("ngs_fseek error end ret[1]\n" );
		return 1;
	}
}

int ngs_fscanf(FILE * fp, const char * first , ...)
{
	DEBUGLOG( "fscanf function is not impliment.\n" );
	return 0;
}

int ngs_fprintf(FILE * fp, const char * first, ...)
{
	va_list marker;
	char buf[1024];
	DEBUGLOG("ngs_fprintf start FH[%d]\n",(int)fp );

	va_start( marker, first );     /* ό̈̏ */
	vsprintf( buf,first,marker );
	va_end( marker );

	ngs_fwrite( buf, 1, strlen(buf),fp );
	DEBUGLOG("ngs_fprintf end\n" );
	return 0;
}

int ngs_fgetc( FILE * fp )
{
	DWORD ret;
	DWORD rcount;
	char buffer;

	DEBUGLOG("ngs_fgetc start FH[%d]\n",(int)fp );
	
	ret = ReadFile( FH[(int)fp].fp , &buffer, 1, &rcount, NULL );
	if( ret ){
		if(rcount > 0){
			DEBUGLOG("ngs_fgetc end ret[%d]\n", (int)buffer );
			return (int)buffer;
		} else {
			DEBUGLOG("ngs_fgetc end ret[EOF]\n" );
		}
	}else{
		DEBUGLOG("ngs_fgetc error end\n" );
		FH[(int)fp].error = 1;
	}
	FH[(int)fp].eof = 1;
	return EOF;
}

char * ngs_fgets( char * str , int n, FILE * fp )
{
	DWORD ret;
	int i;
	int rcount;

	DEBUGLOG("ngs_fgets start FH[%d]\n",(int)fp );

	str[0] = '\0';
	for(i=0;i<n;i++){
		ret = ReadFile( FH[(int)fp].fp , &str[i], 1, &rcount, NULL );
		if( ret ){
			if(str[i]=='\n'){
				str[i+1] = '\0';
				break;
			}else if(rcount==0){
				str[i]='\0';
				FH[(int)fp].eof = 1;
				break;
			}
		}else{
			str[0]='\0';
			FH[(int)fp].error = 1;
			break;
		}
	}			
	DEBUGLOG("ngs_fgets end ret[%s]\n",str );
	if( str[0] == '\0' ) return NULL;
					else return str;
}

int ngs_fputc(int c,  FILE * fp )
{
	int ret;
	int rcount;
	unsigned char buf = (unsigned char)c;
	ret = WriteFile( FH[(int)fp].fp , &buf, 1, &rcount, NULL );
	if( ret ){
		if( rcount ){
			return c;
		}
	}
	return EOF;
}

int ngs_ftell( FILE * fp )
{
	return SetFilePointer(FH[(int)fp].fp, 0,NULL,FILE_CURRENT );
}

int ngs_feof( FILE * fp )
{
	return FH[(int)fp].eof;
}

int ngs_ferror( FILE * fp )
{
	return FH[(int)fp].error;
}

void deb_printf( char * str , ... )
{
#ifdef USE_DEBUGLOG
	HANDLE fp;
	int ret;
	int rcount;
	va_list marker;
	char buf[1024];

#ifdef POPOPE
	fp = CreateFile( _T("\\MultiMedia Card\\darcnes\\debug.log"), 
#else
	fp = CreateFile( _T("\\storage card\\emu\\darcNES\\debug.log"), 
#endif
				GENERIC_WRITE,
				0,					// no shared
				NULL,				// set NULL
				OPEN_ALWAYS,
				FILE_ATTRIBUTE_NORMAL |	FILE_FLAG_RANDOM_ACCESS,
				0 );

	SetFilePointer(fp, 0,NULL,FILE_END );

	va_start( marker, str );     /* ό̈̏ */
	vsprintf( buf,str,marker );
	va_end( marker );

	ret = WriteFile( fp, buf, strlen(buf), &rcount, NULL ); 

	CloseHandle( fp );

#endif
}

