#include <windows.h>
#include "msx/msx.h"
#include "ppp_stdio.h"
#include "msx/sound.h"
#include "Keybind.h"

/** Public parameters ****************************************/
int UseSound  = 8192;          /* Sound driver frequency    */
char *Disks[2][MAXDISKS+1];    /* Disk names for each drive */

/** Various variables ****************************************/
//#define WIDTH  272
//#define HEIGHT 228
int WIDTH  = 272;
int HEIGHT = 228;

/** Keyboard bindings ****************************************/
byte WinKeyMap[16];             /* Keyboard map              */
byte JoyKeyMap[2];				/* Joystick Keymap           */

unsigned int BPal[256],XPal[80],XPal0; 
char *XBuf;
//static Port Prt;
static byte JoyState;

extern HWND      g_hWnd;

HBITMAP	g_hbitmap;
HANDLE	g_hDIB;

extern HBITMAP bmpKeyBoard;
extern int UseSOFTKEY; 
extern int SoftKeyLeft; 
extern int SoftKeyTop;
int UseStatic = 0;
//extern void DrawBitmap(HDC, HBITMAP);

extern int View_x;
extern int View_y;
extern int UseNarrow;
extern int Usex2Mode;

extern byte TapeHeader[8];

void ReadKeyBind( char * fn, KEYBIND * kb )
{
	FILE * fp;
	int i;
	char * ret;
	char fname[512];
	char buf[256];

	strcpy( fname, ProgDir );
	strcat( fname, fn );
	fp = fopen(fname, "r");
	if ( !fp ){
		LOG("Keybind file [%s] is not found. Keybind use internal default.\n", fname );
		return; 
	}
	i = 0;	
	while( 1 ){
		ret = fgets( buf , 256, fp );
		if( ret == NULL ) break;
		kb[i].Code = atoi(buf);
		kb[i].Hold = atoi(buf+7);
		kb[i].Pos  = atoi(buf+12);
		kb[i].Mask = atoi(buf+17);
//   	DEBUGLOG( "key Code [%X]\n",kb[i].Code );
		if( kb[i].Mask == 0 ) break;
		i++;
	}
	fclose( fp );

	LOG("Keybind loaded.[%s]\n", fname );
}


char * vid_init()
{
	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;
	char * vram;

	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= Usex2Mode?544:WIDTH;
	bi.biHeight			= -HEIGHT * (Usex2Mode?2:1);
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	g_hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( g_hDIB );
#else
	g_hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( g_hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	g_hbitmap = CreateDIBSection( NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&vram, NULL, 0 );

#if _WIN32_WCE >= 300
	GlobalUnlock( g_hDIB );
	GlobalFree( g_hDIB );
#else
	LocalUnlock( g_hDIB );
	LocalFree( g_hDIB );
#endif

	if (vram == NULL){
		LOG( "GDI video open NG!.\n" );
		return 0;
	}else{
		LOG( "GDI video open OK.\n" );
		return vram;
	}
}

void vid_close()
{
	DeleteObject( g_hbitmap );
	LOG( "Video closed.\n" );
}

/** InitMachine() ********************************************/
/** Allocate resources needed by the machine-dependent code.**/
/************************************ TO BE WRITTEN BY USER **/
int InitMachine(void)
{
	int I;
	int J;

	ReadKeyBind(KeyRCFile, Keys);

	if(Usex2Mode){
		RefreshLine[ 0]=RefreshLine0_x2;
		RefreshLine[ 1]=RefreshLine1_x2;
		RefreshLine[ 2]=RefreshLine2_x2;
		RefreshLine[ 3]=RefreshLine3_x2;
		RefreshLine[ 4]=RefreshLine4_x2;
		RefreshLine[ 5]=RefreshLine5_x2;
		RefreshLine[ 6]=RefreshLine6_x2;
		RefreshLine[ 7]=RefreshLine7_x2;
		RefreshLine[ 8]=RefreshLine8_x2;
		RefreshLine[10]=RefreshLine10_x2;
		RefreshLine[11]=RefreshLine10_x2;
		RefreshLine[12]=RefreshLine12_x2;
		RefreshLine[13]=RefreshLineTx80_x2;
	}else{
		if(UseNarrow){
			RefreshLine[6]=RefreshLine6;
			RefreshLine[7]=RefreshLine7;
			RefreshLine[13]=RefreshLineTx80;
			WIDTH  = 272;
		}else{
			RefreshLine[6]=RefreshLine6W;
			RefreshLine[7]=RefreshLine7W;
			RefreshLine[13]=RefreshLineTx80W;
			WIDTH  = 528;
		}
	}    
  /* video init */
  XBuf = vid_init();
  if( !XBuf ) return 0; 

  /* sound init */
  InitSound(UseSound,0);

  /* keybord init */ 
  memset(WinKeyMap,0xFF,sizeof(WinKeyMap));

  /* Reset the palette */
  for(J=0;J<16;J++) XPal[J]=0;
  XPal0=0;

  /* Set SCREEN8 colors */
/*
  for(J=0;J<64;J++)
  {
    I=(J&0x03)+(J&0x0C)*16+(J&0x30)/2;
    XPal[J+16]= (((J&0x30)*255/48)<<16)+(((J&0x0C)*255/12)<<8)+(J&0x03)*255/3;
    BPal[I]=BPal[I|0x04]=BPal[I|0x20]=BPal[I|0x24]=XPal[J+16];
  }
*/
  for(J=0;J<256;J++ ){
    BPal[J] = ((J&0x1c)<<11)+(J&0xc0)*8+(J&0x03)*8;  
  }

  return 1;
}

/** TrashMachine() *******************************************/
/** Deallocate all resources taken by InitMachine().        **/
/************************************ TO BE WRITTEN BY USER **/
void TrashMachine(void)
{
  /* video close */
  vid_close();

  /* sound close */
  TrashSound();  

}

/** Keyboard() ***********************************************/
/** This function is periodically called to poll keyboard.  **/
/************************************ TO BE WRITTEN BY USER **/

#define SetDownKey(AA) (  WinKeyMap[AA->Pos]&=~AA->Mask)
#define SetUpKey(AA)   (  WinKeyMap[AA->Pos]|= AA->Mask)
#define isDownKey(AA)  (!(WinKeyMap[AA->Pos]&  AA->Mask))

void Keyboard(void)
{
    int i,code;
    short key;
    KEYBIND * K;

    Sleep(0);
	
	for( i = 0;i<256;i++ ){
        K = &Keys[i];
//		if( !K->Code ) continue;
		if( !K->Mask ) break;
        if( K->Code>>8 ){
            if( !(GetAsyncKeyState(K->Code>>8)&0x8000) ) continue;
            code = K->Code & 0x00ff;         
        }else{
            code = K->Code;
        }       
//    DEBUGLOG( "Keys[%d]\n",i );

        key = GetAsyncKeyState(code);
        if( K->Hold & 0x01 ){			// z[hL[				
            if( (key&0x8000) ) {       // Ăꍇ
		        if ( K->Hold & 0x80 ){                  // Ԃ̏ꍇ
                    K->Hold &= 0x7F;                    // KeyDowntONA
		        }else{                                  // 
                    K->Hold |= 0x80;                     // KeyDowntOĂ
                    SetDownKey(K);                      // 
                }
            }else{                      // ĂȂꍇ
                if ( (K->Hold)&0x80 )     // ԂȂ΁AL[
                    SetDownKey(K);                          
            }
        }else{                        // ʏL[                   
            if( !(key&0x8000) ) continue;               // KeyUp
            SetDownKey(K);
        }
    }

    memcpy( KeyMap, WinKeyMap, 16 );

    // Clear Keymap
    for( i = 0;i<256;i++ ){
        K = &Keys[i];
        if( !(K->Mask) ) break;
        if( !((K->Hold)&0x80) )
            SetUpKey(K);
    }
    
}

/** DownSoftKey() ********************************************/
/*************************************************************/
int DownSoftKey( int num )
{
  KEYBIND * K;

  DEBUGLOG( "DownSoftKey[%d]\n", num );
  K = &Keys[num];
  if( K->Hold&0x01 ){
      if( K->Hold&0x80 ){
        K->Hold &= 0x7F;
      }else{
        K->Hold |= 0x80;
      }
  }
  SetDownKey(K);
  return 1;
}

/** Joystick() ***********************************************/
/** Query position of a joystick connected to port N.       **/
/** Returns 0.0.F2.F1.R.L.D.U.                              **/
/************************************ TO BE WRITTEN BY USER **/
byte Joystick(byte N)
{
	return JoyKeyMap[N];
}

int DownJoy( word vKey )
{
  int i;
  if( (JoyTypeA!=1)&&(JoyTypeB!=1) ) return 0;
  for( i = 0;i<16;i++ ){
	if( Joys[i].Code == 0 ) break;
	if( Joys[i].Code == vKey ) {
		JoyKeyMap[Joys[i].Pos]|=Joys[i].Mask;
		return 1;
	}
  }
  return 0;
}

int UpJoy( word vKey )
{
	int i;
	if( (JoyTypeA!=1)&&(JoyTypeB!=1) ) return 0;
	for( i = 0;i<16;i++ ){
		if( Joys[i].Code == 0 ) break;
		if( Joys[i].Code == vKey ) {
			JoyKeyMap[Joys[i].Pos]&=~Joys[i].Mask;
			return 1;
		}
	}
	return 0;
}

/** Mouse() **************************************************/
/** Query coordinates of a mouse connected to port N.       **/
/** Returns F2.F1.Y.Y.Y.Y.Y.Y.Y.Y.X.X.X.X.X.X.X.X.          **/
/************************************ TO BE WRITTEN BY USER **/
int Mouse(byte N)
{
	return 0;
}

/** SetColor() ***********************************************/
/** Set color N (0..15) to (R,G,B).                         **/
/************************************ TO BE WRITTEN BY USER **/
void SetColor(byte N,byte R,byte G,byte B)
{
  unsigned int J;
  if(UseStatic) J=BPal[((7*R/255)<<2)|((7*G/255)<<5)|(3*B/255)];
  else J=( ((int)(R/8)<<11)|((int)(G/4)<<5)|(int)(B/8) );

  if(N) XPal[N]=J; else XPal0=J;
}

/** RefreshScreen() ******************************************/
/** Refresh screen. This function is called in the end of   **/
/** refresh cycle to show the entire screen.                **/
/************************************ TO BE WRITTEN BY USER **/
void RefreshScreen( void )
{
	HDC	hDC;
	HDC	hbDC;
    HRGN rgn;
	int sw,sh;
//    DEBUGLOG("RefreshScreen Start\n" );

	hDC = GetDC(g_hWnd);
    hbDC = CreateCompatibleDC(hDC);

	if(UseSOFTKEY){
		BITMAP	bm;
		SelectObject(hbDC, bmpKeyBoard);
		GetObject(bmpKeyBoard, sizeof(BITMAP), (LPVOID)&bm);
        BitBlt(hDC, SoftKeyLeft, SoftKeyTop, bm.bmWidth, bm.bmHeight,	hbDC, 0, 0, SRCCOPY);    //	SRCINVERT
        rgn = CreateRectRgn( 0,0, 240,320);
        SelectClipRgn(hDC,rgn);
        ExcludeClipRect(hDC,SoftKeyLeft,SoftKeyTop,SoftKeyLeft+bm.bmWidth,SoftKeyTop+bm.bmHeight );      
   
    }
    
	SelectObject( hbDC, g_hbitmap );
	if( Usex2Mode ){
		sw = 544;
		sh = 456;
	}else{
		if( UseNarrow ){
			sw = 272;
			sh = 228;
		}else{
			if( (ScrMode == 6) || (ScrMode == 7) || (ScrMode == 13) ){
				sw = 528;
				sh = 228;
			}else{
				sw = 272;
				sh = 228;
			}
		}
	}

    BitBlt( hDC, View_x, View_y, sw, sh, hbDC,0,0,SRCCOPY ); 


    if(UseSOFTKEY){
        DeleteObject( rgn );
    }  

    ReleaseDC( g_hWnd, hDC );
	DeleteDC( hbDC );

//  DEBUGLOG("RefreshScreen End\n" );

}

void ChangeCas( char * fname )
{
    if( CasStream ){
        fclose( CasStream );
    }
    if(CasStream=fopen(fname,"a+b")){
        if(Verbose) LOG("Using %s as a tape\n",CasName);
    }
    fseek(CasStream,0,SEEK_SET);
}

void CasTop( void )
{
  if(CasStream)
  {
    rewind(CasStream);
  }
}

void CasEnd( void )
{
  if(CasStream)
  {
    fseek(CasStream,0,SEEK_END);
  }
}

void CasPrev( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos=ftell(CasStream);
    if(Pos&7)
      if(fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(fread(Buf,1,8,CasStream)==8){
      fseek(CasStream,-8,SEEK_CUR);
      if(!memcmp(Buf,TapeHeader,8)) return;
      if(fseek(CasStream,-8,SEEK_CUR)) return;
    }
  }
}

void CasNext( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos=ftell(CasStream);
    if(Pos&7)
      if(fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(fread(Buf,1,8,CasStream)==8){
      if(!memcmp(Buf,TapeHeader,8))
      {
        return;
      }
    }
  }

}

KEYBIND Joys[16] =
{
  {0x0026,0,0,0x01},   // UP
  {0x0028,0,0,0x02},   // DOWN
  {0x0025,0,0,0x04},   // LEFT
  {0x0027,0,0,0x08},   // RIGHT
  {0x005A,0,0,0x10},   // 'Z'
  {0x0058,0,0,0x20},   // 'X'
  {0x0026,0,1,0x01},   // UP
  {0x0028,0,1,0x02},   // DOWN
  {0x0025,0,1,0x04},   // LEFT
  {0x0027,0,1,0x08},   // RIGHT
  {0x005A,0,1,0x10},   // 'Z'
  {0x0058,0,1,0x20},   // 'X'
  {0,0,0} 
};

KEYBIND Keys[256] =
{
  {0x0025,0,8,0x10},  // LEFT
  {0x0026,0,8,0x20},  // UP
  {0x0028,0,8,0x40},  // DOWN
  {0x0027,0,8,0x80},  // RIGHT
  {0x000D,0,7,0x80},  // RETURN
  {0x0020,0,8,0x01},  // SPACE
  {0x0008,0,7,0x20},  // BS
  {0x0030,0,0,0x01},  // '0'
  {0x0031,0,0,0x02},  // '1'
  {0x0032,0,0,0x04},  // '2'
  {0x0033,0,0,0x08},  // '3'
  {0x0034,0,0,0x10},  // '4'
  {0x0035,0,0,0x20},  // '5'
  {0x0036,0,0,0x40},  // '6'
  {0x0037,0,0,0x80},  // '7'
  {0x0038,0,1,0x01},  // '8'
  {0x0039,0,1,0x02},  // '9'
  {0x00BD,0,1,0x04},  // -
  {0x00DE,0,1,0x08},  // ^
  {0x00DC,0,1,0x10},  /* \ */
  {0x00C0,0,1,0x20},  // @
  {0x00DB,0,1,0x40},  // [
  {0x00BB,0,1,0x80},  // +
  {0x00BA,0,2,0x01},  // :
  {0x00DD,0,2,0x02},  // ]
  {0x00BC,0,2,0x04},  // ,
  {0x00BE,0,2,0x08},  // .
  {0x00BF,0,2,0x10},  // /
  {0x00E2,0,2,0x20},  // _
  {0x0041,0,2,0x40},  // 'A'
  {0x0042,0,2,0x80},  // 'B'
  {0x0043,0,3,0x01},  // 'C'
  {0x0044,0,3,0x02},  // 'D'
  {0x0045,0,3,0x04},  // 'E'
  {0x0046,0,3,0x08},  // 'F'
  {0x0047,0,3,0x10},  // 'G'
  {0x0048,0,3,0x20},  // 'H'
  {0x0049,0,3,0x40},  // 'I'
  {0x004A,0,3,0x80},  // 'J'
  {0x004B,0,4,0x01},  // 'K'
  {0x004C,0,4,0x02},  // 'L'
  {0x004D,0,4,0x04},  // 'M'
  {0x004E,0,4,0x08},  // 'N'
  {0x004F,0,4,0x10},  // 'O'
  {0x0050,0,4,0x20},  // 'P'
  {0x0051,0,4,0x40},  // 'Q'
  {0x0052,0,4,0x80},  // 'R'
  {0x0053,0,5,0x01},  // 'S'
  {0x0054,0,5,0x02},  // 'T'
  {0x0055,0,5,0x04},  // 'U'
  {0x0056,0,5,0x08},  // 'V'
  {0x0057,0,5,0x10},  // 'W'
  {0x0058,0,5,0x20},  // 'X'
  {0x0059,0,5,0x40},  // 'Y'
  {0x005A,0,5,0x80},  // 'Z'
  {0x0010,0,6,0x01},  // SHIFT  
  {0x0011,0,6,0x02},  // CONTROL
  {0x001D,0,6,0x04},  // ϊ   -> GRAPH
  {0x0075,0,6,0x08},  // p     -> CAPS 
  {0x0076,0,6,0x10},  // Ђ炪 -> 
  {0x0070,0,6,0x20},  // VK_F1
  {0x0071,0,6,0x40},  // VK_F2
  {0x0072,0,6,0x80},  // VK_F3
  {0x0073,0,7,0x01},  // VK_F4
  {0x0074,0,7,0x02},  // VK_F5
  {0x001B,0,7,0x04},  // VK_ESCAPE 
  {0x0009,0,7,0x08},  // VK_TAB    
  {0x0022,0,7,0x10},  // VK_NEXT   -> STOP/BREAK
  {0x0023,0,7,0x40},  // VK_END    -> SELECT    
  {0x0024,0,8,0x02},  // VK_HOME   -> HOME/CLS  
  {0x002D,0,8,0x04},  // VK_INSERT -> INSERT    
  {0x002E,0,8,0x08},  // VK_DELETE -> DELETE    
  {0x0000,0,0,0x00}   // ** The End. ** //
};
