// fMSX_CE.cpp 
#include "stdafx.h"
#include "resource.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <tchar.h>


#define MAX_LOADSTRING 512

ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass);
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow);
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
HWND CreateRpCommandBar(HWND hwnd);
void DoPaint(HWND hWnd);
int start_msx();
void SaveOption();
void LoadOption();

#include "msx/msx.h"
#include "ppp_stdio.h"
#include "KeyBind.h"

extern byte JoyTypeA;
extern byte JoyTypeB;
extern byte Verbose; 
extern byte MSXVersion;
 
HBITMAP bmpKeyBoard;
int UseSOFTKEY  = FALSE; 
int SoftKeyLeft = 0; 
int SoftKeyTop  = 150;

extern int UseSound ;     /* Sound driver frequency			 */
extern int UseStereo;     /* Stereo sound (1=enable)         */
extern int UsePSG   ;     /* PSG emulation (1=enable)        */
extern int UseSCC   ;     /* SCC emulation (1=enable)        */
extern int Use2413  ;     /* MSX-MUSIC (FMPAC) emulation (1=enable)  */
extern int Use8950  ;     /* MSX-AUDIO emulation (1=enable)  */
extern int UseSpriteOver; /* Sprite Over Check 1=ON */      
extern int RemoveCart;
extern int RemoveDisk;
extern int RemoveCas ;
extern int UseAutoRun;

int View_x = 0;
int View_y = 0;
int UseNarrow = FALSE;
int Usex2Mode = FALSE;
int UseDrawBorder = TRUE;
HINSTANCE g_hInst;
HWND      g_hWnd;
HWND      g_hwndCB;  // menu window handle
int CommandBarVis;
int thread_running = FALSE;


char * OpenFileDlg(HWND hWnd, int flg);

LRESULT CALLBACK DLGJoystick(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGSoftKey (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGKeyCheck(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGMisc    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGSound   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGDebug   (HWND, UINT, WPARAM, LPARAM);


#ifdef WIN32_PLATFORM_PSPC
#include "gx.h"

int (*pGXOpenInput)() = NULL;
int (*pGXCloseInput)() = NULL;
GXKeyList (*pGXGetDefaultKeys)(int) = NULL;
HMODULE gxlib;
#endif

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	{
		TCHAR cmd[512];
		char  cmdline[512];	
		char * bufptr;
		int ret;
		ret = GetModuleFileName(hInstance,cmd,512);
		ret = wcstombs(cmdline,cmd,512); 
		if ((bufptr=strrchr( cmdline, '\\' )) != NULL )*bufptr = '\0';
		ProgDir = (char *) malloc( 512 );
		strcpy( ProgDir, cmdline );
	}
	DELLOG();		// Debuglog Deleteing

	LoadOption();

	LOG("fMSX_CE start\n");
	LOG("Program Dir [%s]\n",ProgDir);
	
	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

//	if( *lpCmdLine ){
//		OpenNewGame(hWndNES, lpCmdLine );
//	}

    hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_fMSXCE);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	LOG("fMSX_CE Exit\n");

	return msg.wParam;
}

// MyRegisterClass
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_fMSXCE));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

//  FUNCTION: InitInstance(HANDLE, int)
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name
    RECT	rect;

	LOG("InitInstance Start\n");
	
	g_hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
	LoadString(hInstance, IDC_fMSXCE, szWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	DEBUGLOG("InitInstance 1\n");

	//If it is already running, then focus on the window
	hWnd = FindWindow(szWindowClass, szTitle);	
	if (hWnd) 
	{
		SetForegroundWindow ((HWND) (((DWORD)hWnd) | 0x01));    
		return 0;
	} 

	DEBUGLOG("InitInstance 2\n");

	MyRegisterClass(hInstance, szWindowClass);

	DEBUGLOG("InitInstance 3\n");

//	bmpKeyBoard = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_KEYBOARD));
	{
		TCHAR cmd[512];
		mbstowcs(cmd,ProgDir,512); 
		wcscat( cmd, _T("\\keyboard.bmp") );
		bmpKeyBoard = SHLoadDIBitmap( cmd );
	}
	LOG("KeyBoard Bitmap %s\n",(bmpKeyBoard?"loaded.":"no load. Can't use SoftWare Keyboard.") );

	GetClientRect(hWnd, &rect);
	
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	if (!hWnd)
	{	
		return FALSE;
	}

	DEBUGLOG("InitInstance 4\n");

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// save the handle to this window for other functions to use
	g_hWnd = hWnd;

	if(!bmpKeyBoard) UseSOFTKEY = FALSE;

#ifdef WIN32_PLATFORM_PSPC
	gxlib = (HMODULE) LoadLibrary(TEXT("gx.dll"));
	if (gxlib != NULL)
	{
        pGXOpenInput      = (int (__cdecl *)(void)  ) GetProcAddress(gxlib, TEXT("?GXOpenInput@@YAHXZ" ));
        pGXCloseInput     = (int (__cdecl *)(void)  ) GetProcAddress(gxlib, TEXT("?GXCloseInput@@YAHXZ"));
        pGXGetDefaultKeys = (GXKeyList (__cdecl *)(int )) GetProcAddress(gxlib, TEXT("?GXGetDefaultKeys@@YA?AUGXKeyList@@H@Z"));
    }else{
       LOG("GX.DLL not found.");
    }

	{
		int ret;
		ret = pGXOpenInput();
		LOG( "PocketPC Input device open %s\n",(ret?"OK.\n":"NG!\n") ); 
		if(!ret) return FALSE;
	}
#endif

	LOG("InitInstance End\n");
	return TRUE;
}

//------------------------------------------------------
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	int x,y,num;
	HMENU hMenu;
	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{	
				case ID_MENU_Run:
                    start_msx();
					break;
                case ID_MENU_Reset:
                    ResetZ80(&CPU);
                    break;
                case ID_MENU_Exit:
					SendMessage (hWnd, WM_CLOSE, 0, 0);
					break;
				case ID_MENU_Cart1:
					CartA = OpenFileDlg(hWnd, 1);
					break;
				case ID_MENU_Cart2:
					CartB = OpenFileDlg(hWnd, 1);
					break;
				case ID_MENUCHGDRV_A:
					DiskA = OpenFileDlg(hWnd, 2);
					if( thread_running ) ChangeDisk(0,DiskA);
					break;
				case ID_MENUCHGDRV_B:
					DiskB = OpenFileDlg(hWnd, 2);
					if( thread_running ) ChangeDisk(1,DiskB);
					break;
				case ID_MENUCHGCAS:
					CasName = OpenFileDlg(hWnd, 3);
                    if( strlen(CasName) ) ChangeCas(CasName);
					break;
				case ID_CAS_PREV:
                        CasPrev();
					break;
				case ID_CAS_NEXT:
                        CasNext();
					break;
				case ID_CAS_TOP:
                        CasTop();
					break;
				case ID_CAS_END:
                        CasEnd();
					break;
				case ID_MENUVERBOSE:
					Verbose = (Verbose?0:1);
					hMenu = CommandBar_GetMenu(g_hwndCB, 0 );
					CheckMenuItem(hMenu, ID_MENUVERBOSE, MF_BYCOMMAND | (Verbose? MF_CHECKED : MF_UNCHECKED) );
					break;
				case ID_MENUMSX1:
				case ID_MENUMSX2:
				case ID_MENUMSX2P:
					MSXVersion = wmId - ID_MENUMSX1;
					hMenu = CommandBar_GetMenu(g_hwndCB, 0 );
					CheckMenuRadioItem(hMenu, ID_MENUMSX1,ID_MENUMSX2P,wmId, MF_BYCOMMAND );
					break;
				case ID_MENU_MISC:
					DialogBox(g_hInst, (LPCTSTR)IDD_SETUP, hWnd, (DLGPROC)DLGMisc);
					break;
				case ID_MENU_SOUND:
					DialogBox(g_hInst, (LPCTSTR)IDD_SOUND, hWnd, (DLGPROC)DLGSound);
					break;
				case ID_MENU_JOYSTICK:
					DialogBox(g_hInst, (LPCTSTR)IDD_JOYSTICK, hWnd, (DLGPROC)DLGJoystick);
					break;
				case ID_MENU_SOFTKEYBOARD:
					DialogBox(g_hInst, (LPCTSTR)IDD_SOFTKEY, hWnd, (DLGPROC)DLGSoftKey);
					break;
				case ID_KEYCHECK:
					DialogBox(g_hInst, (LPCTSTR)IDD_KEYCHECK, hWnd, (DLGPROC)DLGKeyCheck);
					break;
				case ID_MENU_DEBUG:
                    CommandBarVis = CommandBar_Show( g_hwndCB, FALSE );
                    DialogBox(g_hInst, (LPCTSTR)IDD_DEBUG, hWnd, (DLGPROC)DLGDebug);
					break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			g_hwndCB = CreateRpCommandBar(hWnd);
//            LoadOption();
            if( UseAutoRun ) {
//               Sleep(1000);
                start_msx();
            }
            break;
		case WM_PAINT:
			DoPaint(hWnd);
			break; 
		case WM_CLOSE:
			ExitNow = 1;
			while( thread_running ) {Sleep(10);};
			SaveOption();
			CommandBar_Destroy(g_hwndCB);
#ifdef WIN32_PLATFORM_PSPC
			pGXCloseInput();
#endif
			DestroyWindow(hWnd);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
/*
        case WM_KEYDOWN:
			if( !UseHARDKEYCHECK )	DownKey( wParam ); 
			break;	
		case WM_KEYUP:
			if( !UseHARDKEYCHECK )	UpKey( wParam );
			break;
*/
		case WM_LBUTTONDOWN:
			x = LOWORD(lParam); 
			y = HIWORD(lParam); 
			if( UseSOFTKEY &&
				( x > SoftKeyLeft ) && ( x <= SoftKeyLeft + 240 ) &&  
				( y > SoftKeyTop  ) && ( y <= SoftKeyTop  + 96  )    ) { 
				num = ((y - SoftKeyTop) / 16)  * 15  + ( (x - SoftKeyLeft) / 16 );
				DownSoftKey( num );
			}else{
				CommandBarVis = CommandBar_Show( g_hwndCB, CommandBarVis );
			}
			break;
/*
        case WM_LBUTTONUP:
            x = LOWORD(lParam); 
			y = HIWORD(lParam); 
			if( UseSOFTKEY &&
				( x > SoftKeyLeft ) && ( x <= SoftKeyLeft + 240 ) &&  
				( y > SoftKeyTop  ) && ( y <= SoftKeyTop  + 48  )    ){ 
				num = ((y - SoftKeyTop) / 12)  * 20  + ( (x - SoftKeyLeft) / 12 );
				UpSoftKey( num );
			}
			break;
*/
        case WM_ACTIVATE:
            switch( LOWORD(wParam) )
            {
                case WA_ACTIVE:
                case WA_CLICKACTIVE:
                    break;
                case WA_INACTIVE:
                    break;
            }
        default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

HWND CreateRpCommandBar(HWND hwnd)
{
	HWND hcb;
	BOOL res;
    HMENU hmn;

    hcb = CommandBar_Create( g_hInst, hwnd, 1 );
	res = CommandBar_InsertMenubar( hcb, g_hInst, IDM_MENU, 0 );	
    hmn = CommandBar_GetMenu( hcb, 0 );

	CheckMenuRadioItem(hmn, ID_MENUMSX1,ID_MENUMSX2P,(MSXVersion+ID_MENUMSX1), MF_BYCOMMAND );
	CheckMenuItem(hmn, ID_MENUVERBOSE, MF_BYCOMMAND | (Verbose? MF_CHECKED : MF_UNCHECKED) );
	if(!bmpKeyBoard) EnableMenuItem(hmn,ID_MENU_SOFTKEYBOARD,MF_GRAYED);
#ifndef DEBUG
    EnableMenuItem(hmn,ID_MENU_DEBUG,MF_GRAYED);
#endif        
	return hcb;
}

char * OpenFileDlg(HWND hWnd, int flg)
{
	TCHAR szFileName[256];
	TCHAR szDir[256];
	TCHAR filter1[] = _T("Cart Files(*.rom)\0*.rom\0All files (*.*)\0*.*\0"); 
	TCHAR filter2[] = _T("Disk Files(*.dsk)\0*.dsk\0All files (*.*)\0*.*\0");
	TCHAR filter3[] = _T("Casette Files(*.cas)\0*.cas\0All files (*.*)\0*.*\0") ;

	char * fname;
	
	int ret;
	OPENFILENAME ofn;

	DEBUGLOG( "OpenFileDlg Start\n" );

	szFileName[0] = 0;
	szDir[0] = 0;
	mbstowcs( szDir, ProgDir,256 );	
	memset(&ofn,0,sizeof(ofn));

    DEBUGLOG( "OpenFileDlg 1\n" );

  switch( flg ){
  case 1: ofn.lpstrFilter	= filter1; break;
  case 2: ofn.lpstrFilter	= filter2; break;
  case 3: ofn.lpstrFilter	= filter3; break;
  }     
  ofn.hwndOwner   = hWnd;
  ofn.lStructSize	= sizeof(ofn);
	ofn.lpstrFile		= szFileName;
	ofn.nMaxFile		= 256;
	ofn.Flags			  = OFN_EXPLORER | OFN_ENABLETEMPLATE;
	if(szDir[0]) ofn.lpstrInitialDir = szDir;
	DEBUGLOG( "OpenFileDlg 2\n" );

	// display a open file dialog
	{
	    HINSTANCE hInst = LoadLibrary(_T("gsgetfile.dll"));
		if (hInst) {
			BOOL (*gsGetOpenFileName)(OPENFILENAME* );
			gsGetOpenFileName = GetProcAddress(hInst, _T("gsGetOpenFileName"));
			if (gsGetOpenFileName) {
				ret = gsGetOpenFileName(&ofn);
			}
			FreeLibrary(hInst);
	    }else{
			ret = GetOpenFileName(&ofn);
		}
	}
	DEBUGLOG( "OpenFileDlg 3\n" );

	if( ret ){
		DEBUGLOG( "OpenFileDlg 4\n" );
		fname = (char*)malloc(wcslen(szFileName)*2+1);
		// UNICODE -> char
    	wcstombs(fname, szFileName, wcslen(szFileName)*2);
	}

	return fname;

	DEBUGLOG( "OpenFileDlg END\n" );
}

void DoPaint(HWND hWnd)
{
	HDC hdc;
	PAINTSTRUCT ps;
	
	hdc = BeginPaint(hWnd, &ps);

//	DrawBitmap(hdc, bmpKeyBoard);

	EndPaint(hWnd, &ps);
}

int thread_msx()
{
  HMENU hMenu;

  LOG("start_msx start\n");
  CPU.Trace=0;

#ifdef DEBUG
  CPU.Trap=0xFFFF;CPU.Trace=0;
#endif

  /* Start fMSX! */
  if(!InitMachine()){
	  LOG("start_msx error end [InitMachine err]\n");
	  return(1);
  }

  CommandBarVis = CommandBar_Show( g_hwndCB, FALSE );

  hMenu = CommandBar_GetMenu(g_hwndCB, 0 );
  EnableMenuItem(hMenu,ID_MENU_Run, MF_GRAYED);

  thread_running = TRUE;
  StartMSX();
  TrashMSX();
  TrashMachine();
  thread_running = FALSE;
  DEBUGLOG("start_msx exit\n");
  return(0);
}

int start_msx()
{
	HANDLE hThread;
	DWORD rc;

	hThread = CreateThread(NULL, 
		0,		// stack size (ignored)
		(LPTHREAD_START_ROUTINE)thread_msx,	// Thread function
		0,		// 32 bit parameter passed to thread
		0,		// Creation flags (0 = start thread immediately)
		&rc);	// Receives thread ID

	CloseHandle(hThread);
	return 0;
}

void setJoyPara( HWND hDlg,int str , int cnt )
{
	TCHAR buf[16];
	char mbs[16];
	char mbs2[32];

	strcpy(mbs2,"0x");
	GetDlgItemText( hDlg,str,buf,16 );
	wcstombs(mbs,buf,16);
	strcat(mbs2,mbs);
	Joys[0].Code = atoi(mbs2);
}

// Mesage handler for the Joystick Config box.
LRESULT CALLBACK DLGJoystick(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	TCHAR buf[16];
	switch (message)
	{
		case WM_INITDIALOG:
			SendDlgItemMessage(hDlg,IDC_CHKJOY1,BM_SETCHECK,JoyTypeA,0);
			SendDlgItemMessage(hDlg,IDC_CHKJOY2,BM_SETCHECK,JoyTypeB,0);
			SetDlgItemText( hDlg,IDC_EDTUP1   ,_itow(Joys[0].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTDOWN1 ,_itow(Joys[1].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTLEFT1 ,_itow(Joys[2].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTRIGHT1,_itow(Joys[3].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTA1    ,_itow(Joys[4].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTB1    ,_itow(Joys[5].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTUP2   ,_itow(Joys[6].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTDOWN2 ,_itow(Joys[7].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTLEFT2 ,_itow(Joys[8].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTRIGHT2,_itow(Joys[9].Code,buf,16)  );
			SetDlgItemText( hDlg,IDC_EDTA2    ,_itow(Joys[10].Code,buf,16) );
			SetDlgItemText( hDlg,IDC_EDTB2    ,_itow(Joys[11].Code,buf,16) );
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				JoyTypeA = (unsigned char)SendDlgItemMessage(hDlg,IDC_CHKJOY1,BM_GETCHECK,0,0);
				JoyTypeB = (unsigned char)SendDlgItemMessage(hDlg,IDC_CHKJOY2,BM_GETCHECK,0,0);
//				JoyTypeA = GetDlgItemInt(hDlg,IDC_CHKJOY1,&res,TRUE);
//				JoyTypeB = (IsDlgButtonChecked(HWND hDlg,IDC_CHKJOY2)?1:0);
				setJoyPara( hDlg,IDC_EDTUP1   ,0 );
				setJoyPara( hDlg,IDC_EDTDOWN1 ,1 );
				setJoyPara( hDlg,IDC_EDTLEFT1 ,2 );
				setJoyPara( hDlg,IDC_EDTRIGHT1,3 );
				setJoyPara( hDlg,IDC_EDTA1    ,4 );
				setJoyPara( hDlg,IDC_EDTB1    ,5 );
				setJoyPara( hDlg,IDC_EDTUP2   ,6 );
				setJoyPara( hDlg,IDC_EDTDOWN2 ,7 );
				setJoyPara( hDlg,IDC_EDTLEFT2 ,8 );
				setJoyPara( hDlg,IDC_EDTRIGHT2,9 );
				setJoyPara( hDlg,IDC_EDTA2    ,10);
				setJoyPara( hDlg,IDC_EDTB2    ,11);
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// Mesage handler for the Software Keyboard Config box.
LRESULT CALLBACK DLGSoftKey(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			SendDlgItemMessage( hDlg, IDC_USESOFTKEYBOARD, BM_SETCHECK, UseSOFTKEY, 0 );   // softkeyboard  
			SetDlgItemInt( hDlg, IDC_EDIT_LEFT , SoftKeyLeft, FALSE );
			SetDlgItemInt( hDlg, IDC_EDIT_TOP  , SoftKeyTop , FALSE );
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				UseSOFTKEY  = SendDlgItemMessage(hDlg,IDC_USESOFTKEYBOARD,BM_GETCHECK,0,0);
				SoftKeyLeft = GetDlgItemInt( hDlg, IDC_EDIT_LEFT, NULL, FALSE );
				SoftKeyTop  = GetDlgItemInt( hDlg, IDC_EDIT_TOP , NULL, FALSE );
				EndDialog(hDlg, LOWORD(wParam));
//        ReadKeyBind((UseSOFTKEY?SoftKeyRCFile:KeyRCFile),Keys);
        return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// Mesage handler for the Misc Config box.
LRESULT CALLBACK DLGMisc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			SetDlgItemInt( hDlg, IDC_UPERIOD , UPeriod, FALSE );
			SetDlgItemInt( hDlg, IDC_VPERIOD , VPeriod, FALSE );
			SetDlgItemInt( hDlg, IDC_HPERIOD , HPeriod, FALSE );
            SetDlgItemInt( hDlg, IDC_VIEW_X  , View_x , TRUE );
            SetDlgItemInt( hDlg, IDC_VIEW_Y  , View_y , TRUE );
			SendDlgItemMessage( hDlg, IDC_NARROW  ,  BM_SETCHECK, UseNarrow, 0 );   // Narrow Mode 
			SendDlgItemMessage( hDlg, IDC_x2MODE  ,  BM_SETCHECK, Usex2Mode, 0 );   // x2 Mode 
			SendDlgItemMessage( hDlg, IDC_DRAWBORDER,BM_SETCHECK, UseDrawBorder, 0 );   // Draw border 
			SendDlgItemMessage( hDlg, IDC_SPOVRCHK,  BM_SETCHECK, UseSpriteOver, 0 );   // Sprite Over Check 
			SendDlgItemMessage( hDlg, IDC_AUTORUN ,  BM_SETCHECK, UseAutoRun, 0 );   // Auto run 

            SendDlgItemMessage( hDlg, IDC_REMOVECART, BM_SETCHECK, RemoveCart, 0 );   // Remove Cart 
			SendDlgItemMessage( hDlg, IDC_REMOVEDISK, BM_SETCHECK, RemoveDisk, 0 );   // Remove Disk 
			SendDlgItemMessage( hDlg, IDC_REMOVECAS,  BM_SETCHECK, RemoveCas,  0 );   // Remove Cas 
            return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				UPeriod = GetDlgItemInt( hDlg, IDC_UPERIOD, NULL, FALSE );
				VPeriod = GetDlgItemInt( hDlg, IDC_VPERIOD, NULL, FALSE );
				HPeriod = GetDlgItemInt( hDlg, IDC_HPERIOD, NULL, FALSE );
                View_x  = GetDlgItemInt( hDlg, IDC_VIEW_X , NULL, TRUE );
                View_y  = GetDlgItemInt( hDlg, IDC_VIEW_Y , NULL, TRUE );
				UseNarrow     = SendDlgItemMessage( hDlg, IDC_NARROW,    BM_GETCHECK,0,0 );
				Usex2Mode     = SendDlgItemMessage( hDlg, IDC_x2MODE,    BM_GETCHECK,0,0 );
				UseDrawBorder = SendDlgItemMessage( hDlg, IDC_DRAWBORDER,BM_GETCHECK,0,0 );
				UseSpriteOver = SendDlgItemMessage( hDlg, IDC_SPOVRCHK,  BM_GETCHECK,0,0 );
			    UseAutoRun    = SendDlgItemMessage( hDlg, IDC_AUTORUN,   BM_GETCHECK,0,0 );   // Auto run 

                RemoveCart = SendDlgItemMessage( hDlg, IDC_REMOVECART, BM_GETCHECK,0 ,0 );   // Remove Cart 
			    RemoveDisk = SendDlgItemMessage( hDlg, IDC_REMOVEDISK, BM_GETCHECK,0 ,0 );   // Remove Disk 
			    RemoveCas  = SendDlgItemMessage( hDlg, IDC_REMOVECAS,  BM_GETCHECK,0 ,0 );   // Remove Cas 
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
// Mesage handler for the Sound Config box.
LRESULT CALLBACK DLGSound(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
//			SendDlgItemMessage( hDlg, IDC_SOUNDENABLE , BM_SETCHECK, UseSOUND,  0 );   // Sound enable 
			SendDlgItemMessage( hDlg, IDC_PSG         , BM_SETCHECK, UsePSG,    0 );   // PSG 
			SendDlgItemMessage( hDlg, IDC_SCC         , BM_SETCHECK, UseSCC,    0 );   // SCC  
			SendDlgItemMessage( hDlg, IDC_FMPAC       , BM_SETCHECK, Use2413,   0 );   // FMPAC
			SendDlgItemMessage( hDlg, IDC_MSXAUDIO    , BM_SETCHECK, Use8950,   0 );   // MSX-AUDIO 
	        SendDlgItemMessage( hDlg, IDC_STEREO      , BM_SETCHECK, UseStereo, 0 );   // STEREO 
			SetDlgItemInt( hDlg, IDC_SAMPLERATE , UseSound, FALSE );
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
//				UseSOUNDENABLE = SendDlgItemMessage( hDlg, IDC_SOUNDENABLE, BM_GETCHECK,0,0 );
				UsePSG         = SendDlgItemMessage( hDlg, IDC_PSG        , BM_GETCHECK,0,0 );
				UseSCC         = SendDlgItemMessage( hDlg, IDC_SCC        , BM_GETCHECK,0,0 );
				Use2413        = SendDlgItemMessage( hDlg, IDC_FMPAC      , BM_GETCHECK,0,0 );
				Use8950        = SendDlgItemMessage( hDlg, IDC_MSXAUDIO   , BM_GETCHECK,0,0 );
				UseStereo      = SendDlgItemMessage( hDlg, IDC_STEREO     , BM_GETCHECK,0,0 );
				UseSound       = GetDlgItemInt( hDlg, IDC_SAMPLERATE , NULL, FALSE );
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

void view_reg(HWND hDlg, Z80 *R) 
{                        
    static char Flags[9] = "SZ.H.PNC";
    char T[16];
    char buf[128];
    TCHAR tbuf[128];
    int I,J;
    for(J=0,I=R->AF.B.l;J<8;J++,I<<=1) T[J]=I&0x80? Flags[J]:'.';
    T[8]='\0';
    sprintf
      ( buf,"AF:%04X\r\nHL:%04X\r\nDE:%04X\r\nBC:%04X\r\nSP:%04X\r\nIX:%04X\r\nIY:%04X\r\nI :%02X\r\n"
            "PC:%04X\r\nFLGS:%s\r\n%s: %s",
        R->AF.W,R->HL.W,R->DE.W,R->BC.W,R->SP.W,R->IX.W,R->IY.W,R->I,
        R->PC.W,T,
        R->IFF&0x04? "IM2":R->IFF&0x02? "IM1":"IM0", R->IFF&0x01? "EI":"DI"
      ); 
    mbstowcs(tbuf,buf,128);
    SetDlgItemText( hDlg,IDC_REG,tbuf );
/*
    sprintf
      ( buf,"AT PC: [%02X]   AT SP: [%04X]   FLAGS: [%s]   %s: %s\r\n\r\n",
        RdZ80(R->PC.W),RdZ80(R->SP.W)+RdZ80(R->SP.W+1)*256,T,
        R->IFF&0x04? "IM2":R->IFF&0x02? "IM1":"IM0", R->IFF&0x01? "EI":"DI"
      );
    mbstowcs(tbuf,buf,128);
    SetDlgItemText( hDlg,IDC_CONSOLE,tbuf );
*/
}

HWND Debug_hDlg;

void view_reg2(Z80 *R) 
{
	if( Debug_hDlg ){
		view_reg( Debug_hDlg, R);
	}
}

void putcon( HWND hDlg, char * buf )
{
    TCHAR tbuf[128];
    mbstowcs(tbuf,buf,128);
    SendDlgItemMessage(hDlg, IDC_CONSOLE, EM_REPLACESEL,FALSE,(LPARAM)tbuf );
}

extern int DAsm(char *S,word A);

word Addr;
int rflg = 1;

// Mesage handler for the Sound Config box.
LRESULT CALLBACK DLGDebug(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{

	switch (message)
	{
		case WM_INITDIALOG:
			Debug_hDlg = hDlg;
			break;
	    case WM_COMMAND:
		    if (LOWORD(wParam) == IDC_TRAP) {
                CPU.Trace=1;
                view_reg(hDlg,&CPU);
                break;
            }   
            if( LOWORD(wParam) == IDCANCEL) {
                CPU.Trap=0xFFFF;CPU.Trace=0;
				Debug_hDlg = NULL;
                EndDialog(hDlg, LOWORD(wParam));
                break;
            }
            if( LOWORD(wParam) == IDOK) {
                TCHAR tbuf[128];
                char buf[256];
                int J;
                Z80 *R = &CPU;

                GetDlgItemText( hDlg, IDC_DBG_CMD, tbuf, 128 );
                wcstombs(buf,tbuf,128);
                
                for(J=0;buf[J]>=' ';J++)
                  buf[J]=toupper(buf[J]);
                buf[J]='\0';

                switch(buf[0])
                {
                  case 'H':
                  case '?':
                    putcon(hDlg,"***** Built-in Z80 Debugger Commands *****\r\n");
                    putcon(hDlg,"<CR>       : Break at next instruction\r\n");
                    putcon(hDlg,"= <addr>   : Break at addr\r\n");
                    putcon(hDlg,"+ <offset> : Break at PC + offset\r\n");
                    putcon(hDlg,"c          : Continue without break\r\n");
                    putcon(hDlg,"j <addr>   : Continue from addr\r\n");
                    putcon(hDlg,"m <addr>   : Memory dump at addr\r\n");
                    putcon(hDlg,"d <addr>   : Disassembly at addr\r\n");
                    putcon(hDlg,"?,h        : Show this help text\r\n");
                    break;
                  case '\0': R->Trap=0xFFFF;
                             R->Trace=2;
                            rflg = 1;
                             break;
                  case '=':  if(strlen(buf)>=2){
                               R->Trace=0;
                               R->Trap = atoi(&buf[1]);
                             }
                            rflg = 1;
                             break;
                  case '+':  if(strlen(buf)>=2){
                               R->Trace = atoi(&buf[1]);
                               R->Trap=0xFFFF;
                             }
                            rflg = 1;
                             break;
                  case 'J':  if(strlen(buf)>=2){ 
                               R->PC.W = atoi(&buf[1]);
                               R->Trace=0;
                             }
                            rflg = 1;
                             break;
                  case 'C':  R->Trap=0xFFFF;R->Trace=0; 
                            rflg = 1;
                             break;
                  case 'M':
                    {
                      char S[32];
                      int I;

                      if(strlen(buf)>1) 
                         Addr = atoi( &buf[1] ); 
                      else {
                         if( rflg ) Addr=R->PC.W;
                      }

                      for(J=0;J<16;J++)
                      {
                        sprintf( S, "%04X: ",Addr ) ;
                        putcon(hDlg,S);
                        for(I=0;I<16;I++,Addr++){
                          sprintf(S, "%02X ",RdZ80(Addr));
                          putcon(hDlg, S);
                        }
                        putcon(hDlg, " | ");Addr-=16;
                        for(I=0;I<16;I++,Addr++){
                          S[I] = isprint(RdZ80(Addr))? RdZ80(Addr):'.';
                        }
                        S[16] = '\0';
                        putcon(hDlg,S);
                        putcon(hDlg,"\r\n" );
                      }
                    }
                    rflg = 0;
                    break;

                  case 'D':
                    {
                      char S[64];

                      if(strlen(buf)>1) 
                         Addr = atoi( &buf[1] ); 
                      else {
                         if( rflg ) Addr=R->PC.W;
                      }

                      for(J=0;J<16;J++)
                      {
                        int add, i;
                        char b[10];
                        sprintf(S, "%04X: ",Addr);
                        putcon(hDlg,S);
#ifdef DEBUG
                        add = DAsm(S,Addr);
#endif
                        for(i=0;i<3;i++){
                          if(i<add){
                            sprintf(b,"%02X ",RdZ80(Addr+i));
                          }else{
                            strcpy(b,"   ");
                          }
                          putcon(hDlg,b);
                        }
                        putcon(hDlg,S);
                        putcon(hDlg,"\r\n" );
                        Addr+=add;
                      }
                      putcon(hDlg,"\r\n" );
                    }
                    rflg = 0;
                    break;
                  case 'V':
                      {
                        char buf[64];
                        sprintf( buf,"VDP 00[%02x] 01[%02x] 02[%02x] 03[%02x] 04[%02x] 05[%02x] 06[%02x] 07[%02x]\r\n",
                                   VDP[0],VDP[1],VDP[2],VDP[3],VDP[4],VDP[5],VDP[6],VDP[7]);
                        putcon(hDlg,buf);
                        sprintf( buf,"VDP 08[%02x] 09[%02x] 10[%02x] 11[%02x] 12[%02x] 13[%02x] 14[%02x] 15[%02x]\r\n",
                                   VDP[8],VDP[9],VDP[10],VDP[11],VDP[12],VDP[13],VDP[14],VDP[15]);
                        putcon(hDlg,buf);
                        sprintf( buf,"VDP 16[%02x] 17[%02x] 18[%02x] 19[%02x] 20[%02x] 21[%02x] 22[%02x] 23[%02x]\r\n",
                                   VDP[16],VDP[17],VDP[18],VDP[19],VDP[20],VDP[21],VDP[22],VDP[23]);
                        putcon(hDlg,buf);
                      }
                      break;                       
                }
            }
            break;
        default:
           return FALSE;
    }        
    return TRUE;
}

void CALLBACK TimerProc(HWND hwnd,UINT uMsg,UINT idEvent,DWORD dwTime )
{ 
	TCHAR buf[128];
	TCHAR sbuf[16];	
	int i;

	buf[0]=0;

	for( i=1;i<255;i++ ){
		if( GetAsyncKeyState(i)&0x8000 ) {
			_itow(i,sbuf,16);
			wcscat( buf, sbuf );
		}
	}
	SetDlgItemText( hwnd,IDC_EDIT1,buf );
}

// Mesage handler for the Key Check Config box.
LRESULT CALLBACK DLGKeyCheck(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
//	TCHAR buf[16];
	switch (message)
	{
		case WM_INITDIALOG:
			SetTimer( hDlg,1,500,TimerProc);
			break;
/*		case WM_PAINT:
			SetDlgItemText( hDlg,IDC_EDIT1   ,_itow(DownKey(0),buf,16)  );
			break;			
/*		case WM_KEYDOWN:
			SetDlgItemText( hDlg,IDC_EDIT1   ,_itow(wParam,buf,16)  );
			break;		
*/
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

void CheckBool( char * key, char * buf, int * flg )
{
	if( !strncmp(key,buf,10) ){
		if( buf[11] == 't' || buf[11] == 'T' ) *flg = TRUE;
										else   *flg = FALSE;
	}
}
void CheckInt( char * key, char * buf, int * flg )
{
	if( !strncmp(key,buf,10) )	*flg =  atoi( &buf[11] );
}
void CheckByte( char * key, char * buf, unsigned char * flg )
{
	if( !strncmp(key,buf,10) )	*flg =  atoi( &buf[11] );
}
char * CheckStr( char * key, char * buf, char * rbuf )
{
    if( !strncmp(key,buf,10) ){
		DEBUGLOG("CheckStr buf[%s]\n",&buf[11]);
        if(rbuf) free(rbuf);
		DEBUGLOG("CheckStr 2\n");
        rbuf = malloc( strlen(buf)+1);
		DEBUGLOG("CheckStr 3\n");
        strcpy(rbuf,&buf[11]);
		DEBUGLOG("CheckStr 4\n");
    }
    return rbuf;
}
/*===================================================================*/
/*            LoadOption() : Option Load                             */
/*===================================================================*/
void LoadOption()
{
	FILE * fp;
	char buf[256];

	strcpy(buf, ProgDir);
	strcat(buf,"\\fMSX_CE.cfg");

	fp = fopen( buf,"r" );
	while( fgets(buf,255,fp) ){
		char * sbuf = strrchr( buf, 0x0A );
		*sbuf = '\0';
        CheckInt(  "VIEW_X    ",buf,&View_x          );
        CheckInt(  "VIEW_Y    ",buf,&View_y          );
		CheckBool( "USENARROW ",buf,&UseNarrow       );
		CheckBool( "USEx2MODE ",buf,&Usex2Mode       );
		CheckBool( "DRAWBORDER",buf,&UseDrawBorder   );

        CheckBool( "USESOFTKEY",buf,&UseSOFTKEY      );

        CheckBool( "USEPSG    ",buf,&UsePSG          );
		CheckBool( "USESCC    ",buf,&UseSCC          );
		CheckBool( "USE2413   ",buf,&Use2413         );
		CheckBool( "USE8950   ",buf,&Use8950         );
		CheckBool( "USESTEREO ",buf,&UseStereo       );
		CheckInt(  "USESOUND  ",buf,&UseSound        );

		CheckInt(  "SOFTKEYLFT",buf,&SoftKeyLeft     );
		CheckInt(  "SOFTKEYTOP",buf,&SoftKeyTop      );
                                  
		CheckByte( "U_PERIOD  ",buf,&UPeriod         );
		CheckInt(  "V_PERIOD  ",buf,&VPeriod         );
		CheckInt(  "H_PERIOD  ",buf,&HPeriod         );
        
        CheckBool( "CHKSPOVER ",buf,&UseSpriteOver   ); 

        CartA   = CheckStr(  "CARTANAME ",buf,CartA  );
		CartB   = CheckStr(  "CARTBNAME ",buf,CartB  );
		DiskA   = CheckStr(  "DISKANAME ",buf,DiskA  );
		DiskB   = CheckStr(  "DISKBNAME ",buf,DiskB  );
		CasName = CheckStr(  "CASNAME   ",buf,CasName);

		CheckBool( "REMOVECART",buf,&RemoveCart );
		CheckBool( "REMOVEDISK",buf,&RemoveDisk );
		CheckBool( "REMOVECAS ",buf,&RemoveCas  );

		CheckBool( "AUTORUN   ",buf,&UseAutoRun );
		CheckByte( "VERBOSE   ",buf,&Verbose    );

    }
	fclose(fp);

	LOG("Option loaded.\n");
}

/*===================================================================*/
/*            SaveOption() : Save Option                             */
/*===================================================================*/
void SaveOption()
{
	FILE * fp;
	char buf[256];

	strcpy(buf, ProgDir);
	
	strcat(buf,"\\fMSX_CE.cfg");

	fp = fopen( buf,"w" );
    fprintf(fp,"VIEW_X    =%d\n",View_x  );
    fprintf(fp,"VIEW_Y    =%d\n",View_y  );
	fprintf(fp,"USENARROW =%s\n",(UseNarrow      ?"TRUE":"FALSE") );
	fprintf(fp,"USEx2MODE =%s\n",(Usex2Mode      ?"TRUE":"FALSE") );
	fprintf(fp,"DRAWBORDER=%s\n",(UseDrawBorder  ?"TRUE":"FALSE") );

    fprintf(fp,"USESOFTKEY=%s\n",(UseSOFTKEY     ?"TRUE":"FALSE") );

	fprintf(fp,"USEPSG    =%s\n",(UsePSG         ?"TRUE":"FALSE") );
	fprintf(fp,"USESCC    =%s\n",(UseSCC         ?"TRUE":"FALSE") );
	fprintf(fp,"USE2413   =%s\n",(Use2413        ?"TRUE":"FALSE") );
	fprintf(fp,"USE8950   =%s\n",(Use8950        ?"TRUE":"FALSE") );
	fprintf(fp,"USESTEREO =%s\n",(UseStereo      ?"TRUE":"FALSE") );
	fprintf(fp,"USESOUND  =%d\n",UseSound    );

	fprintf(fp,"SOFTKEYLFT=%d\n",SoftKeyLeft );
	fprintf(fp,"SOFTKEYTOP=%d\n",SoftKeyTop  );

	fprintf(fp,"U_PERIOD  =%d\n",UPeriod  );
	fprintf(fp,"V_PERIOD  =%d\n",VPeriod  );
	fprintf(fp,"H_PERIOD  =%d\n",HPeriod  );
    fprintf(fp,"CHKSPOVER =%d\n",UseSpriteOver ); 

	if( RemoveCart ){
		fprintf(fp,"CARTANAME =\n" );
		fprintf(fp,"CARTBNAME =\n" );
	}else{
		fprintf(fp,"CARTANAME =%s\n",CartA  );
		fprintf(fp,"CARTBNAME =%s\n",CartB  );
	}

	if( RemoveDisk ){
		fprintf(fp,"DISKANAME =\n" );
		fprintf(fp,"DISKBNAME =\n" );
	}else{
		fprintf(fp,"DISKANAME =%s\n",DiskA  );
		fprintf(fp,"DISKBNAME =%s\n",DiskB  );
	}
    if( RemoveCas ){
		fprintf(fp,"CASNAME   =\n");
	}else{
		fprintf(fp,"CASNAME   =%s\n",CasName);
	}

	fprintf(fp,"REMOVECART=%s\n",(RemoveCart ?"TRUE":"FALSE") );
	fprintf(fp,"REMOVEDISK=%s\n",(RemoveDisk ?"TRUE":"FALSE") );
	fprintf(fp,"REMOVECAS =%s\n",(RemoveCas  ?"TRUE":"FALSE") );

	fprintf(fp,"AUTORUN   =%s\n",(UseAutoRun ?"TRUE":"FALSE") );

	fprintf(fp,"VERBOSE   =%d\n", Verbose );
	fclose(fp);

	LOG("Option saved.\n");
}
