#ifndef __PPP_STDIO__
#define __PPP_STDIO__

//#define DEBUGLOG LOG
#define DEBUGLOG NOLOG

void LOG( char * str , ... );
void NOLOG( char * str, ... );
void DELLOG(void);

#define fopen(_AA,_BB)          ppp_fopen(_AA,_BB)
#define fclose(_AA)             ppp_fclose(_AA)
#define fread(_AA,_BB,_CC,_DD)  ppp_fread(_AA,_BB,_CC,_DD)
#define fwrite(_AA,_BB,_CC,_DD) ppp_fwrite(_AA,_BB,_CC,_DD)
#define fseek(_AA,_BB,_CC)      ppp_fseek(_AA,_BB,_CC)
#define rewind(_AA)             ppp_rewind(_AA)
#define fgetc(_AA)              ppp_fgetc(_AA)
#define fgets(_AA,_BB,_CC)      ppp_fgets(_AA,_BB,_CC)
#define fputc(_AA,_BB)          ppp_fputc(_AA,_BB)
#define feof(_AA)               ppp_feof(_AA)
#define ferror(_AA)             ppp_ferror(_AA)
#define ftell(_AA)              ppp_ftell(_AA)
#define fscanf                  ppp_fscanf
#define fprintf                 ppp_fprintf
#define calloc(_AA,_BB)         ppp_calloc(_AA,_BB)
#define strrchr(_AA,_BB)        ppp_strrchr(_AA,_BB)
#define atoi(_AA)               ppp_atoi(_AA)
#ifndef islower
#define islower(_AA)            ppp_islower(_AA)
#endif
#ifndef isupper
#define isupper(_AA)            ppp_isupper(_AA)
#endif
#ifndef isdigit
#define isdigit(_AA)            ppp_isdigit(_AA)
#endif
#ifndef isalpha
#define isalpha(_AA)            ppp_isalpha(_AA)
#endif
#ifndef isprint
#define isprint(_AA)            ppp_isprint(_AA)
#endif
#ifndef ZeroMemory
#define ZeroMemory(_AA,_BB)     memset(_AA,0,_BB)
#endif

#ifdef __cplusplus
extern "C"{
#endif 

FILE * ppp_fopen( const char * , const char * );
int    ppp_fclose( FILE * );
size_t ppp_fread( void * , size_t , size_t , FILE * );
size_t ppp_fwrite( const void * , size_t , size_t , FILE * );
int    ppp_fseek( FILE * , long , int );
int    ppp_rewind( FILE *stream );

int    ppp_fscanf(FILE *, const char *, ...);
int    ppp_fprintf(FILE *, const char *, ...);
int    ppp_fgetc( FILE * );
char * ppp_fgets( char * , int , FILE * );

int    ppp_fputc( int , FILE * );

int    ppp_feof( FILE * );
int    ppp_ferror( FILE * );

int    ppp_ftell( FILE * );

void * ppp_calloc( size_t num, size_t siz);
char * ppp_strrchr(const char * buf, int chr);
int    ppp_atoi(const char *s);
int    ppp_islower(int a );
int    ppp_isupper(int a );
int    ppp_isdigit(int a );
int    ppp_isalpha(int a );
int    ppp_isprint(int a );

#ifdef __cplusplus
}
#endif 

#endif
