//////////////////////////////////////////////////////////////////////
// fmsxDS
//////////////////////////////////////////////////////////////////////
#include "../../common/ipc2.h"
#include "msx.h"
#include <string.h>
#include <stdlib.h>
#include <NDS.h>
#include "DSGraph.h"
#include "Keybind.h"
#include "gba_nds_fat.h"

#define RGB16(a,r,g,b)  RGB15(r,g,b)|((a)<<15)

/** Public parameters ****************************************/
int UseSound  = 8192;          /* Sound driver frequency    */
char *Disks[2][MAXDISKS+1];    /* Disk names for each drive */

extern byte *MemMap[4][4][8];   /* Memory maps [PPage][SPage][Addr] */

/** Various variables ****************************************/
//#define WIDTH  272
//#define HEIGHT 228
int WIDTH  = 272;
int HEIGHT = 228;

extern u8 touchmap[32*16];
extern void waitForVBlank(int);



/** Keyboard bindings ****************************************/
byte WinKeyMap[16];             /* Keyboard map              */
byte JoyKeyMap[2];				/* Joystick Keymap           */

byte hkey[16];					/* Hold key map              */

unsigned int BPal[256],XPal[80],XPal0; 
char *XBuf;
char *XBuf2;
int  XBufType = 1;

int UseStatic = 0;

extern int View_x;
extern int View_y;
extern int UseNarrow;
extern int Usex2Mode;
extern byte TapeHeader[8];

extern int InitSound(int Rate,int Verb);

u8 * itoa( int n, u8 * buf );

void drawAllKeyboard(void);

void ChangeCas( char * fname );

int pad_type = 0;

#define SetDownKey(AA) ( WinKeyMap[(AA).code]&=~((AA).mask) )
#define SetUpKey(AA)   ( WinKeyMap[(AA).code]|= ((AA).mask) )
//#define SetDownKey(AA) ( KeyMap[(AA).code]&=~((AA).mask) )
//#define SetUpKey(AA)   ( KeyMap[(AA).code]|= ((AA).mask) )

void LOG( char * str , ... )
{
	copyGraph( BG_GFX_SUB, 0, 160, 0, 168, 255, 24 );
	fill( BG_GFX_SUB, 0, 184, 256, 8, 0x8000 );
	drawText( BG_GFX_SUB, 0, 184, (u8*)str, 0xFFFF, 0x8000 );
}

int touchX(void){
	return IPC->touchXpx;
}
int touchY(void){
	return IPC->touchYpx;
}

/*
 getfilelist
    char *  path  XgpX
    char *  ext   gq
	char ** fn    t@C
    int     top   擪̈ʒu
    )
*/

typedef struct tagFILELIST {
	int type;
	char * name;
	struct tagFILELIST * next;
} FILELIST;

FILELIST * newFList( int typ, char * nm )
{
	FILELIST * fl;
	fl = (FILELIST*)malloc( sizeof(FILELIST) );
	fl->type = typ;
	fl->name = (char*)malloc( 13 );
	memcpy( fl->name, nm, 13 );
	fl->next = NULL;
	return fl;
}

FILELIST * getfilelist( char * path, char * ext )
{
	char * c;
	int ret;
	int flg= false;
	int first = true;
	char fname[13];
	FILELIST * top = NULL;
	FILELIST * cur;
	FILELIST * cur_o;

	FAT_chdir( path );

	ret = FAT_FindFirstFile( fname );

	while( ret != 0 ){
		flg = false;
		if( ret == 1 ){		// file
			if( ext != NULL ){
				c = strrchr( fname, '.' );
				if( c != NULL ){
					if( strcmp( c+1, ext )==0 )	flg = true;
				}
			}else{
				flg = true;
			}
		}else{				// dir
			flg = true;
		}

		if( flg ){
			cur = newFList( ret, fname );
			if( first ){
				top = cur;
				first = false;
			}else{
				cur_o->next = cur;
			}
			cur_o = cur;
//			LOG( cur->name );
		}
		ret = FAT_FindNextFile( fname );
//		LOG( "FAT_FindNextFile" );
	}
	return top;
}

char * fnlist;

FILELIST * getlist( FILELIST * lst, int cnt )
{
	for(int i=0;i<cnt;i++){
		if( lst->next ){
			lst = lst->next;
		}else{
			break;
		}
	}
	return lst;
}

#define FSELWIN_X     20
#define FSELWIN_Y     30
#define FSELWIN_W     200
#define FSELWIN_H     120

#define FLIST_X       (FSELWIN_X+10)
#define FLIST_Y       (FSELWIN_Y+10)
#define FLIST_W       120
#define FLIST_H       10
#define FLIST_CNT     10

#define BtnUP_X       (FSELWIN_X+130)
#define BtnUP_Y       (FSELWIN_Y+10)
#define BtnUP_W       20
#define BtnUP_H       20

#define BtnDOWN_X     (FSELWIN_X+130)
#define BtnDOWN_Y     (FSELWIN_Y+90)
#define BtnDOWN_W     20
#define BtnDOWN_H     20

#define BtnOK_X       (FSELWIN_X+155)
#define BtnOK_Y       (FSELWIN_Y+70)
#define BtnOK_W       40
#define BtnOK_H       20

#define BtnCancel_X   (FSELWIN_X+155)
#define BtnCancel_Y   (FSELWIN_Y+90)
#define BtnCancel_W   40
#define BtnCancel_H   20

#define BtnEject_X    (FSELWIN_X+155)
#define BtnEject_Y    (FSELWIN_Y+10)
#define BtnEject_W    40
#define BtnEject_H    20

int downCheck( int tx,int ty, int x, int y , int w, int h )
{
	if( (tx > x) && (tx < x + w) ){
		if( (ty > y) && (ty < y + h) ){
			return true;
		}
	}
	return false;
}

void freefilelist( FILELIST * lst )
{
	FILELIST * wk;
	while( lst ){
		free( lst->name );
		wk = lst;
		lst = lst->next;
		free( wk );
	}
}

int getfilecount( FILELIST * lst )
{
	int cnt = 0;
	while( lst ){
		cnt ++;
		lst = lst->next;
	}
	return cnt;
}

int fileselect( char * p, char * ext, char * fname )
{
	int top = 0;
	int sel = -1;
//	int y=0;
	int i;
	int chg = true;
	int filecount;
	int ret = false;
//	int col;
	int loopflg = true;
	int firstflg = true;
	int evt;
	FILELIST * lst;
	FILELIST * cur;


	char path[256];

	strcpy( path, p );

	lst = getfilelist( path, ext );
	filecount = getfilecount(lst);
	drawWindow( BG_GFX_SUB,FSELWIN_X,FSELWIN_Y,FSELWIN_W,FSELWIN_H );

	drawButton( BG_GFX_SUB,BtnUP_X    ,BtnUP_Y    ,BtnUP_W    ,BtnUP_H    ,(u8*)"\x7F"   );
	drawButton( BG_GFX_SUB,BtnDOWN_X  ,BtnDOWN_Y  ,BtnDOWN_W  ,BtnDOWN_H  ,(u8*)"\x80"   );
	drawButton( BG_GFX_SUB,BtnEject_X ,BtnEject_Y ,BtnEject_W ,BtnEject_H ,(u8*)"Eject"  );
	drawButton( BG_GFX_SUB,BtnOK_X    ,BtnOK_Y    ,BtnOK_W    ,BtnOK_H    ,(u8*)"OK"     );
	drawButton( BG_GFX_SUB,BtnCancel_X,BtnCancel_Y,BtnCancel_W,BtnCancel_H,(u8*)"Cancel" );

	box ( BG_GFX_SUB,FLIST_X,FLIST_Y,FLIST_W,FLIST_H*FLIST_CNT, RGB16(1,16,16,16) );

	while(loopflg){

		if( chg ){

			fill( BG_GFX_SUB,FLIST_X+1,FLIST_Y+1,FLIST_W-2,FLIST_H*FLIST_CNT-2, RGB16(1,31,31,31) );

			cur = getlist( lst , top );
//			LOG( "fileselect 3" );
			for( i=0;i<FLIST_CNT;i++ ){
//				LOG( cur->name );
				char buf[32];
				if( top + i == sel ) fill( BG_GFX_SUB,FLIST_X+1,FLIST_Y+FLIST_H*i+1,FLIST_W-2,FLIST_H-2, RGB16(1,31,15,15) );
				if( cur->type == 1 ){
					strcpy( buf, cur->name );
				}else{
					strcpy( buf, "[" );
					strcat( buf, cur->name );
					strcat( buf, "]" );
				}
				drawText( BG_GFX_SUB,FLIST_X+2,FLIST_Y+2+FLIST_H*i, (u8*)buf, RGB16(1,0,0,0), 0 );
				cur = cur->next;
				if( !cur ) break;
			}
			chg = false;
		}

	    uint16 specialKeysPressed = ~IPC->buttons;
		evt = 0;
		if(specialKeysPressed & IPC_PEN_DOWN ){
			int tx = touchX();
			int ty = touchY();
			if( downCheck( tx, ty, FLIST_X,FLIST_Y,FLIST_W, FLIST_H*FLIST_CNT ) ){
				sel = top + ( ty - FLIST_Y ) / 10;
				chg = true;
			}else
			if( downCheck(tx,ty, BtnOK_X, BtnOK_Y, BtnOK_W, BtnOK_H) ){
				evt = 1;
			}else
			if( downCheck(tx,ty, BtnCancel_X, BtnCancel_Y, BtnCancel_W, BtnCancel_H) ){
				evt = 2;
			}else
			if( downCheck(tx,ty, BtnEject_X, BtnEject_Y, BtnEject_W, BtnEject_H) ){
				evt = 3;
			}else
			if( downCheck(tx,ty, BtnUP_X, BtnUP_Y, BtnUP_W, BtnUP_H) ){
				if( top > 0 ){
					top --;
					chg = true;
				}
			}else
			if( downCheck(tx,ty, BtnDOWN_X, BtnDOWN_Y, BtnDOWN_W, BtnDOWN_H) ){
				if( top < filecount - 10 ){
					top ++;
					chg = true;
				}
			}
		}
		vuint16 k = ~REG_KEYINPUT;
		if(k&KEY_DOWN ){
			if( sel < filecount-1 ){
				sel++;
				if( top+9 < sel ){
					top+= sel-(top+9);
				}
				chg = true;
			}
		}
		if(k&KEY_UP   ){
			if( sel > 0 ){
				sel--;
				if( top > sel ){
					top = sel;
				}
				chg = true;
			}
		}
		if(k&KEY_A  ){
			if( !firstflg ) evt=1;
		}else{ 
			firstflg = false;
		}
		if(k&KEY_B    ){ evt=2; }
		if(specialKeysPressed&1    ){ evt=3; }

		switch( evt ){
			case 1:	// OK button
				if( sel != -1 ){ 
					FILELIST * wk = getlist( lst, sel );
					if( wk->type == 1 ){
						char buf[256];
						strcpy( fname, path );
						if( strcmp( fname, "/" ) ){
							strcat( fname, "/" );
						}
						strcat( fname, wk->name );
						strcpy( buf, fname );
						strcat( buf, " selected.");
						LOG( buf );
						ret = true;
						loopflg = false;
					}else{
						if( strcmp( wk->name , "." ) != 0 ){
							if( strcmp( wk->name , ".." ) == 0 ){
								char * wk;
								wk = strrchr( path, '/' );
								if( wk == path ) wk ++;
								*wk = '\0';
							}else{
								if( strcmp( path, "/" ) != 0 ){;
									strcat( path, "/" );
								}
								strcat( path, wk->name );
							}
							LOG( path );
							freefilelist( lst );
							lst = getfilelist( path, ext );
							filecount = getfilecount(lst);
							top = 0;
							sel = -1;
							chg = true;
						}
					}
				}
				break;
			case 2: // cancel
				ret = false;
				loopflg = false;
				break;
			case 3: // eject
				char buf[32] = "Ejected.";
				LOG( buf );
				strcpy( fname, "" );
				ret = false;
				loopflg = false;
				break;
		}

		waitForVBlank(6);
	}
	freefilelist( lst );
	return ret;
}

void RomSelect( int num )
{
	int ret;
	char fn[256];
	ret = fileselect( "/", "ROM", fn );
	if( ret ){
		if( !ROMName[num] ) ROMName[num] = (char*)malloc(256);
		strcpy( ROMName[num], fn );
	}
}

void DiskSelect( int num )
{
	int ret;
	char fn[256];
	ret = fileselect( "/", "DSK", fn );
	if( !DSKName[num] ) DSKName[num] = (char*)malloc(256);
	strcpy( DSKName[num], fn );
	ChangeDisk(num,DSKName[num]);
}

void CasSelect( void )
{
	int ret;
	char fn[256];
	ret = fileselect( "/", "CAS", fn );
	if( !CasName ) CasName = (char*)malloc(256);
	strcpy( CasName, fn );
	ChangeCas( CasName );
}

#define MAINMENU_X 5
#define MAINMENU_Y 40
#define MAINMENU_ICONLEFT  (MAINMENU_X +  7)
#define MAINMENU_ICONTOP   (MAINMENU_Y + 10)
#define MAINMENU_ICONW  (32 + 1)
void dispTouch();

int MainMenu()
{
	int tx=0,ty=0;
//	u8 buf[16];
	int redraw = 1;
//	int c = 0;
//	int col;
//	int firstflg = false;
	int kx = 0, okx = 0;
	int ky = 0, oky = 0;
	int icon;
	int pendownflg = false;
	int keydownflg = false;

	IPC2->soundCommand = 1; /* pause sound*/

	while(1){
//		dispTouch();

		if( redraw ){
			drawWindow( BG_GFX_SUB,MAINMENU_X,MAINMENU_Y,245,90 );

			icon = ( ExitNow==0 ? ICON_POWER_ON:ICON_POWER_OFF ) ;
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT , MAINMENU_ICONTOP ,icon );
//			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT , MAINMENU_ICONTOP + 34,ICON_RESET );

			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW  , MAINMENU_ICONTOP               ,ICON_ROM1 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW  , MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_ROM2 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*2, MAINMENU_ICONTOP               ,ICON_DISK1 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*2, MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_DISK2 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*3, MAINMENU_ICONTOP               ,ICON_CAS   );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*4, MAINMENU_ICONTOP               ,ICON_STATLOAD );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*4, MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_STATSAVE );


//			drawIcon( BG_GFX_SUB, 12+34*5, 52   ,ICON_CONFIG );
/*
			switch( pad_type ){
				case STICK1: drawIcon( BG_GFX_SUB, 12+34*6, 52   ,ICON_STICK1 ); break;
				case STICK2: drawIcon( BG_GFX_SUB, 12+34*6, 52   ,ICON_STICK2 ); break;
				case CURSOR: drawIcon( BG_GFX_SUB, 12+34*6, 52   ,ICON_CURSOR ); break;
			}
*/
			icon = ( XBufType == 1 ? ICON_CLIPBTM : (XBufType == 2 ?ICON_CLIPTOP : ICON_CLIPFIT  ) );
			drawIcon( BG_GFX_SUB,MAINMENU_ICONLEFT+MAINMENU_ICONW*6,MAINMENU_ICONTOP   ,icon );

			drawIcon( BG_GFX_SUB,MAINMENU_ICONLEFT+MAINMENU_ICONW*6,MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_CLOSE  );

			if( kx >= 0 && ky >= 0 ){
				box( BG_GFX_SUB,MAINMENU_ICONLEFT+MAINMENU_ICONW*kx,
								MAINMENU_ICONTOP +MAINMENU_ICONW*ky,
								MAINMENU_ICONW-1,
								MAINMENU_ICONW-1,
								RGB16(1,31,0,0 ) );
			}
			redraw = 0;
		}

	    uint16 specialKeysPressed = ~IPC->buttons;
		if(specialKeysPressed & IPC_PEN_DOWN ){
			pendownflg = true;
			tx = touchX();
			ty = touchY();
		}else{
			if( pendownflg ){
				if( ty > MAINMENU_ICONTOP && ty < MAINMENU_ICONTOP+MAINMENU_ICONW ){
					if( tx > MAINMENU_ICONLEFT && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW ) {
						if( ExitNow ) {
							ExitNow = 0;
						}else{
							ExitNow = 1;
						}
						break;
					}
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW   && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*2 ) { RomSelect(0);  redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*2 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*3 ) { DiskSelect(0); redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*3 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*4 ) { CasSelect();   redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*4 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*5 ) { LoadState("/fmsxDS.sta"); }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*6 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*7 ) {
						XBufType = XBufType==1?2:1;
						redraw = 1;
					}
				}
				if( ty > MAINMENU_ICONTOP+MAINMENU_ICONW && ty < MAINMENU_ICONTOP+MAINMENU_ICONW*3 ){
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW   && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*2 ) { RomSelect(1);  redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*2 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*3 ) { DiskSelect(1); redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*4 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*5 ) { SaveState("/fmsxDS.sta"); }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*6 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*7 ) break;
				}
				pendownflg = false;
			}
		}

		vuint16 k = ~REG_KEYINPUT;
		oky = ky;
		okx = kx;
		if(k&KEY_DOWN ){ ky+=1; ky = ky>1?1:ky; }
		if(k&KEY_UP   ){ ky-=1; ky = ky<0?0:ky; }
		if(k&KEY_RIGHT){ kx+=1; kx = kx>6?6:kx; }
		if(k&KEY_LEFT ){ kx-=1; kx = kx<0?0:kx; }
		if( (okx!=kx) || (oky!=ky) ) redraw = 1;
		if(k&KEY_A    ){
			keydownflg = true;
		}else{
			if( keydownflg ){
				if( ky == 0 ){
					if( kx == 0 ) {
						ExitNow = ExitNow==0?1:0;
						break;
					}
					if( kx == 1 ) { RomSelect(0);  redraw = 1; }
					if( kx == 2 ) { DiskSelect(0); redraw = 1; }
					if( kx == 3 ) { CasSelect();   redraw = 1; }
					if( kx == 4 ) { LoadState("/fmsxDS.sta");  }
					if( kx == 6 ) { 
						XBufType = XBufType==1?2:1;
						redraw = 1;
					}
				} else 
				if( ky == 1 ){
					if( kx == 1 ) { RomSelect(1);  redraw = 1; }
					if( kx == 2 ) { DiskSelect(1); redraw = 1; }
					if( kx == 4 ) { SaveState("/fmsxDS.sta");  }
					if( kx == 6 ) { 
						break;
					}
				}
			}
			keydownflg = false;
		}

		waitForVBlank(6);
	}

	drawDesktop( BG_GFX_SUB );
	drawAllKeyboard();

	IPC2->soundCommand = 2; /* play sound*/

	return 0;
}

byte system_RTCIn(byte R)
{
	byte J;
    switch(R)
    {
        case 0:  J=IPC->rtc_seconds % 10   ;break;
        case 1:  J=IPC->rtc_seconds / 10   ;break;
        case 2:  J=IPC->rtc_minutes % 10   ;break;
        case 3:  J=IPC->rtc_minutes / 10   ;break;
        case 4:  J=IPC->rtc_hours   % 10   ;break;
        case 5:  J=IPC->rtc_hours   / 10   ;break;
        case 6:  J=IPC->rtc_incr           ;break;
        case 7:  J=IPC->rtc_day     % 10   ;break;
        case 8:  J=IPC->rtc_day     / 10   ;break;
        case 9:  J=IPC->rtc_month   % 10   ;break;
        case 10: J=IPC->rtc_month   / 10   ;break;
        case 11: J=IPC->rtc_year    % 10   ;break;
        case 12: J=IPC->rtc_year    / 10   ;break;
        default: J=0x0F;break;
    } 
	return J;
}

void ReadKeyBind( char * fn, KEYBIND * kb )
{
}

void vid_close()
{
}

/** InitMachine() ********************************************/
/** Allocate resources needed by the machine-dependent code.**/
/************************************ TO BE WRITTEN BY USER **/
int InitMachine(void)
{
//	int I;
	int J;

	/* sound init */
//	InitSound(UseSound,0);

	/* keybord init */ 
	memset((char*)WinKeyMap,0xFF,16);
	memset((char*)hkey,0xFF,16);

	JoyKeyMap[0] = 0;
	JoyKeyMap[1] = 0;

	/* Reset the palette */
	for(J=0;J<16;J++) XPal[J]=0;
	XPal0=0;

	/* Set SCREEN8 colors */
	for(J=0;J<256;J++ ){
		BPal[J] = RGB16(1, J&0x1C, (J&0xE0)>>3, (J&0x03)<<3 );
//		BPal[J] = ((J&0x1c)<<11)+(J&0xc0)*8+(J&0x03)*8;  
	}

	XBuf  = (char*) BG_GFX;
	XBuf2 = (char*) BG_GFX_SUB;

	return 1;
}

/** TrashMachine() *******************************************/
/** Deallocate all resources taken by InitMachine().        **/
/************************************ TO BE WRITTEN BY USER **/
void TrashMachine(void)
{
  /* video close */
  vid_close();

  /* sound close */
  TrashSound();  

}


#define LINECOL 0xFFFF
#define OFFCOL  0xF39C
#define ONCOL   0xA108
#define FONTCOL 0x8000

#define KB_X	0
#define KB_Y	32
#define KB_CHIP 8

int checkKey( int16 x, int16 y )
{
//	int i=0;

	if( y < KB_Y ) return 255;
	x = (int) x / KB_CHIP;
	y = (int) (y - KB_Y) / KB_CHIP;
	return touchmap[ y * 32 + x ]; 
/*
	int i=0;
	while( Keys[i].mask ){
		if( (Keys[i].x <= x) && (Keys[i].x+Keys[i].width >= x) ){
			if( (Keys[i].y <= y) && (Keys[i].y+Keys[i].height >= y) ){
				return i;
			}
		}
		i++;
	}
	return 0xFFFF;
*/
}

u8 * itoa( int n, u8 * buf )
{
	int a[20];
	int i=0,j,k;
	int f = false;
	if( n == 0 ){
		buf[0]= 0x30;
		buf[1]= 0;
	}else{
		if( n < 0 ){
			n = -n;
			f = true;
		}
		while(n>0){
			a[i] = n%10 + 0x30;
			n = (int)n/10;
			i++;
		}
		if( f ){
			buf[0]='-';
			k = 1;
		}else{
			k = 0;
		}
		for(j=i-1;j>=0;j--){
			buf[k] = a[j] ;
			k++;
		}
		buf[k] = 0;
	}
	return buf;
}
extern byte RdZ80(register word Addr);
#define LOCK_KANA RdZ80(0xFCAC)
#define LOCK_CAPS RdZ80(0xFCAB)
#define LOCK_SHIFT ( !(hkey[6]&1) )
#define LOCK_CTRL  ( !(hkey[6]&2) )
#define LOCK_GRAPH ( !(hkey[6]&4) )

void drawKey( int k, u16 col )
{
	if( k == 255 ) return;
	int x = Keys[k].x * KB_CHIP + KB_X;
	int y = Keys[k].y * KB_CHIP + KB_Y;
	int w = Keys[k].width  * KB_CHIP;
	int h = Keys[k].height * KB_CHIP;
	
	fill( BG_GFX_SUB,x,y,w,h,col );
	box ( BG_GFX_SUB,x,y,w,h,RGB16(1,21,21,21) );

	int num;
	if     ( LOCK_CTRL  ){ num = 9; }
	else if( LOCK_GRAPH ){ num = 8; }
	else if( LOCK_KANA  ){
		if( LOCK_CAPS ){
			num = LOCK_SHIFT?7:6;
		} else {
			num = LOCK_SHIFT?5:4;
		}
	}else
	if( LOCK_CAPS ){
		num = LOCK_SHIFT?3:2;
	} else {
		num = LOCK_SHIFT?1:0;
	}
//  u8 buf[16];
//	itoa( num , buf );
//	LOG( (char *)buf );
	if( Keys[k].text[num] ){
		if( *(Keys[k].text[num]) == 0xFF ){
			char * buf = Keys[k].text[num] + 1;
			drawText( BG_GFX_SUB, x + Keys[k].x_mgn, y + Keys[k].y_mgn, (u8*)buf, RGB16(1,0,0,0), 0);
		}else{
			drawTextMSX( BG_GFX_SUB, x + Keys[k].x_mgn, y + Keys[k].y_mgn, (u8*)(Keys[k].text[num]), RGB16(1,0,0,0), 0);
		}
	}
}

void printText(char * str, int x, int y , int i )
{
    u8 buf[16];
	fill( BG_GFX_SUB, x, y , 100 ,8, 0 );
	drawText( BG_GFX_SUB, x, y, (u8*)str,RGB16(1,31,31,31),RGB16(1,0,0,0) );
	itoa( i , buf );
	drawText( BG_GFX_SUB, x+(strlen((char*)str)*8)+2,y, (u8*)buf,RGB16(1,31,31,31),RGB16(1,0,0,0) );
}

void dispTouch(){
	printText( "touchX  ", 0, 10, IPC->touchX   );
	printText( "touchY  ", 0, 20, IPC->touchY   );
	printText( "touchXpx", 0, 30, IPC->touchXpx );
	printText( "touchYpx", 0, 40, IPC->touchYpx );
	printText( "touchZ1 ", 0, 50, IPC->touchZ1  );
	printText( "touchZ2 ", 0, 60, IPC->touchZ2  );
	printText( "touchXav", 0, 70, IPC2->touchXave);
	printText( "touchYav", 0, 80, IPC2->touchYave);

}

void drawAllKeyboard(void)
{
	int i = 0;
	while( Keys[i].mask ){
		drawKey( i, RGB16(1,31,31,31) );
		i++;
	}
}

void Keyboard(void)
{
	int k;
	int tx = 0,ty = 0;
	static int pen=false;
	static int ok = 0xFF;
//	u8 buf[16];
	int i;
	int chgflg = false;
//	LOG( "Keyboard" );

//    memset((char*)WinKeyMap, 0xFF, 16 );

//	dispTouch();
//	printText( "cnt  ", 0, 10, IPC2->cnt   );

    uint16 specialKeysPressed = ~IPC->buttons;
	if(specialKeysPressed & IPC_PEN_DOWN ){
//		LOG( "Keyboard 1" );
		tx = touchX();
		ty = touchY();

		k = checkKey( tx, ty );
		if( k < 200 ){
			if( k != ok ){
				pen = true;
//				LOG( "Keyboard 2" );
				drawKey( ok, RGB16(1,31,31,31) );
				drawKey(  k, RGB16(1,28,19,19) );
				if( ok < 200 ) SetUpKey(Keys[ok]);
				SetDownKey(Keys[k]);
				chgflg = true;
				ok = k;
			}
		}
	}else{
//		LOG( "Keyboard 3" );
		if( pen ){
//			LOG( "Keyboard 4" );
			drawKey( ok, RGB16(1,31,31,31) );
			if( ok < 200 ){
				SetUpKey(Keys[ok]);
				if( Keys[ok].Hold&1 ){
					hkey[Keys[ok].code] ^= Keys[ok].mask;
				}
				if( Keys[ok].Hold ){
					drawAllKeyboard();
				}
				chgflg = true;
			}
			ok = 255;
			pen = false;
		}
	}
	if( chgflg ){
	    memcpy((char*)KeyMap, (char*)WinKeyMap, 16 );
		for(i=0;i<16;i++ ) KeyMap[i] &= hkey[i];
	}
}

/** DownSoftKey() ********************************************/
/*************************************************************/
/*
int DownSoftKey( int num )
{
	KEYBIND * K;
//	TCHAR buf[32];
//	wsprintf( buf, _T("SKey[%d]\n"), num );
//	OutputDebugString( buf );

	K = &Keys[num];
	if( K->Hold > 0 ){
		hkey[K->Hold] = (hkey[K->Hold])?0:1;	//gO
	}
	SetDownKey(K);
	return 1;
}
*/
/** DrawSoftKey() ***********************************************/
/*************************************************************/
/*
void DrawSoftKey()
{
}
*/

/** Joystick() ***********************************************/
/** Query position of a joystick connected to port N.       **/
/** Returns 0.0.F2.F1.R.L.D.U.                              **/
/************************************ TO BE WRITTEN BY USER **/
byte Joystick(byte N)
{
//	u8 buf[16];
	vuint16 k = ~REG_KEYINPUT;
	JoyKeyMap[0] = 0;
	JoyKeyMap[0] |= (k&KEY_DOWN )?0x02:0;
	JoyKeyMap[0] |= (k&KEY_UP   )?0x01:0;
	JoyKeyMap[0] |= (k&KEY_RIGHT)?0x08:0;
	JoyKeyMap[0] |= (k&KEY_LEFT )?0x04:0;
	JoyKeyMap[0] |= (k&KEY_A    )?0x10:0;
	JoyKeyMap[0] |= (k&KEY_B    )?0x20:0;

	if( k&KEY_START ) MainMenu();

//	itoa( k, buf );
//	LOG( (char*)buf );
	return JoyKeyMap[N];
}

/** Mouse() **************************************************/
/** Query coordinates of a mouse connected to port N.       **/
/** Returns F2.F1.Y.Y.Y.Y.Y.Y.Y.Y.X.X.X.X.X.X.X.X.          **/
/************************************ TO BE WRITTEN BY USER **/
int Mouse(byte N)
{
	return 0;
}

/** SetColor() ***********************************************/
/** Set color N (0..15) to (R,G,B).                         **/
/************************************ TO BE WRITTEN BY USER **/
void SetColor(byte N,byte R,byte G,byte B)
{
  unsigned int J;
  if(UseStatic) J=BPal[((7*R/255)<<2)|((7*G/255)<<5)|(3*B/255)];
  else J=( ((int)(B/8)<<10)|((int)(G/8)<<5)|(int)(R/8)|BIT(15) );

  if(N) XPal[N]=J; else XPal0=J;
}

/** RefreshScreen() ******************************************/
/** Refresh screen. This function is called in the end of   **/
/** refresh cycle to show the entire screen.                **/
/************************************ TO BE WRITTEN BY USER **/
void RefreshScreen( void )
{

//	dPrint( "RefreshScreen\n");
//    BitBlt( hDC, View_x, View_y, sw, sh, hbDC,0,0,SRCCOPY ); 
//	swiWaitForVBlank();

}

void ChangeCas( char * fname )
{
    if( CasStream ){
        FAT_fclose( CasStream );
    }
    CasStream=FAT_fopen(fname,"a+");
    if(CasStream==NULL){
		LOG("Can't Open Cassette %s.\n",CasName);
	}else{
		LOG("Cassette Select %s.\n",CasName);
	    FAT_fseek(CasStream,0,SEEK_SET);
    }
}

void CasTop( void )
{
  if(CasStream)
  {
    FAT_fseek(CasStream,0,SEEK_SET);
  }
}

void CasEnd( void )
{
  if(CasStream)
  {
    FAT_fseek(CasStream,0,SEEK_END);
  }
}

void CasPrev( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos=FAT_ftell(CasStream);
    if(Pos&7)
      if(FAT_fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(FAT_fread(Buf,1,8,CasStream)==8){
      FAT_fseek(CasStream,-8,SEEK_CUR);
      if(!memcmp(Buf,TapeHeader,8)) return;
      if(FAT_fseek(CasStream,-8,SEEK_CUR)) return;
    }
  }
}

void CasNext( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos=FAT_ftell(CasStream);
    if(Pos&7)
      if(FAT_fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(FAT_fread(Buf,1,8,CasStream)==8){
      if(!memcmp(Buf,TapeHeader,8))
      {
        return;
      }
    }
  }

}

KEYBIND Joys[] =
{
  {0x0026,0,0,0x01},   // UP
  {0,0,0} 
};

u8 touchmap[32*16] = {
	255,  0,  0,  0,  1,  1,  1,  2,  2,  2,  3,  3,  3,  4,  4,  4,255,255,  5,  5,  5,  6,  6,  6,255,  7,  7,  8,  8,  9,  9,255,
	255,  0,  0,  0,  1,  1,  1,  2,  2,  2,  3,  3,  3,  4,  4,  4,255,255,  5,  5,  5,  6,  6,  6,255,  7,  7,  8,  8,  9,  9,255,
	255, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24,255,
	255, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24,255,
	255, 25, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31, 32, 32, 33, 33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 38,255,
	255, 25, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31, 32, 32, 33, 33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 38,255,
	255, 39, 39, 39, 40, 40, 41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48, 48, 49, 49, 50, 50, 51, 51, 38, 38, 38,255,
	255, 39, 39, 39, 40, 40, 41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48, 48, 49, 49, 50, 50, 51, 51, 38, 38, 38,255,
	255, 52, 52, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64,255,255,255,
	255, 52, 52, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64,255,255,255,
	255, 65, 65, 65, 66, 66, 66, 67, 67, 67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,255,255,255,255, 69, 69, 70, 70, 71, 71,255,
	255, 65, 65, 65, 66, 66, 66, 67, 67, 67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,255,255,255,255, 69, 69, 70, 70, 71, 71,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,200,200,200,255,201,201,201,202,202,202,255,203,203,203,204,204,204,255,255,255,255,255,255,255,255,255,255,205,205,205,255,
	255,200,200,200,255,201,201,201,202,202,202,255,203,203,203,204,204,204,255,255,255,255,255,255,255,255,255,255,205,205,205,255,
	255,200,200,200,255,201,201,201,202,202,202,255,203,203,203,204,204,204,255,255,255,255,255,255,255,255,255,255,205,205,205,255 
};

KEYBIND Keys[] =
{
//                          NO     SHIFT  CAPS   CPS-S  KN     KN-S   KN-C   KN-C-S GRP   CTRL
  {6,0x20,0, 1, 0,3,2,1, 4,{"F01" ,"F06" ,"F01" ,"F06" ,"F01" ,"F06" ,"F01" ,"F06" ,"F01" ,"F01" } },  // F1
  {6,0x40,0, 4, 0,3,2,1, 4,{"F02" ,"F07" ,"F02" ,"F07" ,"F02" ,"F07" ,"F02" ,"F07" ,"F02" ,"F02" } },  // F2
  {6,0x80,0, 7, 0,3,2,1, 4,{"F03" ,"F08" ,"F03" ,"F08" ,"F03" ,"F08" ,"F03" ,"F08" ,"F03" ,"F03" } },  // F3
  {7,0x01,0,10, 0,3,2,1, 4,{"F04" ,"F09" ,"F04" ,"F09" ,"F04" ,"F09" ,"F04" ,"F09" ,"F04" ,"F04" } },  // F4
  {7,0x02,0,13, 0,3,2,1, 4,{"F05" ,"F10" ,"F05" ,"F10" ,"F05" ,"F10" ,"F05" ,"F10" ,"F05" ,"F05" } },  // F5

  {7,0x10,0,18, 0,3,2,1, 4,{"\xFFSTOP","\xFFSTOP","\xFFSTOP","\xFFSTOP","\xFFSTOP","\xFFSTOP","\xFFSTOP","\xFFSTOP","\xFFSTOP","\xFF^STOP"} },  // STOP
  {8,0x02,0,21, 0,3,2,1, 4,{"\xFFHOME","\xFF\x43LS" ,"\xFFHOME","\xFF\x43LS" ,"\xFFHOME","\xFF\x43LS" ,"\xFFHOME","\xFF\x43LS" ,"\xFFHOME","\xFFHOME"} },  // HOME/CLS  
  {7,0x40,0,25, 0,2,2,1, 4,{"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" ,"\xFFSEL" } },  // SELECT    
  {8,0x04,0,27, 0,2,2,1, 4,{"\xFFINS" ,"\xFFINS" ,"\xFFINS" ,"\xFFINS" ,"\xFFINS" ,"\xFFINS" ,"\xFFINS" ,"\xFFINS" ,"\xFFINS" ,"\xFFINS" } },  // INSERT    
  {8,0x08,0,29, 0,2,2,1, 4,{"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" ,"\xFF\x44\x45L" } },  // DELETE    
//           X  Y W H FxFy                        
  {7,0x04,0, 1, 2,2,2,1, 5,{"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" ,"\xFF\x45SC" } },  // ESC
  {0,0x02,0, 3, 2,2,2,6, 5,{"1"   ,"!"   ,"1"   ,"!"   ,"\x91","\x87","\xB1","\xA7","\x07","1"   } },  // '1'
  {0,0x04,0, 5, 2,2,2,6, 5,{"2"   ,"\""  ,"2"   ,"\""  ,"\x92","\x88","\xB2","\xA8","\x01","2"   } },  // '2'
  {0,0x08,0, 7, 2,2,2,6, 5,{"3"   ,"#"   ,"3"   ,"#"   ,"\x93","\x89","\xB3","\xA9","\x02","3"   } },  // '3'
  {0,0x10,0, 9, 2,2,2,6, 5,{"4"   ,"$"   ,"4"   ,"$"   ,"\x94","\x8A","\xB4","\xAA","\x03","4"   } },  // '4'
  {0,0x20,0,11, 2,2,2,6, 5,{"5"   ,"%"   ,"5"   ,"%"   ,"\x95","\x8B","\xB5","\xAB","\x04","5"   } },  // '5'
  {0,0x40,0,13, 2,2,2,6, 5,{"6"   ,"&"   ,"6"   ,"&"   ,"\xE5","\xE5","\xC5","\xC5","\x05","6"   } },  // '6'
  {0,0x80,0,15, 2,2,2,6, 5,{"7"   ,"'"   ,"7"   ,"'"   ,"\xE6","\xE6","\xC6","\xC6","\x06","7"   } },  // '7'
  {1,0x01,0,17, 2,2,2,6, 5,{"8"   ,"("   ,"8"   ,"("   ,"\xE7","\xE7","\xC7","\xC7","\x0D","8"   } },  // '8'
  {1,0x02,0,19, 2,2,2,6, 5,{"9"   ,")"   ,"9"   ,")"   ,"\xE8","\xE8","\xC8","\xC8","\x0E","9"   } },  // '9'
  {0,0x01,0,21, 2,2,2,6, 5,{"0"   ,0     ,"0"   ,0     ,"\xE9","\xE9","\xC9","\xC9","\x0F","0"   } },  // '0'
  {1,0x04,0,23, 2,2,2,6, 5,{"-"   ,"="   ,"-"   ,"="   ,"\xF7","\xF7","\xD7","\xD7","\x17","-"   } },  // -
  {1,0x08,0,25, 2,2,2,6, 5,{"^"   ,"~"   ,"^"   ,"~"   ,"\xF8","\xF8","\xD8","\xD8",0     ,"UP"  } },  // ^
  {1,0x10,0,27, 2,2,2,6, 5,{"\\"  ,"|"   ,"\\"  ,"|"   ,"\xF8","\xF8","\xD8","\xD8","\x09","LFT" } },  // "\"
  {7,0x20,0,29, 2,2,2,3, 5,{"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  ,"\xFF\x42S"  } },  // BS
//25                       
  {7,0x08,0, 1, 4,3,2,1, 5,{"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" ,"\xFFTAB" } },  // TAB
  {4,0x40,0, 4, 4,2,2,6, 5,{"q"   ,"Q"   ,"Q"   ,"q"   ,"\x96","\x96","\xB6","\xB6",0     ,0     } },  // 'Q'
  {5,0x10,0, 6, 4,2,2,6, 5,{"w"   ,"W"   ,"W"   ,"w"   ,"\x97","\x97","\xB7","\xB7",0     ,0     } },  // 'W'
  {3,0x04,0, 8, 4,2,2,6, 5,{"e"   ,"E"   ,"E"   ,"e"   ,"\x98","\x98","\xB8","\xB8","\x18","^E"  } },  // 'E'
  {4,0x80,0,10, 4,2,2,6, 5,{"r"   ,"R"   ,"R"   ,"r"   ,"\x99","\x99","\xB9","\xB9","\x12","^R"  } },  // 'R'
  {5,0x02,0,12, 4,2,2,6, 5,{"t"   ,"T"   ,"T"   ,"t"   ,"\x9A","\x9A","\xBA","\xBA","\x19",0     } },  // 'T'
  {5,0x40,0,14, 4,2,2,6, 5,{"y"   ,"Y"   ,"Y"   ,"y"   ,"\xEA","\xEA","\xDA","\xDA","\x08",0     } },  // 'Y'
  {5,0x04,0,16, 4,2,2,6, 5,{"u"   ,"U"   ,"U"   ,"u"   ,"\xEB","\xEB","\xDB","\xDB",0     ,0     } },  // 'U'
  {3,0x40,0,18, 4,2,2,6, 5,{"i"   ,"I"   ,"I"   ,"i"   ,"\xEC","\xEC","\xDC","\xDC","\x16","^I"  } },  // 'I'
  {4,0x10,0,20, 4,2,2,6, 5,{"o"   ,"O"   ,"O"   ,"o"   ,"\xED","\xED","\xDD","\xDD",0     ,0     } },  // 'O'
  {4,0x20,0,22, 4,2,2,6, 5,{"p"   ,"P"   ,"P"   ,"p"   ,"\xEE","\xEE","\xDE","\xDE","\x10",0     } },  // 'P'
  {1,0x20,0,24, 4,2,2,6, 5,{"@"   ,"`"   ,"@"   ,"`"   ,"\xFA","\xFA","\xDA","\xDA",0     ,0     } },  // @
  {1,0x40,0,26, 4,2,2,6, 5,{"["   ,"{"   ,"["   ,"{"   ,"\xFB","\xA2","\xDB","\xA2","\x84",0     } },  // [
  {7,0x80,0,28, 4,3,4,6,10,{"\xFFRET","\xFFRET"  ,"\xFFRET" ,"\xFFRET" ,"\xFFRET","\xFFRET"  ,"\xFFRET" ,"\xFFRET" ,"\xFFRET" ,"\xFFRET" } },  // RETURN
//39
  {6,0x02,1, 1, 6,3,2,1, 5,{"\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL","\xFF\x43TRL"} },  // CTRL 
  {2,0x40,0, 4, 6,2,2,6, 5,{"a"   ,"A"   ,"A"   ,"a"   ,"\x9B","\x9B","\xBB","\xAB",0     ,0     } },  // 'A'
  {5,0x01,0, 6, 6,2,2,6, 5,{"s"   ,"S"   ,"S"   ,"s"   ,"\x9C","\x9C","\xBC","\xAC","\x0C",0     } },  // 'S'
  {3,0x02,0, 8, 6,2,2,6, 5,{"d"   ,"D"   ,"D"   ,"d"   ,"\x9D","\x9D","\xBD","\xAD","\x14",0     } },  // 'D'
  {3,0x08,0,10, 6,2,2,6, 5,{"f"   ,"F"   ,"F"   ,"f"   ,"\x9E","\x9E","\xBE","\xAE","\x15","^F"  } },  // 'F'
  {3,0x10,0,12, 6,2,2,6, 5,{"g"   ,"G"   ,"G"   ,"g"   ,"\x9F","\x9F","\xBF","\xAF","\x13","^G"  } },  // 'G'
  {3,0x20,0,14, 6,2,2,6, 5,{"h"   ,"H"   ,"H"   ,"h"   ,"\xEF","\xEF","\xCF","\xAF","\x0A","^H"  } },  // 'H'
  {3,0x80,0,16, 6,2,2,6, 5,{"j"   ,"J"   ,"J"   ,"j"   ,"\xF0","\xF0","\xD0","\xD0",0     ,"^J"  } },  // 'J'
  {4,0x01,0,18, 6,2,2,6, 5,{"k"   ,"K"   ,"K"   ,"k"   ,"\xF1","\xF1","\xD1","\xD1",0     ,"^K"  } },  // 'K'
  {4,0x02,0,20, 6,2,2,6, 5,{"l"   ,"L"   ,"L"   ,"l"   ,"\xF2","\xF2","\xD2","\xD2","\x1E","^L"  } },  // 'L'
  {1,0x80,0,22, 6,2,2,6, 5,{";"   ,"+"   ,";"   ,"+"   ,"\xF3","\xF3","\xD3","\xD3","\x82",0     } },  // +
  {2,0x01,0,24, 6,2,2,6, 5,{":"   ,"*"   ,":"   ,"*"   ,"\xDE","\xB0","\xDE","\xB0","\x81",0     } },  // :
  {2,0x02,0,26, 6,2,2,6, 5,{"]"   ,"}"   ,"]"   ,"}"   ,"\xDF","\xA3","\xDF","\xA3","\x85",0     } },  // ]
//52                                      
  {6,0x01,1, 1, 8,4,2,1, 5,{"\xFFSHIFT","\xFFSHIFT","\xFFSHIFT","\xFFSHIFT","\xFFSHIFT","\xFFSHIFT","\xFFSHIFT","\xFFSHIFT","\xFFSHIFT","\xFFSHIFT"} },  // SHIFT  
  {5,0x80,0, 5, 8,2,2,6, 5,{"z"   ,"Z"   ,"Z"   ,"z"   ,"\xE0","\xE0","\xC0","\xE0",0     ,0     } },  // 'Z'
  {5,0x20,0, 7, 8,2,2,6, 5,{"x"   ,"X"   ,"X"   ,"x"   ,"\xE1","\xE1","\xC1","\xE1","\x1C","^X"  } },  // 'X'
  {3,0x01,0, 9, 8,2,2,6, 5,{"c"   ,"C"   ,"C"   ,"c"   ,"\xE2","\x8F","\xC2","\x8F","\x1A","^C"  } },  // 'C'
  {5,0x08,0,11, 8,2,2,6, 5,{"v"   ,"V"   ,"V"   ,"v"   ,"\xE3","\xE3","\xC3","\xE3","\x11","^V"  } },  // 'V'
  {2,0x80,0,13, 8,2,2,6, 5,{"b"   ,"B"   ,"B"   ,"b"   ,"\xE4","\xE4","\xC4","\xE4","\x1B","^B"  } },  // 'B'
  {4,0x08,0,15, 8,2,2,6, 5,{"n"   ,"N"   ,"N"   ,"n"   ,"\xF4","\x8C","\xD4","\x8C",0     ,"^N"  } },  // 'N'
  {4,0x04,0,17, 8,2,2,6, 5,{"m"   ,"M"   ,"M"   ,"m"   ,"\xF5","\x8D","\xD5","\x8D","\x0B","^M"  } },  // 'M'
  {2,0x04,0,19, 8,2,2,6, 5,{","   ,"<"   ,","   ,"<"   ,"\xF6","\x8E","\xD6","\x8E","\x1F",0     } },  // ,
  {2,0x08,0,21, 8,2,2,6, 5,{"."   ,">"   ,"."   ,">"   ,"\xFC","\xA4","\xFC","\xA4","\x1D",0     } },  // .
  {2,0x10,0,23, 8,2,2,6, 5,{"/"   ,"?"   ,"/"   ,"?"   ,"\x86","\xA1","\x86","\xA1","\x80",0     } },  // /
  {2,0x20,0,25, 8,2,2,6, 5,{"_"   ,"_"   ,"_"   ,"_"   ,"\xFD","\x85","\xFD","\x85","\x83",0     } },  // _
  {8,0x20,0,27, 8,2,2,6, 5,{"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  ,"\xFF\x7F"  } },  // UP
//65
  {6,0x08,2, 1,10, 3,2,1,5,{"\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS","\xFF\x43\x41PS"} },  // CAPS
  {6,0x04,1, 4,10, 3,2,1,5,{"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" ,"\xFFGRPH" } },  // GRAPH
  {6,0x10,2, 7,10, 3,2,6,5,{"\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5"} },      // 
  {8,0x01,0,10,10,11,2,6,5,{"SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE"} },  // SPACE
  {8,0x10,0,25,10, 2,2,6,5,{"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  ,"\xFF\x82"  } },  // LEFT
  {8,0x40,0,27,10, 2,2,6,5,{"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  ,"\xFF\x80"  } },  // DOWN
  {8,0x80,0,29,10, 2,2,6,5,{"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  ,"\xFF\x81"  } },  // RIGHT
  {0,0x00,0, 0, 0, 0,0,0,0,{0,0,0,0,0,0,0,0,0,0} }   // ** End ** /
};
