#include <NDS.h>
#include <string.h>
#include "DSGraph.h"
#include "font5x6.h"
#include "icon.h"

extern byte *MemMap[4][4][8];   /* Memory maps [PPage][SPage][Addr] */

extern void LOG( char * str , ... );

void drawAllKeyboard(void);

void memcpy16( u16 * dst,u16 * src, int cnt ){
	for( int c=0;c<cnt;c++ ) *dst++ = *src++;
}

void line( uint16 * gfx , int x, int y, int w, int h, uint16 col )
{
	int E;
	int dx,dy,sx,sy,i;

	sx = ( w>0 ) ? 1 : -1;
	dx = ( w>0 ) ? w-1 : (-w)-1 ;
	sy = ( h>0 ) ? 1 : -1;
	dy = ( h>0 ) ? h-1 : (-h)-1 ;

	if( dx >= dy ) {
		E = -dx;
		for( i = 0; i <= dx; i++ ) {
			pset(gfx, x, y, col );
			x += sx;
			E += 2 * dy;
			if( E >= 0 ) {
				y += sy;
				E -= 2 * dx;
			}
		}
	} else {
		E = -dy;
		for( i = 0; i <= dy; i++ ) {
			pset(gfx, x, y, col );
			y += sy;
			E += 2 * dx;
			if( E >= 0 ) {
				x += sx;
				E -= 2 * dy;
			}
		}
	}
}

void box( uint16 * gfx, int x,int y,int w,int h,uint16 col )
{
	line( gfx,x    ,y,w,0,col );
	line( gfx,x,y+h-1,w,0,col );
	line( gfx,x,y    ,0,h,col );
	line( gfx,x+w-1,y,0,h,col );
}

void fill( uint16 * gfx, int x,int y,int w,int h,uint16 col )
{
	int i;
	for( i=y;i<y+h;i++ ){
		line( gfx,x,i,w,0,col );
	}
}

void cls(){
	fill( BG_GFX,     0,0,256,192, 0x8000 );
	fill( BG_GFX_SUB, 0,0,256, 20, 0x8000 );
}

void drawWindow( uint16 * gfx, int x, int y , int w, int h )
{
	line( gfx,x    ,y    ,w,0 ,RGB16(1,26,26,26) );
	line( gfx,x    ,y+h-1,w,0 ,RGB16(1, 8, 8, 8) );
	line( gfx,x    ,y    ,0,h ,RGB16(1,26,26,26) );
	line( gfx,x+w-1,y    ,0,h ,RGB16(1, 8, 8, 8) );

	line( gfx,x+1  ,y+1  ,w-2,0  ,RGB16(1,31,31,31) );
	line( gfx,x+1  ,y+h-2,w-2,0  ,RGB16(1,16,16,16) );
	line( gfx,x+1  ,y+1  ,0  ,h-2,RGB16(1,31,31,31) );
	line( gfx,x+w-2,y+1  ,0  ,h-2,RGB16(1,16,16,16) );

	fill( gfx, x+2,y+2,w-4,h-4, RGB16(1,26,26,26) );
}

void drawButton( uint16 * gfx, int x, int y , int w, int h, u8 * buf )
{
	box( gfx, x, y, w, h, RGB16(1,0,0,0) );
	drawWindow(gfx, x+1,y+1, w-2,h-2 );
	int len = strlen( (char*)buf );
	drawText( gfx, x + w/2 - len*5/2, y + h/2 - 3, buf, RGB16(1,0,0,0) , 0 );
}

void drawFontMSX( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol )
{
	uint16 o;
	u8 * f=(u8*)MemMap[0][0][0] + 7103 + (int)chr*8;
	uint16 * g = gfx + fy * 256 + fx;
	for(int i=0;i<8;i++ ){
		o = g[0];g[0]=*f&0x80?col:(bcol?bcol:o);
		o = g[1];g[1]=*f&0x40?col:(bcol?bcol:o);
		o = g[2];g[2]=*f&0x20?col:(bcol?bcol:o);
		o = g[3];g[3]=*f&0x10?col:(bcol?bcol:o);
		o = g[4];g[4]=*f&0x08?col:(bcol?bcol:o);
		o = g[5];g[5]=*f&0x04?col:(bcol?bcol:o);
		o = g[6];g[6]=*f&0x02?col:(bcol?bcol:o);
		o = g[7];g[7]=*f&0x01?col:(bcol?bcol:o);
		g+=256;
		f++;
	}
}
void drawTextMSX( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol )
{
	int x = fx;
	int i=0;
	while( buf[i] )
	{
		drawFontMSX( gfx, x, fy, buf[i], col, bcol );
		x +=8;
		i++;
	}
}

void drawFont( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol )
{
	if( (chr>=0x20) && (chr<=0x82) ){
		u8 * f=(u8*)font5x6 +(int)(chr-0x20)*6;
		uint16 o;
		uint16 * g = gfx + fy * 256 + fx;
		for(int i=0;i<6;i++ ){
			o = *g; *g = *f&0x80?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x40?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x20?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x10?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x08?col:(bcol?bcol:o);g+=256-4;
			f++;
		}
	}
}

void drawText( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol )
{
	int x = fx;
	int i=0;
	while( buf[i] )
	{
		drawFont( gfx, x, fy, buf[i], col, bcol );
		x +=5;
		i++;
	}
}

void drawDesktop( uint16 * gfx )
{
	int col1 = RGB16(1,29,29,29);
	int col2 = RGB16(1,25,25,25);
	int col;
	int flg=0;
	for(int i=0;i<20*256;i++) *gfx++ = 0;
	for(int i=20;i<160;i++){
		col = flg?col1:col2;
		for(int j=0;j<256;j++){
			*gfx++ = col;
		}
		flg =(flg+1)&1;
	}
}

void copyGraph( uint16 * gfx, u16 dx, u16 dy, u16 sx, u16 sy, u16 width, u16 height )
{
	int i;
	for( i=sy;i<sy+height;i++ ){
		memcpy16( BG_GFX_SUB + 256 * dy + dx, BG_GFX_SUB + 256*i+sx, width );
		dy++;
	}
}

void drawIcon( uint16 * gfx, int x, int y, int num )
{
	u16 * f=(u16*)icon + 1024 * num;
	gfx += y*256+x;

	for(int i=0;i<32;i++){
		for(int j=0;j<32;j++) *gfx++ = *f++ | 0x8000 ;
		gfx += (256-32);
	}
}
