//////////////////////////////////////////////////////////////////////
// fmsxDS
//////////////////////////////////////////////////////////////////////
#include "../../common/ipc2.h"
//#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <NDS.h>
#include <NDS/ARM9/console.h>
#include "DSGraph.h"
#include "gba_nds_fat.h"

#include "emu2149.h"
#include "emu2212.h"

extern void InitMachine(void);
extern int StartMSX(void);
extern int TrashMSX(void);
extern u8 * itoa( int n, u8 * buf );

extern void LOG( char * str , ... );

extern char *ROMName[];
extern char *DSKName[];

extern int MainMenu();

#define VAR_IN_EXRAM __attribute__ ((section (".ewram")))

extern PSG * psg;
extern SCC * scc;


#define RGB16(a,r,g,b)  RGB15(r,g,b)|((a)<<15)

void waitForVBlank(int cnt)
{
	for(int i=0;i<cnt;i++){
		while(!(DISP_SR & DISP_IN_VBLANK));
		while((DISP_SR & DISP_IN_VBLANK));
	}
}

void initDS()
{

	//fBXvC[h̐ݒ
	videoSetMode   (MODE_5_2D | DISPLAY_BG3_ACTIVE); 
	videoSetModeSub(MODE_5_2D | DISPLAY_BG2_ACTIVE);

	// VRAMoNݒH
    // oNACBGɁAoNCTuBGɃZbg
    //B and D are not used (if you want a bitmap greater than 256x256 you will need more
    //memory so another vram bank must be used and mapped consecutivly
    vramSetMainBanks(VRAM_A_MAIN_BG_0x6000000, VRAM_B_MAIN_BG_0x6020000, VRAM_C_SUB_BG_0x6200000 , VRAM_D_MAIN_BG_0x6040000); 

	//荞ݐݒ
//	irqInitHandler(irqDefaultHandler);
//	irqSet(IRQ_VBLANK, 0);

	// LCD̃CƃTuւ
//	lcdSwap();

    SUB_BG2_CR = BG_BMP16_256x256;

    SUB_BG2_XDX = 1 << 8;
    SUB_BG2_XDY = 0;
    SUB_BG2_YDX = 0;
    SUB_BG2_YDY = 1 << 8;
    //our bitmap looks a bit better if we center it so scroll down (256 - 192) / 2 
    SUB_BG2_CX = 0;
	SUB_BG2_CY = 0;
//    SUB_BG2_CY = 32 << 8;
	
	//these are rotation backgrounds so you must set the rotation attributes:
    //these are fixed point numbers with the low 8 bits the fractional part
    //this basicaly gives it a 1:1 translation in x and y so you get a nice flat bitmap
	BG3_CR = BG_BMP16_256x256;

    BG3_XDX = (1 << 8);//  * 2;
    BG3_XDY = 0;
    BG3_YDX = 0;
    BG3_YDY = (1 << 8);//  * 2;

//	REG_BG2PA = 256*100/xscale;
//	REG_BG2PB = 0*100/xscale;
//	REG_BG2PC = 0*100/yscale;
//	REG_BG2PD = 256*100/yscale;

    //our bitmap looks a bit better if we center it so scroll down (256 - 192) / 2 
    BG3_CX = 0;
    BG3_CY = 0;

    // ̃EFCgƎgp̐ݒ
	WAIT_CR = 0xE880;

	psg = (PSG*)&(IPC2->psg);
	scc = (SCC*)&(IPC2->scc);
	IPC2->soundbuf = (u16*) malloc( 1024 * 4 * 2 );
	IPC2->soundCommand = 3;
	while( IPC2->soundCommand ){
		waitForVBlank(1);
	}
}

int main(void)
{
	int ret;
	IPC2->soundCommand = 0;

	initDS();

	LOG( "Start" );

	waitForVBlank(10);

	ret = FAT_InitFiles();
	if( !ret ){
		LOG( "FAT_InitFiles Error." );
	    while(1) waitForVBlank(1);
	}
	LOG( "FAT_InitFiles OK" );

	InitMachine();
	LOG("InitMachine OK" );
	
	while(1){

		drawDesktop( BG_GFX_SUB );
		MainMenu();
		LOG("Power ON" );
		StartMSX();
		TrashMSX();
		cls();
		LOG("Power OFF" );
	}
	return 0;
}
