-- fmsxDS setting and menu script --

function RGB(A,R,G,B) return (A)*0x8000 + (B)*0x0400+ (G)*0x0020 + (R); end;

function menu2(t, c)
	if( c == nil) then c = 0; end
	local s=c;
	local os=c;
	local flg = true;
	local n=3;
	if( t.bg == nil )then t.bg = 2; end;

	local function _drw(f)
		ui.waitForVBlank(1);
		-- draw menu
		if(f==1 or f==3) then
			ui.fill(t.bg, t.x, t.y, 5*t.col+10, 10*t.row+10,0x8000 );
			ui.box (t.bg, t.x, t.y, 5*t.col+10, 10*t.row+10,0xFFFF );
			for i=0,t.row-1,1 do
				ui.drawText2(t.bg, t.x+10,t.y+5+10*i, t[i+1][1], 0xFFFF, 0x8000 );
			end
		end
		-- draw arrow
		if(f==2 or f==3) then
			ui.fill     (t.bg, t.x+3, t.y+5+10*os, 5, 6, 0x8000 );
			ui.drawText2(t.bg, t.x+3, t.y+5+10*s, ">", 0xFFFF, 0x8000 );
		end
	end

	-- menu main routine --
	while( flg ) do
		_drw(n); n=0; os=s;
		ui.scanKeys();
		local keys = ui.keysDown();
		if keys.A    then flg, ret = t[s+1][2](s,t); n=3; end
		if keys.B    then flg=false; ret=nil; end
		if keys.UP   then s=s-1;     end
		if keys.DOWN then s=s+1;     end
		if s==-1     then s=t.row-1; end
		if s==t.row  then s=0;       end
		if s ~= os   then n=2;       end
	end
	return ret;
end


function Config_screen_autofit()
	MSX.setParam("scr_x"  ,0);
	MSX.setParam("scr_y"  ,0);
	MSX.setParam("scale_x" ,0);
	MSX.setParam("scale_y" ,0);
	MSX.setParam("AutoFit",1);
	return false, true;
end;

function Config_screen_212()
	MSX.setParam("scr_x"   ,0);
	MSX.setParam("scr_y"   ,0);
	MSX.setParam("scale_x" ,0);
	MSX.setParam("scale_y" ,28);
	MSX.setParam("AutoFit",0);
	return false, true;
end;

function Config_screen_192()
	MSX.setParam("scr_x"   ,0);
	MSX.setParam("scr_y"   ,0);
	MSX.setParam("scale_x" ,0);
	MSX.setParam("scale_y" ,0);
	MSX.setParam("AutoFit",0);
	return false, true;
end;

function Config_screen_user()

	local function _setsc( sx,sy,sw,sh )
		MSX.setParam("scr_x" ,sx);
		MSX.setParam("scr_y" ,sy);
		MSX.setParam("scale_x" ,sw);
		MSX.setParam("scale_y" ,sh);
		buf = "x:"..sx.."   y:"..sy.."  w:"..sw.."  h:"..sh.."       ";
		ui.drawText2( 1, 40, 170, buf, 0xFFFF, RGB(1,0,0,31) );
	end;
	local flg = true;
	local chg = false;
	local x=0;
	local y=0;
	local w=0;
	local h=0;

	MSX.setParam("AutoFit",0);
	_setsc( x,y,w,h );

	ui.fill( 1, 0,0,256,212, RGB(1,0,0,31) );
	ui.box ( 1, 0,0,256,212, 0xFFFF );
	ui.drawText2( 1, 10, 30, "=== Screen Setting === ", 0xFFFF, RGB(1,0,0,31) );
	ui.drawText2( 1, 40, 80, "     Controler - move screen.", 0xFFFF, RGB(1,0,0,31) );
	ui.drawText2( 1, 40, 120, "B + Controler - zoom up or down.", 0xFFFF, RGB(1,0,0,31) );
	ui.drawText2( 1, 40, 140, "            A - return menu.", 0xFFFF, RGB(1,0,0,31) );

	while( flg ) do
		ui.scanKeys();
		local keys = ui.keysDown();
		local hkeys = ui.keysHeld();
		if keys.A     then flg=false; end
		if hkeys.B    then
			if keys.UP    then h=h+1; chg = true; end
			if keys.DOWN  then h=h-1; chg = true; end
			if keys.LEFT  then w=w+1; chg = true; end
			if keys.RIGHT then w=w-1; chg = true; end
		else
			if keys.UP    then y=y+256; chg = true; end
			if keys.DOWN  then y=y-256; chg = true; end
			if keys.LEFT  then x=x+256; chg = true; end
			if keys.RIGHT then x=x-256; chg = true; end
		end;
		if( chg ) then _setsc(x,y,w,h); end;
		chg = false;
		ui.waitForVBlank(1);
	end
	return true;
end;

function Config_screen()
	local ret = nil;
	local tbl = { x=30,y=30,col=20,row=5,
					{"߂"       ,function(n) return false, true;  end },
					{"k"   ,Config_screen_autofit },
					{"212hbg"  ,Config_screen_212 },
					{"192hbg"  ,Config_screen_192 },
					{"Őݒ" ,Config_screen_user }
				};
	while( ret == nil ) do
		ret = menu2(tbl);
	end;
	return ret;
end


function Config_sound()

	local psg = MSX.getParam("PSG");
	local scc = MSX.getParam("SCC");
	local fmp = MSX.getParam("FMP");

	function _psgSet(n,t)
		psg = not psg;
		local buf;
		if( psg ) then buf = "ON"; else buf = "OFF"; end
		t[2][1] = "PSG    "..buf;
		return true, false;
	end;
	function _sccSet(n,t)
		scc = not scc;
		local buf;
		if( scc ) then buf = "ON"; else buf = "OFF"; end
		t[3][1] = "SCC    "..buf;
		return true, false;
	end;
	function _fmpSet(n,t)
		fmp = not fmp;
		local buf;
		if( fmp ) then buf = "ON"; else buf = "OFF"; end
		t[4][1] = "FM-PAC "..buf;
		return true, false;
	end;

	local ret = nil;
	local tbl = { x=30,y=30,col=20,row=4,
					{"߂" ,function(n) return false, true;  end },
					{"PSG    ON"  ,_psgSet},
					{"SCC    ON"  ,_sccSet},
					{"FM-PAC OFF" ,_fmpSet},
				};
	while( ret == nil ) do
		ret = menu2(tbl);
	end;
	return ret;
end

function Config_KEY()
	ui.Joybind( 0,0,8,0x01); --Key_A 
	ui.Joybind( 1,0,4,0x08); --Key_B 
	ui.Joybind( 2,0,6,0x20); --Select
	ui.Joybind( 3,2,1,0x00); --Start 
	ui.Joybind( 4,0,8,0x80); --Right
	ui.Joybind( 5,0,8,0x10); --Left
	ui.Joybind( 6,0,8,0x20); --UP
	ui.Joybind( 7,0,8,0x40); --Down
	ui.Joybind( 8,0,0,0x00); --KEY_R 
	ui.Joybind( 9,0,0,0x00); --KEY_L 
	ui.Joybind(10,0,7,0x80); --KEY_X 
	ui.Joybind(11,0,0,0x00); --KEY_Y 
	ui.LOG( "Controler is Keyboard.");
	return true, true;
end

function Config_JOY1()
	ui.Joybind( 0,1,0,0x10); --Key_A = trg1
	ui.Joybind( 1,1,0,0x20); --Key_B = trg2
	ui.Joybind( 2,0,6,0x20); --Select= F1
	ui.Joybind( 3,2,1,0x00); --Start = Menu
	ui.Joybind( 4,1,0,0x08); --Right
	ui.Joybind( 5,1,0,0x04); --Left
	ui.Joybind( 6,1,0,0x01); --UP
	ui.Joybind( 7,1,0,0x02); --Down
	ui.Joybind( 8,1,0,0x00); --KEY_R = none
	ui.Joybind( 9,1,0,0x00); --KEY_L = none
	ui.Joybind(10,1,0,0x00); --KEY_X = none
	ui.Joybind(11,1,0,0x00); --KEY_Y = none
	MSX.setParam( "JoyTypeA"  , 1 );
	ui.LOG( "Controler is Joystick 1.");
	return true, true;
end
function Config_JOY2()
	ui.Joybind( 0,1,1,0x10); --Key_A = trg1
	ui.Joybind( 1,1,1,0x20); --Key_B = trg2
	ui.Joybind( 2,0,6,0x20); --Select= F1
	ui.Joybind( 3,2,1,0x00); --Start = Menu
	ui.Joybind( 4,1,1,0x08); --Right
	ui.Joybind( 5,1,1,0x04); --Left
	ui.Joybind( 6,1,1,0x01); --UP
	ui.Joybind( 7,1,1,0x02); --Down
	ui.Joybind( 8,1,1,0x00); --KEY_R = none
	ui.Joybind( 9,1,1,0x00); --KEY_L = none
	ui.Joybind(10,1,1,0x00); --KEY_X = none
	ui.Joybind(11,1,1,0x00); --KEY_Y = none
	MSX.setParam( "JoyTypeB"  , 1 );
	ui.LOG( "Controler is Joystick 2.");
	return true, true;
end

function Config_control()
	local ret = nil;
	local tbl = { x=30,y=30,col=20,row=4,
					{"߂"       ,function(n) return false, true;  end },
					{"KEYBOARD"   ,Config_KEY  },
					{"JOYSTICK1"  ,Config_JOY1 },
					{"JOYSTICK2"  ,Config_JOY2 },
				};
	while( ret == nil ) do
		ret = menu2(tbl);
	end;
	return ret;
end

function Config()
	local ret = nil;
	local tbl = { x=20,y=20,col=20,row=3, 
					{"߂"        , function(n) return false, true;  end },
					{"XN["  , Config_screen  },
					{"Rg[", Config_control },
					{"TEh"    , Config_sound   },
				};
	while( ret == nil ) do
		ret = menu2(tbl);
	end;
	return ret;
end

function edit()
	dofile( "edit.lua" );
end

function execlua()
	local r,fn = ui.fileselect( "/","lua" );
	if r==1 then dofile( fn ); end;
end

function MainMenu_RomSelect(n)
	local r,fn = ui.fileselect( ROMPath,"ROM" );
	if r==1 then 
		if MSX.RomChange(n-1,fn) == 0 then
			ui.LOG( "RomChange Error!" );
		end;
	end;
	return true, false;
end

function MainMenu_DskSelect(n)
	local r,fn = ui.fileselect( DSKPath,"DSK" );
	if r==1 then 
		if MSX.DskChange(n-3,fn) == 0 then
			ui.LOG( "DskChange Error!" );
		end;
	end;
	return true, false;
end;

function MainMenu_CasSelect(n)
	local r,fn = ui.fileselect( CASPath,"CAS" );
	if r==1 then MSX.CasChange(fn); end;
	return true, false;
end;

function MainMenu_State()
	local ret = nil;
	local tbl = { x=20,y=20,col=20,row=7, 
					{"߂"        , function(n) return false, true;  end },
					{"Z[uP"    , function(n) MSX.saveState("state1.sta"); return true, false; end },
					{"Z[uQ"    , function(n) MSX.saveState("state2.sta"); return true, false; end },
					{"Z[uR"    , function(n) MSX.saveState("state3.sta"); return true, false; end },
					{"[hP"    , function(n) MSX.loadState("state1.sta"); return true, false; end },
					{"[hQ"    , function(n) MSX.loadState("state2.sta"); return true, false; end },
					{"[hR"    , function(n) MSX.loadState("state3.sta"); return true, false; end },
				};
	while( ret == nil ) do
		ret = menu2(tbl);
	end;
	return ret;
end

-- flg = 1:before boot  0:after boot
function MainMenu(flg)
--	ui.LOG( "MainMenu" );
	local m1;
	local cnt;
	local ret=nil;

	ui.soundStop();
	-- Draw Infomation --
	ui.cls(3);
	ui.drawText2( 1, 150, 170, "fmsxDS Ver.0.08 ", 0xFFFF, 0x8000 );
	ui.drawText2( 1, 160, 180, "Ported by NYAGOSU", 0xFFFF, 0x8000 );

	-- Draw Menu --
	local tbl = { x=10,y=10,col=10, 
					{ "s"      , function(n) return false, true; end },
					{ "P"    , MainMenu_RomSelect },
					{ "Q"    , MainMenu_RomSelect },
					{ "fBXN`", MainMenu_DskSelect },
					{ "fBXNa", MainMenu_DskSelect },
					{ "JZbg"  , MainMenu_CasSelect },
					{ "ݒ"  , Config },
					{ "Xe[g"  , MainMenu_State },
--					{ "GfB^"  , edit },
--					{ "luas"   , execlua },
					{ "Zbg"  , function(n) MSX.exit(); resetflg=1; return false, true; end },
					{ "df"    , function(n) MSX.exit(); resetflg=0; return false, true; end }
				};
	if flg == 1 then 
		tbl[1][1] = "s";
		tbl.row = 8;
	else
		tbl[1][1] = "߂";
		tbl.row = 10;
	end
	while( ret == nil ) do
		ret = menu2(tbl, ret);
	end

	ui.cls(3);
	ui.drawAllKeyboard();
	ui.soundStart();
	return 1;
end

function KeySettings()
end

-- loadIcon
--ICN = {};
--ICN[0] = ui.loadIcon( "icon.dat", 2048 );

-- loadFont
if( ui.loadFont( "ELISA8.FON" ) ) then 
	ui.LOG( "Font load OK" );
else
	ui.LOG("Font load NG" );
end;

-- setting path
BIOSPath="fat:/";
ROMPath ="fat:/";
DSKPath ="fat:/";
CASPath ="fat:/";

-- setting MSX Hardware
MSX.setParam( "Version"   , 1 ); -- 0:MSX1 1:MSX2 2:MSX2+
MSX.setParam( "RAMPages"  , 8 );
MSX.setParam( "VRAMPages" , 8 );

MSX.setBIOS(0,0,0,BIOSPath.."MSX2.ROM"   ,0x8000);
MSX.setBIOS(3,1,0,BIOSPath.."MSX2EXT.ROM",0x4000);
MSX.setBIOS(3,1,2,BIOSPath.."DISK.ROM"   ,0x4000);
MSX.patchBDOS(3,1,2);
MSX.patchBIOS();

--MSX.setBIOS(3,3,2,"RS232C.ROM" ,0x4000);

--MSX.loadCart(0,"SALA.ROM" );
--MSX.loadCart(1,"GRA2.ROM" );
--MSX.loadFMPAC(2,"FMPAC.ROM");
--MSX.loadMSXDOS2(2,"MSXDOS2.ROM");

--MSX.ChangeDisk(0,"YS1.DSK" );
--MSX.ChangeDisk(1,"USR.DSK" );
--MSX.ChangeCas( "DEZENI.CAS" );

Config_screen_autofit();

-- start fmsxDS
exitflg = 1;
resetflg = 0;
while 1 do
	if resetflg==0 then MainMenu(1); end;
	resetflg = 0;
	MSX.boot();
	MSX.exit();
end
