#ifndef __GRAPH_H__
#define __GRAPH_H__

#include <nds.h>

#define ICON_POWER_OFF	0
#define ICON_POWER_ON	1
#define ICON_RESET		2
#define ICON_CLOSE		3
#define ICON_ROM1		4
#define ICON_ROM2		5
#define ICON_DISK1		6
#define ICON_DISK2		7
#define ICON_CONFIG		8
#define ICON_STICK1		9
#define ICON_STICK2		10
#define ICON_CURSOR		11
#define ICON_CLIPTOP	12
#define ICON_CLIPBTM	13
#define ICON_CLIPFIT	14
#define ICON_STATLOAD	15
#define ICON_STATSAVE	16
#define ICON_CAS		17

#define CURSOR			0
#define STICK1			1
#define STICK2			2

#define RGB16(a,r,g,b)  RGB15(r,g,b)|((a)<<15)
#define pset( GFX, X,Y, COL )	(*((uint16*)(GFX) + ((Y)*256+(X)) ) = (COL) )

// void pset( uint16 * gfx, int x,int y,uint16 col );
void box( uint16 * gfx, int x,int y,int w,int h,uint16 col );
void line( uint16 * gfx, int x,int y,int w,int h,uint16 col );
void fill( uint16 * gfx, int x,int y,int w,int h,uint16 col );
void drawFont( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol );
void drawText( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol );
int  loadFont( char * fn );
void drawFont2( uint16 * gfx, u16 fx, u16 fy, u16 chr, u16 col, u16 bcol );
void drawText2( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol );
void drawFontMSX( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol );
void drawTextMSX( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol );
void drawDesktop( uint16 * gfx );
void copyGraph( uint16 * dgfx, u16 dx, u16 dy, uint16 * sgfx, u16 sx, u16 sy, u16 width, u16 height );
void drawIcon( uint16 * gfx, int x, int y, int num );
void drawIcon2( uint16 * gfx, int x, int y, int w, int h, u16 * buf );
void cls( int g );
void drawWindow( uint16 * gfx, int x, int y , int w, int h );
void drawButton( uint16 * gfx, int x, int y , int w, int h ,u8 * buf);

#endif
