#include "msx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nds.h>
#include "lua.h"
#include "lualib.h"
#include "lauxlib.h"
#include "keybind.h"
#include "DSGraph.h"
#include "DSDriver.h"
#include "DSFileList.h"

extern void soundInitialize(void);
extern void soundStart(void);
extern void soundStop(void);

extern void waitForVBlank(int);
extern int autoFitScreen;

lua_State *lua = NULL;

static int msx_RomChange(lua_State *L) {
	int slot = (int)luaL_checknumber(L, 1);
	const char * nm = luaL_checkstring(L, 2);
	int ret;

	if( !ROMName[slot] ){
		ROMName[slot] = (char*)malloc( 256 );
		*ROMName[slot] = '\0';
	}
	strcpy( ROMName[slot], (nm?nm:"") );
	ret = LoadCart(nm , slot);
	lua_pushnumber(L, ret);
	return 1;
}

static int msx_DskChange(lua_State *L) {
	int slot = (int)luaL_checknumber(L, 1);
	const char * nm = luaL_checkstring(L, 2);
	byte ret;
	
	if( !DSKName[slot] ){
		DSKName[slot] = (char*)malloc( 256 );
		*DSKName[slot] = '\0';
	}
	strcpy( DSKName[slot], (nm?nm:"") );
	ret = ChangeDisk(slot,DSKName[slot]);
	lua_pushnumber(L, ret);
	return 1;
}

static int msx_CasChange(lua_State *L) {
	const char * nm = luaL_checkstring(L, 1);
	int ret;

	if( !CasName ){
		CasName = (char*)malloc(256);
		*CasName = '\0';
	}
	strcpy( CasName, nm );
	ret = ChangeCas( CasName );
	lua_pushnumber(L, ret);
	return 1;
}

static int msx_setBIOS(lua_State *L) {
	int a = (int)luaL_checknumber(L, 1);
	int b = (int)luaL_checknumber(L, 2);
	int c = (int)luaL_checknumber(L, 3);
	char * fn = (char *)luaL_checkstring(L, 4);
	int siz = (int)luaL_checknumber(L, 5);
	setBios( a, b, c, fn, siz );
	return 0;
}
static int msx_patchBIOS(lua_State *L) {
	patchBIOS();
	return 1;
}

static int msx_patchBDOS(lua_State *L) {
	int a = (int)luaL_checknumber(L, 1);
	int b = (int)luaL_checknumber(L, 2);
	int c = (int)luaL_checknumber(L, 3);
	patchBDOS( a, b, c );
	return 0;
}

static int msx_bootMSX(lua_State *L){
	cls(1);
	bootMSX();
	return 0;
}

static int msx_exitMSX(lua_State *L){
	ExitNow = 1;
	return 0;
}

static int msx_initPallette(lua_State *L){
	initPallette();
	return 0;
}
static int msx_loadMSXDOS2(lua_State *L){
	int slot = (int)luaL_checknumber(L, 1);
	char* fn = (char *)luaL_checkstring(L, 2);
	loadMSXDOS2( slot, fn );
	return 0;
}
static int msx_loadFMPAC(lua_State *L){
	int slot = (int)luaL_checknumber(L, 1);
	char* fn = (char *)luaL_checkstring(L, 2);
	loadFMPAC( slot, fn );
	return 0;
}
static int msx_loadCMOS(lua_State *L){
	char* fn = (char *)luaL_checkstring(L, 1);
	loadCMOS( fn );
	return 0;
}
static int msx_loadKanjiRom(lua_State *L){
	char* fn = (char *)luaL_checkstring(L, 1);
	int siz = (int)luaL_checknumber(L, 2);
	loadKanjiRom( fn, siz );
	return 0;
}

static int msx_setParam(lua_State *L){
	char* nm = (char *)luaL_checkstring(L, 1);
	if     ( !strcmp(nm,"RAMSize"  ) ){ RAMPages  = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"VRAMSize" ) ){ VRAMPages = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"AutoFit"  ) )
	{
		autoFitScreen = luaL_checkint(L, 2);
		if( autoFitScreen ){
		    BG3_YDY = (1 << 8) + ((VDP[9]&0x80)?28:0);
		}
	}
	else if( !strcmp(nm,"scr_x"    ) ){ BG3_CX = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"scr_y"    ) ){ BG3_CY = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"scale_x"  ) ){ BG3_XDX = (1 << 8) + luaL_checkint(L, 2); }
	else if( !strcmp(nm,"scale_y"  ) ){ BG3_YDY = (1 << 8) + luaL_checkint(L, 2); }
	else if( !strcmp(nm,"Version"  ) ){ MSXVersion = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"Verbose"  ) ){ Verbose = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"UPeriod"  ) ){ UPeriod = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"VPeriod"  ) ){ VPeriod = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"HPeriod"  ) ){ HPeriod = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"JoyTypeA" ) ){ JoyTypeA = luaL_checkint(L, 2); }
	else if( !strcmp(nm,"JoyTypeB" ) ){ JoyTypeB = luaL_checkint(L, 2); }
	return 0;
}
static int msx_saveState(lua_State *L){
	char* fn = (char *)luaL_checkstring(L, 1);
	SaveState( fn );
	return 0;
}
static int msx_loadState(lua_State *L){
	char* fn = (char *)luaL_checkstring(L, 1);
	LoadState( fn );
	return 0;
}

static const luaL_Reg msxlib[] = {
	{"RomChange"   , msx_RomChange   },
	{"DskChange"   , msx_DskChange   },
	{"CasChange"   , msx_CasChange   },
	{"setBIOS"     , msx_setBIOS     },
	{"patchBIOS"   , msx_patchBIOS   },
	{"patchBDOS"   , msx_patchBDOS   },
	{"initPallette", msx_initPallette},
	{"loadMSXDOS2" , msx_loadMSXDOS2 },
	{"loadFMPAC"   , msx_loadFMPAC   },
	{"loadCMOS"    , msx_loadCMOS    },
	{"loadKanjiRom", msx_loadKanjiRom},
	{"boot"        , msx_bootMSX     },
	{"exit"        , msx_exitMSX     },
	{"setParam"    , msx_setParam    },
	{"saveState"   , msx_saveState   },
	{"loadState"   , msx_loadState   },
	{NULL, NULL}
};

LUALIB_API int luaopen_msx(lua_State *L) {
	luaL_register(L, "MSX", msxlib);
	return 1;
}

static int ui_pset(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int c = (int)luaL_checknumber(L, 4);
	pset( g==1?BG_GFX:BG_GFX_SUB,x,y,c );
	return 0;
}

static int ui_box(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int w = (int)luaL_checknumber(L, 4);
	int h = (int)luaL_checknumber(L, 5);
	int c = (int)luaL_checknumber(L, 6);
	box( g==1?BG_GFX:BG_GFX_SUB, x, y, w, h, c );
	return 0;
}
static int ui_line(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int w = (int)luaL_checknumber(L, 4);
	int h = (int)luaL_checknumber(L, 5);
	int c = (int)luaL_checknumber(L, 6);
	line( g==1?BG_GFX:BG_GFX_SUB, x, y, w, h, c );
	return 0;
}
static int ui_fill(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int w = (int)luaL_checknumber(L, 4);
	int h = (int)luaL_checknumber(L, 5);
	int c = (int)luaL_checknumber(L, 6);
	fill( g==1?BG_GFX:BG_GFX_SUB, x, y, w, h, c );
	return 0;
}
static int ui_drawFont(lua_State *L) {
	int g  = (int)luaL_checknumber(L, 1);
	int x  = (int)luaL_checknumber(L, 2);
	int y  = (int)luaL_checknumber(L, 3);
	int chr= (int)luaL_checknumber(L, 4);
	int fc = (int)luaL_checknumber(L, 5);
	int bc = (int)luaL_checknumber(L, 6);
	drawFont( g==1?BG_GFX:BG_GFX_SUB, x, y, chr, fc, bc );
	return 0;
}

static int ui_drawText(lua_State *L) {
	int g  = (int)luaL_checknumber(L, 1);
	int x  = (int)luaL_checknumber(L, 2);
	int y  = (int)luaL_checknumber(L, 3);
	u8* b  = (u8*)luaL_checkstring(L, 4);
	int fc = (int)luaL_checknumber(L, 5);
	int bc = (int)luaL_checknumber(L, 6);
	drawText( g==1?BG_GFX:BG_GFX_SUB, x, y, b, fc, bc );
	return 0;
}
static int ui_loadFont(lua_State *L) {
	int ret;
	char * fn   = (char*)luaL_checkstring(L, 1);
	ret = loadFont( fn );
	lua_pushboolean( L,ret );
	return 1;
}
static int ui_drawFont2(lua_State *L) {
	int g  = (int)luaL_checknumber(L, 1);
	int x  = (int)luaL_checknumber(L, 2);
	int y  = (int)luaL_checknumber(L, 3);
	int chr= (int)luaL_checknumber(L, 4);
	int fc = (int)luaL_checknumber(L, 5);
	int bc = (int)luaL_checknumber(L, 6);
	drawFont2( g==1?BG_GFX:BG_GFX_SUB, x, y, chr, fc, bc );
	return 0;
}
static int ui_drawText2(lua_State *L) {
	int g  = (int)luaL_checknumber(L, 1);
	int x  = (int)luaL_checknumber(L, 2);
	int y  = (int)luaL_checknumber(L, 3);
	u8* b  = (u8*)luaL_checkstring(L, 4);
	int fc = (int)luaL_checknumber(L, 5);
	int bc = (int)luaL_checknumber(L, 6);
	drawText2( g==1?BG_GFX:BG_GFX_SUB, x, y, b, fc, bc );
	return 0;
}
static int ui_drawFontMSX(lua_State *L) {
	int g  = (int)luaL_checknumber(L, 1);
	int x  = (int)luaL_checknumber(L, 2);
	int y  = (int)luaL_checknumber(L, 3);
	int chr= (int)luaL_checknumber(L, 4);
	int fc = (int)luaL_checknumber(L, 5);
	int bc = (int)luaL_checknumber(L, 6);
	drawFontMSX( g==1?BG_GFX:BG_GFX_SUB, x, y, chr, fc, bc );
	return 0;
}
static int ui_drawTextMSX(lua_State *L) {
	int g  = (int)luaL_checknumber(L, 1);
	int x  = (int)luaL_checknumber(L, 2);
	int y  = (int)luaL_checknumber(L, 3);
	u8* b  = (u8*)luaL_checkstring(L, 4);
	int fc = (int)luaL_checknumber(L, 5);
	int bc = (int)luaL_checknumber(L, 6);
	drawTextMSX( g==1?BG_GFX:BG_GFX_SUB, x, y, b, fc, bc );
	return 0;
}
static int ui_drawDesktop(lua_State *L) {
	int g  = (int)luaL_checknumber(L, 1);
	drawDesktop( g==1?BG_GFX:BG_GFX_SUB );
	return 0;
}
static int ui_copyGraph(lua_State *L) {
	int dg = (int)luaL_checknumber(L, 1);
	int dx = (int)luaL_checknumber(L, 2);
	int dy = (int)luaL_checknumber(L, 3);
	int sg = (int)luaL_checknumber(L, 1);
	int sx = (int)luaL_checknumber(L, 4);
	int sy = (int)luaL_checknumber(L, 5);
	int w  = (int)luaL_checknumber(L, 6);
	int h  = (int)luaL_checknumber(L, 7);
	copyGraph( dg==1?BG_GFX:BG_GFX_SUB, dx, dy, sg==1?BG_GFX:BG_GFX_SUB, sx, sy, w, h );
	return 0;
}
static int ui_drawIcon(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int n = (int)luaL_checknumber(L, 4);
	drawIcon( g==1?BG_GFX:BG_GFX_SUB, x, y, n );
	return 0;
}
static int ui_drawIcon2(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int w = (int)luaL_checknumber(L, 4);
	int h = (int)luaL_checknumber(L, 5);
	u16* b = (u16*)lua_touserdata(L, 6);
	if(b==NULL) return luaL_error(L, "drawIcon2 :not userdata param." );
	drawIcon2( g==1?BG_GFX:BG_GFX_SUB, x, y, w, h, b );
	return 0;
}

static int ui_loadIcon(lua_State *L) {
	FILE * fp;
	int cnt;
	char * fn   = (char*)luaL_checkstring(L, 1);
	int siz  = (int)luaL_checknumber(L, 2);
	char * buf = (char*)lua_newuserdata(L, siz);

	fp = fopen( fn, "rb" );
	if( fp == NULL ) return luaL_error(L, "loadIcon :%s file not found.", fn );
	cnt = fread(buf, 1, siz, fp );
	if( cnt != siz ) return luaL_error(L, "loadIcon :File size invaild. %d", siz );
	fclose( fp );
	return 1;
}

static int ui_cls(lua_State *L) {	cls((int)luaL_checknumber(L, 1));	return 0; }
static int ui_drawWindow(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int w = (int)luaL_checknumber(L, 4);
	int h = (int)luaL_checknumber(L, 5);
	drawWindow( g==1?BG_GFX:BG_GFX_SUB, x, y , w, h );
	return 0;
}
static int ui_drawButton(lua_State *L) {
	int g = (int)luaL_checknumber(L, 1);
	int x = (int)luaL_checknumber(L, 2);
	int y = (int)luaL_checknumber(L, 3);
	int w = (int)luaL_checknumber(L, 4);
	int h = (int)luaL_checknumber(L, 5);
	u8* b = (u8*)luaL_checkstring(L, 6);
	drawButton( g==1?BG_GFX:BG_GFX_SUB, x, y, w, h , b);
	return 0;
}
static int ui_LOG(lua_State *L) {	LOG( (char*)luaL_checkstring(L, 1) );	return 0; }

static int ui_keybind(lua_State *L){
	int num = (int)luaL_checknumber(L, 1);
	Keys[num].type  =  (u8)luaL_checknumber(L, 2);
	Keys[num].code  =  (u8)luaL_checknumber(L, 3);
	Keys[num].mask  =  (u8)luaL_checknumber(L, 4);
	Keys[num].Hold  =  (u8)luaL_checknumber(L, 5);
	Keys[num].x     = (u16)luaL_checknumber(L, 6);
	Keys[num].y     = (u16)luaL_checknumber(L, 7);
	Keys[num].width = (u16)luaL_checknumber(L, 8);
	Keys[num].height= (u16)luaL_checknumber(L, 9);
	Keys[num].x_mgn = (u16)luaL_checknumber(L,10);
	Keys[num].y_mgn = (u16)luaL_checknumber(L,11);
	Keys[num].fnttype =(u8)luaL_checknumber(L,12);
	strncpy( Keys[num].text[0] , (char *)luaL_checkstring(L,13),8);
	strncpy( Keys[num].text[1] , (char *)luaL_checkstring(L,14),8);
	strncpy( Keys[num].text[2] , (char *)luaL_checkstring(L,15),8);
	strncpy( Keys[num].text[3] , (char *)luaL_checkstring(L,16),8);
	strncpy( Keys[num].text[4] , (char *)luaL_checkstring(L,17),8);
	strncpy( Keys[num].text[5] , (char *)luaL_checkstring(L,18),8);
	strncpy( Keys[num].text[6] , (char *)luaL_checkstring(L,19),8);
	strncpy( Keys[num].text[7] , (char *)luaL_checkstring(L,20),8);
	strncpy( Keys[num].text[8] , (char *)luaL_checkstring(L,21),8);
	strncpy( Keys[num].text[9] , (char *)luaL_checkstring(L,22),8);
	createTouchMap();
	return 0;
}

static int ui_joybind(lua_State *L){
	int num = (int)luaL_checknumber(L, 1);
	Joys[num].type  =  (u8)luaL_checknumber(L, 2);
	Joys[num].code  =  (u8)luaL_checknumber(L, 3);
	Joys[num].mask  =  (u8)luaL_checknumber(L, 4);
	return 0;
}

static int ui_waitForVBlank(lua_State *L){	waitForVBlank((int)luaL_checknumber(L, 1));	return 0; }

static int ui_scanKeys(lua_State *L){	scanKeys();	return 0;}

static void pushkeydata(lua_State *L, uint32 k )
{
	lua_createtable(L, 0, 0);
	lua_pushstring(L, "A"      ); lua_pushboolean( L, k&BIT( 0) ); lua_settable (L,1);
	lua_pushstring(L, "B"      ); lua_pushboolean( L, k&BIT( 1) ); lua_settable (L,1);
	lua_pushstring(L, "SELECT" ); lua_pushboolean( L, k&BIT( 2) ); lua_settable (L,1);
	lua_pushstring(L, "START"  ); lua_pushboolean( L, k&BIT( 3) ); lua_settable (L,1);
	lua_pushstring(L, "RIGHT"  ); lua_pushboolean( L, k&BIT( 4) ); lua_settable (L,1);
	lua_pushstring(L, "LEFT"   ); lua_pushboolean( L, k&BIT( 5) ); lua_settable (L,1);
	lua_pushstring(L, "UP"     ); lua_pushboolean( L, k&BIT( 6) ); lua_settable (L,1);
	lua_pushstring(L, "DOWN"   ); lua_pushboolean( L, k&BIT( 7) ); lua_settable (L,1);
	lua_pushstring(L, "R"      ); lua_pushboolean( L, k&BIT( 8) ); lua_settable (L,1);
	lua_pushstring(L, "L"      ); lua_pushboolean( L, k&BIT( 9) ); lua_settable (L,1);
	lua_pushstring(L, "X"      ); lua_pushboolean( L, k&BIT(10) ); lua_settable (L,1);
	lua_pushstring(L, "Y"      ); lua_pushboolean( L, k&BIT(11) ); lua_settable (L,1);
	lua_pushstring(L, "TOUCH"  ); lua_pushboolean( L, k&BIT(12) ); lua_settable (L,1);
	lua_pushstring(L, "LID"    ); lua_pushboolean( L, k&BIT(13) ); lua_settable (L,1);
}
static int ui_keysDown(lua_State *L){
	uint32 k = keysDown();
	pushkeydata(L,k);
	return 1;
}
static int ui_keysDownRepeat(lua_State *L){
	uint32 k = keysDownRepeat();
	pushkeydata(L,k);
	return 1;
}

static int ui_keysHeld(lua_State *L){
	uint32 k = keysHeld();
	pushkeydata(L,k);
	return 1;
}

static int ui_keysUp(lua_State *L){
	uint32 k = keysUp();
	pushkeydata(L,k);
	return 1;
}

static int ui_keysSetRepeat(lua_State *L){
	u8 d = (u8)luaL_checknumber(L, 1);
	u8 r = (u8)luaL_checknumber(L, 2);
	keysSetRepeat( d, r );
	return 0;
}
static int ui_touchReadXY(lua_State *L){
	touchPosition t = touchReadXY();
	lua_createtable(L, 0, 0);
	lua_pushstring(L, "x" ); lua_pushinteger( L, t.x ); lua_settable (L,1);
	lua_pushstring(L, "y" ); lua_pushinteger( L, t.y ); lua_settable (L,1);
	lua_pushstring(L, "px"); lua_pushinteger( L, t.px); lua_settable (L,1);
	lua_pushstring(L, "py"); lua_pushinteger( L, t.py); lua_settable (L,1);
	lua_pushstring(L, "z1"); lua_pushinteger( L, t.z1); lua_settable (L,1);
	lua_pushstring(L, "z2"); lua_pushinteger( L, t.z2); lua_settable (L,1);
	return 1;
}

static int ui_fileselect(lua_State *L){
	int ret;
	char * p   = (char *)luaL_checkstring(L, 1);
	char * ext = (char *)luaL_checkstring(L, 2);
	char fn[256];
	*fn = '\0';
	if( strlen(ext)==0 ) ext = NULL;
	ret = fileselect( p, ext, fn );
	lua_pushinteger(L, ret );
	lua_pushstring( L,fn );
	return 2;
}

static int ui_soundStart(lua_State *L){	LOG( "soundStart" ); soundStart();	return 0; }
static int ui_soundStop(lua_State *L) {	soundStop();	return 0; }
static int ui_drawAllKeyboard(lua_State *L){ drawAllKeyboard();	return 0; }

static const luaL_Reg uilib[] = {
	{"pset"         , ui_pset },
	{"box"          , ui_box },
	{"line"         , ui_line },
	{"fill"         , ui_fill },
	{"drawFont"     , ui_drawFont },
	{"drawText"     , ui_drawText },
	{"drawText2"    , ui_drawText2 },
	{"loadFont"     , ui_loadFont },
	{"drawFont2"    , ui_drawFont2 },
	{"drawFontMSX"  , ui_drawFontMSX },
	{"drawTextMSX"  , ui_drawTextMSX },
	{"drawDesktop"  , ui_drawDesktop },
	{"copyGraph"    , ui_copyGraph },
	{"drawIcon"     , ui_drawIcon },
	{"drawIcon2"    , ui_drawIcon2 },
	{"loadIcon"     , ui_loadIcon },
	{"cls"          , ui_cls },
	{"drawWindow"   , ui_drawWindow },
	{"drawButton"   , ui_drawButton },
	{"LOG"          , ui_LOG },
	{"Keybind"      , ui_keybind },
	{"Joybind"      , ui_joybind },
	{"waitForVBlank", ui_waitForVBlank },
	{"scanKeys"     , ui_scanKeys},
	{"keysDown"     , ui_keysDown},
	{"keysDownRepeat",ui_keysDownRepeat},
	{"keysHeld"     , ui_keysHeld},
	{"keysUp"       , ui_keysUp},
	{"keysSetRepeat", ui_keysSetRepeat},
	{"touchReadXY"  , ui_touchReadXY},
	{"fileselect"   , ui_fileselect},
	{"soundStart"   , ui_soundStart},
	{"soundStop"    , ui_soundStop},
	{"drawAllKeyboard",ui_drawAllKeyboard},
	{NULL, NULL}
};

LUALIB_API int luaopen_ui (lua_State *L) {
  luaL_register(L, "ui", uilib);
	return 1;
}

void StartLua(char * luaname )
{
	int ret;
	lua = lua_open();
	if( lua == NULL ) return;
	luaL_openlibs(lua);	// internal lib open
	luaopen_msx(lua);	// MSX Lib open
	luaopen_ui(lua);	// ui Lib open

	ret = luaL_loadfile(lua, luaname);
	switch( ret ){
	case LUA_ERRSYNTAX :LOG( "[ERRSYNTAX]%s",(char*)luaL_checkstring(lua, -1) ); break;
	case LUA_ERRMEM    :LOG( "[ERRMEM]%s"   ,(char*)luaL_checkstring(lua, -1) ); break;
	case LUA_ERRFILE   :LOG( "[ERRFILE]%s"  ,(char*)luaL_checkstring(lua, -1) ); break;
	default: LOG( "fmsxDS.lua load ok." );
	}
	if( ret != 0 ) return;
	ret = lua_pcall(lua, 0, LUA_MULTRET, 0);
	switch( ret ){
	case LUA_ERRRUN:LOG( "[RUNERR]%s",(char*)luaL_checkstring(lua, -1) ); break;
	case LUA_ERRMEM:LOG( "[MEMERR]%s",(char*)luaL_checkstring(lua, -1) ); break;
	case LUA_ERRERR:LOG( "[ERRERR]%s",(char*)luaL_checkstring(lua, -1) ); break;
	default: LOG( "fmsxDS.lua normal end" );
	}
	lua_close(lua);
}

int lua_MainMenu(int flg)
{
	int ret;
	char buf[32];
	sprintf( buf, "MainMenu(%d);", flg );
	ret = luaL_loadstring( lua, buf );
	switch( ret ){
	case LUA_ERRSYNTAX :LOG( "[ERRSYNTAX]%s",(char*)luaL_checkstring(lua, -1) ); break;
	case LUA_ERRMEM    :LOG( "[ERRMEM]%s"   ,(char*)luaL_checkstring(lua, -1) ); break;
	case LUA_ERRFILE   :LOG( "[ERRFILE]%s"  ,(char*)luaL_checkstring(lua, -1) ); break;
	}
	lua_pcall(lua,0,LUA_MULTRET,0);
	return 1;
}

int lua_vsync()
{
	if( lua ){
		int	ret = luaL_loadstring( lua, "vsync()" );
		if( ret ) lua_pcall(lua,0,LUA_MULTRET,0);
	}
	return 1;
}
