//////////////////////////////////////////////////////////////////////
// Simple ARM7 stub (sends RTC, TSC, and X/Y data to the ARM 9)
// -- joat
// -- modified by Darkain and others
//////////////////////////////////////////////////////////////////////

#include "ipc2.h"
#include <NDS.h>
//#include "emu2149.h"
//#include "emu2212.h"
//#include "emu2413.h"
#include <string.h>

//////////////////////////////////////////////////////////////////////
#define TOUCH_CAL_X1 (*(vs16*)0x027FFCD8)
#define TOUCH_CAL_Y1 (*(vs16*)0x027FFCDA)
#define TOUCH_CAL_X2 (*(vs16*)0x027FFCDE)
#define TOUCH_CAL_Y2 (*(vs16*)0x027FFCE0)
#define SCREEN_WIDTH    256
#define SCREEN_HEIGHT   192
#define TOUCH_WIDTH    ((s32)( TOUCH_CAL_X2 - TOUCH_CAL_X1 ))
#define TOUCH_HEIGHT   ((s32)( TOUCH_CAL_Y2 - TOUCH_CAL_Y1 ))
#define TOUCH_OFFSET_X (((s32)((SCREEN_WIDTH -60) * TOUCH_CAL_X1) / TOUCH_WIDTH  ) - 28 )
#define TOUCH_OFFSET_Y (((s32)((SCREEN_HEIGHT-60) * TOUCH_CAL_Y1) / TOUCH_HEIGHT ) - 28 )
//////////////////////////////////////////////////////////////////////
PSG * psg;
SCC * scc;
//OPLL * opll;

//extern	e_uint32 * ptllTable   ;
//extern	e_uint32 * pdphaseTable;


#define MSX_CLK 3579545
#define SAMPLERATE  11025  //22050
#define SOUNDBUFCNT ((u16)(1024))   //367

#define TIMERCOUNT(N)  ((int)( 0x2000000 / (N) ))

int samplerate;
s16 * soundbuf;
s16 * sbuf;
int wptr  = 0; // f[^ʒu
int wbufp = 0; // f[^obt@
int SoundProcTiming = 0;
u16 nosoundcnt = 0;
//////////////////////////////////////////////////////////////////////

void startSound(int sampleRate, const void* data, uint32 bytes, u8 channel, u8 vol,  u8 pan, u8 format) {
  SCHANNEL_TIMER(channel)  = SOUND_FREQ(sampleRate);
  SCHANNEL_SOURCE(channel) = (uint32)data;
  SCHANNEL_LENGTH(channel) = bytes >> 2;
  SCHANNEL_REPEAT_POINT(channel) = 0;
  SCHANNEL_CR(channel)     = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(vol) | SOUND_PAN(pan) | (format==1? SOUND_FORMAT_8BIT:SOUND_FORMAT_16BIT);
}

bool isFreeSoundChannel(int i) {
  if ( (SCHANNEL_CR(i) & SCHANNEL_ENABLE) == 0 ) return true;
  return false;
}

void waitForVBlank()
{
	while(!(REG_DISPSTAT & DISP_IN_VBLANK));
	while((REG_DISPSTAT & DISP_IN_VBLANK));
}

//////////////////////////////////////////////////////////////////////

void InitSound(int r)
{
	// Timer setting
	TIMER0_DATA = (u16)(0x10000 - TIMERCOUNT(r) );
	TIMER0_CR = TIMER_DIV_1 | TIMER_ENABLE;     // | TIMER_IRQ_REQ;

	TIMER1_DATA = (u16)(0x10000 - SOUNDBUFCNT);
	TIMER1_CR = TIMER_CASCADE | TIMER_ENABLE ;  // | TIMER_IRQ_REQ ;

	
	psg = (PSG *)&(IPC2->psg);
	scc = (SCC *)&(IPC2->scc);
//	opll= (OPLL*)&(IPC2->opll);
//	psg = (PSG *)IPC2->psg;
//	scc = (SCC *)IPC2->scc;
//	opll= (OPLL*)IPC2->opll;

//	ptllTable    = IPC2->ptllTable;
//	pdphaseTable = IPC2->pdphaseTable;
	soundbuf = (s16*)(IPC2->soundbuf);
	sbuf = soundbuf;

	// PSG initialize
	PSG_new(psg, MSX_CLK,r);
	PSG_reset( psg );

	// SCC initialize
	SCC_new(scc, MSX_CLK,r);
	SCC_reset( scc );

	// OPLL initialize
//	OPLL_new(opll, MSX_CLK,r);
//	OPLL_reset( opll ); 		// OPLL_new̒Ŏsς
}

void vsync()
{

	touchPosition tp;
	uint16 but=0,x=0,y=0,xpx=0,ypx=0, z1=0, z2=0, batt=0, aux=0;
	int t1=0, t2=0;
	uint32 temp=0;
	uint8 ct[sizeof(IPC->time.curtime)];
	u32 i; 

	// Read the X/Y buttons and the /PENIRQ line
	but = REG_KEYXY;
	tp = touchReadXY();
	if (!(but & 0x40)) {
		// Read the touch screen
		x = tp.x;
		y = tp.y;
		xpx = ( ((SCREEN_WIDTH -60) * x) / TOUCH_WIDTH  ) - TOUCH_OFFSET_X;
		ypx = ( ((SCREEN_HEIGHT-60) * y) / TOUCH_HEIGHT ) - TOUCH_OFFSET_Y;
		z1 = tp.z1;
		z2 = tp.z2;
	}

	batt = touchRead(TSC_MEASURE_BATTERY);
	aux  = touchRead(TSC_MEASURE_AUX);

	// Read the time
	rtcGetTime((uint8 *)ct);
	BCDToInteger((uint8 *)&(ct[1]), 7);

	// Read the temperature
	temp = touchReadTemperature(&t1, &t2);

	// Update the IPC struct
	IPC->touchZ1   = z1;
	IPC->touchZ2   = z2;
	IPC->battery   = batt;
	IPC->aux       = aux;
	IPC->temperature = temp;
	IPC->tdiode1   = t1;
	IPC->tdiode2   = t2;
	IPC->buttons   = but;
	IPC->touchX    = x;
	IPC->touchY    = y;
	IPC->touchXpx  = xpx;
	IPC->touchYpx  = ypx;
	for(i=0; i<sizeof(ct); i++) {
	  IPC->time.curtime[i] = ct[i];
	}

	IPC2->cnt = nosoundcnt;
}

void InterruptHandler(void) {

/*	if (REG_IF & IRQ_TIMER1) {
		startSound(SAMPLERATE, soundbuf + wbufp*SOUNDBUFCNT, SOUNDBUFCNT*2, wbufp , 0x7f, 63, 0);
		wbufp = wbufp==0?1:0; 
		sbuf = soundbuf + wbufp*SOUNDBUFCNT;
		wptr = 0;
		VBLANK_INTR_WAIT_FLAGS |= IRQ_TIMER1;
	}
*/
	if (REG_IF & IRQ_VBLANK) {
		vsync();
		VBLANK_INTR_WAIT_FLAGS |= IRQ_VBLANK;
	}

	// Acknowledge interrupts
	REG_IF = REG_IF;
}
 

/** LoopSound() **********************************************/
/** Main loop of the sound server.                          **/
/*************************************************************/

void ProcSound()
{
	s16 P,S,O,A;
	P=O=A=S=0;

	P = PSG_calc(psg);
	S = SCC_calc(scc);
//	O = OPLL_calc(opll)*2;
//			if(snd.opl)  A = OPL_calc(snd.opl);
	*sbuf = (P+S+O)*2; //O+(A>>2);
	sbuf++;
	wptr++;

	if( wptr >= SOUNDBUFCNT ){
		startSound(samplerate, soundbuf + wbufp*SOUNDBUFCNT, SOUNDBUFCNT*2, wbufp , 0x7f, 63, 0);
		wbufp = wbufp==0?1:0; 
		sbuf = soundbuf + wbufp*SOUNDBUFCNT;
		wptr = 0;
	}

}

int main(int argc, char ** argv) {

	//	IPC->soundCommandResult	= 0;
	int SoundPause = true;
	// Reset the clock if needed
	rtcReset();

	//enable sound
	powerON(POWER_SOUND);
	SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7F);

	// Set up the interrupt handler
	REG_IME = 0;
	IRQ_HANDLER = &InterruptHandler;
	REG_IE  = IRQ_VBLANK ; //| IRQ_TIMER0;
	REG_IF  = ~0;
	REG_DISPSTAT = DISP_VBLANK_IRQ;
	REG_IME = 1;

	while (1){
		switch( IPC2->soundCommand ){
			case 1: // Pause
				SoundPause = true;
				IPC2->soundCommand = 0;
				break;
			case 2: // Play
				SoundPause = false;
				SoundProcTiming = 0;
				wptr  = 0;
				wbufp = 0;
				IPC2->soundCommand = 0;
				break;
			case 3: // Sound Initialize
				samplerate = IPC2->sampleRate;
				if( samplerate < 1 ) samplerate = 0x4000;
				InitSound(samplerate);
				IPC2->soundCommand = 0;
				break;
		}
		if( !SoundPause ){
			if( SoundProcTiming != TIMER1_DATA ){
				SoundProcTiming = TIMER1_DATA;
				ProcSound();
			}else{
				nosoundcnt ++;
			}
		}
//		swiWaitForVBlank();
	}
	return 0;
}
