/** EMULib Emulation Library *********************************/
/**                                                         **/
/**                          Sound.h                        **/
/**                                                         **/
/** This file defines standard sound generation API and     **/
/** functions needed to log soundtrack into a MIDI file.    **/
/** See Sound.c and the sound drivers for the code.         **/ 
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1996-2005                 **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifndef SOUND_H
#define SOUND_H

/** TrashSound() *********************************************/
/** Shut down sound driver. Each driver implements its own  **/
/** TrashSound() function.                                  **/
/*************************************************************/
void TrashSound(void);

/** InitSound() **********************************************/
/** Initialize MSDOS sound driver with given synthesis      **/
/** rate. Returns Rate on success, 0 otherwise. Pass Rate=0 **/
/** to skip initialization and be silent. Pass Rate=1 to    **/
/** use Adlib (OPL3) sound. Pass Rate=8192..44100 to use    **/
/** SoundBlaster wave synthesis.                            **/
/*************************************************************/
int InitSound(int Rate,int Verb);

/** ResetSound() *********************************************/
/** Reset sound chips.                                      **/
/*************************************************************/
void ResetSound();

/*************************************************************/
/** access sound chips.                                     **/
/*************************************************************/
void WriteAUDIO(int R,int V);
void WriteOPLL (int R,int V);
void Write2212 (int R,int V);
void WritePSG  (int R,int V);
int  ReadPSG   (int R)      ;

#endif /* SOUND_H */
