//////////////////////////////////////////////////////////////////////
// fmsxDS
//////////////////////////////////////////////////////////////////////
#include "../../common/ipc2.h"
#include "msx.h"
#include <string.h>
#include <stdlib.h>
#include <NDS.h>
#include <fcntl.h>	
#include <fat.h>
#include <sys/dir.h>
#include <stdarg.h>

#include "DSDriver.h"
#include "DSGraph.h"
#include "Keybind.h"
#include "DSFileList.h"
#include "DSLua.h"

#define RGB16(a,r,g,b)  RGB15(r,g,b)|((a)<<15)

#ifdef FMSX
#define RdZ80 RDZ80
extern byte *RAM[],PSL[],SSLReg;
static byte RdZ80(register word A)
{
//  LOG( "RdZ80 %d" , A );
  if(A!=0xFFFF) return(RAM[A>>13][A&0x1FFF]);
  else return((PSL[3]==3)? ~SSLReg:RAM[7][0x1FFF]);
}
#endif

/** Public parameters ****************************************/
int UseSound  = 8192;          /* Sound driver frequency    */
char *Disks[2][MAXDISKS+1];    /* Disk names for each drive */

extern byte *MemMap[4][4][8];   /* Memory maps [PPage][SPage][Addr] */

/** Various variables ****************************************/
//#define WIDTH  272
//#define HEIGHT 228
int WIDTH  = 272;
int HEIGHT = 228;

extern u8 touchmap[];
extern void waitForVBlank(int);

void createTouchMap();



/** Keyboard bindings ****************************************/
byte WinKeyMap[16];             /* Keyboard map              */
byte JoyKeyMap[2];				/* Joystick Keymap           */
byte MouseMap[2];				/* Mouse Keymap              */

byte hkey[16];					/* Hold key map              */

unsigned int BPal[256],XPal[80],XPal0; 
char *XBuf;
char *XBuf2;
int  XBufType = 1;

int UseStatic = 0;

extern int View_x;
extern int View_y;
extern int UseNarrow;
extern int Usex2Mode;
extern byte TapeHeader[8];

//extern int InitSound(int Rate,int Verb);

void drawAllKeyboard(void);

int pad_type = 0;

#define SetDownKey(AA) ( WinKeyMap[(AA).code]&=~((AA).mask) )
#define SetUpKey(AA)   ( WinKeyMap[(AA).code]|= ((AA).mask) )
#define SetDownJoy(AA) ( JoyKeyMap[(AA).code]|= ((AA).mask) )
#define SetUpJoy(AA)   ( JoyKeyMap[(AA).code]&=~((AA).mask) )

#define LOG_CHR_NUM  51
void LOG( char * str , ... )
{
	va_list args;
	char buf[256];
	char a[LOG_CHR_NUM+1];
	char * n;
	int l;
	va_start(args,str);
	vsprintf(buf,str,args);
	va_end(args);
	n = buf;
	l = strlen( buf );
	while(l){
		if( l > LOG_CHR_NUM ){
			strncpy(a, n,LOG_CHR_NUM);
			n+=LOG_CHR_NUM;
			l=strlen(n);
		}else{
			strcpy( a, n );
			l=0;
		}
		copyGraph( BG_GFX_SUB, 0, 160, BG_GFX_SUB, 0, 168, 256, 24 );
		fill( BG_GFX_SUB, 0, 184, 256, 8, 0x8000 );
		drawText( BG_GFX_SUB, 0, 184, (u8*)a, 0xFFFF, 0x8000 );
	}
}

int touchX(void){
	return IPC->touchXpx;
}
int touchY(void){
	return IPC->touchYpx;
}


void RomSelect( int num )
{
	int ret;
	char fn[256];
	ret = fileselect( "fat:/", "ROM", fn );
	if( ret ){
		if( !ROMName[num] ) ROMName[num] = (char*)malloc(256);
		strcpy( ROMName[num], fn );
	}
}

void DiskSelect( int num )
{
	int ret;
	char fn[256];
	ret = fileselect( "fat:/", "DSK", fn );
	if( !DSKName[num] ) DSKName[num] = (char*)malloc(256);
	strcpy( DSKName[num], fn );
	ChangeDisk(num,DSKName[num]);
}

void CasSelect( void )
{
	int ret;
	char fn[256];
	ret = fileselect( "fat:/", "CAS", fn );
	if( !CasName ) CasName = (char*)malloc(256);
	strcpy( CasName, fn );
	ChangeCas( CasName );
}

#define MAINMENU_X 5
#define MAINMENU_Y 40
#define MAINMENU_ICONLEFT  (MAINMENU_X +  7)
#define MAINMENU_ICONTOP   (MAINMENU_Y + 10)
#define MAINMENU_ICONW  (32 + 1)
void dispTouch();

#if 0
int MainMenu()
{
	int tx=0,ty=0;
//	u8 buf[16];
	int redraw = 1;
//	int c = 0;
//	int col;
//	int firstflg = false;
	int kx = 0, okx = 0;
	int ky = 0, oky = 0;
	int icon;
	int pendownflg = false;
	int keydownflg = false;

	IPC2->soundCommand = 1; /* pause sound*/

	while(1){
//		dispTouch();

		if( redraw ){
			drawWindow( BG_GFX_SUB,MAINMENU_X,MAINMENU_Y,245,90 );

			icon = ( ExitNow==0 ? ICON_POWER_ON:ICON_POWER_OFF ) ;
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT , MAINMENU_ICONTOP ,icon );
//			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT , MAINMENU_ICONTOP + 34,ICON_RESET );

			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW  , MAINMENU_ICONTOP               ,ICON_ROM1 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW  , MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_ROM2 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*2, MAINMENU_ICONTOP               ,ICON_DISK1 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*2, MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_DISK2 );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*3, MAINMENU_ICONTOP               ,ICON_CAS   );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*4, MAINMENU_ICONTOP               ,ICON_STATLOAD );
			drawIcon( BG_GFX_SUB, MAINMENU_ICONLEFT+MAINMENU_ICONW*4, MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_STATSAVE );


//			drawIcon( BG_GFX_SUB, 12+34*5, 52   ,ICON_CONFIG );
/*
			switch( pad_type ){
				case STICK1: drawIcon( BG_GFX_SUB, 12+34*6, 52   ,ICON_STICK1 ); break;
				case STICK2: drawIcon( BG_GFX_SUB, 12+34*6, 52   ,ICON_STICK2 ); break;
				case CURSOR: drawIcon( BG_GFX_SUB, 12+34*6, 52   ,ICON_CURSOR ); break;
			}
*/
			icon = ( XBufType == 1 ? ICON_CLIPBTM : (XBufType == 2 ?ICON_CLIPTOP : ICON_CLIPFIT  ) );
			drawIcon( BG_GFX_SUB,MAINMENU_ICONLEFT+MAINMENU_ICONW*6,MAINMENU_ICONTOP   ,icon );

			drawIcon( BG_GFX_SUB,MAINMENU_ICONLEFT+MAINMENU_ICONW*6,MAINMENU_ICONTOP+MAINMENU_ICONW,ICON_CLOSE  );

			if( kx >= 0 && ky >= 0 ){
				box( BG_GFX_SUB,MAINMENU_ICONLEFT+MAINMENU_ICONW*kx,
								MAINMENU_ICONTOP +MAINMENU_ICONW*ky,
								MAINMENU_ICONW-1,
								MAINMENU_ICONW-1,
								RGB16(1,31,0,0 ) );
			}
			redraw = 0;
		}

	    uint16 specialKeysPressed = ~IPC->buttons;
		if(specialKeysPressed & IPC_PEN_DOWN ){
			pendownflg = true;
			tx = touchX();
			ty = touchY();
		}else{
			if( pendownflg ){
				if( ty > MAINMENU_ICONTOP && ty < MAINMENU_ICONTOP+MAINMENU_ICONW ){
					if( tx > MAINMENU_ICONLEFT && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW ) {
						if( ExitNow ) {
							ExitNow = 0;
						}else{
							ExitNow = 1;
						}
						break;
					}
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW   && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*2 ) { RomSelect(0);  redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*2 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*3 ) { DiskSelect(0); redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*3 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*4 ) { CasSelect();   redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*4 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*5 ) { LoadState("/fmsxDS.sta"); }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*6 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*7 ) {
						XBufType = XBufType==1?2:1;
						redraw = 1;
					}
				}
				if( ty > MAINMENU_ICONTOP+MAINMENU_ICONW && ty < MAINMENU_ICONTOP+MAINMENU_ICONW*3 ){
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW   && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*2 ) { RomSelect(1);  redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*2 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*3 ) { DiskSelect(1); redraw = 1; }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*4 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*5 ) { SaveState("/fmsxDS.sta"); }
					if( tx > MAINMENU_ICONLEFT+MAINMENU_ICONW*6 && tx < MAINMENU_ICONLEFT+MAINMENU_ICONW*7 ) break;
				}
				pendownflg = false;
			}
		}

		vuint16 k = ~REG_KEYINPUT;
		oky = ky;
		okx = kx;
		if(k&KEY_DOWN ){ ky+=1; ky = ky>1?1:ky; }
		if(k&KEY_UP   ){ ky-=1; ky = ky<0?0:ky; }
		if(k&KEY_RIGHT){ kx+=1; kx = kx>6?6:kx; }
		if(k&KEY_LEFT ){ kx-=1; kx = kx<0?0:kx; }
		if( (okx!=kx) || (oky!=ky) ) redraw = 1;
		if(k&KEY_A    ){
			keydownflg = true;
		}else{
			if( keydownflg ){
				if( ky == 0 ){
					if( kx == 0 ) {
						ExitNow = ExitNow==0?1:0;
						break;
					}
					if( kx == 1 ) { RomSelect(0);  redraw = 1; }
					if( kx == 2 ) { DiskSelect(0); redraw = 1; }
					if( kx == 3 ) { CasSelect();   redraw = 1; }
					if( kx == 4 ) { LoadState("/fmsxDS.sta");  }
					if( kx == 6 ) { 
						XBufType = XBufType==1?2:1;
						redraw = 1;
					}
				} else 
				if( ky == 1 ){
					if( kx == 1 ) { RomSelect(1);  redraw = 1; }
					if( kx == 2 ) { DiskSelect(1); redraw = 1; }
					if( kx == 4 ) { SaveState("/fmsxDS.sta");  }
					if( kx == 6 ) { 
						break;
					}
				}
			}
			keydownflg = false;
		}

		waitForVBlank(6);
	}

	drawDesktop( BG_GFX_SUB );
	drawAllKeyboard();

	IPC2->soundCommand = 2; /* play sound*/

	return 0;
}
#endif
byte system_RTCIn(byte R)
{
	byte J;
    switch(R)
    {
    	case 0:  J=IPC->time.rtc.seconds % 10   ;break;
        case 1:  J=IPC->time.rtc.seconds / 10   ;break;
        case 2:  J=IPC->time.rtc.minutes % 10   ;break;
        case 3:  J=IPC->time.rtc.minutes / 10   ;break;
        case 4:  J=IPC->time.rtc.hours   % 10   ;break;
        case 5:  J=IPC->time.rtc.hours   / 10   ;break;
        case 6:  J=IPC->time.rtc.incr           ;break;
        case 7:  J=IPC->time.rtc.day     % 10   ;break;
        case 8:  J=IPC->time.rtc.day     / 10   ;break;
        case 9:  J=IPC->time.rtc.month   % 10   ;break;
        case 10: J=IPC->time.rtc.month   / 10   ;break;
        case 11: J=IPC->time.rtc.year    % 10   ;break;
        case 12: J=IPC->time.rtc.year    / 10   ;break;
        default: J=0x0F;break;
    }                   
	return J;
}

void ReadKeyBind( char * fn, KEYBIND * kb )
{
}

void vid_close()
{
}

/** InitMachine() ********************************************/
/** Allocate resources needed by the machine-dependent code.**/
/************************************ TO BE WRITTEN BY USER **/
int InitMachine(void)
{
//	int I;
	int J;

	/* sound init */
//	InitSound(UseSound,0);

	/* keybord init */ 
	memset((char*)WinKeyMap,0xFF,16);
	memset((char*)hkey,0xFF,16);

	JoyKeyMap[0] = 0;
	JoyKeyMap[1] = 0;

	MouseMap[0] = 0xFF;
	MouseMap[1] = 0xFF;

	/* Reset the palette */
	for(J=0;J<16;J++) XPal[J]=0;
	XPal0=0;

	/* Set SCREEN8 colors */
	for(J=0;J<256;J++ ){
		BPal[J] = RGB16(1, J&0x1C, (J&0xE0)>>3, (J&0x03)<<3 );
//		BPal[J] = ((J&0x1c)<<11)+(J&0xc0)*8+(J&0x03)*8;  
	}

	XBuf  = (char*) BG_GFX;
	XBuf2 = (char*) BG_GFX_SUB;

	createTouchMap();

	return 1;
}

/** TrashMachine() *******************************************/
/** Deallocate all resources taken by InitMachine().        **/
/************************************ TO BE WRITTEN BY USER **/
void TrashMachine(void)
{
  /* video close */
  vid_close();

  /* sound close */
  TrashSound();  

}


#define LINECOL 0xFFFF
#define OFFCOL  0xF39C
#define ONCOL   0xA108
#define FONTCOL 0x8000

#define KB_X	0
#define KB_Y	32
#define KB_CHIP 8

int checkKey( int16 x, int16 y )
{
	x = (int) x / KB_CHIP;
	y = (int) y / KB_CHIP;
	return touchmap[ y * 32 + x ]; 
}

// extern byte RdZ80(register word Addr);
#define LOCK_KANA 	(ExitNow==0?RdZ80(0xFCAC):0)
#define LOCK_CAPS 	(ExitNow==0?RdZ80(0xFCAB):0)
#define LOCK_SHIFT ( !(hkey[6]&1) )
#define LOCK_CTRL  ( !(hkey[6]&2) )
#define LOCK_GRAPH ( !(hkey[6]&4) )

void drawKey( int k, u16 col )
{
//	LOG( "drawKey" );
	if( k == 255 ) return;
	int x = Keys[k].x * KB_CHIP;
	int y = Keys[k].y * KB_CHIP;
	int w = Keys[k].width  * KB_CHIP;
	int h = Keys[k].height * KB_CHIP;
	
//	LOG( "fill" );
	fill( BG_GFX_SUB,x,y,w,h,col );
//	LOG( "box" );
	box ( BG_GFX_SUB,x,y,w,h,RGB16(1,21,21,21) );
//	LOG( "drawKey 2" );

	int num;
	if     ( LOCK_CTRL  ){ num = 9; }
	else if( LOCK_GRAPH ){ num = 8; }
	else if( LOCK_KANA  ){
		if( LOCK_CAPS ){
			num = LOCK_SHIFT?7:6;
		} else {
			num = LOCK_SHIFT?5:4;
		}
	}else
	if( LOCK_CAPS ){
		num = LOCK_SHIFT?3:2;
	} else {
		num = LOCK_SHIFT?1:0;
	}
//	LOG( "%d", num );
	if( Keys[k].text[num] ){
		char * buf = Keys[k].text[num];
		if( Keys[k].fnttype == 1 ){
//			LOG( "drawText" );
			drawText   ( BG_GFX_SUB, x + Keys[k].x_mgn, y + Keys[k].y_mgn, (u8*)buf, RGB16(1,0,0,0), 0);
		}else{
//			LOG( "drawTextMSX" );
			drawTextMSX( BG_GFX_SUB, x + Keys[k].x_mgn, y + Keys[k].y_mgn, (u8*)buf, RGB16(1,0,0,0), 0);
		}
	}
//	LOG( "drawKey end" );
}

void drawAllKeyboard(void)
{
	int i = 0;
	while( Keys[i].mask ){
		drawKey( i, RGB16(1,31,31,31) );
		i++;
	}
}

void Keyboard(void)
{
//	int tx = 0,ty = 0;
	static int pen=false;
	static int ok = 255;
//	u8 buf[16];
	int i;
	int chgflg = false;
	uint32 k;
//	LOG( "Keyboard" );
//    memset((char*)WinKeyMap, 0xFF, 16 );
//	dispTouch();
//	printText( "cnt  ", 0, 10, IPC2->cnt   );

/*
    uint16 specialKeysPressed = ~IPC->buttons;
	if(specialKeysPressed & IPC_PEN_DOWN ){
*/
	scanKeys();
	k = keysDown();
	if( k|0x0FFF ){
		for(i=0;i<12;i++ ){
			if( k&BIT(i) ) {
				switch( Joys[i].type ){
				  case 0: SetDownKey(Joys[i]);chgflg=true;break;
				  case 1: SetDownJoy(Joys[i]); break;
				}
			}
		}
	}
	if( k&KEY_TOUCH ){
		touchPosition tp = touchReadXY();
		k = checkKey( tp.px, tp.py );
		if( k != ok ){
			pen = true;
			if( ok != k ){
				drawKey( ok, RGB16(1,31,31,31) );
				drawKey(  k, RGB16(1,28,19,19) );
				SetUpKey(Keys[ok]);
				SetDownKey(Keys[k]);
			}
			chgflg = true;
			ok = k;
		}
	}
	k = keysUp();
	if( k|0x0FFF ){
		for(i=0;i<12;i++ ){
			if( k&BIT(i) ) {
				switch( Joys[i].type ){
				  case 0: SetUpKey(Joys[i]);chgflg=true;break;
				  case 1: SetUpJoy(Joys[i]); break;
				  case 2: 
					switch( Joys[i].code ){
					  case 1: lua_MainMenu(2);break;
					}
					break;
				}
			}
		}
	}
	if( k&KEY_TOUCH ){
		drawKey( ok, RGB16(1,31,31,31) );
		SetUpKey(Keys[ok]);
		if( Keys[ok].Hold&1 ){
			hkey[Keys[ok].code] ^= Keys[ok].mask;
		}
		if( Keys[ok].Hold ){
			drawAllKeyboard();
		}
		chgflg = true;
		ok = 255;
		pen = false;
	}

	if( chgflg ){
	    memcpy((char*)KeyMap, (char*)WinKeyMap, 16 );
		for(i=0;i<16;i++ ) KeyMap[i] &= hkey[i];
	}
}

/** Joystick() ***********************************************/
/** Query position of a joystick connected to port N.       **/
/** Returns 0.0.F2.F1.R.L.D.U.                              **/
/************************************ TO BE WRITTEN BY USER **/
byte Joystick(byte N)
{
	return JoyKeyMap[N];
}

/** Mouse() **************************************************/
/** Query coordinates of a mouse connected to port N.       **/
/** Returns F2.F1.Y.Y.Y.Y.Y.Y.Y.Y.X.X.X.X.X.X.X.X.          **/
/************************************ TO BE WRITTEN BY USER **/
int Mouse(byte N)
{
	return MouseMap[N];
}

/** SetColor() ***********************************************/
/** Set color N (0..15) to (R,G,B).                         **/
/************************************ TO BE WRITTEN BY USER **/
void SetColor(byte N,byte R,byte G,byte B)
{
  unsigned int J;
  if(UseStatic) J=BPal[((7*R/255)<<2)|((7*G/255)<<5)|(3*B/255)];
  else J=( ((int)(B/8)<<10)|((int)(G/8)<<5)|(int)(R/8)|BIT(15) );

  if(N) XPal[N]=J; else XPal0=J;
}

/** RefreshScreen() ******************************************/
/** Refresh screen. This function is called in the end of   **/
/** refresh cycle to show the entire screen.                **/
/************************************ TO BE WRITTEN BY USER **/
void RefreshScreen( void )
{

//	dPrint( "RefreshScreen\n");
//    BitBlt( hDC, View_x, View_y, sw, sh, hbDC,0,0,SRCCOPY ); 
//	swiWaitForVBlank();

}

/** ChangeCas() **********************************************/
/************************************ TO BE WRITTEN BY USER **/
int ChangeCas( char * fname )
{
    if( CasStream ){
        fclose( CasStream );
    }
    CasStream= fopen(fname,"a+");
    if(CasStream==NULL){
		LOG("Can't Open Cassette %s.\n",CasName);
		return 0;
    }else{
		LOG("Cassette Select %s.\n",CasName);
	    fseek(CasStream,0,SEEK_SET);
    }
	return 1;
}

/** CasTop() *************************************************/
/*************************************************************/
void CasTop( void )
{
  if(CasStream)
  {
    fseek(CasStream,0,SEEK_SET);
  }
}

/** CasEnd() *************************************************/
/*************************************************************/
void CasEnd( void )
{
  if(CasStream)
  {
    fseek(CasStream,0,SEEK_END);
  }
}

/** CasPrev() ************************************************/
/*************************************************************/
void CasPrev( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos= ftell(CasStream);
    if(Pos&7)
      if(fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(fread(Buf,1,8,CasStream)==8){
      fseek(CasStream,-8,SEEK_CUR);
      if(!memcmp(Buf,TapeHeader,8)) return;
      if(fseek(CasStream,-8,SEEK_CUR)) return;
    }
  }
}

/** CasNext() ************************************************/
/*************************************************************/
void CasNext( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos=ftell(CasStream);
    if(Pos&7)
      if(fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(fread(Buf,1,8,CasStream)==8){
      if(!memcmp(Buf,TapeHeader,8))
      {
        return;
      }
    }
  }

}

void createTouchMap()
{
	int i,j,k;
	for( i=0;i<32*24;i++ ) touchmap[i]=255;

	for( i=0;i<128;i++ ){
		for(j=0;j<Keys[i].height;j++ ){
			for(k=0;k<Keys[i].width;k++){
				touchmap[(Keys[i].y+j) * 32 + (Keys[i].x + k) ] = i;
			}
		}
	}
}

u8 touchmap[32*24];

JOYBIND Joys[16] =
{
	{0,8,0x01},		// Key_A = Space
	{0,4,0x08},		// Key_B = N
	{0,6,0x20},		// Select= F1
	{2,1,0x00},		// Start = MainMenu
	{0,8,0x80},		// Right
	{0,8,0x10},		// Left
	{0,8,0x20},		// UP
	{0,8,0x40},		// Down
	{0,0,0x00},		// KEY_R = none
	{0,0,0x00},		// KEY_L = none
	{0,7,0x80},		// KEY_X = return
	{0,0,0x00}		// KEY_Y = none

};

KEYBIND Keys[128] =
{
//             X  Y W H FxFy                        
  {0,6,0x20,0, 1, 0,3,2,1, 4,0,{"F01" ,"F06" ,"F01" ,"F06" ,"F01" ,"F06" ,"F01" ,"F06" ,"F01" ,"F01" } },  // F1
  {0,6,0x40,0, 4, 0,3,2,1, 4,0,{"F02" ,"F07" ,"F02" ,"F07" ,"F02" ,"F07" ,"F02" ,"F07" ,"F02" ,"F02" } },  // F2
  {0,6,0x80,0, 7, 0,3,2,1, 4,0,{"F03" ,"F08" ,"F03" ,"F08" ,"F03" ,"F08" ,"F03" ,"F08" ,"F03" ,"F03" } },  // F3
  {0,7,0x01,0,10, 0,3,2,1, 4,0,{"F04" ,"F09" ,"F04" ,"F09" ,"F04" ,"F09" ,"F04" ,"F09" ,"F04" ,"F04" } },  // F4
  {0,7,0x02,0,13, 0,3,2,1, 4,0,{"F05" ,"F10" ,"F05" ,"F10" ,"F05" ,"F10" ,"F05" ,"F10" ,"F05" ,"F05" } },  // F5

  {0,7,0x10,0,18, 0,3,2,1, 4,1,{"STOP","STOP"  ,"STOP" ,"STOP" ,"STOP" ,"STOP","STOP","STOP","STOP","^STOP"} },  // STOP
  {0,8,0x02,0,21, 0,3,2,1, 4,1,{"HOME" ,"CLS"  ,"HOME" ,"CLS"  ,"HOME" ,"CLS" ,"HOME","CLS" ,"HOME","HOME" } },  // HOME/CLS  
  {0,7,0x40,0,25, 0,2,2,1, 4,1,{"SEL" ,"SEL"   ,"SEL"  ,"SEL"  ,"SEL"  ,"SEL" ,"SEL" ,"SEL" ,"SEL" ,"SEL"  } },  // SELECT    
  {0,8,0x04,0,27, 0,2,2,1, 4,1,{"INS"  ,"INS"  ,"INS"  ,"INS"  ,"INS"  ,"INS" ,"INS" ,"INS" ,"INS" ,"INS"  } },  // INSERT    
  {0,8,0x08,0,29, 0,2,2,1, 4,1,{"DEL"  ,"DEL"  ,"DEL"  ,"DEL"  ,"DEL"  ,"DEL" ,"DEL" ,"DEL" ,"DEL" ,"DEL"  } },  // DELETE    

  {0,7,0x04,0, 1, 2,2,2,1, 5,1,{"ESC" ,"ESC" ,"ESC" ,"ESC" ,"ESC" ,"ESC" ,"ESC" ,"ESC" ,"ESC" ,"ESC" } },  // ESC
  {0,0,0x02,0, 3, 2,2,2,6, 5,0,{"1"   ,"!"   ,"1"   ,"!"   ,"\x91","\x87","\xB1","\xA7","\x07","1"   } },  // '1'
  {0,0,0x04,0, 5, 2,2,2,6, 5,0,{"2"   ,"\""  ,"2"   ,"\""  ,"\x92","\x88","\xB2","\xA8","\x01","2"   } },  // '2'
  {0,0,0x08,0, 7, 2,2,2,6, 5,0,{"3"   ,"#"   ,"3"   ,"#"   ,"\x93","\x89","\xB3","\xA9","\x02","3"   } },  // '3'
  {0,0,0x10,0, 9, 2,2,2,6, 5,0,{"4"   ,"$"   ,"4"   ,"$"   ,"\x94","\x8A","\xB4","\xAA","\x03","4"   } },  // '4'
  {0,0,0x20,0,11, 2,2,2,6, 5,0,{"5"   ,"%"   ,"5"   ,"%"   ,"\x95","\x8B","\xB5","\xAB","\x04","5"   } },  // '5'
  {0,0,0x40,0,13, 2,2,2,6, 5,0,{"6"   ,"&"   ,"6"   ,"&"   ,"\xE5","\xE5","\xC5","\xC5","\x05","6"   } },  // '6'
  {0,0,0x80,0,15, 2,2,2,6, 5,0,{"7"   ,"'"   ,"7"   ,"'"   ,"\xE6","\xE6","\xC6","\xC6","\x06","7"   } },  // '7'
  {0,1,0x01,0,17, 2,2,2,6, 5,0,{"8"   ,"("   ,"8"   ,"("   ,"\xE7","\xE7","\xC7","\xC7","\x0D","8"   } },  // '8'
  {0,1,0x02,0,19, 2,2,2,6, 5,0,{"9"   ,")"   ,"9"   ,")"   ,"\xE8","\xE8","\xC8","\xC8","\x0E","9"   } },  // '9'
  {0,0,0x01,0,21, 2,2,2,6, 5,0,{"0"   ,""    ,"0"   ,""    ,"\xE9","\xE9","\xC9","\xC9","\x0F","0"   } },  // '0'
  {0,1,0x04,0,23, 2,2,2,6, 5,0,{"-"   ,"="   ,"-"   ,"="   ,"\xF7","\xF7","\xD7","\xD7","\x17","-"   } },  // -
  {0,1,0x08,0,25, 2,2,2,6, 5,0,{"^"   ,"~"   ,"^"   ,"~"   ,"\xF8","\xF8","\xD8","\xD8",""    ,"U"   } },  // ^
  {0,1,0x10,0,27, 2,2,2,6, 5,0,{"\\"  ,"|"   ,"\\"  ,"|"   ,"\xF8","\xF8","\xD8","\xD8","\x09","L"   } },  // "\"
  {0,7,0x20,0,29, 2,2,2,3, 5,1,{"BS"  ,"BS"  ,"BS"  ,"BS"  ,"BS"  ,"BS"  ,"BS"  ,"BS"  ,"BS"  ,"BS"  } },  // BS
//25                       
  {0,7,0x08,0, 1, 4,3,2,1, 5,1,{"TAB" ,"TAB" ,"TAB" ,"TAB" ,"TAB" ,"TAB" ,"TAB" ,"TAB" ,"TAB" ,"TAB" } },  // TAB
  {0,4,0x40,0, 4, 4,2,2,6, 5,0,{"q"   ,"Q"   ,"Q"   ,"q"   ,"\x96","\x96","\xB6","\xB6",""    ,""    } },  // 'Q'
  {0,5,0x10,0, 6, 4,2,2,6, 5,0,{"w"   ,"W"   ,"W"   ,"w"   ,"\x97","\x97","\xB7","\xB7",""    ,""    } },  // 'W'
  {0,3,0x04,0, 8, 4,2,2,6, 5,0,{"e"   ,"E"   ,"E"   ,"e"   ,"\x98","\x98","\xB8","\xB8","\x18","^E"  } },  // 'E'
  {0,4,0x80,0,10, 4,2,2,6, 5,0,{"r"   ,"R"   ,"R"   ,"r"   ,"\x99","\x99","\xB9","\xB9","\x12","^R"  } },  // 'R'
  {0,5,0x02,0,12, 4,2,2,6, 5,0,{"t"   ,"T"   ,"T"   ,"t"   ,"\x9A","\x9A","\xBA","\xBA","\x19",""    } },  // 'T'
  {0,5,0x40,0,14, 4,2,2,6, 5,0,{"y"   ,"Y"   ,"Y"   ,"y"   ,"\xEA","\xEA","\xDA","\xDA","\x08",""    } },  // 'Y'
  {0,5,0x04,0,16, 4,2,2,6, 5,0,{"u"   ,"U"   ,"U"   ,"u"   ,"\xEB","\xEB","\xDB","\xDB",""    ,""    } },  // 'U'
  {0,3,0x40,0,18, 4,2,2,6, 5,0,{"i"   ,"I"   ,"I"   ,"i"   ,"\xEC","\xEC","\xDC","\xDC","\x16","^I"  } },  // 'I'
  {0,4,0x10,0,20, 4,2,2,6, 5,0,{"o"   ,"O"   ,"O"   ,"o"   ,"\xED","\xED","\xDD","\xDD",""    ,""    } },  // 'O'
  {0,4,0x20,0,22, 4,2,2,6, 5,0,{"p"   ,"P"   ,"P"   ,"p"   ,"\xEE","\xEE","\xDE","\xDE","\x10",""    } },  // 'P'
  {0,1,0x20,0,24, 4,2,2,6, 5,0,{"@"   ,"`"   ,"@"   ,"`"   ,"\xFA","\xFA","\xDA","\xDA",""    ,""    } },  // @
  {0,1,0x40,0,26, 4,2,2,6, 5,0,{"["   ,"{"   ,"["   ,"{"   ,"\xFB","\xA2","\xDB","\xA2","\x84",""    } },  // [
  {0,7,0x80,0,28, 4,3,4,6,10,1,{"RET" ,"RET" ,"RET" ,"RET" ,"RET","RET"  ,"RET" ,"RET" ,"RET" ,"RET" } },  // RETURN
//39
  {0,6,0x02,1, 1, 6,3,2,1, 5,1,{"CTRL","CTRL","CTRL","CTRL","CTRL","CTRL","CTRL","CTRL","CTRL","CTRL"} },  // CTRL 
  {0,2,0x40,0, 4, 6,2,2,6, 5,0,{"a"   ,"A"   ,"A"   ,"a"   ,"\x9B","\x9B","\xBB","\xAB",""    ,""    } },  // 'A'
  {0,5,0x01,0, 6, 6,2,2,6, 5,0,{"s"   ,"S"   ,"S"   ,"s"   ,"\x9C","\x9C","\xBC","\xAC","\x0C",""    } },  // 'S'
  {0,3,0x02,0, 8, 6,2,2,6, 5,0,{"d"   ,"D"   ,"D"   ,"d"   ,"\x9D","\x9D","\xBD","\xAD","\x14",""    } },  // 'D'
  {0,3,0x08,0,10, 6,2,2,6, 5,0,{"f"   ,"F"   ,"F"   ,"f"   ,"\x9E","\x9E","\xBE","\xAE","\x15","^F"  } },  // 'F'
  {0,3,0x10,0,12, 6,2,2,6, 5,0,{"g"   ,"G"   ,"G"   ,"g"   ,"\x9F","\x9F","\xBF","\xAF","\x13","^G"  } },  // 'G'
  {0,3,0x20,0,14, 6,2,2,6, 5,0,{"h"   ,"H"   ,"H"   ,"h"   ,"\xEF","\xEF","\xCF","\xAF","\x0A","^H"  } },  // 'H'
  {0,3,0x80,0,16, 6,2,2,6, 5,0,{"j"   ,"J"   ,"J"   ,"j"   ,"\xF0","\xF0","\xD0","\xD0",""    ,"^J"  } },  // 'J'
  {0,4,0x01,0,18, 6,2,2,6, 5,0,{"k"   ,"K"   ,"K"   ,"k"   ,"\xF1","\xF1","\xD1","\xD1",""    ,"^K"  } },  // 'K'
  {0,4,0x02,0,20, 6,2,2,6, 5,0,{"l"   ,"L"   ,"L"   ,"l"   ,"\xF2","\xF2","\xD2","\xD2","\x1E","^L"  } },  // 'L'
  {0,1,0x80,0,22, 6,2,2,6, 5,0,{";"   ,"+"   ,";"   ,"+"   ,"\xF3","\xF3","\xD3","\xD3","\x82",""    } },  // +
  {0,2,0x01,0,24, 6,2,2,6, 5,0,{":"   ,"*"   ,":"   ,"*"   ,"\xDE","\xB0","\xDE","\xB0","\x81",""    } },  // :
  {0,2,0x02,0,26, 6,2,2,6, 5,0,{"]"   ,"}"   ,"]"   ,"}"   ,"\xDF","\xA3","\xDF","\xA3","\x85",""    } },  // ]
//50,2                                      
  {0,6,0x01,1, 1, 8,4,2,1, 5,1,{"SHIFT","SHIFT","SHIFT","SHIFT","SHIFT","SHIFT","SHIFT","SHIFT","SHIFT","SHIFT"} },  // SHIFT  
  {0,5,0x80,0, 5, 8,2,2,6, 5,0,{"z"   ,"Z"   ,"Z"   ,"z"   ,"\xE0","\xE0","\xC0","\xE0",""    ,""    } },  // 'Z'
  {0,5,0x20,0, 7, 8,2,2,6, 5,0,{"x"   ,"X"   ,"X"   ,"x"   ,"\xE1","\xE1","\xC1","\xE1","\x1C","^X"  } },  // 'X'
  {0,3,0x01,0, 9, 8,2,2,6, 5,0,{"c"   ,"C"   ,"C"   ,"c"   ,"\xE2","\x8F","\xC2","\x8F","\x1A","^C"  } },  // 'C'
  {0,5,0x08,0,11, 8,2,2,6, 5,0,{"v"   ,"V"   ,"V"   ,"v"   ,"\xE3","\xE3","\xC3","\xE3","\x11","^V"  } },  // 'V'
  {0,2,0x80,0,13, 8,2,2,6, 5,0,{"b"   ,"B"   ,"B"   ,"b"   ,"\xE4","\xE4","\xC4","\xE4","\x1B","^B"  } },  // 'B'
  {0,4,0x08,0,15, 8,2,2,6, 5,0,{"n"   ,"N"   ,"N"   ,"n"   ,"\xF4","\x8C","\xD4","\x8C",""    ,"^N"  } },  // 'N'
  {0,4,0x04,0,17, 8,2,2,6, 5,0,{"m"   ,"M"   ,"M"   ,"m"   ,"\xF5","\x8D","\xD5","\x8D","\x0B","^M"  } },  // 'M'
  {0,2,0x04,0,19, 8,2,2,6, 5,0,{","   ,"<"   ,","   ,"<"   ,"\xF6","\x8E","\xD6","\x8E","\x1F",""    } },  // ,
  {0,2,0x08,0,21, 8,2,2,6, 5,0,{"."   ,">"   ,"."   ,">"   ,"\xFC","\xA4","\xFC","\xA4","\x1D",""    } },  // .
  {0,2,0x10,0,23, 8,2,2,6, 5,0,{"/"   ,"?"   ,"/"   ,"?"   ,"\x86","\xA1","\x86","\xA1","\x80",""    } },  // /
  {0,2,0x20,0,25, 8,2,2,6, 5,0,{"_"   ,"_"   ,"_"   ,"_"   ,"\xFD","\x85","\xFD","\x85","\x83",""    } },  // _
//60,5
  {0,6,0x08,2, 1,10, 3,2,1,5,1,{"CAPS" ,"CAPS" ,"CAPS" ,"CAPS" ,"CAPS" ,"CAPS" ,"CAPS" ,"CAPS" ,"CAPS" ,"CAPS" } },  // CAPS
  {0,6,0x04,1, 4,10, 3,2,1,5,1,{"GRPH" ,"GRPH" ,"GRPH" ,"GRPH" ,"GRPH" ,"GRPH" ,"GRPH" ,"GRPH" ,"GRPH" ,"GRPH" } },  // GRAPH
  {0,6,0x10,2, 7,10, 3,2,6,5,0,{"\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5","\x96\xE5"} },  // 
  {0,8,0x01,0,10,10,11,2,6,5,0,{"SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE","SPACE"} },  // SPACE

  {0, 8,0x30,0,25,12, 2,2,6,5,1,{""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     } },  // UP LEFT
  {0, 8,0x20,0,27,12, 2,2,6,5,1,{"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" } },  // UP
  {0, 8,0xA0,0,29,12, 2,2,6,5,1,{""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     } },  // UP RIGHT
  {0, 8,0x10,0,25,14, 2,2,6,5,1,{"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" } },  // LEFT
  {0, 8,0x80,0,29,14, 2,2,6,5,1,{"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" } },  // RIGHT
  {0, 8,0x50,0,25,16, 2,2,6,5,1,{""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     } },  // DOWN LEFT
  {0, 8,0x40,0,27,16, 2,2,6,5,1,{"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" } },  // DOWN
  {0, 8,0xC0,0,29,16, 2,2,6,5,1,{""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     ,""     } },  // DOWN RIGHT

  {0,10,0x04,0,15,12, 2,2,6,5,0,{"7" ,"7" ,"7" ,"7" ,"7" ,"7" ,"7" ,"7" ,"7" ,"7" } }, //83 NUM 7
  {0,10,0x08,0,17,12, 2,2,6,5,0,{"8" ,"8" ,"8" ,"8" ,"8" ,"8" ,"8" ,"8" ,"8" ,"8" } }, //84 NUM 8
  {0,10,0x10,0,19,12, 2,2,6,5,0,{"9" ,"9" ,"9" ,"9" ,"9" ,"9" ,"9" ,"9" ,"9" ,"9" } }, //85 NUM 9
  {0, 9,0x04,0,21,12, 2,2,6,5,0,{"/" ,"/" ,"/" ,"/" ,"/" ,"/" ,"/" ,"/" ,"/" ,"/" } }, //75 NUM /
  {0, 9,0x80,0,15,14, 2,2,6,5,0,{"4" ,"4" ,"4" ,"4" ,"4" ,"4" ,"4" ,"4" ,"4" ,"4" } }, //80 NUM 4
  {0,10,0x01,0,17,14, 2,2,6,5,0,{"5" ,"5" ,"5" ,"5" ,"5" ,"5" ,"5" ,"5" ,"5" ,"5" } }, //81 NUM 5
  {0,10,0x02,0,19,14, 2,2,6,5,0,{"6" ,"6" ,"6" ,"6" ,"6" ,"6" ,"6" ,"6" ,"6" ,"6" } }, //82 NUM 6
  {0, 9,0x01,0,21,14, 2,2,6,5,0,{"*" ,"*" ,"*" ,"*" ,"*" ,"*" ,"*" ,"*" ,"*" ,"*" } }, //73 NUM *
  {0, 9,0x10,0,15,16, 2,2,6,5,0,{"1" ,"1" ,"1" ,"1" ,"1" ,"1" ,"1" ,"1" ,"1" ,"1" } }, //77 NUM 1
  {0, 9,0x20,0,17,16, 2,2,6,5,0,{"2" ,"2" ,"2" ,"2" ,"2" ,"2" ,"2" ,"2" ,"2" ,"2" } }, //78 NUM 2
  {0, 9,0x40,0,19,16, 2,2,6,5,0,{"3" ,"3" ,"3" ,"3" ,"3" ,"3" ,"3" ,"3" ,"3" ,"3" } }, //79 NUM 3
  {0,10,0x20,0,21,16, 2,2,6,5,0,{"-" ,"-" ,"-" ,"-" ,"-" ,"-" ,"-" ,"-" ,"-" ,"-" } }, //86 NUM -
  {0, 9,0x08,0,15,18, 2,2,6,5,0,{"0" ,"0" ,"0" ,"0" ,"0" ,"0" ,"0" ,"0" ,"0" ,"0" } }, //76 NUM 0
  {0,10,0x80,0,17,18, 2,2,6,5,0,{"." ,"." ,"." ,"." ,"." ,"." ,"." ,"." ,"." ,"." } }, //88 NUM .
  {0,10,0x40,0,19,18, 2,2,6,5,0,{"," ,"," ,"," ,"," ,"," ,"," ,"," ,"," ,"," ,"," } }, //87 NUM ,
  {0, 9,0x02,0,21,18, 2,2,6,5,0,{"+" ,"+" ,"+" ,"+" ,"+" ,"+" ,"+" ,"+" ,"+" ,"+" } }, //74 NUM +
  {0, 0,0x00,0, 0, 0, 0,0,0,0,0,{"" ,"" ,"" ,"" ,"" ,"" ,"" ,"" ,"" ,"" } }, // END
};

#if 0
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //89 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //90 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //91 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //92 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //93 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //94 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //95 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //96 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //97 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //98 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //99 reserved
	{ 0,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //100 reserved
	/* joy */
	{ 1,0x00,0x01,1,{"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" } }, //101 joy1 UP
	{ 1,0x00,0x02,1,{"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" } }, //102 joy1 DOWN
	{ 1,0x00,0x04,1,{"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" } }, //103 joy1 LEFT
	{ 1,0x00,0x08,1,{"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" } }, //104 joy1 RIGHT
	{ 1,0x00,0x05,1,{"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" } }, //105 joy1 UP LEFT
	{ 1,0x00,0x09,1,{"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" } }, //106 joy1 UP RIGHT
	{ 1,0x00,0x06,1,{"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" } }, //107 joy1 DOWN LEFT
	{ 1,0x00,0x0A,1,{"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" } }, //108 joy1 DOWN RIGHT
	{ 1,0x00,0x10,1,{"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   } }, //109 joy1 BTN1
	{ 1,0x00,0x20,1,{"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   } }, //110 joy1 BTN2
	{ 1,0x01,0x01,1,{"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" } }, //111 joy2 UP
	{ 1,0x01,0x02,1,{"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" } }, //112 joy2 DOWN
	{ 1,0x01,0x04,1,{"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" } }, //113 joy2 LEFT
	{ 1,0x01,0x08,1,{"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" } }, //114 joy2 RIGHT
	{ 1,0x00,0x05,1,{"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" ,"\x7F" } }, //115 joy1 UP LEFT
	{ 1,0x00,0x09,1,{"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" ,"\x80" } }, //116 joy1 UP RIGHT
	{ 1,0x00,0x06,1,{"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" ,"\x82" } }, //117 joy1 DOWN LEFT
	{ 1,0x00,0x0A,1,{"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" ,"\x81" } }, //118 joy1 DOWN RIGHT
	{ 1,0x01,0x10,1,{"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   ,"T1"   } }, //119 joy2 BTN1
	{ 1,0x01,0x20,1,{"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   ,"T2"   } }, //120 joy2 BTN2
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //121 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //122 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //123 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //124 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //125 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //126 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //127 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //128 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //129 reserved
	{ 1,0x00,0x00,0,{0,0,0,0,0,0,0,0,0,0} }, //130 reserved
	/* main menu */
	{ 2,MAINMENU, 0,00 }
};
#endif
