#include <NDS.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "DSGraph.h"
#include "font5x6.h"
#include "icon.h"

char * fontbin = NULL;

extern byte *MemMap[4][4][8];   /* Memory maps [PPage][SPage][Addr] */

extern void LOG( char * str , ... );

void drawAllKeyboard(void);

void memcpy16( u16 * dst,u16 * src, int cnt ){
	int c;
	for( c=0;c<cnt;c++ ) *dst++ = *src++;
}

void line( uint16 * gfx , int x, int y, int w, int h, uint16 col )
{
	int E;
	int dx,dy,sx,sy,i;

	sx = ( w>0 ) ? 1 : -1;
	dx = ( w>0 ) ? w-1 : (-w)-1 ;
	sy = ( h>0 ) ? 1 : -1;
	dy = ( h>0 ) ? h-1 : (-h)-1 ;

	if( dx >= dy ) {
		E = -dx;
		for( i = 0; i <= dx; i++ ) {
			pset(gfx, x, y, col );
			x += sx;
			E += 2 * dy;
			if( E >= 0 ) {
				y += sy;
				E -= 2 * dx;
			}
		}
	} else {
		E = -dy;
		for( i = 0; i <= dy; i++ ) {
			pset(gfx, x, y, col );
			y += sy;
			E += 2 * dx;
			if( E >= 0 ) {
				x += sx;
				E -= 2 * dy;
			}
		}
	}
}

void box( uint16 * gfx, int x,int y,int w,int h,uint16 col )
{
	line( gfx,x    ,y,w,0,col );
	line( gfx,x,y+h-1,w,0,col );
	line( gfx,x,y    ,0,h,col );
	line( gfx,x+w-1,y,0,h,col );
}

void fill( uint16 * gfx, int x,int y,int w,int h,uint16 col )
{
	int i;
	for( i=y;i<y+h;i++ ){
		line( gfx,x,i,w,0,col );
	}
}

void cls(int g){
	if(g&1)fill( BG_GFX,     0,0,256,256, 0x8000 );
	if(g&2)fill( BG_GFX_SUB, 0,0,256,256, 0x8000 );
}

void drawWindow( uint16 * gfx, int x, int y , int w, int h )
{
	line( gfx,x    ,y    ,w,0 ,RGB16(1,26,26,26) );
	line( gfx,x    ,y+h-1,w,0 ,RGB16(1, 8, 8, 8) );
	line( gfx,x    ,y    ,0,h ,RGB16(1,26,26,26) );
	line( gfx,x+w-1,y    ,0,h ,RGB16(1, 8, 8, 8) );

	line( gfx,x+1  ,y+1  ,w-2,0  ,RGB16(1,31,31,31) );
	line( gfx,x+1  ,y+h-2,w-2,0  ,RGB16(1,16,16,16) );
	line( gfx,x+1  ,y+1  ,0  ,h-2,RGB16(1,31,31,31) );
	line( gfx,x+w-2,y+1  ,0  ,h-2,RGB16(1,16,16,16) );

	fill( gfx, x+2,y+2,w-4,h-4, RGB16(1,26,26,26) );
}

void drawButton( uint16 * gfx, int x, int y , int w, int h, u8 * buf )
{
	box( gfx, x, y, w, h, RGB16(1,0,0,0) );
	drawWindow(gfx, x+1,y+1, w-2,h-2 );
	int len = strlen( (char*)buf );
	drawText( gfx, x + w/2 - len*5/2, y + h/2 - 3, buf, RGB16(1,0,0,0) , 0 );
}

void drawFontMSX( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol )
{
	int i;
	uint16 o;
	u8 * f=(u8*)MemMap[0][0][0] + 7103 + (int)chr*8;
	uint16 * g = gfx + fy * 256 + fx;
	for( i=0;i<8;i++ ){
		o = g[0];g[0]=*f&0x80?col:(bcol?bcol:o);
		o = g[1];g[1]=*f&0x40?col:(bcol?bcol:o);
		o = g[2];g[2]=*f&0x20?col:(bcol?bcol:o);
		o = g[3];g[3]=*f&0x10?col:(bcol?bcol:o);
		o = g[4];g[4]=*f&0x08?col:(bcol?bcol:o);
		o = g[5];g[5]=*f&0x04?col:(bcol?bcol:o);
		o = g[6];g[6]=*f&0x02?col:(bcol?bcol:o);
		o = g[7];g[7]=*f&0x01?col:(bcol?bcol:o);
		g+=256;
		f++;
	}
}
void drawTextMSX( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol )
{
	int x = fx;
	int i=0;
	while( buf[i] )
	{
		drawFontMSX( gfx, x, fy, buf[i], col, bcol );
		x +=8;
		i++;
	}
}

void drawFont( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol )
{
	int i;
	if( (chr>=0x20) && (chr<=0x82) ){
		u8 * f=(u8*)font5x6 +(int)(chr-0x20)*6;
		uint16 o;
		uint16 * g = gfx + fy * 256 + fx;
		for( i=0;i<6;i++ ){
			o = *g; *g = *f&0x80?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x40?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x20?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x10?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x08?col:(bcol?bcol:o);g+=256-4;
			f++;
		}
	}
}

int loadFont(char * fn)
{
	int siz;
	FILE * fp;
	fp = fopen(fn, "rb");
	if( fp != NULL ){
		fseek(fp,0,SEEK_END);
		siz = ftell(fp);
		fseek(fp,0,SEEK_SET);
		LOG( "loadfont siz:%d", siz );
		if( siz == 0 ){
			LOG( "File size zero?" );
			return false;
		}
		if( fontbin != NULL ) free(fontbin);
		fontbin = (char *)malloc( siz );
		if( fread(fontbin, 1, siz, fp ) != siz ){
			LOG( "font load error" );
			fclose( fp );
			free( fontbin );
			fontbin = NULL;
			return false;
		}
		fclose( fp );
	}else{
		LOG( "wrong font filename" );
		return false;
	}
	return true;
}

void drawFont2( uint16 * gfx, u16 fx, u16 fy, u16 chr, u16 col, u16 bcol )
{
	if( fontbin == NULL ) return;
	int i;
	u8 nochr[8] = { 0,0,0,0,0,0,0,0 };
	if( chr<=0x00FF ){
//		LOG( "HAN:%x",chr );
		u8 * f=(u8*)fontbin + (int)chr*8;
		uint16 o;
		uint16 * g = gfx + fy * 256 + fx;
		for( i=0;i<8;i++ ){
			o = *g; *g = *f&0x80?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x40?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x20?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x10?col:(bcol?bcol:o);g+=256-3;
			f++;
		}
	}else{
//		LOG( "ZEN:%x",chr );
		int c1 = (chr>>8);
		if( c1>0xDF) c1 -= 0x40;
		c1 -= 0x81;
		int c2 = chr&0xFF;
		u8 * f=(u8*)fontbin + 2048 + c1*1504;
		if( c2<0x40 || c2==0x7F || c2>0xFC ){ 
			f = nochr;
		}else {
			if( c2>0x7F ) c2--;
			c2 -= 0x40;
			f += c2*8;
		}
		uint16 o;
		uint16 * g = gfx + fy * 256 + fx;
		for( i=0;i<8;i++ ){
			o = *g; *g = *f&0x80?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x40?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x20?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x10?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x08?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x04?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x02?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x01?col:(bcol?bcol:o);g+=256-7;
			f++;
		}
	}
}

int isleadbyte( u8 c )
{
	if((c>0x80 && c<0xa0)|| (c>0xdf && c<0xfd)) return true;
	return false;
}

void drawText2( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol )
{
	int x = fx;
	int i=0;
	int c;
	int n;
	
	while( buf[i] )
	{
		if( isleadbyte( buf[i] ) ) {
			c = (int)buf[i]<<8 | buf[i+1];
			n = 8;
			i+=2;
		}else{
			c = buf[i];
			n = 4;
			i++;
		}
		drawFont2( gfx, x, fy, c, col, bcol );
		x += n;
	}
}

void drawText( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol )
{
	int x = fx;
	int i=0;
	while( buf[i] )
	{
		drawFont( gfx, x, fy, buf[i], col, bcol );
		x +=5;
		i++;
	}
}

void drawDesktop( uint16 * gfx )
{
	int i,j;
	int col1 = RGB16(1,29,29,29);
	int col2 = RGB16(1,25,25,25);
	int col;
	int flg=0;
	for(i=0;i<20*256;i++) *gfx++ = 0;
	for(i=20;i<160;i++){
		col = flg?col1:col2;
		for(j=0;j<256;j++){
			*gfx++ = col;
		}
		flg =(flg+1)&1;
	}
}

void copyGraph( uint16 * dgfx, u16 dx, u16 dy, uint16 * sgfx, u16 sx, u16 sy, u16 width, u16 height )
{
	int i;
	for( i=sy;i<sy+height;i++ ){
		memcpy16( dgfx + 256 * dy + dx, sgfx + 256*i+sx, width );
		dy++;
	}
}

void drawIcon( uint16 * gfx, int x, int y, int num )
{
	int i,j;
	u16 * f=(u16*)icon + 1024 * num;
	gfx += y*256+x;

	for(i=0;i<32;i++){
		for(j=0;j<32;j++) *gfx++ = *f++ | 0x8000 ;
		gfx += (256-32);
	}
}

void drawIcon2( uint16 * gfx, int x, int y, int w, int h, u16 * buf )
{
	int i,j;
	gfx += y*256+x;

	for(i=0;i<h;i++){
		for(j=0;j<w;j++) *gfx++ = *buf++;
		gfx += (256-w);
	}
}

