//////////////////////////////////////////////////////////////////////
// Simple ARM7 stub (sends RTC, TSC, and X/Y data to the ARM 9)
// -- joat
// -- modified by Darkain and others
//////////////////////////////////////////////////////////////////////

#include "ipc2.h"
#include <NDS.h>
#include <string.h>

PSG * psg;
SCC * scc;

#define MSX_CLK 3579545
#define SOUNDBUFSIZ ((u16)(1024))   //367

int samplerate;
s16 * soundbuf_psg[2];
s16 * soundbuf_scc[2];
int SoundPtr    = 0; // f[^ʒu
int SoundBufCnt = 0; // f[^obt@
volatile int SoundProcTiming = 0;
int SoundPause = true;
int SoundInit  = false;
int psgON      = true;
int sccON      = true;

void StopSound();

//////////////////////////////////////////////////////////////////////
void startSound(int sampleRate, const void* data, uint32 bytes, u8 channel, u8 vol,  u8 pan, u8 format) {
  SCHANNEL_TIMER(channel)  = SOUND_FREQ(sampleRate);
  SCHANNEL_SOURCE(channel) = (uint32)data;
  SCHANNEL_LENGTH(channel) = bytes >> 2;
  SCHANNEL_REPEAT_POINT(channel) = 0;
  SCHANNEL_CR(channel)     = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(vol) | SOUND_PAN(pan) | (format==1? SOUND_FORMAT_8BIT:SOUND_FORMAT_16BIT);
}

bool isFreeSoundChannel(int i) {
  if ( (SCHANNEL_CR(i) & SCHANNEL_ENABLE) == 0 ) return true;
  return false;
}

void waitForVBlank()
{
	while(!(REG_DISPSTAT & DISP_IN_VBLANK));
	while((REG_DISPSTAT & DISP_IN_VBLANK));
}

//////////////////////////////////////////////////////////////////////
static void IrqVBlank(void)
{
	static touchPosition tp;
	uint16 but=0, batt=0, aux=0;
	int16 x=0, y=0, px=0, py=0, z1=0, z2=0;
	int t1=0, t2=0;
	uint32 temp=0;
	uint8 ct[sizeof(IPC->time.curtime)];
	u32 i; 
	// Read the X/Y buttons and the /PENIRQ line
	but = REG_KEYXY;
	if (!(but & 0x40)) {
		// Read the touch screen
		tp = touchReadXY();
		x  = tp.x;
		y  = tp.y;
		px = tp.px;
		py = tp.py;
		z1 = tp.z1;
		z2 = tp.z2;
	}

	batt = touchRead(TSC_MEASURE_BATTERY);
//	aux  = touchRead(TSC_MEASURE_AUX);

	// Read the time
	rtcGetTime((uint8 *)ct);
	BCDToInteger((uint8 *)&(ct[1]), 7);

	// Read the temperature
//	temp = touchReadTemperature(&t1, &t2);

	// Update the IPC struct
	IPC->touchX      = tp.x;
	IPC->touchY      = tp.y;
	IPC->touchXpx    = tp.px;
	IPC->touchYpx    = tp.py;
	IPC->touchZ1     = tp.z1;
	IPC->touchZ2     = tp.z2;
	IPC->battery     = batt;
	IPC->aux         = aux;
	IPC->temperature = temp;
	IPC->tdiode1     = t1;
	IPC->tdiode2     = t2;
	IPC->buttons     = but;
	for(i=0; i<sizeof(ct); i++) {
	  IPC->time.curtime[i] = ct[i];
	}
}
//////////////////////////////////////////////////////////////////////

void InitSound(void)
{
	SoundPause = true;
	SoundInit  = false;

	// sound Register
	SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7F);

	psg = (PSG *)&(IPC2->psg);
	scc = (SCC *)&(IPC2->scc);

	// Sound buffer setting
	soundbuf_psg[0] = (s16*)VRAM;
	soundbuf_psg[1] = (s16*)VRAM + SOUNDBUFSIZ    ;
	soundbuf_scc[0] = (s16*)VRAM + SOUNDBUFSIZ * 2;
	soundbuf_scc[1] = (s16*)VRAM + SOUNDBUFSIZ * 3;
}

void ResetSound(void)
{
	StopSound();

//	samplerate = IPC2->sampleRate;
	samplerate = 0x2000;
	if( samplerate < 1 ) samplerate = 0x2000;

	// PSG initialize
	PSG_new(psg, MSX_CLK,samplerate);
	PSG_reset( psg );

	// SCC initialize
	SCC_new(scc, MSX_CLK,samplerate);
	SCC_reset( scc );

	IPC2->soundCommand = 0;
}

static void IrqTimer0(void)
{
	SoundProcTiming++;
}
static void IrqTimer1(void)
{
	SCHANNEL_CR(SoundPtr*2  ) = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(0x7F) | SOUND_PAN(63) | SOUND_FORMAT_16BIT;
	SCHANNEL_CR(SoundPtr*2+1) = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(0x7F) | SOUND_PAN(63) | SOUND_FORMAT_16BIT;

	SoundPtr = SoundPtr==0?1:0;

	SCHANNEL_CR(SoundPtr*2  ) = 0;
	SCHANNEL_CR(SoundPtr*2+1) = 0;

	SoundBufCnt = 0;
}
/*
static int _range( int num, int min, int max ){
	return (num>max)?num=max:(num<min)?num=min:num;
}
*/
static int _range( int num, int min, int max ){
	return num;
}
static void CalcSound( void )
{
	if( SoundProcTiming == 0 ) return;

	if( psgON ){
		s16 * P = soundbuf_psg[SoundPtr] + SoundBufCnt;
		*P = (s16)_range( (int)PSG_calc(psg)*2,-32768, 32767 );
	}
	if( sccON ){
		s16 * S = soundbuf_scc[SoundPtr] + SoundBufCnt;
		*S = (s16)_range( (int)SCC_calc(scc)*2,-32768, 32767 );
	}
	SoundBufCnt++;
	if( SoundBufCnt >= SOUNDBUFSIZ ) {
		IrqTimer1();
		SoundProcTiming = 0;
	}else{
		SoundProcTiming --;
	}
	return;
}

void PlaySound()
{
	int i;

	SoundPause = false;
	SoundProcTiming = 0;
	SoundPtr        = 0;
	SoundBufCnt     = 0;

	psgON = IPC2->psgON;
	sccON = IPC2->sccON;

	// clear sound buffer
	for(i=0;i<SOUNDBUFSIZ*4;i++ ){
		*((s16*)VRAM+i) = 0;
	}

	// Sound REG setting
	for(i=0;i<4;i++){
		SCHANNEL_CR(i)           = 0;
		SCHANNEL_TIMER(i)        = SOUND_FREQ(samplerate);
		SCHANNEL_LENGTH(i)       = SOUNDBUFSIZ*2 >> 2;
		SCHANNEL_REPEAT_POINT(i) = 0;
	}

	SCHANNEL_SOURCE(0) = (uint32)soundbuf_psg[0];
	SCHANNEL_SOURCE(1) = (uint32)soundbuf_scc[0];
	SCHANNEL_SOURCE(2) = (uint32)soundbuf_psg[1];
	SCHANNEL_SOURCE(3) = (uint32)soundbuf_scc[1];

	// Timer setting
	TIMER0_DATA = TIMER_FREQ(samplerate);
	TIMER0_CR = TIMER_DIV_1   | TIMER_ENABLE | TIMER_IRQ_REQ;

//	TIMER1_DATA = (u16)(0x10000 - SOUNDBUFSIZ);
//	TIMER1_CR = TIMER_CASCADE | TIMER_ENABLE | TIMER_IRQ_REQ;

    REG_IME=0;
	irqSet(IRQ_TIMER0,IrqTimer0);
//	irqSet(IRQ_TIMER1,IrqTimer1);
    REG_IME=1;

	IPC2->soundCommand = 0;
}

void StopSound()
{
	int i;
	if( !SoundPause ){
		SoundPause = true;
		SoundProcTiming = 0;
		SoundPtr        = 0;
		SoundBufCnt     = 0;

		for(i=0;i<4;i++){
			SCHANNEL_CR(i) = 0;
		}

	    REG_IME=0;
		irqClear(IRQ_TIMER0);
		REG_IME=1;
	}
	IPC2->soundCommand = 0;
}

int main(int argc, char ** argv) {

	// IPC->soundCommandResult	= 0;

	// Reset the clock if needed
	rtcReset();

	// Power supply Register
	powerON(POWER_SOUND);

	InitSound();

	// Set up the interrupt handler
	REG_IME = 0;
	irqInit();
	irqSet(IRQ_VBLANK,IrqVBlank);
	REG_IME = 1;

	while (1){
		switch( IPC2->soundCommand ){		// Wait for Command from Arm9
			case 1: StopSound();  break;	// Stop
			case 2: PlaySound();  break;	// Play
			case 3: ResetSound(); break;	// Reset
		}
		if( SoundPause ){
			swiWaitForVBlank();
		}else{
			REG_IME=0;
			CalcSound();
			REG_IME=1;
//			swiDelay(1);					// Delay?
		}
	}
	return 0;
}
