//////////////////////////////////////////////////////////////////////
// fmsxDS
//////////////////////////////////////////////////////////////////////
#include "ipc2.h"
#include "MSX.h"
//#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <NDS.h>
#include <fat.h>
#include <unistd.h>
#include "DSGraph.h"
#include "DSLua.h"
#include "DSFileList.h"

#define MSX_CLK 3579545

void InitLOG(void);
extern void LOG( char * str , ... );

extern char *ROMName[];
extern char *DSKName[];

extern int MainMenu();

extern PSG * psg;
extern SCC * scc;

int psgON = true;
int sccON = true;

extern int NewSampleRate;

int autoFitScreen=0;

#define RGB16(a,r,g,b)  RGB15(r,g,b)|((a)<<15)

void waitForVBlank(int cnt)
{
	int i;
	for(i=0;i<cnt;i++){
		swiWaitForVBlank();
	}
}

void vsync()
{
//	scanKeys();
//	lua_vsync();
//	LOG("vsync");
}

void InterruptHandler(void)
{

	if (REG_IF & IRQ_VBLANK) {
		vsync();
		VBLANK_INTR_WAIT_FLAGS |= IRQ_VBLANK;
		REG_IF |= IRQ_VBLANK;
	}
	REG_IF = REG_IF;
}


void InitInterruptHandler()
{
  REG_IME = 0;
  IRQ_HANDLER = InterruptHandler;
  REG_IE = IRQ_VBLANK;
  REG_IF = ~0;
  REG_DISPSTAT = DISP_VBLANK_IRQ;
  REG_IME = 1;
}

void ResetSound(int smpl)
{
	IPC2->sampleRate = smpl;
	IPC2->soundCommand = 3;
	while( IPC2->soundCommand ) waitForVBlank(1);
}

void StartSound(void)
{
	IPC2->psgON = psgON;
	IPC2->sccON = sccON;
	IPC2->soundCommand = 2;
	while( IPC2->soundCommand ) waitForVBlank(1);
}

void StopSound(void)
{
	IPC2->soundCommand = 1;
	while( IPC2->soundCommand ) waitForVBlank(1);
}

void InitDS()
{
    // ̃EFCgƎgp̐ݒ
	REG_EXMEMCNT = 0xE880;

	//荞ݏ
	InitInterruptHandler();

	//fBXvC[h̐ݒ
	videoSetMode   (MODE_5_2D | DISPLAY_BG3_ACTIVE); 
	videoSetModeSub(MODE_5_2D | DISPLAY_BG2_ACTIVE);

	// VRAMoNݒ
	vramSetMainBanks(VRAM_A_MAIN_BG, VRAM_B_MAIN_BG, VRAM_C_SUB_BG , VRAM_D_ARM7_0x06000000); 

	// LCD̃CƃTuւ
//	lcdSwap();

    SUB_BG2_CR = BG_BMP16_256x256;
    SUB_BG2_XDX = 1 << 8;
    SUB_BG2_XDY = 0;
    SUB_BG2_YDX = 0;
    SUB_BG2_YDY = 1 << 8;
	SUB_BG2_CX = 0;
	SUB_BG2_CY = 0;

	BG3_CR = BG_BMP16_256x256;
    BG3_XDX = (1 << 8);
    BG3_XDY = 0;
    BG3_YDX = 0;
    BG3_YDY = (1 << 8);
    BG3_CX = 0;
    BG3_CY = 0;


	psg = (PSG*)&(IPC2->psg);
	scc = (SCC*)&(IPC2->scc);
}

void changeBGSize(byte V)
{
	static int line212flg = -1;
	if( autoFitScreen ){
		if(line212flg != (V&0x80) ){
			line212flg = (V&0x80);
		    BG3_YDY = (1 << 8) + (line212flg?32:0);
		}
	}
}

int InitFAT()
{
	int ret;
//	char buf[256];

	ret = fatInitDefault();
	if( !ret ){
		LOG( "fatInitDefault() Error." );
	    while(1) waitForVBlank(1);
	}
	LOG( "fatInitDefault() OK" );
/*
	getcwd(buf,256);
	LOG( buf );
	waitForVBlank(100);
*/
	return true;
}

int main(int ac, char*av[])
{
	char scriptname[256];
	int ret = 1;
	IPC2->soundCommand = 0;

	//DS
	InitDS();

	//O
	InitLOG();
	
	//t@CVXe
	InitFAT();

	//VM 
	InitMachine();
	InitMSX();

	// Sound reset
	ResetSound(SampleRate);

	strcpy( scriptname, "fmsxDS.lua" );
	while( 1 ){
		if( ret ){
			//	XNvgs
			StartLua(scriptname);
		}
		ret = fileselect( "fat:/", "LUA", scriptname );
	}
	return 0;
}
