#include "CE_driver.h"

void ChangeCas( char * fname )
{
    if( CasStream ){
        fclose( CasStream );
    }
    if(CasStream=fopen(fname,"a+b")){
        if(Verbose) LOG("Using %s as a tape\n",CasName);
    }
    fseek(CasStream,0,SEEK_SET);
}

void CasTop( void )
{
  if(CasStream)
  {
    fseek(CasStream,0,SEEK_SET);
  }
}

void CasEnd( void )
{
  if(CasStream)
  {
    fseek(CasStream,0,SEEK_END);
  }
}

void CasPrev( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos=ftell(CasStream);
    if(Pos&7)
      if(fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(fread(Buf,1,8,CasStream)==8){
      fseek(CasStream,-8,SEEK_CUR);
      if(!memcmp(Buf,TapeHeader,8)) return;
      if(fseek(CasStream,-8,SEEK_CUR)) return;
    }
  }
}

void CasNext( void )
{
  long Pos;
  char Buf[16];

  if(CasStream)
  {
    Pos=ftell(CasStream);
    if(Pos&7)
      if(fseek(CasStream,8-(Pos&7),SEEK_CUR))
      {
        return;
      }

    while(fread(Buf,1,8,CasStream)==8){
      if(!memcmp(Buf,TapeHeader,8))
      {
        return;
      }
    }
  }
}


