#include "CE_driver.h"

void NOLOG( char * str , ... )
{
}

void LOG( char * str , ... )
{
	HANDLE fp;
	int ret;
	int rcount;
	va_list marker;
	char buf[1024];
	TCHAR fname[1024];
	TCHAR * bufptr;

	if(!Verbose) return;

	GetModuleFileName(GetModuleHandle(NULL),fname,1023);
    if ((bufptr=_tcsrchr(fname,_T('\\'))) != NULL ) *bufptr = NULL;
	_tcscat( fname, _T("\\debug.log") );
	fp = CreateFile(
				fname , 
				GENERIC_WRITE,
				0,					// no shared
				NULL,				// set NULL
				OPEN_ALWAYS,
				FILE_ATTRIBUTE_NORMAL |	FILE_FLAG_RANDOM_ACCESS,
				0 );

	SetFilePointer(fp, 0,NULL,FILE_END );

	va_start( marker, str );     /* ό̈̏ */
	vsprintf( buf,str,marker );
	va_end( marker );

	ret = WriteFile( fp, buf, strlen(buf), (LPDWORD)&rcount, NULL ); 

	CloseHandle( fp );
}

void DELLOG( void )
{
	TCHAR fname[1024];
	TCHAR * bufptr;
	
	GetModuleFileName(GetModuleHandle(NULL),fname,1023);
    if ((bufptr=_tcsrchr(fname,_T('\\'))) != NULL ) *bufptr = NULL;
	_tcscat( fname, _T("\\debug.log") );
	DeleteFile(fname);
}

DWORD tim[256];
int timcnt[256];
LARGE_INTEGER timlast[256],nFreq;


void DEBUG_TIME_INIT()
{
	memset( tim    ,0,sizeof(LARGE_INTEGER)*256 );
	memset( timcnt ,0,sizeof(int)*256 );
	memset( timlast,0,sizeof(LARGE_INTEGER)*256 );
	QueryPerformanceFrequency(&nFreq);
}

void DEBUG_TIME_START(int num)
{
	QueryPerformanceCounter(&timlast[num]);
}

void DEBUG_TIME_END(int num )
{
	LARGE_INTEGER e;
	QueryPerformanceCounter(&e);
	tim[num] += (e.QuadPart - timlast[num].QuadPart)*1000/nFreq.QuadPart;
	timcnt[num]++;
}

void DEBUG_TIME_LOG()
{
	int i;
	for(i=0;i<256;i++){
		LOG( "tim[%d] cnt:%d  tim:%ld\n",i,timcnt[i],tim[i] );
	}
}
