#include "CE_driver.h"

HBITMAP	g_hbitmap;
HANDLE	g_hDIB;

int UseStatic = 0;

char * vid_init()
{
	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;
	char * vram;

	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= WIDTH;
	bi.biHeight			= -HEIGHT;
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	g_hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( g_hDIB );
#else
	g_hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( g_hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	g_hbitmap = CreateDIBSection( NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&vram, NULL, 0 );

/*
#if _WIN32_WCE >= 300
	GlobalUnlock( g_hDIB );
	GlobalFree( g_hDIB );
#else
	LocalUnlock( g_hDIB );
	LocalFree( g_hDIB );
#endif
*/
	if (vram == NULL){
		LOG( "GDI video open NG!.\n" );
		return NULL;
	}

	LOG( "GDI video open OK.\n" );
	return vram;
}

void vid_close()
{
	DeleteObject( g_hbitmap );
	LOG( "Video closed.\n" );
}

/** SetColor() ***********************************************/
/** Set color N (0..15) to (R,G,B).                         **/
/************************************ TO BE WRITTEN BY USER **/
void SetColor(byte N,byte R,byte G,byte B)
{
  unsigned int J;
  if(UseStatic) J=BPal[((7*R/255)<<2)|((7*G/255)<<5)|(3*B/255)];
  else J=( ((int)(R/8)<<11)|((int)(G/4)<<5)|(int)(B/8) );

  if(N) XPal[N]=J; else XPal0=J;
}

/** RefreshScreen() ******************************************/
/** Refresh screen. This function is called in the end of   **/
/** refresh cycle to show the entire screen.                **/
/************************************ TO BE WRITTEN BY USER **/
void RefreshScreen( void )
{
	HDC	hDC;
	HDC	hbDC;
	int sw,sh;
//    LOG("RefreshScreen Start\n" );

	hDC = GetDC(g_hWnd);
    hbDC = CreateCompatibleDC(hDC);

	SelectObject( hbDC, g_hbitmap );
#if 0
	if( Usex2Mode ){
		if( UseDrawBorder ){
			sw = 544;
			sh = 456;
		}else{
			sw = 512;
			sh = 424;
		}
	}else{
		if( UseDrawBorder ){
			sw = 272;
			sh = 228;
		}else{
			sw = 256;
			sh = 212;
		}
	}
#endif

    BitBlt( hDC, skin[SkinNum].scr.dx, skin[SkinNum].scr.dy, 
				 skin[SkinNum].scr.sw, skin[SkinNum].scr.sh, 
			hbDC,skin[SkinNum].scr.sx, skin[SkinNum].scr.sy,SRCCOPY ); 

    ReleaseDC( g_hWnd, hDC );
	DeleteDC( hbDC );

	wait_fps();

//  LOG("RefreshScreen End\n" );
}

/** DrawSkin() ***********************************************/
/*************************************************************/
void DrawSkin(HWND hwnd, HDC hDC){

	HDC     hDC1;
//	HDC     hDC;
//	BITMAP	bm;
	HBITMAP hbmold;
//	RECT    rct;
	int i;

	if(UseSOFTKEY){
//		hDC = GetDC(g_hWnd);
		hDC1=CreateCompatibleDC(NULL);
		hbmold = (HBITMAP)SelectObject(hDC1, (HGDIOBJ)bmpSkin);
//		GetObject(bmpSkin, sizeof(BITMAP), (LPVOID)&bm);
		for(i=0;i<skin[SkinNum].skincnt;i++){
			BitBlt(hDC, skin[SkinNum].srect[i].dx, skin[SkinNum].srect[i].dy, 
						skin[SkinNum].srect[i].sw, skin[SkinNum].srect[i].sh,
				   hDC1,skin[SkinNum].srect[i].sx, skin[SkinNum].srect[i].sy, SRCCOPY);
		}
		SelectObject(hDC1,hbmold);
		DeleteDC(hDC1);
	}
}
