#include "CE_driver.h"

//static byte JoyState;
extern KEYBIND Keys[256];
extern VIRTUALKEY VKey[256];
extern byte skey[300];

extern byte holdList[8];
byte holdkey[8] = {0,0,0,0,0,0,0,0};

byte WinJoy[2];

int KeyProcDown( KEYBIND k );
int KeyProcUP  ( KEYBIND k );

int softKeyNum = -1;

/** DownSoftKey() ********************************************/
/*************************************************************/
int DownSoftKey( int x, int y )
{
	int num = (int)(y / SoftKeyChip) * (int)(screen_x / SoftKeyChip) + (int)(x / SoftKeyChip) ;
	if( VKey[skey[num]].type == 2 ){
		softKeyNum = -1;
		return VKey[skey[num]].Pos;
	}
	softKeyNum = num;
	return GUI_NONE;
}
/** UoSoftKey() ********************************************/
/*************************************************************/
int UpSoftKey( int x, int y )
{
	softKeyNum = -1;
	return 0;
}

/** ReadKeyBind() *********************************************/
/**************************************************************/
void ReadKeyBind()
{
	FILE * fp;
	char buf[256];

	strcpy(buf,ProgDir);
	strcat(buf,"\\" );
	if( SkinDir ){
		strcat(buf,SkinDir );
		strcat(buf,"\\" );
	}
	if( skin[SkinNum].skeybind ){
		strcat(buf,skin[SkinNum].skeybind );
		fp = fopen(buf, "r");
		if ( !fp ){
			LOG("Load SoftKeyBind file failed! Keybindfile[%s]\n", buf );
			return;
		}
		int k = 0;
		int j = 0;
		while( fgets( buf , 256, fp ) ){
			char * tok;
			if( (tok = strtok(buf,", \t\x0A")) == NULL ) continue;
			if( strcmp(tok,"SKEY")==0 ){
				while( (tok = strtok(NULL,", \t\x0A"))!= NULL ){
					skey[j] = (byte)strtol(tok,NULL,0);
					j++;
				}
			}
		}
		fclose( fp );
		LOG("SoftKeybind loaded.\n" );
	}else{
		LOG("SoftKeybind no load.\n" );
	}

	strcpy(buf,ProgDir);
	strcat(buf,"\\" );
	if( SkinDir ){
		strcat(buf,SkinDir );
		strcat(buf,"\\" );
	}
	if( skin[SkinNum].hkeybind ){
		strcat(buf,skin[SkinNum].hkeybind );
		fp = fopen(buf, "r");
		if ( !fp ){
			LOG("Load HardKeyBind file failed! Keybindfile[%s]\n", buf );
			return;
		}
		int k = 0;
		int j = 0;
		while( fgets( buf , 256, fp ) ){
			char * tok;
			if( (tok = strtok(buf,", \t\x0A")) == NULL ) continue;
			if( strcmp(tok,"KEY")==0 ){
				if( (tok = strtok(NULL,", \t\x0A")) == NULL ) continue;
				Keys[k].Code = (byte)strtol(tok,NULL,0);
				if( (tok = strtok(NULL,", \t\x0A")) == NULL ) continue;
				Keys[k].vkey = (byte)strtol(tok,NULL,0);
				k++;
			}
		}
		fclose( fp );
		LOG("HardKeybind loaded.\n" );
	}else{
		LOG("HardKeybind no load.\n" );
	}

}

/** Keyboard() ***********************************************/
/** This function is periodically called to poll keyboard.  **/
/************************************ TO BE WRITTEN BY USER **/
#define SetDownKey(AA) ( KeyMap[AA.Pos]&=~AA.Mask )
#define SetUpKey(AA)   ( KeyMap[AA.Pos]|= AA.Mask )
#define SetDownJoy(AA) ( WinJoy[AA.Pos]|= AA.Mask )

void vkeytorealkey(int k)
{
	if( k == 0 ) return;
	switch( VKey[k].type ){
	case 0:	SetDownKey(VKey[k]); break;
	case 1: SetDownJoy(VKey[k]); break;
//	case 2:
//		PostMessage( g_hWnd,WM_APP_COMMAND,(WPARAM)VKey[k].Pos,0 );
//		break;
	}
}

void Keyboard(void)
{
    int i,j;
    KEYBIND K;
	SHORT key;
	POINT pt;

    Sleep(0);

	memset(KeyMap,0xFF,16);

	for( i = 0;i<256;i++ ){
		if( !Keys[i].Code ) break;
		key = GetAsyncKeyState(Keys[i].Code);
		if( key&0x8000 ) vkeytorealkey(Keys[i].vkey);
/*
		for(i=0;i<8;i++){
			if( holdList[i]==skey[softKeyNum] ){
				holdkey[i]=0;
				break;
			}
		}
*/
	}
	if( softKeyNum > -1 ){
		vkeytorealkey(skey[softKeyNum]);	/* touched Screen */
		for(i=0;i<8;i++){
			if( holdList[i]==skey[softKeyNum] ){
				if( holdkey[i]==0 ) holdkey[i]=1;
				if( holdkey[i]==2 )	holdkey[i]=3;
				break;
			}
		}
	}else{
		for(i=0;i<8;i++){
			if( holdkey[i]==1 )	holdkey[i]=2;
			if( holdkey[i]==3 )	holdkey[i]=0;
		}
	}
	for(i=0;i<8;i++){
		if( holdkey[i]==2 ){
			vkeytorealkey(holdList[i]);
		}
	}	
}
/** Joystick() ***********************************************/
/** Query position of a joystick connected to port N.       **/
/** Returns 0.0.F2.F1.R.L.D.U.                              **/
/************************************ TO BE WRITTEN BY USER **/
byte Joystick(byte N)
{
	byte a = WinJoy[N];
	WinJoy[N] &= 0xC0;
	return a;
}
/** Mouse() **************************************************/
/** Query coordinates of a mouse connected to port N.       **/
/** Returns F2.F1.Y.Y.Y.Y.Y.Y.Y.Y.X.X.X.X.X.X.X.X.          **/
/************************************ TO BE WRITTEN BY USER **/
int Mouse(byte N)
{
	return 0;
}

/** default softkeybind *******************************************/
byte skey[300] =
{
	121,  0,123,124,125,126,127,132,140,133,134,135,136,137,122,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 59, 59, 54, 55, 56, 57, 58,  0, 61, 66,  0, 63, 67, 68, 62,
	 60, 60,  2,  3,  4,  5,  6,  7,  8,  9, 10,  1, 11, 12, 13,
	 52, 52, 39, 45, 27, 40, 42, 47, 43, 31, 37, 38, 14, 15, 64,
	 50, 50, 23, 41, 26, 28, 29, 30, 32, 33, 34, 16, 17, 18, 64,
	 49, 49, 48, 46, 25, 44, 24, 36, 35, 19, 20,  0, 69, 70, 72,
	 51, 51, 53, 53,  0, 65, 65, 65,  0, 21, 22,  0, 69, 71, 72
};

/** default keybind *******************************************/
KEYBIND Keys[256] =
{
  {0x25, 69},  // LEFT
  {0x26, 70},  // UP
  {0x28, 71},  // DOWN
  {0x27, 72},  // RIGHT
  {0x0D, 64},  // RETURN
  {0x71, 65},  // SPACE
  {0x08, 62},  // BS
  {0x30,  1},  // '0'
  {0x31,  2},  // '1'
  {0x32,  3},  // '2'
  {0x33,  4},  // '3'
  {0x34,  5},  // '4'
  {0x35,  6},  // '5'
  {0x36,  7},  // '6'
  {0x37,  8},  // '7'
  {0x38,  9},  // '8'
  {0x39, 10},  // '9'
  {0xBD, 11},  // -
  {0xDE, 12},  // ^
  {0xDC, 13},  /* \ */
  {0xC0, 14},  // @
  {0xDB, 15},  // [
  {0xBB, 16},  // +
  {0xBA, 17},  // *
  {0xDD, 18},  // ]
  {0xBC, 19},  // ,
  {0xBE, 20},  // .
  {0xBF, 21},  // /
  {0xE2, 22},  // _
  {0x41, 23},  // 'A'
  {0x42, 24},  // 'B'
  {0x43, 25},  // 'C'
  {0x44, 26},  // 'D'
  {0x45, 27},  // 'E'
  {0x46, 28},  // 'F'
  {0x47, 29},  // 'G'
  {0x48, 30},  // 'H'
  {0x49, 31},  // 'I'
  {0x4A, 32},  // 'J'
  {0x4B, 33},  // 'K'
  {0x4C, 34},  // 'L'
  {0x4D, 35},  // 'M'
  {0x4E, 36},  // 'N'
  {0x4F, 37},  // 'O'
  {0x50, 38},  // 'P'
  {0x51, 39},  // 'Q'
  {0x52, 40},  // 'R'
  {0x53, 41},  // 'S'
  {0x54, 42},  // 'T'
  {0x55, 43},  // 'U'
  {0x56, 44},  // 'V'
  {0x57, 45},  // 'W'
  {0x58, 46},  // 'X'
  {0x59, 47},  // 'Y'
  {0x5A, 48},  // 'Z'
  {0x10, 49},  // SHIFT  
  {0x11, 50},  // CONTROL
  {0x1D, 51},  // ϊ   -> GRAPH
  {0xF0, 52},  // p     -> CAPS 
  {0xF2, 53},  // Ђ炪 -> 
  {0x70, 54},  // VK_F1
  {0x71, 55},  // VK_F2
  {0x72, 56},  // VK_F3
  {0x73, 57},  // VK_F4
  {0x74, 58},  // VK_F5
  {0x1B, 59},  // VK_ESCAPE 
  {0x09, 60},  // VK_TAB    
  {0x22, 61},  // VK_NEXT   -> STOP/BREAK
  {0x23, 63},  // VK_END    -> SELECT    
  {0x24, 66},  // VK_HOME   -> HOME/CLS  
  {0x2D, 67},  // VK_INSERT -> INSERT    
  {0x2E, 68},  // VK_DELETE -> DELETE    
  {0x00,  0}   // ** The End. ** //
};

/*********************************************/
byte holdList[8] = {
	49,	50, 51,0,0,0,0,0
};

/*********************************************/
VIRTUALKEY VKey[256] = {
	/* key */
	{ 0,0x00,0x00 }, //0	no use
	{ 0,0x00,0x01 }, //1	'0'
	{ 0,0x00,0x02 }, //2	'1'
	{ 0,0x00,0x04 }, //3	'2'
	{ 0,0x00,0x08 }, //4	'3'
	{ 0,0x00,0x10 }, //5	'4'
	{ 0,0x00,0x20 }, //6	'5'
	{ 0,0x00,0x40 }, //7	'6'
	{ 0,0x00,0x80 }, //8	'7'
	{ 0,0x01,0x01 }, //9	'8'
	{ 0,0x01,0x02 }, //10	'9'
	{ 0,0x01,0x04 }, //11	-
	{ 0,0x01,0x08 }, //12	^
	{ 0,0x01,0x10 }, /*13	\ */
	{ 0,0x01,0x20 }, //14	@
	{ 0,0x01,0x40 }, //15 [
	{ 0,0x01,0x80 }, //16 +
	{ 0,0x02,0x01 }, //17 :
	{ 0,0x02,0x02 }, //18 ]
	{ 0,0x02,0x04 }, //19 ,
	{ 0,0x02,0x08 }, //20 .
	{ 0,0x02,0x10 }, //21 /
	{ 0,0x02,0x20 }, //22 _
	{ 0,0x02,0x40 }, //23 'A'
	{ 0,0x02,0x80 }, //24 'B'
	{ 0,0x03,0x01 }, //25 'C'
	{ 0,0x03,0x02 }, //26 'D'
	{ 0,0x03,0x04 }, //27 'E'
	{ 0,0x03,0x08 }, //28 'F'
	{ 0,0x03,0x10 }, //29 'G'
	{ 0,0x03,0x20 }, //30 'H'
	{ 0,0x03,0x40 }, //31 'I'
	{ 0,0x03,0x80 }, //32 'J'
	{ 0,0x04,0x01 }, //33 'K'
	{ 0,0x04,0x02 }, //34 'L'
	{ 0,0x04,0x04 }, //35 'M'
	{ 0,0x04,0x08 }, //36 'N'
	{ 0,0x04,0x10 }, //37 'O'
	{ 0,0x04,0x20 }, //38 'P'
	{ 0,0x04,0x40 }, //39 'Q'
	{ 0,0x04,0x80 }, //40 'R'
	{ 0,0x05,0x01 }, //41 'S'
	{ 0,0x05,0x02 }, //42 'T'
	{ 0,0x05,0x04 }, //43 'U'
	{ 0,0x05,0x08 }, //44 'V'
	{ 0,0x05,0x10 }, //45 'W'
	{ 0,0x05,0x20 }, //46 'X'
	{ 0,0x05,0x40 }, //47 'Y'
	{ 0,0x05,0x80 }, //48 'Z'
	{ 0,0x06,0x01 }, //49 SHIFT  
	{ 0,0x06,0x02 }, //50 CONTROL
	{ 0,0x06,0x04 }, //51 GRAPH
	{ 0,0x06,0x08 }, //52 CAPS 
	{ 0,0x06,0x10 }, //53 
	{ 0,0x06,0x20 }, //54 VK_F1
	{ 0,0x06,0x40 }, //55 VK_F2
	{ 0,0x06,0x80 }, //56 VK_F3
	{ 0,0x07,0x01 }, //57 VK_F4
	{ 0,0x07,0x02 }, //58 VK_F5
	{ 0,0x07,0x04 }, //59 VK_ESCAPE 
	{ 0,0x07,0x08 }, //60 VK_TAB    
	{ 0,0x07,0x10 }, //61 STOP/BREAK
	{ 0,0x07,0x20 }, //62 BS
	{ 0,0x07,0x40 }, //63 SELECT
	{ 0,0x07,0x80 }, //64 RETURN
	{ 0,0x08,0x01 }, //65 SPACE
	{ 0,0x08,0x02 }, //66 HOME/CLS  
	{ 0,0x08,0x04 }, //67 INSERT    
	{ 0,0x08,0x08 }, //68 DELETE    
	{ 0,0x08,0x10 }, //69 LEFT
	{ 0,0x08,0x20 }, //70 UP
	{ 0,0x08,0x40 }, //71 DOWN
	{ 0,0x08,0x80 }, //72 RIGHT
	{ 0,0x09,0x01 }, //73 NUM *
	{ 0,0x09,0x02 }, //74 NUM +
	{ 0,0x09,0x04 }, //75 NUM /
	{ 0,0x09,0x08 }, //76 NUM 0
	{ 0,0x09,0x10 }, //77 NUM 1
	{ 0,0x09,0x20 }, //78 NUM 2
	{ 0,0x09,0x40 }, //79 NUM 3
	{ 0,0x09,0x80 }, //80 NUM 4
	{ 0,0x0A,0x01 }, //81 NUM 5
	{ 0,0x0A,0x02 }, //82 NUM 6
	{ 0,0x0A,0x04 }, //83 NUM 7
	{ 0,0x0A,0x08 }, //84 NUM 8
	{ 0,0x0A,0x10 }, //85 NUM 9
	{ 0,0x0A,0x20 }, //86 NUM -
	{ 0,0x0A,0x40 }, //87 NUM ,
	{ 0,0x0A,0x80 }, //88 NUM .
	{ 0,0x00,0x00 }, //89 reserved
	{ 0,0x00,0x00 }, //90 reserved
	{ 0,0x00,0x00 }, //91 reserved
	{ 0,0x00,0x00 }, //92 reserved
	{ 0,0x00,0x00 }, //93 reserved
	{ 0,0x00,0x00 }, //94 reserved
	{ 0,0x00,0x00 }, //95 reserved
	{ 0,0x00,0x00 }, //96 reserved
	{ 0,0x00,0x00 }, //97 reserved
	{ 0,0x00,0x00 }, //98 reserved
	{ 0,0x00,0x00 }, //99 reserved
	{ 0,0x00,0x00 }, //100 reserved
	/* joy */
	{ 1,0x00,0x01 }, //101 joy1 UP
	{ 1,0x00,0x02 }, //102 joy1 DOWN
	{ 1,0x00,0x04 }, //103 joy1 LEFT
	{ 1,0x00,0x08 }, //104 joy1 RIGHT
	{ 1,0x00,0x10 }, //105 joy1 BTN1
	{ 1,0x00,0x20 }, //106 joy1 BTN2
	{ 1,0x01,0x01 }, //107 joy2 UP
	{ 1,0x01,0x02 }, //108 joy2 DOWN
	{ 1,0x01,0x04 }, //109 joy2 LEFT
	{ 1,0x01,0x08 }, //110 joy2 RIGHT
	{ 1,0x01,0x10 }, //111 joy2 BTN1
	{ 1,0x01,0x20 }, //112 joy2 BTN2
	{ 1,0x00,0x00 }, //113 reserved
	{ 1,0x00,0x00 }, //114 reserved
	{ 1,0x00,0x00 }, //115 reserved
	{ 1,0x00,0x00 }, //116 reserved
	{ 1,0x00,0x00 }, //117 reserved
	{ 1,0x00,0x00 }, //118 reserved
	{ 1,0x00,0x00 }, //119 reserved
	{ 1,0x00,0x00 }, //120 reserved
	/* GUI */
	{ 2,GUI_START			, 0x00 },	//121
	{ 2,GUI_EXIT			, 0x00 },	//122
	{ 2,GUI_SEL_CART1		, 0x00 },	//123
	{ 2,GUI_SEL_CART2		, 0x00 },	//124
	{ 2,GUI_SEL_DISKA		, 0x00 },	//125
	{ 2,GUI_SEL_DISKB		, 0x00 },	//126
	{ 2,GUI_SEL_CAS			, 0x00 },	//127
	{ 2,GUI_CAS_PREV		, 0x00 },	//128
	{ 2,GUI_CAS_NEXT		, 0x00 },	//129
	{ 2,GUI_CAS_TOP 		, 0x00 },	//130
	{ 2,GUI_CAS_END 		, 0x00 },	//131
	{ 2,GUI_MISC			, 0x00 },	//132
	{ 2,GUI_SOUND			, 0x00 },	//133
	{ 2,GUI_JOYSTICK		, 0x00 },	//134
	{ 2,GUI_SOFTKEYBOARD	, 0x00 },	//135
	{ 2,GUI_KEYCHECK		, 0x00 },	//136
	{ 2,GUI_DEBUG			, 0x00 },	//137
	{ 2,GUI_MENU			, 0x00 },	//138
	{ 2,GUI_NEXTSKIN		, 0x00 },	//139
	{ 2,GUI_PATH			, 0x00 },	//140
	{ 2,GUI_LOAD			, 0x00 },	//141
	{ 2,GUI_LOAD_1			, 0x00 },	//142
	{ 2,GUI_LOAD_2			, 0x00 },	//143
	{ 2,GUI_LOAD_3			, 0x00 },	//144
	{ 2,GUI_LOAD_4			, 0x00 },	//145
	{ 2,GUI_LOAD_5			, 0x00 },	//146
	{ 2,GUI_LOAD_6			, 0x00 },	//147
	{ 2,GUI_LOAD_7			, 0x00 },	//148
	{ 2,GUI_LOAD_8			, 0x00 },	//149
	{ 2,GUI_LOAD_9			, 0x00 },	//150
	{ 2,GUI_SAVE			, 0x00 },	//151
	{ 2,GUI_SAVE_1			, 0x00 },	//152
	{ 2,GUI_SAVE_2			, 0x00 },	//153
	{ 2,GUI_SAVE_3			, 0x00 },	//154
	{ 2,GUI_SAVE_4			, 0x00 },	//155
	{ 2,GUI_SAVE_5			, 0x00 },	//156
	{ 2,GUI_SAVE_6			, 0x00 },	//157
	{ 2,GUI_SAVE_7			, 0x00 },	//158
	{ 2,GUI_SAVE_8			, 0x00 },	//159
	{ 2,GUI_SAVE_9			, 0x00 }	//160
};
