#include "CE_Driver.h"
//#include <windows.h>
//#include "../msx/Sound.h"

#include "../msx/device/emu2149.h"
#include "../msx/device/emu2212.h"
#include "../msx/device/emu2413.h"
#include "../msx/device/emu8950.h"

#define MSX_CLK 3579545

extern int UseSound ;     /* Sound driver frequency		     */
int UseStereo    = 0;     /* Stereo sound (1=enable)         */
int UsePSG       = 0;     /* PSG emulation (1=enable)        */
int UseSCC       = 0;     /* SCC emulation (1=enable)        */
int Use2413      = 0;     /* MSX-MUSIC emulation (1=enable)  */
int Use8950      = 0;     /* MSX-AUDIO emulation (1=enable)  */
int SndBufSize   = 2048;  /* Buffer size for audio emulation */
#define SndBufCnt    4    /* */

float FactorPSG  = 1.00;  /* Volume percentage of PSG        */
float FactorSCC  = 1.00;  /* Volume percentage of SCC        */
float Factor2413 = 1.00;  /* Volume percentage of MSX-MUSIC  */
float Factor8950 = 0.25;  /* Volume percentage of MSX-AUDIO  */

extern byte Verbose ;     /* Verbose messaging flag          */

OPLL   *opll;
OPL    *opl;
PSG    *psg;
SCC    *scc;

HANDLE hSoundThread;
HANDLE hEvent;

HWAVEOUT wout;
byte *buf;
WAVEHDR hdr[SndBufCnt];
int curbuf;
int bufcnt = 0;
int sounddeley = 1;    //1 or 2 or 4 or 8 ....
int soundthread_stat = 0;
int pause = false;

/** thread_sound() *******************************************/
/** Main loop of the sound .                                **/
/*************************************************************/
static void thread_sound()
{
	register int   J,K;
	register INT16 P,O,A,R1,R2,S;

	hEvent = CreateEvent(NULL,		// ZLeBLqq
						 TRUE,		// Zbg
						 FALSE,		// 
						 NULL		// CxgIuWFNg̖O
						);

	soundthread_stat = 1;

	while( soundthread_stat ){ 
		if( bufcnt < SndBufCnt ){
			for(J=0;J<SndBufSize;J+=2)
			{
				P = UsePSG  ? PSG_calc (psg ) : 0;
				S = UseSCC  ? SCC_calc (scc ) : 0;
				O = Use2413 ? OPLL_calc(opll) : 0;
				A = Use8950 ? OPL_calc (opl ) : 0;

				R1=(P+O+(A>>2)+S) * 2;
				hdr[curbuf].lpData[J+0] = R1&0x00FF;
				hdr[curbuf].lpData[J+1] = R1>>8;
			}

			waveOutWrite(wout, &hdr[curbuf], sizeof(WAVEHDR) );
			curbuf = (curbuf + 1) % SndBufCnt;
			bufcnt = bufcnt + 1; 
		}else{
			ResetEvent(hEvent);
			WaitForSingleObject( hEvent, 100 );
//			Sleep(1);
		}  
	}
	waveOutReset(wout);
	soundthread_stat = -1;
}

/** woutcallback() *******************************************/
/*************************************************************/
static void CALLBACK woutcallback(HANDLE wout, UINT msg,
								  DWORD user, DWORD dw1, DWORD dw2)
{
	if (msg == WOM_DONE){
	    bufcnt = (bufcnt==0)?0:bufcnt - 1;
		SetEvent(hEvent);
	}
}

/** OpenSoundDevice() ****************************************/
/** Open sound device with a given level of sound quality.  **/
/** Returns 0 if failed or sound quality (Mode).            **/
/*************************************************************/
static int OpenSoundDevice(int Rate)
{
	WAVEFORMATEX format;
	int i,rc;

	LOG("OpenSoundDevice Start\n" );

	format.wFormatTag      = WAVE_FORMAT_PCM;
	format.nChannels       = UseStereo ? 2 : 1;
	format.nSamplesPerSec  = Rate;
	format.wBitsPerSample  = 16;
	format.nBlockAlign     = format.nChannels * format.wBitsPerSample / 8; 
	format.nAvgBytesPerSec = Rate * format.nBlockAlign;
	format.cbSize          = 0;
	Sleep(1000);

	if (waveOutOpen(&wout, WAVE_MAPPER, &format,
					(DWORD) woutcallback, (DWORD) 0 , CALLBACK_FUNCTION)
					!= MMSYSERR_NOERROR){
		LOG( "waveOutOpen error.\n" );
		return 0;
	}
	buf = (byte *) calloc(SndBufSize , SndBufCnt);

	for (i = 0; i < SndBufCnt; i++) {
		hdr[i].lpData = (LPSTR) (buf + SndBufSize * i);
		hdr[i].dwBufferLength = SndBufSize;
		hdr[i].dwBytesRecorded = 0;
		hdr[i].dwUser = 0;
		hdr[i].dwFlags = 0;
		hdr[i].dwLoops = 0;
		hdr[i].lpNext = NULL;
		hdr[i].reserved = 0;
		waveOutPrepareHeader(wout, &hdr[i], sizeof(WAVEHDR) );
	}

	curbuf = 1;
	bufcnt = 0;

	hSoundThread = CreateThread(NULL, 
		0,		// stack size (ignored)
		(LPTHREAD_START_ROUTINE)thread_sound,	// Thread function
		0,		// 32 bit parameter passed to thread
		0,		// Creation flags (0 = start thread immediately)
		(LPDWORD)&rc);	// Receives thread ID


	if(!hSoundThread){
	  LOG( "Sound thread Create error.\n" );
	  return 0;
	}

	CloseHandle( hSoundThread );

	LOG("OpenSoundDevice END\n" );
	return(Rate);
}

/** InitSound() **********************************************/
/** Initialize DSP. Returns Rate on success, 0 otherwise.   **/
/** Mode is 0 to skip initialization (will be silent).      **/
/*************************************************************/
int InitSound(int Rate,int Verb)
{
  int r;
  LOG("InitSound START\n" );

//  Verbose=Verb;
  r = Rate;
  if(Rate<8192) r=44100;

  /* MSX-MUSIC emulation */
  opll=OPLL_new(MSX_CLK,r);
  OPLL_reset(opll);
  LOG("OPLL_reset OK\n" );

  /* PSG emulation*/
  psg=PSG_new(MSX_CLK,r);
  PSG_reset(psg);
  LOG("PSG_reset OK\n" );

  /* SCC emulation */
  scc=SCC_new(MSX_CLK,r);
  SCC_reset(scc);
  LOG("SCC_reset OK\n" );

  /* MSX-AUDIO emulation */
  opl = OPL_new(MSX_CLK,r) ;
  LOG("OPL_new OK\n" );

  /* Open sound device */
  if( !Rate ){
      LOG("InitSOUND END Rate=0. No sound.\n" );
      return(1);
  }
  if(!(Rate=OpenSoundDevice(Rate))){
      if(Verbose) LOG("Opening sound device...NG! No sound.\n");
	  return(0);
  }
  if(Verbose) LOG("Opening sound device...OK. Rate=%d\n", Rate);

  LOG("InitSound END\n" );
  return Rate;
}

/** ResetSound() *********************************************/
/** Reset sound chips.                                      **/
/*************************************************************/
void ResetSound()
{
  if(!UseSound) return;
  OPLL_reset(opll);
  OPL_reset(opl);
  PSG_reset(psg);
  SCC_reset(scc);
}

/** PauseSound() *********************************************/
/*************************************************************/
void PauseSound()
{
	if( pause ){
		ResumeThread( hSoundThread );
		waveOutRestart(wout);
	} else {
		waveOutPause(wout);
		SuspendThread( hSoundThread );
	}
	pause = ~pause;
}

/** TrashSound() *********************************************/
/** Shut DSP down.                                          **/
/*************************************************************/
void TrashSound(void)
{
  int i;

  LOG( "TrashSound start\n" );

  if(soundthread_stat == 1 ){
	  soundthread_stat = 0;
	  while(soundthread_stat==0) Sleep(100);
  }

  for (i = 0; i < SndBufCnt; i++)
    waveOutUnprepareHeader(wout, &hdr[i], sizeof(WAVEHDR) );

  waveOutClose(wout);

  if (buf) free(buf);

  /* clean up msxmusic */
  OPLL_delete(opll);
  /* clean up msxaudio */
  OPL_delete(opl);
  /* clean up psg */
  PSG_delete(psg);
  /* clean up scc */
  SCC_delete(scc);

  LOG( "Sound Device Trash ... OK.\n" );
}

/* wrapper functions to actual sound emulation */
void WriteOPLL (int R,int V) { OPLL_writeReg(opll,R,V);   }
void WriteAUDIO(int R,int V) { OPL_writeReg(opl,R,V);     }
void Write2212 (int R,int V) { SCC_write(scc,R,V);        }
void WritePSG  (int R,int V) { PSG_writeReg(psg,R,V);     }
int  ReadPSG   (int R)       { return PSG_readReg(psg,R); }
