#include "CE_driver.h"
#include "../MSX/Common.h"

/** Public parameters ****************************************/
int UseSound  = 8192;          /* Sound driver frequency    */
char *Disks[2][MAXDISKS+1];    /* Disk names for each drive */

int WIDTH  = 272;
int HEIGHT = 228;

unsigned int BPal[256],XPal[80],XPal0; 
char *XBuf;
//static Port Prt;

SKIN skin[8];
//char * skindir;
int SkinNum = 0;
int SkinCnt;
int Orientation;

/** InitMachine() ********************************************/
/** Allocate resources needed by the machine-dependent code.**/
/************************************ TO BE WRITTEN BY USER **/
int InitMachine(void)
{
	int I;
	int J;
	LOG( "InitMachine Start\n" );

//	ReadKeyBind(KeyRCFile, Keys);


	/* video init */
	XBuf = vid_init();
	if( !XBuf ) return 0; 

	/* sound init */
	InitSound(UseSound,0);

	/* Reset the palette */
	for(J=0;J<16;J++) XPal[J]=0;
	XPal0=0;

	/* Set SCREEN8 colors */
/*
	for(J=0;J<64;J++)
	{
		I=(J&0x03)+(J&0x0C)*16+(J&0x30)/2;
		XPal[J+16]= (((J&0x30)*255/48)<<16)+(((J&0x0C)*255/12)<<8)+(J&0x03)*255/3;
		BPal[I]=BPal[I|0x04]=BPal[I|0x20]=BPal[I|0x24]=XPal[J+16];
	}
*/
	for(J=0;J<256;J++ ){
		BPal[J] = ((J&0x1c)<<11)+(J&0xc0)*8+(J&0x03)*8;  
	}

	set_fps(60);

	LOG( "InitMachine End\n" );

	return 1;
}

/** TrashMachine() *******************************************/
/** Deallocate all resources taken by InitMachine().        **/
/************************************ TO BE WRITTEN BY USER **/
void TrashMachine(void)
{
  /* video close */
  vid_close();

  /* sound close */
  TrashSound();  

}

bool CheckBool( char * key, char * buf, int * flg )
{
	char * tok;
	if( !strcmp(key,buf) ){
		tok = strtok( NULL,"=, \t\x0A" );
		if( tok==NULL )return true;  
		if( *tok == 't' || *tok == 'T' ) *flg = TRUE;
									else *flg = FALSE;
		return true;
	}
	return false;
}
bool CheckInt( char * key, char * buf, int * flg )
{
	char * tok;
	if( !strcmp(key,buf) ){
		tok = strtok( NULL,"=, \t\x0A" );
		if( tok==NULL )return true;  
		*flg =  (int)strtol(tok,NULL,0);
		return true;
	}
	return false;
}
bool CheckByte( char * key, char * buf, unsigned char * flg )
{
	char * tok;
	if( !strcmp(key,buf) ){
		tok = strtok( NULL,"=, \t\x0A" );
		if( tok==NULL )return true;  
		*flg =  (unsigned char)strtol(tok,NULL,0);
		return true;
	}
	return false;
}
bool CheckStr( char * key, char * buf, char **rbuf )
{
	char * tok;
	if( !strcmp(key,buf) ){
		tok=strtok( NULL,"=, \t\x0A" );
		if( *rbuf )	free( *rbuf );
		*rbuf = NULL;
		if( tok!=NULL )	*rbuf = _strdup( tok );  
		return true;
	}
	return false;
}

bool CheckRect( char * key, char * buf, int *x1,int *x2,int *y1,int *y2, int * x, int * y )
{
	char * tok;
	if( !strcmp(key,buf) ){
		if( (tok=strtok( NULL,",= \t\x0A" )) != NULL ) *x1 = (int)strtol(tok,NULL,0);
		if( (tok=strtok( NULL,",= \t\x0A" )) != NULL ) *x2 = (int)strtol(tok,NULL,0);
		if( (tok=strtok( NULL,",= \t\x0A" )) != NULL ) *y1 = (int)strtol(tok,NULL,0);
		if( (tok=strtok( NULL,",= \t\x0A" )) != NULL ) *y2 = (int)strtol(tok,NULL,0);
		if( (tok=strtok( NULL,",= \t\x0A" )) != NULL ) *x  = (int)strtol(tok,NULL,0);
		if( (tok=strtok( NULL,",= \t\x0A" )) != NULL ) *y  = (int)strtol(tok,NULL,0);
		return true;
	}
	return false;
}

/*===================================================================*/
/*            LoadOption() : Option Load                             */
/*===================================================================*/
void LoadOption()
{
	FILE * fp;
	char buf[256];

	strcpy(buf, ProgDir);
	strcat(buf,"\\fmsxSEcfg.txt");

	fp = fopen( buf,"r" );
	while( fgets(buf,255,fp) ){
		char * sbuf = strrchr( buf, 0x0A );
		if( sbuf == buf ) continue;
		sbuf = strtok( buf, "=, \t\0x0A" );

		if( CheckBool( "INTERLESS" ,sbuf,&UseInterless    ) )continue;
		if( CheckStr ( "SKINDIR"   ,sbuf,&SkinDir         ) )continue;
		if( CheckStr ( "BIOSDIR"   ,sbuf,&BiosDir         ) )continue;	// Bios dir
		if( CheckStr ( "ROMDIR"	   ,sbuf,&RomDir          ) )continue;	// ROM dir
		if( CheckStr ( "DISKDIR"   ,sbuf,&DskDir          ) )continue;	// DISK dir
		if( CheckStr ( "CASDIR"    ,sbuf,&CasDir          ) )continue;	// CAS dir
		if( CheckStr ( "STADIR"    ,sbuf,&StaDir          ) )continue;	// State dir

        if( CheckBool( "USEPSG"    ,sbuf,&UsePSG          ) )continue;
		if( CheckBool( "USESCC"    ,sbuf,&UseSCC          ) )continue;
		if( CheckBool( "USE2413"   ,sbuf,&Use2413         ) )continue;
		if( CheckBool( "USE8950"   ,sbuf,&Use8950         ) )continue;
		if( CheckBool( "USESTEREO" ,sbuf,&UseStereo       ) )continue;
		if( CheckInt(  "USESOUND"  ,sbuf,&UseSound        ) )continue;

		if( CheckByte( "U_PERIOD"  ,sbuf,&UPeriod         ) )continue;
		if( CheckInt(  "V_PERIOD"  ,sbuf,&VPeriod         ) )continue;
		if( CheckInt(  "H_PERIOD"  ,sbuf,&HPeriod         ) )continue;

		if( CheckBool( "CHKSPOVER" ,sbuf,&UseSpriteOver   ) )continue; 

        if( CheckStr(  "CARTANAME" ,sbuf,&ROMName[0] ) )continue;
		if( CheckStr(  "CARTBNAME" ,sbuf,&ROMName[1] ) )continue;
		if( CheckStr(  "DISKANAME" ,sbuf,&DSKName[0] ) )continue;
		if( CheckStr(  "DISKBNAME" ,sbuf,&DSKName[1] ) )continue;
		if( CheckStr(  "CASNAME"   ,sbuf,&CasName    ) )continue;

		if( CheckBool( "REMOVECART",sbuf,&RemoveCart ) )continue;
		if( CheckBool( "REMOVEDISK",sbuf,&RemoveDisk ) )continue;
		if( CheckBool( "REMOVECAS" ,sbuf,&RemoveCas  ) )continue;

		if( CheckBool( "AUTORUN"   ,sbuf,&UseAutoRun ) )continue;
		if( CheckByte( "VERBOSE"   ,sbuf,&Verbose    ) )continue;
		if( CheckByte( "MSXVERSION",sbuf,&MSXVersion ) )continue;
    }
	fclose(fp);

	LOG("Option loaded.\n");
}

/*===================================================================*/
/*            SaveOption() : Save Option                             */
/*===================================================================*/
void SaveOption()
{
	FILE * fp;
	char buf[256];

	strcpy(buf, ProgDir);
	
	strcat(buf,"\\fmsxSEcfg.txt");

	fp = fopen( buf,"w" );
	fprintf(fp,"SKINDIR   =" ); if( SkinDir )fprintf(fp,"%s",SkinDir ); fprintf(fp,"\n");
	fprintf(fp,"BIOSDIR   =" ); if( BiosDir )fprintf(fp,"%s",BiosDir ); fprintf(fp,"\n");
	fprintf(fp,"ROMDIR    =" ); if( RomDir  )fprintf(fp,"%s",RomDir  ); fprintf(fp,"\n");
	fprintf(fp,"DISKDIR   =" ); if( DskDir  )fprintf(fp,"%s",DskDir  ); fprintf(fp,"\n");
	fprintf(fp,"CASDIR    =" ); if( CasDir  )fprintf(fp,"%s",CasDir  ); fprintf(fp,"\n");
	fprintf(fp,"STADIR    =" ); if( StaDir  )fprintf(fp,"%s",StaDir  ); fprintf(fp,"\n");

	fprintf(fp,"INTERLESS =%s\n",(UseInterless   ?"TRUE":"FALSE") );

	fprintf(fp,"USEPSG    =%s\n",(UsePSG         ?"TRUE":"FALSE") );
	fprintf(fp,"USESCC    =%s\n",(UseSCC         ?"TRUE":"FALSE") );
	fprintf(fp,"USE2413   =%s\n",(Use2413        ?"TRUE":"FALSE") );
	fprintf(fp,"USE8950   =%s\n",(Use8950        ?"TRUE":"FALSE") );
	fprintf(fp,"USESTEREO =%s\n",(UseStereo      ?"TRUE":"FALSE") );
	fprintf(fp,"USESOUND  =%d\n",UseSound    );

	fprintf(fp,"U_PERIOD  =%d\n",UPeriod  );
	fprintf(fp,"V_PERIOD  =%d\n",VPeriod  );
	fprintf(fp,"H_PERIOD  =%d\n",HPeriod  );
    fprintf(fp,"CHKSPOVER =%d\n",UseSpriteOver ); 

	fprintf(fp,"CARTANAME =" ); if( !RemoveCart ) fprintf(fp,"%s",ROMName[0]); fprintf(fp,"\n");
	fprintf(fp,"CARTBNAME =" ); if( !RemoveCart ) fprintf(fp,"%s",ROMName[1]); fprintf(fp,"\n");
	fprintf(fp,"DISKANAME =" ); if( !RemoveDisk ) fprintf(fp,"%s",DSKName[0]); fprintf(fp,"\n");
	fprintf(fp,"DISKBNAME =" );	if( !RemoveDisk ) fprintf(fp,"%s",DSKName[1]); fprintf(fp,"\n");
	fprintf(fp,"CASNAME   =" ); if( !RemoveCas  ) fprintf(fp,"%s",CasName   ); fprintf(fp,"\n");

	fprintf(fp,"REMOVECART=%s\n",(RemoveCart ?"TRUE":"FALSE") );
	fprintf(fp,"REMOVEDISK=%s\n",(RemoveDisk ?"TRUE":"FALSE") );
	fprintf(fp,"REMOVECAS =%s\n",(RemoveCas  ?"TRUE":"FALSE") );

	fprintf(fp,"AUTORUN   =%s\n",(UseAutoRun ?"TRUE":"FALSE") );

	fprintf(fp,"VERBOSE   =%d\n", Verbose );
	fprintf(fp,"MSXVERSION=%d\n", MSXVersion );
	fclose(fp);

	LOG("Option saved.\n");
}
/** LoadSkin() ***********************************************/
/*************************************************************/
int LoadSkin()
{
	FILE * fp;
	char buf[256];
	char s[16];
	char * skinbmpfile;
	skinbmpfile = NULL;
	int ori;
	int num=-1;
	int i;

	strcpy(buf, ProgDir);
	if( SkinDir ){
		strcat(buf,"\\" );
		strcat(buf,SkinDir );
	}
	strcat(buf,"\\skin.txt");
	fp = fopen( buf,"r" );
	if( fp == NULL ){
		MessageBox( g_hWnd,_T("Can't open skin.txt."),_T("ERROR"),MB_OK|MB_ICONSTOP );
		return FALSE;
	}
	while( fgets(buf,255,fp) ){
		char * sbuf = strrchr( buf, 0x0A );
		if( sbuf == buf ) continue;
		sbuf = strtok( buf, "=, \t\0x0A" );

		if( CheckInt ( "ORIENTATION",sbuf,&ori) ){
			num++;
			skin[num].ori = ori;
			continue;
		}
		if( CheckInt ( "SKINNO"    ,sbuf,&(skin[num].num      ) ) )continue;
		if( CheckBool( "USEx2MODE" ,sbuf,&(skin[num].Usex2Mode) ) )continue;
//		if( CheckBool( "DRAWBORDER",sbuf,&(skin[num].DrawBorder)) )continue;
//		if( CheckInt ( "VIEW_X"    ,sbuf,&(skin[num].View_x   ) ) )continue;
//		if( CheckInt ( "VIEW_Y"    ,sbuf,&(skin[num].View_y   ) ) )continue;
		if( CheckRect( "SCREEN"    ,sbuf,&(skin[num].scr.sx),&(skin[num].scr.sy),
										 &(skin[num].scr.sw),&(skin[num].scr.sh),
										 &(skin[num].scr.dx),&(skin[num].scr.dy) ) ) continue;
		if( CheckStr ( "SKINBMP"   ,sbuf,&(skin[num].skinbmp  ) ) )continue;
		if( CheckInt ( "SKINNUM"   ,sbuf,&(skin[num].skincnt  ) ) )continue;
		if( CheckStr ( "SKEYBIND"  ,sbuf,&(skin[num].skeybind ) ) )continue;
		if( CheckStr ( "HKEYBIND"  ,sbuf,&(skin[num].hkeybind ) ) )continue;
		for( i=0;i<skin[num].skincnt;i++ ){
			sprintf(s,"SKINRECT%02d",i); 
			if( CheckRect( s,sbuf,&(skin[num].srect[i].sx),&(skin[num].srect[i].sy),
								  &(skin[num].srect[i].sw),&(skin[num].srect[i].sh),
								  &(skin[num].srect[i].dx),&(skin[num].srect[i].dy) ) ) break;
		}
	}
	SkinCnt = num + 1;
	fclose( fp );
	return TRUE;
}

int CheckSkin( int num )
{
	int ret = -1;
	for(int i=0;i<SkinCnt;i++ ){
		if( (skin[i].ori==Orientation) && (skin[i].num==num ) ){
			ret = i;
		}
	}
	return ret;
}

void ChangeSkin( int num )
{
	TCHAR cmd[256];
	char  buf[256];
	BITMAP	bm;
	int i;

	SkinNum = CheckSkin( num );
	if( SkinNum == -1 ){
		SkinNum = CheckSkin( 0 );
	}
	if( SkinNum == -1 ) SkinNum = 0;

	strcpy(buf,ProgDir);
	strcat(buf,"\\" );
	if( SkinDir ){
		strcat(buf,SkinDir );
		strcat(buf,"\\" );
	}
	if( skin[SkinNum].skinbmp ){
		strcat(buf,skin[SkinNum].skinbmp );
		mbstowcs(cmd,buf,256);
		if( bmpSkin != NULL ) DeleteObject( bmpSkin );
		bmpSkin = NULL;
		bmpSkin = SHLoadDIBitmap( cmd );
	}
	LOG("Skin Bitmap %s\n",(bmpSkin?"loaded.":"no load. Can't use SoftWare Keyboard.") );
	if(!bmpSkin) UseSOFTKEY = FALSE;

//	View_x = skin[SkinNum].View_x;
//	View_y = skin[SkinNum].View_y;
	Usex2Mode = skin[SkinNum].Usex2Mode;
//	UseDrawBorder = skin[SkinNum].DrawBorder;

	setRefreshLine();
	setRefreshScreen();

	ReadKeyBind();

	InvalidateRect(g_hWnd , NULL, true);
	UpdateWindow(g_hWnd);
}

void NextSkin()
{
	ChangeSkin( skin[SkinNum].num + 1 ); 
}

void CE_Polling()
{
	Sleep(0);
}

DWORD fpscnt = 0;
DWORD beforetime = 0;
DWORD now;
DWORD g_fps;

void set_fps(int fps){
	if( fps == 0 ){
		g_fps = 0;
	}else{
		g_fps = 1000 * 0x10000 / fps;
	}
}

void wait_fps(){
	DWORD diff;
	DWORD sleeptime;
	int ms;

	if( g_fps==0 ) return;

	fpscnt = g_fps + fpscnt;
	now = timeGetTime();
	diff = (now - beforetime)<<16;

	if( diff < fpscnt ){
		ms    = fpscnt - diff;
		sleeptime = ms >> 16;
		fpscnt    = ms & 0xFFFF ;
		now += sleeptime;

		Sleep( sleeptime );

	}else{
		if( diff > fpscnt + g_fps ){
			// frameskip = 2;  // 1 frame skip;
			fpscnt = 0;
			now += g_fps >> 16;
		}else{
			int ms = (diff - fpscnt);
			fpscnt = ms & 0xFFFF ;
			now -= ms >> 16;
		}
	}
	beforetime = now;
}
