#include <windows.h>
#include "CE_driver.h"
#include "../MSX/common.h"
//#include <gx.h>

RawFrameBufferInfo g_rfbi;

HBITMAP	g_hbitmap;
HANDLE	g_hDIB;

int UseStatic = 0;

char * g_vbuf;
extern GXDisplayProperties g_gxdp;
void setRefreshScreen( void );

extern void (*RefreshScreen)( void );

#if 0
char * vid_init()
{
	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;
	char * vram;

	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= WIDTH;
	bi.biHeight			= -HEIGHT;
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	g_hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( g_hDIB );
#else
	g_hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( g_hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	g_hbitmap = CreateDIBSection( NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&vram, NULL, 0 );

/*

#if _WIN32_WCE >= 300
	GlobalUnlock( g_hDIB );
	GlobalFree( g_hDIB );
#else
	LocalUnlock( g_hDIB );
	LocalFree( g_hDIB );
#endif
*/
	if (vram == NULL){
		LOG( "GDI video open NG!.\n" );
		return NULL;
	}

	LOG( "GDI video open OK.\n" );
	return vram;
}

void vid_close()
{
	DeleteObject( g_hbitmap );
	LOG( "Video closed.\n" );
}
#endif

char * vid_init()
{
	HEIGHT = 228;
	if(isVGA){
		WIDTH  = 544;
	}else{
		WIDTH  = 272;
	}

	setRefreshLine();
	setRefreshScreen();

	g_vbuf = (char*)malloc( HEIGHT * WIDTH * 2 );

	HDC hdc = GetDC(NULL);
	ExtEscape(hdc, GETRAWFRAMEBUFFER, 0, NULL, 
	   sizeof(RawFrameBufferInfo), (char *) &g_rfbi);
	ReleaseDC(NULL, hdc);

	if( g_rfbi.pFramePointer == NULL ){
		return NULL;
	}
	return g_vbuf;
}

void vid_close()
{
	free( g_vbuf );
}
/** SetColor() ***********************************************/
/** Set color N (0..15) to (R,G,B).                         **/
/************************************ TO BE WRITTEN BY USER **/
void SetColor(byte N,byte R,byte G,byte B)
{
  unsigned int J;
  if(UseStatic) J=BPal[((7*R/255)<<2)|((7*G/255)<<5)|(3*B/255)];
  else J=( ((int)(R/8)<<11)|((int)(G/4)<<5)|(int)(B/8) );

  if(N) XPal[N]=J; else XPal0=J;
}

/** RefreshScreen() ******************************************/
/** Refresh screen. This function is called in the end of   **/
/** refresh cycle to show the entire screen.                **/
/************************************ TO BE WRITTEN BY USER **/
typedef unsigned short pixel;

int SX, SY, SW, SH, DX, DY; 

void setScreenParam( void )
{
	DX = skin[SkinNum].scr.dx;
	DY = skin[SkinNum].scr.dy;
	SX = skin[SkinNum].scr.sx;
	SY = skin[SkinNum].scr.sy;
	SW = skin[SkinNum].scr.sw;
	SH = skin[SkinNum].scr.sh;
}

void RefreshScreen0x1( void )
{
    pixel * dst = (pixel*)g_rfbi.pFramePointer + DY * g_rfbi.cxPixels + DX;
	pixel * src = (pixel*)g_vbuf               + SY * WIDTH           + SX;

	for(int y=0;y<SH ;y++){
		pixel * d = dst;
		pixel * s = src;
		for(int x=0;x<SW ;x++){
			*d++ = *s++;
		}
		dst += g_rfbi.cxPixels;
		src += WIDTH;
	}
	wait_fps();
}
void RefreshScreen1x1( void )
{
	int dx = DY;
	int dy = (g_rfbi.cyPixels - DX - SW);
	pixel * dst = (pixel*)g_rfbi.pFramePointer + dy * g_rfbi.cxPixels + dx;
	pixel * src = (pixel*)g_vbuf + SY * WIDTH + SX + SW - 1;

	for(int y=0;y<SW;y++){
		pixel * d = dst;
		pixel * s = src;
		for(int x=0;x<SH;x++){
			*d++ = *s;
			s+=WIDTH;
		}
		dst += g_rfbi.cxPixels;
		src -- ;
	}
	wait_fps();
}
void RefreshScreen2x1( void )
{
    pixel * dst = (pixel*)g_rfbi.pFramePointer +(DY+SH) * g_gxdp.cxWidth + DX + SW - 1;
	pixel * src = (pixel*)g_vbuf + SY * WIDTH + SX;

	for(int y=0;y<SH;y++){
		pixel * d = dst;
		pixel * s = src;
		for(int x=0;x<SW;x++){
			*d-- = *s++;
		}
		dst += g_gxdp.cxWidth;
		src -= WIDTH;
	}
	wait_fps();
}
void RefreshScreen4x1( void )
{
	int dx = g_rfbi.cxPixels - (DY + SH);
	int dy = DX;
	pixel * dst = (pixel*)g_rfbi.pFramePointer + dy * g_rfbi.cyPixels + dx;
	pixel * src = (pixel*)g_vbuf + (SY + SH-1) * WIDTH + SX ;

	for(int y=0;y<SW;y++){
		pixel * d = dst;
		pixel * s = src;
		for(int x=0;x<SH;x++){
			*d++ = *s;
			s-=WIDTH;
		}
		dst += g_rfbi.cxPixels;
		src ++ ;
	}
	wait_fps();
}

typedef unsigned long dpixel; 
void RefreshScreen0x2( void )
{
	int dx = DX;
	int dy = DY;
	dpixel * dst1 = (dpixel*)g_rfbi.pFramePointer + (dy * g_rfbi.cxPixels + dx) / 2;
	dpixel * dst2 = dst1 + g_rfbi.cxPixels / 2;
	pixel * src = (pixel*)g_vbuf + SY * WIDTH + SX;

	if( ScrMode==6 ||ScrMode== 7 || ScrMode==13 ){
		for(int y=0;y<SH/2;y++){
			dpixel * d1 = dst1;
			dpixel * d2 = dst2;
			pixel * s = src;
			for(int x=0;x<SW/2;x++){
				int s1 = *s++;
				int s2 = *s++;
				*d1++ = *d2++ = s2<<16|s1;
			}
			dst1 += g_rfbi.cxPixels;
			dst2 += g_rfbi.cxPixels;
			src += WIDTH;
		}
	}else{
		for(int y=0;y<SH/2;y++){
			dpixel * d1 = dst1;
			dpixel * d2 = dst2;
			pixel  * s  = src;
			for(int x=0;x<SW/2;x++){
				*d1++ = *d2++ = *s<<16|*s;
				s++;
			}
			dst1 += g_rfbi.cxPixels;
			dst2 += g_rfbi.cxPixels;
			src  += WIDTH;
		}
	}
	wait_fps();
}
void RefreshScreen1x2( void )
{
	int dx = DY;
	int dy = g_rfbi.cyPixels - (DX + SW);
	dpixel * dst1 = (dpixel*)g_rfbi.pFramePointer + (dy * g_rfbi.cxPixels + dx) / 2;
	dpixel * dst2 = dst1 + g_rfbi.cxPixels / 2;

	if( ScrMode==6 ||ScrMode== 7 || ScrMode==13 ){
		pixel * src = (pixel*)g_vbuf + SY * WIDTH + SX + SW -1;
		for(int y=0;y<SW;y++){
			dpixel * d = dst1;
			pixel  * s = src;
			for(int x=0;x<SH/2;x++){
				*d++ = *s<<16|*s;
				s+=WIDTH;
			}
			dst1 += g_rfbi.cxPixels / 2;
			src -- ;
		}
	}else{
		pixel * src = (pixel*)g_vbuf + SY * WIDTH + SX + SW/2 -1;
		for(int y=0;y<SW/2;y++){
			dpixel * d1 = dst1;
			dpixel * d2 = dst2;
			pixel * s = src;
			for(int x=0;x<SH/2;x++){
				*d1++ = *d2++ = *s<<16|*s;
				s+=WIDTH;
			}
			dst1 += g_rfbi.cxPixels;
			dst2 += g_rfbi.cxPixels;
			src -- ;
		}
	}
	wait_fps();
}
void RefreshScreen2x2( void )
{
}
void RefreshScreen4x2( void )
{
	int dx = g_rfbi.cxPixels - (DY + SH);
	int dy = DX;
	dpixel * dst1 = (dpixel*)g_rfbi.pFramePointer + (dy * g_rfbi.cxPixels + dx) / 2;
	dpixel * dst2 = dst1 + g_rfbi.cxPixels / 2;

	if( ScrMode==6 ||ScrMode== 7 || ScrMode==13 ){
		pixel * src = (pixel*)g_vbuf + ( SY + SH/2 ) * WIDTH + SX;
		for(int y=0;y<SW;y++){
			dpixel * d = dst1;
			pixel  * s = src;
			for(int x=0;x<SH/2;x++){
				*d++ = *s<<16|*s;
				s-=WIDTH;
			}
			dst1 += g_rfbi.cxPixels / 2;
			src ++ ;
		}
	}else{
		pixel * src = (pixel*)g_vbuf + ( SY + SH/2 ) * WIDTH + SX;
		for(int y=0;y<SW/2;y++){
			dpixel * d1 = dst1;
			dpixel * d2 = dst2;
			pixel * s = src;
			for(int x=0;x<SH/2;x++){
				*d1++ = *d2++ = *s<<16|*s;
				s-=WIDTH;
			}
			dst1 += g_rfbi.cxPixels;
			dst2 += g_rfbi.cxPixels;
			src ++ ;
		}
	}
	wait_fps();
}

void setRefreshScreen( void ){
	if( Usex2Mode ){
		switch( Orientation ){
			case 0:RefreshScreen = RefreshScreen0x2;break;
			case 1:RefreshScreen = RefreshScreen1x2;break;
			case 2:RefreshScreen = RefreshScreen2x2;break;
			case 4:RefreshScreen = RefreshScreen4x2;break;
		}
	}else{
		switch( Orientation ){
			case 0:RefreshScreen = RefreshScreen0x1;break;
			case 1:RefreshScreen = RefreshScreen1x1;break;
			case 2:RefreshScreen = RefreshScreen2x1;break;
			case 4:RefreshScreen = RefreshScreen4x1;break;
		}
	}
	setScreenParam();
}
#if 0
void RefreshScreen( void )
{
	HDC	hDC;
	HDC	hbDC;
	int sw,sh;
//    LOG("RefreshScreen Start\n" );

	hDC = GetDC(g_hWnd);
    hbDC = CreateCompatibleDC(hDC);

	SelectObject( hbDC, g_hbitmap );
#if 0
	if( Usex2Mode ){
		if( UseDrawBorder ){
			sw = 544;
			sh = 456;
		}else{
			sw = 512;
			sh = 424;
		}
	}else{
		if( UseDrawBorder ){
			sw = 272;
			sh = 228;
		}else{
			sw = 256;
			sh = 212;
		}
	}
#endif

    BitBlt( hDC, DX, DY, 
				 SW, SH, 
			hbDC,SX, SY,SRCCOPY ); 

    ReleaseDC( g_hWnd, hDC );
	DeleteDC( hbDC );

	wait_fps();

//  LOG("RefreshScreen End\n" );
}
#endif


/** DrawSkin() ***********************************************/
/*************************************************************/
void DrawSkin(HWND hwnd, HDC hDC){

	HDC     hDC1;
//	HDC     hDC;
//	BITMAP	bm;
	HBITMAP hbmold;
//	RECT    rct;
	int i;

	if(UseSOFTKEY){
//		hDC = GetDC(g_hWnd);
		hDC1=CreateCompatibleDC(NULL);
		hbmold = (HBITMAP)SelectObject(hDC1, (HGDIOBJ)bmpSkin);
//		GetObject(bmpSkin, sizeof(BITMAP), (LPVOID)&bm);
		for(i=0;i<skin[SkinNum].skincnt;i++){
			BitBlt(hDC, skin[SkinNum].srect[i].dx, skin[SkinNum].srect[i].dy, 
						skin[SkinNum].srect[i].sw, skin[SkinNum].srect[i].sh,
				   hDC1,skin[SkinNum].srect[i].sx, skin[SkinNum].srect[i].sy, SRCCOPY);
		}
		SelectObject(hDC1,hbmold);
		DeleteDC(hDC1);
	}
}
