#ifndef __CE_DRIVER_H__
#define __CE_DRIVER_H__
#include <windows.h>
#include "../MSX/MSX.h"

#define WM_APP_COMMAND (WM_APP+0x200)

#define GUI_NONE			0
#define GUI_START			1
#define GUI_EXIT			2
#define GUI_SEL_CART1		3
#define GUI_SEL_CART2		4
#define GUI_SEL_DISKA		5
#define GUI_SEL_DISKB		6
#define GUI_SEL_CAS			7
#define GUI_CAS_PREV		8
#define GUI_CAS_NEXT		9
#define GUI_CAS_TOP 		10
#define GUI_CAS_END 		11
#define GUI_MISC			12
#define GUI_SOUND			13
#define GUI_JOYSTICK		14
#define GUI_SOFTKEYBOARD	15
#define GUI_KEYCHECK		16
#define GUI_DEBUG			17
#define GUI_MENU			18
#define GUI_RESET			19
#define GUI_NEXTSKIN		20
#define GUI_PATH			21
#define GUI_LOAD			22
#define GUI_LOAD_1			23
#define GUI_LOAD_2			24
#define GUI_LOAD_3			25
#define GUI_LOAD_4			26
#define GUI_LOAD_5			27
#define GUI_LOAD_6			28
#define GUI_LOAD_7			29
#define GUI_LOAD_8			30
#define GUI_LOAD_9			31
#define GUI_SAVE			32
#define GUI_SAVE_1			33
#define GUI_SAVE_2			34
#define GUI_SAVE_3			35
#define GUI_SAVE_4			36
#define GUI_SAVE_5			37
#define GUI_SAVE_6			38
#define GUI_SAVE_7			39
#define GUI_SAVE_8			40
#define GUI_SAVE_9			41

typedef struct stKeybind { 
	byte Code;
	byte vkey;
} KEYBIND;

typedef struct tagVIRTUALKEY {
	byte type;
	byte Pos;
	byte Mask;
} VIRTUALKEY;

typedef struct tagSKINRECT {
	int sx;
	int sy;
	int sw;
	int sh;
	int dx;
	int dy;
} SKINRECT;

typedef struct tagSKIN {
	int ori;
	int num;	
//	int View_x;
//	int View_y;
	SKINRECT scr;
	int Usex2Mode;
	char * skinbmp;
	char * skeybind;
	char * hkeybind;
	int skincnt;
	SKINRECT srect[16];
} SKIN;

extern SKIN skin[8];
//extern char * skindir;
extern int SkinNum;
extern int screen_x;
extern int screen_y;
extern int SoftKeyChip;

extern int isVGA;

extern int UseNarrow;
extern int Usex2Mode;
extern int UseDrawBorder;
extern int UseInterless;

extern HBITMAP	g_hbitmap;
extern HANDLE	g_hDIB;

extern HWND g_hWnd;
extern HBITMAP bmpSkin;
extern int UseSOFTKEY; 
/*
extern int SoftKeyLeft; 
extern int SoftKeyTop;
extern int SoftKeyWidth;
extern int SoftKeyHeight;
*/
extern int View_x;
extern int View_y;
extern byte TapeHeader[8];

extern int UseSound;     /* Sound driver frequency		     */
extern int UseStereo;     /* Stereo sound (1=enable)         */
extern int UsePSG   ;     /* PSG emulation (1=enable)        */
extern int UseSCC   ;     /* SCC emulation (1=enable)        */
extern int Use2413  ;     /* MSX-MUSIC emulation (1=enable)  */
extern int Use8950  ;     /* MSX-AUDIO emulation (1=enable)  */

extern int RemoveCart;
extern int RemoveDisk;
extern int RemoveCas ;
extern int UseAutoRun;

extern char *XBuf;

extern unsigned int BPal[256];
extern unsigned int XPal[80];
extern unsigned int XPal0; 

extern int Orientation;

extern KEYBIND Joys[];
extern KEYBIND Keys[];

// Debug
void LOG( char * str , ... );
void DELLOG( void );
void DEBUG_TIME_LOG();
void DEBUG_TIME_END(int num );
void DEBUG_TIME_START(int num);
void DEBUG_TIME_INIT();

// Sound
int InitSound(int Rate,int Verb);

// Graph
char * vid_init();
void vid_close();
void ChangeSkin(int num);
void DrawSkin(HWND, HDC);
void NextSkin();

// Interface
void KeyDown(unsigned int key);
void KeyUp(unsigned int key);
extern int DownSoftKey( int, int );
extern int UpSoftKey( int, int );
extern int DownJoy( word vKey );
extern int UpJoy( word vKey );
extern void ReadKeyBind();
extern void DrawSoftKey( HWND ,  HDC );

// Misc
int InitMachine(void);
void TrashMachine(void);
void LoadOption();
void SaveOption();
int LoadSkin();
void CE_Polling();

void wait_fps();
void set_fps(int);

#endif
