// fMSX_CE.cpp 
#include "stdafx.h"
#include "resource.h"

#include "CE/CE_driver.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <tchar.h>
#include <Imm.h> 

#ifdef WIN32_PLATFORM_PSPC
#include <Aygshell.h>
#endif

#include "msx/msx.h"

#define MAX_LOADSTRING 512

ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass);
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow);
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
HWND CreateRpCommandBar(HWND hwnd);
void DoPaint(HWND hWnd);

int SaveStateNum(const int num );
int LoadStateNum(const int num );

char * OpenFileDlg(HWND hWnd, int flg);
char * SaveFileDlg(HWND hWnd, int flg);

int start_msx();
void SaveOption();
void LoadOption();
byte ChangeDisk(byte ID,char *Name);
int ShowMenuBar(int flg);

extern byte JoyTypeA;
extern byte JoyTypeB;
extern byte Verbose; 
extern byte MSXVersion;
 
HBITMAP bmpSkin;
int UseSOFTKEY  = TRUE; 


int isVGA	= true;
int	screen_x;
int	screen_y;
int SoftKeyChip = 32;

int View_x = 0;
int View_y = 0;
//int UseNarrow = FALSE;
int Usex2Mode = FALSE;
int UseInterless = FALSE;
//int UseDrawBorder = TRUE;
HINSTANCE g_hInst;
HWND      g_hWnd;
HWND      g_hwndCB;  // menu window handle

HANDLE hThread = NULL;		// CPU thread

int CommandBarVis;
int thread_running = FALSE;

char * OpenFileDlg(HWND hWnd, int flg);

LRESULT CALLBACK DLGKeyCheck(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGMisc    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGSound   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGDebug   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DLGPath    (HWND, UINT, WPARAM, LPARAM);

void GUICommand( int cmd );

#ifdef WIN32_PLATFORM_PSPC
#include "gx.h"
/*
int (*pGXOpenInput)(HWND,DWORD) = NULL;
int (*pGXCloseInput)() = NULL;
GXKeyList (*pGXGetDefaultKeys)(int) = NULL;
HMODULE gxlib;
*/
GXDisplayProperties g_gxdp;
GXKeyList g_gxkl;
#endif


// MyRegisterClass
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_fMSXCE));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}


//  FUNCTION: InitInstance(HANDLE, int)
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name
    RECT	rect;
	int     sx,sy;
	LOG("InitInstance Start\n");

	g_hInst = hInstance;		// Store instance handle in our global variable

	// Initialize global strings
	LoadString(hInstance, IDC_fMSXCE, szWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	//If it is already running, then focus on the window
	hWnd = FindWindow(szWindowClass, szTitle);	
	if (hWnd) 
	{
		SetForegroundWindow ((HWND) (((DWORD)hWnd) | 0x01));    
		return 0;
	} 

	BOOL ret = ImmDisableIME(0); /* IME Disabled */

	MyRegisterClass(hInstance, szWindowClass);
	GetClientRect(hWnd, &rect);
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	if (!hWnd)
	{	
		return FALSE;
	}

	sx = GetSystemMetrics(SM_CXSCREEN);
	sy = GetSystemMetrics(SM_CYSCREEN);
	MoveWindow(hWnd, 0, 0, sx, sy,TRUE );	

	if( sx >= 480 && sy >= 480 ){
		isVGA = true;
		SoftKeyChip = 32;
	}else{
		isVGA = false;
		SoftKeyChip = 16;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	g_hWnd = hWnd;

	LOG("InitInstance End\n");
	return TRUE;
}

//------------------------------------------------------
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	int x,y,num;
	HMENU hMenu;
	MENUITEMINFO mi;
	BOOL ret;
	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			switch (wmId)
			{	
				case ID_MENU_Run:		GUICommand( GUI_START		);	break;
				case ID_MENU_Reset:		GUICommand( GUI_RESET		);	break;
				case ID_MENU_Exit:		GUICommand( GUI_EXIT		);	break;
				case ID_MENU_Cart1: 	GUICommand( GUI_SEL_CART1	);	break;
				case ID_MENU_Cart2: 	GUICommand( GUI_SEL_CART2	);	break;
				case ID_MENUCHGDRV_A:	GUICommand( GUI_SEL_DISKA	);	break;
				case ID_MENUCHGDRV_B:	GUICommand( GUI_SEL_DISKB	);	break;
				case ID_MENUCHGCAS:		GUICommand( GUI_SEL_CAS		);	break;
				case ID_CAS_PREV:		GUICommand( GUI_CAS_PREV	);	break;
				case ID_CAS_NEXT:		GUICommand( GUI_CAS_NEXT	);	break;
				case ID_CAS_TOP :		GUICommand( GUI_CAS_TOP		);	break;
				case ID_CAS_END :		GUICommand( GUI_CAS_END		);	break;
				case ID_MENU_MISC:		GUICommand( GUI_MISC		);	break;
				case ID_MENU_PATH:		GUICommand( GUI_PATH		);	break;
				case ID_MENU_SOUND:		GUICommand( GUI_SOUND		);	break;
				case ID_KEYCHECK:		GUICommand( GUI_KEYCHECK	);	break;
				case ID_MENU_DEBUG:		GUICommand( GUI_DEBUG		);	break;
				case IDM_DISABLE:		GUICommand( GUI_MENU        );	break;
				case ID_LOAD:			GUICommand( GUI_LOAD        );  break;
				case ID_LOAD_1:			GUICommand( GUI_LOAD_1      );  break;
				case ID_LOAD_2:			GUICommand( GUI_LOAD_2      );  break;
				case ID_LOAD_3:			GUICommand( GUI_LOAD_3      );  break;
				case ID_LOAD_4:			GUICommand( GUI_LOAD_4      );  break;
				case ID_LOAD_5:			GUICommand( GUI_LOAD_5      );  break;
				case ID_LOAD_6:			GUICommand( GUI_LOAD_6      );  break;
				case ID_LOAD_7:			GUICommand( GUI_LOAD_7      );  break;
				case ID_LOAD_8:			GUICommand( GUI_LOAD_8      );  break;
				case ID_LOAD_9:			GUICommand( GUI_LOAD_9      );  break;
				case ID_SAVE:			GUICommand( GUI_SAVE        );  break;
				case ID_SAVE_1:			GUICommand( GUI_SAVE_1      );  break;
				case ID_SAVE_2:			GUICommand( GUI_SAVE_2      );  break;
				case ID_SAVE_3:			GUICommand( GUI_SAVE_3      );  break;
				case ID_SAVE_4:			GUICommand( GUI_SAVE_4      );  break;
				case ID_SAVE_5:			GUICommand( GUI_SAVE_5      );  break;
				case ID_SAVE_6:			GUICommand( GUI_SAVE_6      );  break;
				case ID_SAVE_7:			GUICommand( GUI_SAVE_7      );  break;
				case ID_SAVE_8:			GUICommand( GUI_SAVE_8      );  break;
				case ID_SAVE_9:			GUICommand( GUI_SAVE_9      );  break;

/*
				case ID_MENU_JOYSTICK:		GUICommand(GUI_JOYSTICK	  	);	break;
				case ID_MENU_SOFTKEYBOARD:	GUICommand(GUI_SOFTKEYBOARD	);	break;
				case ID_MENUMSX1:
				case ID_MENUMSX2:
				case ID_MENUMSX2P:
					MSXVersion = wmId - ID_MENUMSX1;
					hMenu = CommandBar_GetMenu(g_hwndCB, 0 );
					CheckMenuRadioItem(hMenu, ID_MENUMSX1,ID_MENUMSX2P,wmId, MF_BYCOMMAND );
					break;
*/
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			g_hwndCB = CreateRpCommandBar(hWnd);
//			ShowMenuBar(false);
			break;
		case WM_PAINT:
			DoPaint(hWnd);
			break; 
		case WM_CLOSE:
			ExitNow = 1;
			ResumeThread( hThread );
			WaitForSingleObject( hThread, 100 );
			CloseHandle(hThread);
			hThread = NULL;
			SaveOption();
			CommandBar_Destroy(g_hwndCB);
#ifdef WIN32_PLATFORM_PSPC
			GXCloseInput();
#endif
			DestroyWindow(hWnd);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
/*
		case WM_KEYDOWN:
			KeyDown(key);
			break;
		case WM_KEYUP:
			KeyUp(wParam);
			break;
*/
		case WM_LBUTTONDOWN:
			x = LOWORD(lParam);
			y = HIWORD(lParam);
			if( num = DownSoftKey( x, y ) ){
				GUICommand( num );
			}
			break;
        case WM_LBUTTONUP:
            x = LOWORD(lParam); 
			y = HIWORD(lParam); 
			UpSoftKey( x , y );
			break;
		case WM_ACTIVATE:
			switch( LOWORD(wParam) )
			{
				case WA_ACTIVE:
				case WA_CLICKACTIVE:
					break;
				case WA_INACTIVE:
					ShowMenuBar(true);
					break;
			}
			break;
		case WM_SETTINGCHANGE:
			if ( SETTINGCHANGE_RESET == wParam ){
				DEVMODE devMode;
				devMode.dmSize = sizeof(DEVMODE);
				devMode.dmFields = DM_DISPLAYORIENTATION;
				devMode.dmOrientation = 0;
				ChangeDisplaySettingsEx(NULL,&devMode,NULL,CDS_TEST,NULL);	/* ݂̉ʕ擾 */
				Orientation = devMode.dmDisplayOrientation;	/* 0:c 1:(E) 2:c(t?) 4:() */ 
				screen_x = GetSystemMetrics(SM_CXSCREEN);
				screen_y = GetSystemMetrics(SM_CYSCREEN);
				ChangeSkin(0);
			}
			break;
		case WM_APP_COMMAND:
			GUICommand( LOWORD(wParam) );
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

void GUICommand( int cmd )
{
	HMENU hMenu;

	switch( cmd ){
	case GUI_START:
		ShowMenuBar(false);
		start_msx();
		break;
	case GUI_RESET:
		ResetZ80(&CPU);
		break;
	case GUI_EXIT:
		SendMessage (g_hWnd, WM_CLOSE, 0, 0);
		break;
	case GUI_SEL_CART1:
		{
			char * fn;
			fn = OpenFileDlg(g_hWnd, 0);
			if( fn ){
				if( ROMName[0] ) free( ROMName[0] );
				ROMName[0] = fn;
			}
		}
		break;
	case GUI_SEL_CART2:
		{
			char * fn;
			fn = OpenFileDlg(g_hWnd, 0);
			if( fn ){
				if( ROMName[1] ) free( ROMName[1] );
				ROMName[1] = fn;
			}
		}
		break;
	case GUI_SEL_DISKA:
		{
			char * fn;
			fn = OpenFileDlg(g_hWnd, 1);
			if( fn ){
				if( DSKName[0] ) free( DSKName[0] );
				DSKName[0] = fn;
			}
		}
		if( thread_running ) ChangeDisk(0,DSKName[0]);
		break;
	case GUI_SEL_DISKB:
		{
			char * fn;
			fn = OpenFileDlg(g_hWnd, 1);
			if( fn ){
				if( DSKName[1] ) free( DSKName[1] );
				DSKName[1] = fn;
			}
		}
		if( thread_running ) ChangeDisk(1,DSKName[1]);
		break;
	case GUI_SEL_CAS:
		{
			char * fn;
			fn = OpenFileDlg(g_hWnd, 2);
			if( fn ){
				if( CasName ) free( CasName );
				CasName = fn;
			}
		}
		if( CasName ) ChangeCas(CasName);
		break;
	case GUI_CAS_PREV: CasPrev(); break;
	case GUI_CAS_NEXT: CasNext(); break;
	case GUI_CAS_TOP : CasTop();  break;
	case GUI_CAS_END : CasEnd();  break;
	case GUI_MISC:
		DialogBox(g_hInst, (LPCTSTR)IDD_SETUP, g_hWnd, (DLGPROC)DLGMisc);
		break;
	case GUI_SOUND:
		DialogBox(g_hInst, (LPCTSTR)IDD_SOUND, g_hWnd, (DLGPROC)DLGSound);
		break;
//	case GUI_JOYSTICK: DialogBox(g_hInst, (LPCTSTR)IDD_JOYSTICK, hWnd, (DLGPROC)DLGJoystick); break;
/*	case GUI_SOFTKEYBOARD: 
		DialogBox(g_hInst, (LPCTSTR)IDD_SOFTKEY, g_hWnd, (DLGPROC)DLGSoftKey);
		InvalidateRect( g_hWnd, NULL, FALSE );
		break; */
	case GUI_PATH:
		DialogBox(g_hInst, (LPCTSTR)IDD_PATH, g_hWnd, (DLGPROC)DLGPath);
		break;
	case GUI_KEYCHECK:
		DialogBox(g_hInst, (LPCTSTR)IDD_KEYCHECK, g_hWnd, (DLGPROC)DLGKeyCheck);
		break;
	case GUI_DEBUG:
		ShowMenuBar(false);
		DialogBox(g_hInst, (LPCTSTR)IDD_DEBUG, g_hWnd, (DLGPROC)DLGDebug);
		break;
	case GUI_MENU:
		ShowMenuBar(!CommandBarVis);
		break;
	case GUI_NEXTSKIN:
		NextSkin();
		break;
	case GUI_LOAD:
		{
			char * fn;
			fn = OpenFileDlg(g_hWnd, 3);
			if( fn ){
				if( StateName ) free( StateName );
				StateName = fn;
			}
		}
		if( thread_running ) LoadState(StateName);
		break;
	case GUI_LOAD_1:
	case GUI_LOAD_2:
	case GUI_LOAD_3:
	case GUI_LOAD_4:
	case GUI_LOAD_5:
	case GUI_LOAD_6:
	case GUI_LOAD_7:
	case GUI_LOAD_8:
	case GUI_LOAD_9:
		if( StateName ) free( StateName );
		StateName = (char*)malloc( 256 );
		strcpy( StateName, ProgDir );
		if( StaDir != NULL ) sprintf( StateName, "%s\\%s",StateName, StaDir );
		sprintf( StateName, "%s\\fmsxSE%02d.STA", StateName, cmd - GUI_LOAD_1 );
		if( thread_running ){
			if(! LoadState( StateName ) ){
				MessageBox( g_hWnd,_T("State Load Error"),_T("Error"),MB_OK );
			}
			ShowMenuBar(false);
		}
		break;
	case GUI_SAVE:
		{
			char * fn;
			fn = SaveFileDlg(g_hWnd, 3);
			if( fn ){
				if( StateName ) free( StateName );
				StateName = fn;
			}
		}
		if( thread_running ) SaveState(StateName);
		break;
	case GUI_SAVE_1:
	case GUI_SAVE_2:
	case GUI_SAVE_3:
	case GUI_SAVE_4:
	case GUI_SAVE_5:
	case GUI_SAVE_6:
	case GUI_SAVE_7:
	case GUI_SAVE_8:
	case GUI_SAVE_9:
		if( StateName ) free( StateName );
		StateName = (char*)malloc( 256 );
		strcpy( StateName, ProgDir );
		if( StaDir != NULL ) sprintf( StateName, "%s\\%s",StateName, StaDir );
		sprintf( StateName, "%s\\fmsxSE%02d.STA", StateName, cmd - GUI_SAVE_1 );
		if( thread_running ){
			if(! SaveState( StateName ) ){
				MessageBox( g_hWnd,_T("State Save Error"),_T("Error"),MB_OK );
			}
			ShowMenuBar(false);
		}
		break;
	}		
}

void OpenDialog( LPCTSTR id, DLGPROC proc )
{
	DialogBox(g_hInst, (LPCTSTR)IDD_SETUP, g_hWnd, (DLGPROC)DLGMisc);
}


int ShowMenuBar(int flg)
{
	DWORD f;
	BOOL  s;
	if( CommandBarVis == flg ) return 0;
	if( flg ){
		f = SHFS_SHOWTASKBAR | SHFS_SHOWSIPBUTTON | SHFS_SHOWSTARTICON;
		if( hThread ){
			SuspendThread( hThread );
//			GXSuspend();
		}
	}else{
		f = SHFS_HIDETASKBAR | SHFS_HIDESIPBUTTON | SHFS_HIDESTARTICON;
		if( hThread ){
			ResumeThread( hThread );
//			GXResume();
		}
	}
	SHFullScreen(g_hWnd, f );
	CommandBar_Show( g_hwndCB, flg );
	CommandBarVis = flg;
	return 0;
}

HWND CreateRpCommandBar(HWND hwnd)
{
#ifdef WIN32_PLATFORM_PSPC
	SHMENUBARINFO mbi;
    HMENU hmn;
	MENUITEMINFO mi;

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hwnd;
	mbi.nToolBarId = IDM_MENU;
	mbi.hInstRes   = g_hInst;
	mbi.nBmpId     = 0;
	mbi.cBmpImages = 0;
	if (!SHCreateMenuBar(&mbi)) return NULL;
/*
	hmn = (HMENU)SendMessage( mbi.hwndMB, SHCMBM_GETSUBMENU, 0, IDM_MENU );
	CheckMenuRadioItem(hmn, ID_MENUMSX1,ID_MENUMSX2P,(MSXVersion+ID_MENUMSX1), MF_BYCOMMAND );
	GetMenuItemInfo(hmn,ID_MENUVERBOSE,FALSE,&mi);
	mi.fState = (Verbose? MFS_CHECKED : MFS_UNCHECKED);
	SetMenuItemInfo(hmn,ID_MENUVERBOSE,FALSE,&mi);
//	CheckMenuItem(hmn, ID_MENUVERBOSE, MF_BYCOMMAND | (Verbose? MF_CHECKED : MF_UNCHECKED) );
	if(!bmpSkin) EnableMenuItem(hmn,ID_MENU_SOFTKEYBOARD,MF_GRAYED);
#ifndef DEBUG
    EnableMenuItem(hmn,ID_MENU_DEBUG,MF_GRAYED);
#endif
*/
	CommandBarVis = true;
	return mbi.hwndMB;
#else	
	HWND hcb;
	BOOL res;
    HMENU hmn;

    hcb = CommandBar_Create( g_hInst, hwnd, 1 );
	res = CommandBar_InsertMenubar( hcb, g_hInst, IDM_MENU, 0 );	
    hmn = CommandBar_GetMenu( hcb, 0 );

	CheckMenuRadioItem(hmn, ID_MENUMSX1,ID_MENUMSX2P,(MSXVersion+ID_MENUMSX1), MF_BYCOMMAND );
	CheckMenuItem(hmn, ID_MENUVERBOSE, MF_BYCOMMAND | (Verbose? MF_CHECKED : MF_UNCHECKED) );
	if(!bmpSkin) EnableMenuItem(hmn,ID_MENU_SOFTKEYBOARD,MF_GRAYED);
#ifndef DEBUG
    EnableMenuItem(hmn,ID_MENU_DEBUG,MF_GRAYED);
#endif        
	return hcb;
#endif
}

char * SaveFileDlg(HWND hWnd, int flg)
{
	TCHAR szFileName[256];
	TCHAR szDir[256];
	TCHAR *filter[] = {  _T("Cart Files(*.rom)\0*.rom\0All files (*.*)\0*.*\0") ,
						_T("Disk Files(*.dsk)\0*.dsk\0All files (*.*)\0*.*\0") ,
						_T("Casette Files(*.cas)\0*.cas\0All files (*.*)\0*.*\0"),
						_T("State Files(*.sta)\0*.sta\0All files (*.*)\0*.*\0") };
	char buf[256];
	char * fname = NULL;
	
	int ret;
	OPENFILENAME ofn;

	LOG( "OpenFileDlg Start\n" );

	szFileName[0] = 0;
	szDir[0] = 0;

	strcpy( buf, ProgDir );
	switch( flg ){
	case 0:
		if( RomDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, RomDir );
		}
		break;
	case 1:
		if( DskDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, DskDir );
		}
		break;
	case 2:
		if( CasDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, CasDir );
		}
		break;
	case 3:
		if( StaDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, StaDir );
		}
		break;
	}

	mbstowcs( szDir, buf,255 );	
	memset(&ofn,0,sizeof(ofn));

    LOG( "SaveFileDlg 1\n" );

	ofn.lpstrFilter = filter[flg];
	ofn.hwndOwner   = hWnd;
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile	= szFileName;
	ofn.nMaxFile	= 256;
	ofn.Flags       = 0;
	if(szDir[0]) ofn.lpstrInitialDir = szDir;
	LOG( "SaveFileDlg 2\n" );

	// display a open file dialog
	{
        int gsflg = 0;
        HINSTANCE hInst = LoadLibrary(_T("gsgetfile.dll"));
		if (hInst) {
			BOOL (*gsGetSaveFileName)(OPENFILENAME* );
            LOG( "gsGetile.dll is Loaded!" );
			gsGetSaveFileName = (BOOL (__cdecl *)(OPENFILENAME *)) GetProcAddress(hInst, _T("gsGetSaveFileName"));
			if (gsGetSaveFileName) {
				ret = gsGetSaveFileName(&ofn);
                gsflg = 1;
            } else {
                LOG( "GetProcAddress error. func[gsGetSaveFileName] ErrorNum[%d]\n",GetLastError() );
            }
			FreeLibrary(hInst);
        }else{
            LOG( "gsGetFile.dll is not use.\n" );
        }
        if( !gsflg ){
            ret = GetSaveFileName(&ofn);
        }
    }
	LOG( "SaveFileDlg 3\n" );

	if( ret ){
		LOG( "SaveFileDlg 4\n" );
		fname = (char*)malloc(wcslen(szFileName)*2+1);
		// UNICODE -> char
    	wcstombs(fname, szFileName, wcslen(szFileName)*2);
        LOG( "Select file is [%s]\n", fname );
    }

	return fname;

	LOG( "SaveFileDlg END\n" );
}

char * OpenFileDlg(HWND hWnd, int flg)
{
	TCHAR szFileName[256];
	TCHAR szDir[256];
	TCHAR *filter[] = {  _T("Cart Files(*.rom)\0*.rom\0All files (*.*)\0*.*\0") ,
						_T("Disk Files(*.dsk)\0*.dsk\0All files (*.*)\0*.*\0") ,
						_T("Casette Files(*.cas)\0*.cas\0All files (*.*)\0*.*\0"),
						_T("State Files(*.sta)\0*.sta\0All files (*.*)\0*.*\0") };
	char buf[256];
	char * fname = NULL;
	int ret;
	OPENFILENAME ofn;

	LOG( "OpenFileDlg Start\n" );

	szFileName[0] = 0;
	szDir[0] = 0;

	strcpy( buf, ProgDir );
	switch( flg ){
	case 0:
		if( RomDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, RomDir );
		}
		break;
	case 1:
		if( DskDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, DskDir );
		}
		break;
	case 2:
		if( CasDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, CasDir );
		}
		break;
	case 3:
		if( StaDir != NULL ){
		    strcat( buf, "\\" );
			strcat( buf, StaDir );
		}
		break;
	}

	mbstowcs( szDir, buf,255 );	
	memset(&ofn,0,sizeof(ofn));

    LOG( "OpenFileDlg 1\n" );

	ofn.lpstrFilter = filter[flg];
	ofn.hwndOwner   = hWnd;
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile	= szFileName;
	ofn.nMaxFile	= 256;
	ofn.Flags       = 0;
	if(szDir[0]) ofn.lpstrInitialDir = szDir;
	LOG( "OpenFileDlg 2\n" );

	// display a open file dialog
	{
        int gsflg = 0;
        HINSTANCE hInst = LoadLibrary(_T("gsgetfile.dll"));
		if (hInst) {
			BOOL (*gsGetOpenFileName)(OPENFILENAME* );
            LOG( "gsGetile.dll is Loaded!" );
			gsGetOpenFileName = (BOOL (__cdecl *)(OPENFILENAME *)) GetProcAddress(hInst, _T("gsGetOpenFileName"));
			if (gsGetOpenFileName) {
				ret = gsGetOpenFileName(&ofn);
                gsflg = 1;
            } else {
                LOG( "GetProcAddress error. func[gsGetOpenFileName] ErrorNum[%d]\n",GetLastError() );
            }
			FreeLibrary(hInst);
        }else{
            LOG( "gsGetFile.dll is not use.\n" );
        }
        if( !gsflg ){
            ret = GetOpenFileName(&ofn);
        }
    }
	LOG( "OpenFileDlg 3\n" );

	if( ret ){
		LOG( "OpenFileDlg 4\n" );
		fname = (char*)malloc(wcslen(szFileName)*2+1);
		// UNICODE -> char
    	wcstombs(fname, szFileName, wcslen(szFileName)*2);
        LOG( "Select file is [%s]\n", fname );
	}

	return fname;

	LOG( "OpenFileDlg END\n" );
}

void DoPaint(HWND hWnd)
{
	HDC hdc;
	PAINTSTRUCT ps;
	hdc = BeginPaint(hWnd, &ps);
	DrawSkin(hWnd,hdc);
	EndPaint(hWnd, &ps);
}

int thread_msx()
{
  HMENU hMenu;

  LOG("thread start\n");
  CPU.Trace=0;

#ifdef DEBUG
  CPU.Trap=0xFFFF;CPU.Trace=0;
#endif

  /* Start fMSX! */
  if(!InitMachine()){
	  LOG("start_msx error end [InitMachine err]\n");
	  return(1);
  }

  LOG("StartMSXĂяoO\n");
  StartMSX();
  TrashMSX();
  TrashMachine();
  LOG("start_msx exit\n");
  thread_running = FALSE;
  return(0);
}

int start_msx()
{
	DWORD rc;

	if( !thread_running ){
		thread_running = TRUE;
		if( hThread ) CloseHandle(hThread);
		hThread = CreateThread(NULL, 
			0,		// stack size (ignored)
			(LPTHREAD_START_ROUTINE)thread_msx,	// Thread function
			0,		// 32 bit parameter passed to thread
			0,		// Creation flags (0 = start thread immediately)
			&rc);	// Receives thread ID
	}
	return 0;
}	

/*
void setJoyPara( HWND hDlg,int str , int cnt )
{
	TCHAR buf[16];
	char mbs[16];
	char mbs2[32];

	strcpy(mbs2,"0x");
	GetDlgItemText( hDlg,str,buf,16 );
	wcstombs(mbs,buf,16);
	strcat(mbs2,mbs);
	Joys[0].Code = atoi(mbs2);
}
*/
// Mesage handler for the Joystick Config box.
/*
LRESULT CALLBACK DLGJoystick(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int flg;
	TCHAR buf[16];
	switch (message)
	{
		case WM_INITDIALOG:
			if( JoyTypeA == 1 ) flg = BST_CHECKED;
			else flg= BST_UNCHECKED;
			SendDlgItemMessage(hDlg,IDC_CHKJOY1,BM_SETCHECK,flg,0);
			if( JoyTypeB == 1 ) flg = BST_CHECKED;
			else flg= BST_UNCHECKED;
			SendDlgItemMessage(hDlg,IDC_CHKJOY2,BM_SETCHECK,flg,0);
			SetDlgItemInt( hDlg,IDC_EDTUP1   ,Joys[ 0].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTDOWN1 ,Joys[ 1].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTLEFT1 ,Joys[ 2].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTRIGHT1,Joys[ 3].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTA1    ,Joys[ 4].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTB1    ,Joys[ 5].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTUP2   ,Joys[ 6].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTDOWN2 ,Joys[ 7].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTLEFT2 ,Joys[ 8].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTRIGHT2,Joys[ 9].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTA2    ,Joys[10].Code,0 );
			SetDlgItemInt( hDlg,IDC_EDTB2    ,Joys[11].Code,0 );
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				JoyTypeA = (SendDlgItemMessage(hDlg,IDC_CHKJOY1,BM_GETCHECK,0,0)==BST_CHECKED)?1:0;
				JoyTypeB = (SendDlgItemMessage(hDlg,IDC_CHKJOY2,BM_GETCHECK,0,0)==BST_CHECKED)?1:0;
//				JoyTypeA = GetDlgItemInt(hDlg,IDC_CHKJOY1,&res,TRUE);
//				JoyTypeB = (IsDlgButtonChecked(HWND hDlg,IDC_CHKJOY2)?1:0);
				Joys[ 0].Code = GetDlgItemInt( hDlg, IDC_EDTUP1   , NULL, FALSE );
				Joys[ 1].Code = GetDlgItemInt( hDlg, IDC_EDTDOWN1 , NULL, FALSE );
				Joys[ 2].Code = GetDlgItemInt( hDlg, IDC_EDTLEFT1 , NULL, FALSE );
				Joys[ 3].Code = GetDlgItemInt( hDlg, IDC_EDTRIGHT1, NULL, FALSE );
				Joys[ 4].Code = GetDlgItemInt( hDlg, IDC_EDTA1    , NULL, FALSE );
				Joys[ 5].Code = GetDlgItemInt( hDlg, IDC_EDTB1    , NULL, FALSE );
				Joys[ 6].Code = GetDlgItemInt( hDlg, IDC_EDTUP2   , NULL, FALSE );
				Joys[ 7].Code = GetDlgItemInt( hDlg, IDC_EDTDOWN2 , NULL, FALSE );
				Joys[ 8].Code = GetDlgItemInt( hDlg, IDC_EDTLEFT2 , NULL, FALSE );
				Joys[ 9].Code = GetDlgItemInt( hDlg, IDC_EDTRIGHT2, NULL, FALSE );
				Joys[10].Code = GetDlgItemInt( hDlg, IDC_EDTA2    , NULL, FALSE );
				Joys[11].Code = GetDlgItemInt( hDlg, IDC_EDTB2    , NULL, FALSE );
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
*/
// Mesage handler for the Software Keyboard Config box.
/*
LRESULT CALLBACK DLGSoftKey(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			SendDlgItemMessage( hDlg, IDC_SPIN_SKEY_X, UDM_SETRANGE, 0, (WPARAM)MAKELONG(480,0) );
			SendDlgItemMessage( hDlg, IDC_SPIN_SKEY_Y, UDM_SETRANGE, 0, (WPARAM)MAKELONG(640,0) );
			SendDlgItemMessage( hDlg, IDC_USESOFTKEYBOARD, BM_SETCHECK, UseSOFTKEY, 0 );   // softkeyboard  
			SetDlgItemInt( hDlg, IDC_EDIT_LEFT , SoftKeyLeft, FALSE );
			SetDlgItemInt( hDlg, IDC_EDIT_TOP  , SoftKeyTop , FALSE );
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				UseSOFTKEY  = SendDlgItemMessage(hDlg,IDC_USESOFTKEYBOARD,BM_GETCHECK,0,0);
				SoftKeyLeft = GetDlgItemInt( hDlg, IDC_EDIT_LEFT, NULL, FALSE );
				SoftKeyTop  = GetDlgItemInt( hDlg, IDC_EDIT_TOP , NULL, FALSE );
				EndDialog(hDlg, LOWORD(wParam));
//        ReadKeyBind((UseSOFTKEY?SoftKeyRCFile:KeyRCFile),Keys);
        return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
*/
// Mesage handler for the Misc Config box.
LRESULT CALLBACK DLGMisc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			SetDlgItemInt( hDlg, IDC_UPERIOD , UPeriod, FALSE );
			SetDlgItemInt( hDlg, IDC_VPERIOD , VPeriod, FALSE );
			SetDlgItemInt( hDlg, IDC_HPERIOD , HPeriod, FALSE );
			SendDlgItemMessage( hDlg, IDC_SPIN_VIEW_X, UDM_SETRANGE, 0, (WPARAM)MAKELONG(480,-256) );
			SendDlgItemMessage( hDlg, IDC_SPIN_VIEW_Y, UDM_SETRANGE, 0, (WPARAM)MAKELONG(640,-256) );
//			SetDlgItemInt( hDlg, IDC_VIEW_X  , View_x , TRUE );
//			SetDlgItemInt( hDlg, IDC_VIEW_Y  , View_y , TRUE );
//			SendDlgItemMessage( hDlg, IDC_NARROW  ,  BM_SETCHECK, UseNarrow, 0 );       // Narrow Mode 
//			SendDlgItemMessage( hDlg, IDC_x2MODE  ,  BM_SETCHECK, Usex2Mode, 0 );       // x2 Mode 
//			SendDlgItemMessage( hDlg, IDC_INTERLESS, BM_SETCHECK, UseInterless, 0 );    // Interless 
//			SendDlgItemMessage( hDlg, IDC_DRAWBORDER,BM_SETCHECK, UseDrawBorder, 0 );   // Draw border 
//			SendDlgItemMessage( hDlg, IDC_SPOVRCHK,  BM_SETCHECK, UseSpriteOver, 0 );   // Sprite Over Check 
//			SendDlgItemMessage( hDlg, IDC_AUTORUN ,  BM_SETCHECK, UseAutoRun, 0 );      // Auto run 
			SendDlgItemMessage( hDlg, IDC_VERBOSE ,  BM_SETCHECK, Verbose, 0 );         // Verbose 

            SendDlgItemMessage( hDlg, IDC_REMOVECART, BM_SETCHECK, RemoveCart, 0 );		// Remove Cart 
			SendDlgItemMessage( hDlg, IDC_REMOVEDISK, BM_SETCHECK, RemoveDisk, 0 );		// Remove Disk 
			SendDlgItemMessage( hDlg, IDC_REMOVECAS,  BM_SETCHECK, RemoveCas,  0 );		// Remove Cas 

			SendDlgItemMessage( hDlg, IDC_CMB_MSXVERSION, CB_ADDSTRING,0,(LPARAM)_T("MSX1") );
            SendDlgItemMessage( hDlg, IDC_CMB_MSXVERSION, CB_ADDSTRING,0,(LPARAM)_T("MSX2") );
            SendDlgItemMessage( hDlg, IDC_CMB_MSXVERSION, CB_ADDSTRING,0,(LPARAM)_T("MSX2+") );
            SendDlgItemMessage( hDlg, IDC_CMB_MSXVERSION, CB_SETCURSEL,MSXVersion,0);	// MSX Version

            return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				UPeriod = GetDlgItemInt( hDlg, IDC_UPERIOD, NULL, FALSE );
				VPeriod = GetDlgItemInt( hDlg, IDC_VPERIOD, NULL, FALSE );
				HPeriod = GetDlgItemInt( hDlg, IDC_HPERIOD, NULL, FALSE );
//				View_x  = GetDlgItemInt( hDlg, IDC_VIEW_X , NULL, TRUE );
//				View_y  = GetDlgItemInt( hDlg, IDC_VIEW_Y , NULL, TRUE );
//				UseNarrow     = SendDlgItemMessage( hDlg, IDC_NARROW,    BM_GETCHECK,0,0 );
//				Usex2Mode     = SendDlgItemMessage( hDlg, IDC_x2MODE,    BM_GETCHECK,0,0 );
//				UseInterless  = SendDlgItemMessage( hDlg, IDC_INTERLESS, BM_GETCHECK,0,0 );
//				UseDrawBorder = SendDlgItemMessage( hDlg, IDC_DRAWBORDER,BM_GETCHECK,0,0 );
//				UseSpriteOver = SendDlgItemMessage( hDlg, IDC_SPOVRCHK,  BM_GETCHECK,0,0 );
//			    UseAutoRun    = SendDlgItemMessage( hDlg, IDC_AUTORUN,   BM_GETCHECK,0,0 );   // Auto run 
			    Verbose       = (byte)SendDlgItemMessage( hDlg, IDC_VERBOSE,   BM_GETCHECK,0,0 );   // Verbose 

                RemoveCart = SendDlgItemMessage( hDlg, IDC_REMOVECART, BM_GETCHECK,0 ,0 );   // Remove Cart 
			    RemoveDisk = SendDlgItemMessage( hDlg, IDC_REMOVEDISK, BM_GETCHECK,0 ,0 );   // Remove Disk 
			    RemoveCas  = SendDlgItemMessage( hDlg, IDC_REMOVECAS,  BM_GETCHECK,0 ,0 );   // Remove Cas 

	            MSXVersion = (byte)SendDlgItemMessage( hDlg, IDC_CMB_MSXVERSION, CB_GETCURSEL,0,0);  // MSX Version

				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
// Mesage handler for the Sound Config box.
LRESULT CALLBACK DLGSound(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int sel;
	switch (message)
	{
		case WM_INITDIALOG:
//			SendDlgItemMessage( hDlg, IDC_SOUNDENABLE , BM_SETCHECK, UseSOUND,  0 );   // Sound enable 
			SendDlgItemMessage( hDlg, IDC_PSG         , BM_SETCHECK, UsePSG,    0 );   // PSG 
			SendDlgItemMessage( hDlg, IDC_SCC         , BM_SETCHECK, UseSCC,    0 );   // SCC  
			SendDlgItemMessage( hDlg, IDC_FMPAC       , BM_SETCHECK, Use2413,   0 );   // FMPAC
			SendDlgItemMessage( hDlg, IDC_MSXAUDIO    , BM_SETCHECK, Use8950,   0 );   // MSX-AUDIO 
	        SendDlgItemMessage( hDlg, IDC_STEREO      , BM_SETCHECK, UseStereo, 0 );   // STEREO 
            SendDlgItemMessage( hDlg, IDC_CMB_SAMPLERATE, CB_ADDSTRING,0,(LPARAM)_T("0") );
            SendDlgItemMessage( hDlg, IDC_CMB_SAMPLERATE, CB_ADDSTRING,0,(LPARAM)_T("11025") );
            SendDlgItemMessage( hDlg, IDC_CMB_SAMPLERATE, CB_ADDSTRING,0,(LPARAM)_T("22050") );
            SendDlgItemMessage( hDlg, IDC_CMB_SAMPLERATE, CB_ADDSTRING,0,(LPARAM)_T("44100") );
			switch( UseSound ){
			case 11025: sel = 1;break;
			case 22050: sel = 2;break;
			case 44100: sel = 3;break;
			default:    sel = 0;break;
			}
            SendDlgItemMessage( hDlg, IDC_CMB_SAMPLERATE, CB_SETCURSEL,sel,0);
//			SetDlgItemInt( hDlg, IDC_SAMPLERATE , UseSound, FALSE );
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
//				UseSOUNDENABLE = SendDlgItemMessage( hDlg, IDC_SOUNDENABLE, BM_GETCHECK,0,0 );
				UsePSG         = SendDlgItemMessage( hDlg, IDC_PSG        , BM_GETCHECK,0,0 );
				UseSCC         = SendDlgItemMessage( hDlg, IDC_SCC        , BM_GETCHECK,0,0 );
				Use2413        = SendDlgItemMessage( hDlg, IDC_FMPAC      , BM_GETCHECK,0,0 );
				Use8950        = SendDlgItemMessage( hDlg, IDC_MSXAUDIO   , BM_GETCHECK,0,0 );
				UseStereo      = SendDlgItemMessage( hDlg, IDC_STEREO     , BM_GETCHECK,0,0 );

	            sel = SendDlgItemMessage( hDlg, IDC_CMB_SAMPLERATE, CB_GETCURSEL,0,0);
				switch( sel ){
				case 1: UseSound = 11025;break;
				case 2: UseSound = 22050;break;
				case 3: UseSound = 44100;break;
				default:UseSound = 0;break;
				}
//				UseSound       = GetDlgItemInt( hDlg, IDC_SAMPLERATE , NULL, FALSE );
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

#define	SETTEXT( __AA, __BB )	\
	if( __AA ){	\
		mbstowcs(tbuf,__AA,255); \
		SendDlgItemMessage( hDlg, __BB, WM_SETTEXT, 0, (LPARAM)tbuf ); \
	}

#define	GETTEXT( __AA, __BB )	\
	len = SendDlgItemMessage( hDlg, __BB , WM_GETTEXTLENGTH, 0,0 );	\
	if( len > 0 ){															\
		if( SkinDir != NULL ) free( __AA );									\
		__AA = (char *)malloc( len + 1 );								\
		SendDlgItemMessage( hDlg, __BB , WM_GETTEXT,(WPARAM)255,(WPARAM)tbuf );	\
		wcstombs(__AA,tbuf,255);	\
	}

// Mesage handler for the Path Config box.
LRESULT CALLBACK DLGPath(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int sel;
	TCHAR tbuf[256];
	switch (message)
	{
		case WM_INITDIALOG:
			SETTEXT( SkinDir, IDC_SKINDIR );	// Skin dir
			SETTEXT( BiosDir, IDC_BIOSDIR );	// Bios dir
			SETTEXT( RomDir,  IDC_ROMDIR );		// ROM dir
			SETTEXT( DskDir,  IDC_DISKDIR );	// DISK dir
			SETTEXT( CasDir,  IDC_CASDIR );		// CAS dir
			SETTEXT( StaDir,  IDC_STATEDIR );	// State dir
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				int len;
				GETTEXT( SkinDir, IDC_SKINDIR );	// Skin dir
				GETTEXT( BiosDir, IDC_BIOSDIR );	// Bios dir
				GETTEXT( RomDir,  IDC_ROMDIR );		// ROM dir
				GETTEXT( DskDir,  IDC_DISKDIR );	// DISK dir
				GETTEXT( CasDir,  IDC_CASDIR );		// CAS dir
				GETTEXT( StaDir,  IDC_STATEDIR );	// State dir
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			} if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

void view_reg(HWND hDlg, Z80 *R) 
{                        
    static char Flags[9] = "SZ.H.PNC";
    char T[16];
    char buf[128];
    TCHAR tbuf[128];
    int I,J;
    for(J=0,I=R->AF.B.l;J<8;J++,I<<=1) T[J]=I&0x80? Flags[J]:'.';
    T[8]='\0';
    sprintf
      ( buf,"AF:%04X\r\nHL:%04X\r\nDE:%04X\r\nBC:%04X\r\nSP:%04X\r\nIX:%04X\r\nIY:%04X\r\nI :%02X\r\n"
            "PC:%04X\r\nFLGS:%s\r\n%s: %s",
        R->AF.W,R->HL.W,R->DE.W,R->BC.W,R->SP.W,R->IX.W,R->IY.W,R->I,
        R->PC.W,T,
        R->IFF&0x04? "IM2":R->IFF&0x02? "IM1":"IM0", R->IFF&0x01? "EI":"DI"
      ); 
    mbstowcs(tbuf,buf,128);
    SetDlgItemText( hDlg,IDC_REG,tbuf );
/*
    sprintf
      ( buf,"AT PC: [%02X]   AT SP: [%04X]   FLAGS: [%s]   %s: %s\r\n\r\n",
        RdZ80(R->PC.W),RdZ80(R->SP.W)+RdZ80(R->SP.W+1)*256,T,
        R->IFF&0x04? "IM2":R->IFF&0x02? "IM1":"IM0", R->IFF&0x01? "EI":"DI"
      );
    mbstowcs(tbuf,buf,128);
    SetDlgItemText( hDlg,IDC_CONSOLE,tbuf );
*/
}

HWND Debug_hDlg;

void view_reg2(Z80 *R) 
{
	if( Debug_hDlg ){
		view_reg( Debug_hDlg, R);
	}
}

void putcon( HWND hDlg, char * buf )
{
    TCHAR tbuf[128];
    mbstowcs(tbuf,buf,128);
    SendDlgItemMessage(hDlg, IDC_CONSOLE, EM_REPLACESEL,FALSE,(LPARAM)tbuf );
}

extern int DAsm(char *S,word A);

word Addr;
int rflg = 1;

// Mesage handler for the Sound Config box.
LRESULT CALLBACK DLGDebug(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{

	switch (message)
	{
		case WM_INITDIALOG:
			Debug_hDlg = hDlg;
			break;
	    case WM_COMMAND:
		    if (LOWORD(wParam) == IDC_TRAP) {
                CPU.Trace=1;
                view_reg(hDlg,&CPU);
                break;
            }   
            if( LOWORD(wParam) == IDCANCEL) {
                CPU.Trap=0xFFFF;CPU.Trace=0;
				Debug_hDlg = NULL;
                EndDialog(hDlg, LOWORD(wParam));
                break;
            }
            if( LOWORD(wParam) == IDOK) {
                TCHAR tbuf[128];
                char buf[256];
                int J;
                Z80 *R = &CPU;

                GetDlgItemText( hDlg, IDC_DBG_CMD, tbuf, 128 );
                wcstombs(buf,tbuf,128);
                
                for(J=0;buf[J]>=' ';J++)
                  buf[J]=toupper(buf[J]);
                buf[J]='\0';

                switch(buf[0])
                {
                  case 'H':
                  case '?':
                    putcon(hDlg,"***** Built-in Z80 Debugger Commands *****\r\n");
                    putcon(hDlg,"<CR>       : Break at next instruction\r\n");
                    putcon(hDlg,"= <addr>   : Break at addr\r\n");
                    putcon(hDlg,"+ <offset> : Break at PC + offset\r\n");
                    putcon(hDlg,"c          : Continue without break\r\n");
                    putcon(hDlg,"j <addr>   : Continue from addr\r\n");
                    putcon(hDlg,"m <addr>   : Memory dump at addr\r\n");
                    putcon(hDlg,"d <addr>   : Disassembly at addr\r\n");
                    putcon(hDlg,"?,h        : Show this help text\r\n");
                    break;
                  case '\0': R->Trap=0xFFFF;
                             R->Trace=2;
                            rflg = 1;
                             break;
                  case '=':  if(strlen(buf)>=2){
                               R->Trace=0;
                               R->Trap = atoi(&buf[1]);
                             }
                            rflg = 1;
                             break;
                  case '+':  if(strlen(buf)>=2){
                               R->Trace = atoi(&buf[1]);
                               R->Trap=0xFFFF;
                             }
                            rflg = 1;
                             break;
                  case 'J':  if(strlen(buf)>=2){ 
                               R->PC.W = atoi(&buf[1]);
                               R->Trace=0;
                             }
                            rflg = 1;
                             break;
                  case 'C':  R->Trap=0xFFFF;R->Trace=0; 
                            rflg = 1;
                             break;
                  case 'M':
                    {
                      char S[32];
                      int I;

                      if(strlen(buf)>1) 
                         Addr = atoi( &buf[1] ); 
                      else {
                         if( rflg ) Addr=R->PC.W;
                      }

                      for(J=0;J<16;J++)
                      {
                        sprintf( S, "%04X: ",Addr ) ;
                        putcon(hDlg,S);
                        for(I=0;I<16;I++,Addr++){
                          sprintf(S, "%02X ",RdZ80(Addr));
                          putcon(hDlg, S);
                        }
                        putcon(hDlg, " | ");Addr-=16;
                        for(I=0;I<16;I++,Addr++){
                          S[I] = isprint(RdZ80(Addr))? RdZ80(Addr):'.';
                        }
                        S[16] = '\0';
                        putcon(hDlg,S);
                        putcon(hDlg,"\r\n" );
                      }
                    }
                    rflg = 0;
                    break;

                  case 'D':
                    {
                      char S[64];

                      if(strlen(buf)>1) 
                         Addr = atoi( &buf[1] ); 
                      else {
                         if( rflg ) Addr=R->PC.W;
                      }

                      for(J=0;J<16;J++)
                      {
                        int add, i;
                        char b[10];
                        sprintf(S, "%04X: ",Addr);
                        putcon(hDlg,S);
#ifdef DEBUG
                        add = DAsm(S,Addr);
#endif
                        for(i=0;i<3;i++){
                          if(i<add){
                            sprintf(b,"%02X ",RdZ80(Addr+i));
                          }else{
                            strcpy(b,"   ");
                          }
                          putcon(hDlg,b);
                        }
                        putcon(hDlg,S);
                        putcon(hDlg,"\r\n" );
                        Addr+=add;
                      }
                      putcon(hDlg,"\r\n" );
                    }
                    rflg = 0;
                    break;
                  case 'V':
                      {
                        char buf[64];
                        sprintf( buf,"VDP 00[%02x] 01[%02x] 02[%02x] 03[%02x] 04[%02x] 05[%02x] 06[%02x] 07[%02x]\r\n",
                                   VDP[0],VDP[1],VDP[2],VDP[3],VDP[4],VDP[5],VDP[6],VDP[7]);
                        putcon(hDlg,buf);
                        sprintf( buf,"VDP 08[%02x] 09[%02x] 10[%02x] 11[%02x] 12[%02x] 13[%02x] 14[%02x] 15[%02x]\r\n",
                                   VDP[8],VDP[9],VDP[10],VDP[11],VDP[12],VDP[13],VDP[14],VDP[15]);
                        putcon(hDlg,buf);
                        sprintf( buf,"VDP 16[%02x] 17[%02x] 18[%02x] 19[%02x] 20[%02x] 21[%02x] 22[%02x] 23[%02x]\r\n",
                                   VDP[16],VDP[17],VDP[18],VDP[19],VDP[20],VDP[21],VDP[22],VDP[23]);
                        putcon(hDlg,buf);
                      }
                      break;                       
                }
            }
            break;
        default:
           return FALSE;
    }        
    return TRUE;
}

void CALLBACK TimerProc(HWND hwnd,UINT uMsg,UINT idEvent,DWORD dwTime )
{ 
	TCHAR buf[128];
	TCHAR sbuf[16];	
	int i;

	buf[0]=0;

	for( i=1;i<255;i++ ){
		if( GetAsyncKeyState(i)&0x8000 ) {
			_itow(i,sbuf,10);
			wcscat( buf, sbuf );
			wcscat( buf, _T(",") );
		}
	}
	SetDlgItemText( hwnd,IDC_EDIT1,buf );
}

// Mesage handler for the Key Check Config box.
LRESULT CALLBACK DLGKeyCheck(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
//	TCHAR buf[16];
	switch (message)
	{
		case WM_INITDIALOG:
			SetTimer( hDlg,1,500,TimerProc);
			break;
/*		case WM_PAINT:
			SetDlgItemText( hDlg,IDC_EDIT1   ,_itow(DownKey(0),buf,16)  );
			break;			
/*		case WM_KEYDOWN:
			SetDlgItemText( hDlg,IDC_EDIT1   ,_itow(wParam,buf,16)  );
			break;		
*/
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			if( LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

int GX_init()
{
	DEVMODE devMode;
	devMode.dmSize = sizeof(DEVMODE);
	devMode.dmFields = DM_DISPLAYORIENTATION;
	devMode.dmOrientation = 0;
	ChangeDisplaySettingsEx(NULL,&devMode,NULL,CDS_TEST,NULL);	/* ݂̉ʕ擾 */
	Orientation = devMode.dmDisplayOrientation;	/* 0:c 1:(E) 2:c(t?) 4:() */ 
	if (GXOpenDisplay(g_hWnd, GX_FULLSCREEN) == 0) {			/* Iɏcɖ߂H */
		LOG("GXOpenDisplay Error.\n");
		return FALSE;
	}
	ChangeDisplaySettingsEx(NULL,&devMode,NULL,CDS_RESET,NULL);	/* ̉ʕɖ߂ */ 

	GXOpenInput();
	g_gxdp = GXGetDisplayProperties();
	g_gxkl = GXGetDefaultKeys(GX_NORMALKEYS);

	screen_x = GetSystemMetrics(SM_CXSCREEN);
	screen_y = GetSystemMetrics(SM_CYSCREEN);

	return TRUE;
}

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	{
		TCHAR cmd[512];
		char  cmdline[512];	
		char * bufptr;
		int ret;
		ret = GetModuleFileName(hInstance,cmd,512);
		ret = wcstombs(cmdline,cmd,512); 
		if ((bufptr=strrchr( cmdline, '\\' )) != NULL )*bufptr = '\0';
		ProgDir = (char *) malloc( 512 );
		strcpy( ProgDir, cmdline );
	}
	DELLOG();		// LOG Deleteing
	LOG("fmsxSE start\n");
	LOG("Program Dir [%s]\n",ProgDir);

	LoadOption();
	if( !LoadSkin() ){
		return FALSE;
	}
	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	/* GXLIB initialize */
	if ( !GX_init() ) return FALSE;
	ChangeSkin(0);
	ShowMenuBar(false);

//    hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_fMSXCE);
	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
//		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
//		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
//		}
	}

	LOG("fmsxSE Exit\n");

	return msg.wParam;
}
