/*  gngeo a neogeo emulator
 *  Copyright (C) 2001 Peponas Mathieu
 * 
 *  This program is free software; you can redistribute it and/or modify  
 *  it under the terms of the GNU General Public License as published by   
 *  the Free Software Foundation; either version 2 of the License, or    
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#ifndef _EMU_H_
#define _EMU_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SDL.h"


#define UINT8     unsigned char
#define UINT16    unsigned short
#define UINT32    unsigned long
#define INT8      char
#define INT16     short
#define INT32     long

#define uint8     unsigned char
#define uint16    unsigned short
#define uint32    unsigned long
#define sint8      char
#define sint16     short
#define sint32     long

struct {
    char *game;
    
    UINT16 x_start;
    UINT16 y_start;
    UINT16 res_x;
    UINT16 res_y;
    UINT16 sample_rate;
    UINT16 test_switch;

    UINT8 sound;
    UINT8 snd_st_reg_create;
    UINT8 do_message;
    UINT8 nb_joy;
    UINT8 raster;
    UINT8 debug;
    UINT8 rom_type;
    UINT8 extra_xor;
    Uint8 pal;

    char message[128];
    char fps[4];

    int *p1_key;
    int *p2_key;

    SDL_Joystick *joy[2];
    int *p1_joy;
    int *p2_joy;

} conf;

enum {
    BUT_A = 0,
    BUT_B,
    BUT_C,
    BUT_D,
    BUT_START,
    BUT_COIN,
    KB_UP,
    KB_DOWN,
    KB_LEFT,
    KB_RIGHT
};
enum {
    AXE_X = 6,
    AXE_Y,
    AXE_X_DIR,
    AXE_Y_DIR
};

//config conf;

UINT8 key[SDLK_LAST];
UINT8 *joy_button[2];
INT32 *joy_axe[2];

void debug_loop(void);
void main_loop(void);
void init_neo(char *rom_name);
void cpu_68k_dpg_step(void);

#ifdef ENABLE_PROFILER
#define PROFILER_START profiler_start
#define PROFILER_STOP profiler_stop

#else
#define PROFILER_START(a)
#define PROFILER_STOP(a)
#endif

#define strdup _strdup
#define strcasecmp _stricmp
#define strncasecmp _strnicmp
#define snprintf _snprintf

extern char * DATA_DIRECTORY;


/* LOG generation */
//#define GNGEO_LOG(...)
//#define GNGEO_LOG printf

#endif
