#include <windows.h>

extern "C" {

#include "..\..\defs.h"
#include "..\..\rc.h"
#include "..\..\fb.h"
#include "..\..\input.h"
#include "..\..\debug.h"
void die(char *fmt, ...);
void DEBUGLOG( char * str , ... );
void joy_init();
void joy_close();
void joy_poll();
void setHWND(HWND w);
int setkeymap();

int keymap[256];

static HWND wnd;

#define landscapemode(screenmode) (screenmode & 0x1)

void create_video_buffer();
void DebugPrint( int x, int y,wchar_t * buf );
void ScrollDebugPrint( int x,int w, wchar_t * buf );

static void paint240x216(word *vram, int landscape);
static void paint240x216s(word *vram, int landscape);
static void paint320x216();
//extern int scale;
//extern int density;
extern int rc_command(char *line);

/*
 * process graphics
 */

static int screenmode = 0;
static int frameskip = 3;
int view_top = 24;
int popope = 0;

static int sc1   = 0;
static int sc1_x = 0;
static int sc1_y = 0;
static int sc1_l = 0;
static int sc1_t = 0;
static int sc1_w = 0;
static int sc1_h = 0;
static int sc2   = 0;
static int sc2_x = 0;
static int sc2_y = 0;
static int sc2_l = 0;
static int sc2_t = 0;
static int sc2_w = 0;
static int sc2_h = 0;

rcvar_t vid_exports[] =
{
	RCV_INT("screenmode", &screenmode),
	RCV_INT("view_top", &view_top),
	RCV_INT("frameskip", &frameskip),
	RCV_BOOL("popope", &popope),

	RCV_BOOL("sc1"  , &sc1  ),
	RCV_INT( "sc1_x", &sc1_x),
	RCV_INT( "sc1_y", &sc1_y),
	RCV_INT( "sc1_l", &sc1_l),
	RCV_INT( "sc1_t", &sc1_t),
	RCV_INT( "sc1_w", &sc1_w),
	RCV_INT( "sc1_h", &sc1_h),
	RCV_BOOL("sc2"  , &sc2  ),
	RCV_INT( "sc2_x", &sc2_x),
	RCV_INT( "sc2_y", &sc2_y),
	RCV_INT( "sc2_l", &sc2_l),
	RCV_INT( "sc2_t", &sc2_t),
	RCV_INT( "sc2_w", &sc2_w),
	RCV_INT( "sc2_h", &sc2_h),
	
	RCV_END
};

struct fb fb;

static int initok = 0;

void setHWND(HWND w)
{
	wnd = w;
}
void vid_preinit()
{
	/* do nothing; only needed on systems where we must drop perms */
}

HBITMAP	fb_hbitmap;
HANDLE	fb_hDIB;


void setfb(int scr)
{
	char buf[128];
	int fbw[4] = {160,160,320,320};
	int fbh[4] = {144,144,288,288};
	int scl[4] = {  1,  1,  2,  2};
	int pth[4] = {640,640,640,640};
	int den[4] = {  1,  1,  2,  2};

	fb.pelsize = 2;
	fb.w  = fbw[scr];
	fb.h  = fbh[scr];
	fb.pitch = pth[scr];
	sprintf( buf, "set scale %d",scl[scr] );
	rc_command( buf );
	sprintf( buf, "set density %d",den[scr] );
	rc_command( buf );
}


void vid_init()
{

	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;
	word * vram;

	if (initok) return;
	
	joy_init();

	setfb(screenmode);
	fb.indexed = 0;
	fb.cc[0].r = 3;
	fb.cc[0].l = 11;
	fb.cc[1].r = 2;
	fb.cc[1].l = 5;
	fb.cc[2].r = 3;
	fb.cc[2].l = 0;
	fb.cc[3].r = 0;
	fb.cc[3].l = 0;
	fb.yuv = 0;
	fb.dirty = 0;
	fb.enabled = 1;
	
	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= 320;
	bi.biHeight			= -288;
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	fb_hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( fb_hDIB );
#else
	fb_hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( fb_hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	fb_hbitmap = CreateDIBSection( NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&vram, NULL, 0 );

#if _WIN32_WCE >= 300
	GlobalUnlock( fb_hDIB );
	GlobalFree( fb_hDIB );
#else
	LocalUnlock( fb_hDIB );
	LocalFree( fb_hDIB );
#endif

	if (vram == NULL)
		die("CreateDIBSection failed\n");

	fb.ptr =(unsigned char *) vram;

	initok = 1;
}

void vid_close()
{
	DEBUGLOG( "vid_close start\n" );
	if (!initok) return;

	DeleteObject( fb_hbitmap );

	joy_close();

	initok = 0;
	DEBUGLOG( "vid_close end\n" );
}

void key_poll();

void ev_poll()
{
	key_poll();
}

void vid_settitle(char *title)
{
	int len;
	wchar_t *title2;
	HWND wnd;

	len = strlen(title);
	title2 = (wchar_t *) malloc(sizeof(wchar_t) * (len + 1));
	mbstowcs(title2, title, len + 1);
	wnd = GetActiveWindow();
	SetWindowText(wnd, title2);
	free(title2);

}

void vid_setpal(int i, int r, int g, int b)
{
}

void vid_begin()
{
	static int skip = 0;
	skip = (skip + 1) % (frameskip > 0 ? frameskip + 1 : 1);
    fb.enabled = skip == 0;
	setfb(screenmode);
}

void vid_end()
{
	int x,y;
	HDC	hDC;
	HDC	hbDC;

	if (!fb.enabled) return;

	hDC = GetDC(wnd);
	hbDC = CreateCompatibleDC(hDC);
	SelectObject( hbDC, fb_hbitmap );

	switch (screenmode) {
	case 0:
		if(debug_trace){
			x = y = 0;
		}else{
			x = 240;
			y = 48;
		}
		if( popope ){
			x = 80; 
			y = 48;
		};
		BitBlt( hDC, x, y, 160, 144, hbDC,0,0,SRCCOPY ); 
		break;
	case 1:
		if( popope ){
			x = 40; 
			y = 5;
		}else{
			x = 200; 
			y = 5;
		}
	    StretchBlt( hDC, x, y, 240, 216, hbDC,0,0,160,144,SRCCOPY ); 
		break;
	case 2:
		if( popope ){
			x = y = 0;
		}else{
			x = 160; 
			y = 0;
		}
	    StretchBlt( hDC, x, y, 320, 240, hbDC,0,0,320,288,SRCCOPY ); 
		break;
	case 3:
		if( popope ){
			x = y = 0;
		}else{
			x = 160; 
			y = 0;
		}
	    BitBlt( hDC, x, y, 320, 240, hbDC,0,view_top, SRCCOPY ); 
		if( sc1 ) BitBlt( hDC, sc1_x, sc1_y, sc1_w, sc1_h, hbDC,sc1_l,sc1_t, SRCCOPY ); 
		if( sc2 ) BitBlt( hDC, sc2_x, sc2_y, sc2_w, sc2_h, hbDC,sc2_l,sc2_t, SRCCOPY ); 
		break;
	}

	ReleaseDC( wnd, hDC );
	DeleteDC( hbDC );
}

void vid_setscreenmode(int mode)
{
	screenmode = mode;
}

void vid_setframeskip(int skip)
{
	frameskip = skip;
}

static void paint160x144(word *vram, int landscape)
{
	word *fbptr;
	word *pixel;
//	int x;
	int y;

	pixel = vram;
	fbptr = (word *) fb.ptr;
/*
	for (y = 0; y < 144; y++) {
		for (x = 0; x < 160; x++) {
			*pixel++ = *fbptr++;
		}
		pixel+=80;
		fbptr++;
	}
*/
	for(y = 0; y < 144; y++ ) {
		memcpy( pixel, fbptr , 160*2 );
		pixel+=240;
		fbptr+=161;
	}
}

static void paint240x216(word *vram, int landscape)
{
	word *fbptr,*fbptr1,*fbptr2;
//	int fbpitch;
	word *line1,*line2,*line3,*pixel;
	int x, y;
//	word *p;

	pixel = vram;
	fbptr = (word *) fb.ptr;

/*
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;
		}
		pixel+=720;
		fbptr+=322;
	}
*/
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			// line1
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;
			// line2
			*line2++ = *fbptr2++;
			*line2++ = *fbptr2;
			*line2++ = *fbptr2++;
		}
		// line3
		memcpy( line3,pixel+240, 240*2 );
		pixel+=720;
		fbptr+=322;
	}
}

static void paint240x216s(word *vram, int landscape)
{
	word *fbptr,*fbptr1,*fbptr2;
//	int fbpitch;
	word *line1,*line2,*line3,*pixel;
	int x, y;
//	word *p;

	pixel = vram;
	fbptr = (word *) fb.ptr;

/*
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;
		}
		pixel+=720;
		fbptr+=322;
	}
*/
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			// line1
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;
			// line2
			*line2++ = *fbptr2++;
			*line2++ = *fbptr2;
			*line2++ = *fbptr2++;
		}
		// line3
//		memcpy( line3,pixel+240, 240*2 );
		pixel+=720;
		fbptr+=322;
	}
}

void vid_suspend()
{
//	GXSuspend();
}

void vid_resume()
{
//	GXResume();
}

/*
 * process hardware keys
 */

/* up, down, left, right, a, b, start, select, escape */
static int joy_code[9] = { 0, 0, 0, 0, 0, 0, 0, 0, 0 };

rcvar_t joy_exports[] =
{
	RCV_VECTOR("joy_code", joy_code, 9),
	RCV_END
};

void joy_init()
{

	setkeymap();

	if (!joy_code[0]) {
		joy_code[0] = 0x26;	// UP
		joy_code[1] = 0x28;	// DOWN
		joy_code[2] = 0x25;	// LEFT
		joy_code[3] = 0x27;	// RIGHT
		joy_code[4] = 0x58;	// X     ... A Button
		joy_code[5] = 0x5A;	// Z     ... B Button
		joy_code[6] = 0x53;	// S     ... Start
		joy_code[7] = 0x41;   // A     ... C ?
		joy_code[8] = 0x1B; // ESC
	}
}



void joy_close()
{
//	GXCloseInput();
}

int joy_process(MSG *msg)
{
	short vkKey = 0;
	event_t ev;

	vkKey = msg->wParam;
	if (msg->message == WM_KEYDOWN ) {
		ev.type = EV_PRESS;
		ev.code = keymap[vkKey];
/*		{
			LPTSTR buf;
            buf = (LPTSTR)malloc(256);
			wsprintf( buf, _T("key [%.4X]\n"), vkKey );
			OutputDebugString( buf );
			free(buf);
		}
*/
	} else if ( msg->message == WM_KEYUP){
		ev.type = EV_RELEASE;
		ev.code = keymap[vkKey];
	} else 
		return 0;

	/* posting a key event here may be inpolite, but actually works */
	ev_postevent(&ev);

	return 0;

}

void joy_poll()
{
}

} // extern "C"

void DebugPrint( int x, int y,wchar_t * buf )
{
	HDC		hdc;
	RECT	rect;
	hdc = GetDC(wnd);

	SetBkColor(hdc, RGB(0, 0, 0));
	SetTextColor(hdc, RGB(255, 255, 255));
	GetClientRect(wnd, &rect);
	rect.left = x;
	rect.top  = y;
	DrawText(hdc, buf, _tcslen(buf), &rect, DT_SINGLELINE | DT_TOP | DT_LEFT);

	ReleaseDC( wnd, hdc );
}

void ScrollDebugPrint( int x,int w, wchar_t * buf )
{
	HDC		hdc;
	hdc = GetDC(wnd);
	BitBlt( hdc, x, 0, w, 240, hdc,x,15,SRCCOPY ); 
	ReleaseDC( wnd, hdc );
	DebugPrint( x,225, buf );
}
