#include <stdlib.h>
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>

#include "..\..\rc.h"

char *getromname();
static char *romdir = 0;

rcvar_t wce_exports[] =
{
	RCV_STRING("romdir", &romdir),
	RCV_END
};

HWND wnd;

#ifndef POPOPE
char *getromname()
{
	OPENFILENAME openname;
	wchar_t name2[MAX_PATH];
	wchar_t dir[MAX_PATH];
	char *name;
	int len;

	memset(&openname, 0, sizeof(openname));
	openname.lStructSize	= sizeof(openname);
	openname.hwndOwner = wnd;
	openname.lpstrTitle = TEXT("gnuboy CE");
	openname.lpstrFilter =
		TEXT("GB Roms (*.gb;*.gbc;*.zip)\0*.gb;*.gbc;*.zip\0All Files (*.*)\0*.*\0");	
	name2[0] = '\0';
	openname.lpstrFile = name2;
	openname.nMaxFile = MAX_PATH;	
	openname.Flags = OFN_EXPLORER;
	if( romdir != 0 ){
		mbstowcs( dir, romdir, MAX_PATH );	
	}else{
		wcscpy( dir, _T("\\") );
	}
	openname.lpstrInitialDir = dir;
	if (!GetOpenFileName(&openname))
		return NULL;

	len = wcslen(openname.lpstrFile);
	name = (char *) malloc(sizeof(char) * (len + 1));
	wcstombs(name, openname.lpstrFile, len + 1);

	return name;
}
#else

HINSTANCE g_hModuleCDQ = 0;
int (pascal *GetCDQVer) (int);
int (pascal *FileDialog) (HWND,TCHAR*,TCHAR*,int);
/*
int (pascal *FolderDialog) (HWND,TCHAR*,TCHAR*,int);
int (pascal *FolderTree) (HWND,TCHAR*,TCHAR*);
COLORREF (pascal *ColorDialog) (HWND,COLORREF);
int (pascal *FontDialog) (HWND,TCHAR*,int,LOGFONT*);
*/

int CDQ_LoadLibrary();
void CDQ_FreeLibrary();

char *getromname()
{
	TCHAR name2[MAX_PATH];
	char *name;
	int ret,len;

	name2[0] = 0;

	// CDQ [h
	if (!CDQ_LoadLibrary()) {
		CDQ_FreeLibrary();
		MessageBox (wnd, _T("CDQ[hł܂"), NULL, MB_OK);
	}

	if( romdir != 0 ){
		mbstowcs( name2, romdir, MAX_PATH );	
	}
	wcscat( name2, _T("\\") );
	ret = FileDialog (		//߂lFIDOK/IDCANCEL
		wnd, 				//(i):eEChEEnh
		_T("GB ROM Select"),//(i):^Cg
		name2,			//(i/o):t@C
		1 );			//(i):݂t@Ĉ=1

	// CDQ J
	CDQ_FreeLibrary();

	if( ret==IDCANCEL ) return NULL;
	
	len = wcslen(name2);
	name = (char *) malloc(sizeof(char) * (len + 1));
	wcstombs(name, name2, len + 1);

	return name;

}

//---------------------------------------------------------------
// CDQ 
int CDQ_LoadLibrary()
{
	// DLL擾iWindowsfBNgɖƂ̓tpXŎw肷j
	g_hModuleCDQ = LoadLibrary (_T("CDQ.DLL"));
	if (g_hModuleCDQ == 0) {
		return FALSE;
	}

	// e֐̃AhX擾
	GetCDQVer = (int (pascal *) (int)) 
			GetProcAddress (g_hModuleCDQ, TEXT("GetCDQVer"));
	if (GetCDQVer == 0) return FALSE;	//G[

	FileDialog = (int (pascal *) (HWND,TCHAR*,TCHAR*,int)) 
			GetProcAddress (g_hModuleCDQ, TEXT("FileDialog"));
	if (FileDialog == 0) return FALSE;	//G[

/*
	FolderDialog = (int (pascal *) (HWND,TCHAR*,TCHAR*,int)) 
			GetProcAddress (g_hModuleCDQ, TEXT("FolderDialog"));
	if (FolderDialog == 0) return FALSE;	//G[

	FolderTree = (int (pascal *) (HWND,TCHAR*,TCHAR*)) 
			GetProcAddress (g_hModuleCDQ, TEXT("FolderTree"));
	if (FolderTree == 0) return FALSE;	//G[

	ColorDialog = (COLORREF (pascal *) (HWND,COLORREF)) 
			GetProcAddress (g_hModuleCDQ, TEXT("ColorDialog"));
	if (ColorDialog == 0) return FALSE;	//G[

	FontDialog = (int (pascal *) (HWND,TCHAR*,int,LOGFONT*)) 
			GetProcAddress (g_hModuleCDQ, TEXT("FontDialog"));
	if (FontDialog == 0) return FALSE;	//G[
*/
	return TRUE;
}

//---------------------------------------------------------------
// CDQ ㏈
void CDQ_FreeLibrary()
{
	// DLLJ
	if (g_hModuleCDQ)
		FreeLibrary (g_hModuleCDQ);
	g_hModuleCDQ = 0;
}
//---------------------------------------------------------------

#endif