#include <stdlib.h>
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <sipapi.h>
#include <afx.h>

#include "resource.h"

extern "C" {

#include "..\..\Version"
#include "..\..\defs.h"
#include "..\..\input.h"
#include "..\..\rc.h"

#include "stdfile.h"

int MAIN(int argc, char *argv[]);
void die(char *fmt, ...);
int rc_setvar(char *name, int c, char **v);
int rc_getint(char *name);
void vid_setscreenmode(int mode);
void vid_setframeskip(int skip);
void vid_suspend();
void vid_resume();
void vid_close();
int joy_process(MSG *msg);
int rc_command(char *line);
void pcm_close();

#define STR_LEN 100
#define DOTDIR "\\My Documents\\gnuboy"
#define MENU_HEIGHT 26

static int paused = 0;

static HINSTANCE inst = NULL;
static HWND wnd = NULL;
static HWND cbar = NULL;
static HACCEL accel = NULL;

int emu_stop = 0;

extern setHWND(HWND w);

/*
 * standard C functions missing in Win CE
 */

time_t time(time_t* t)
{
	CTime ctime = CTime::GetCurrentTime();
	return ctime.GetTime();
}

char * strdup(const char *src)
{
//	printf( "strdup [%s]\n", src );
	char * dst = (char*)malloc( strlen( src )+1 );
	strcpy( dst, src );
	return dst;
}

char * _strlwr( char * a )
{
//	printf( "_strlwr start [%s]\n", a );
	while( *a ) { 
		*a= tolower(*a);
		a++;
	}
//	printf( "_strlwr end \n" );
	return a;
}

#if _WIN32_WCE < 300
int isalpha( int a )
{
//	printf( "isalpha \n" );
	if( ((a>='A')&&(a<='Z')) || ((a>='a')&&(a<='z')) ) return 1;
	return 0;
}

int isdigit( int a )
{
//	printf( "isalpha \n" );
	if( (a>='0')&&(a<='9') ) return 1;
	return 0;
}

int isalnum( int a )
{
//	printf( "isalnum \n" );
	if( isalpha(a) && isdigit(a) ) return 1;
	return 0;
}

char * strpbrk(char * line, char * str )
{
	unsigned int i;
//	printf( "strpbrk \n" );
	while( *line ){
		for( i=0;i<strlen(str);i++ ){
			if( *line == str[i] ){
//				printf( "strpbrk lookup end \n" );
				return line;
			}
		}
		line++;
	}
//	printf( "strpbrk no lookup end \n" );
	return NULL;
}
#endif

int strcasecmp(const char *a, const char *b)
{
	int r;
//	printf( "strcasecmp start [%s] [%s] \n", a, b );
	char * a1 = strdup( a );		
	char * b1 = strdup( b );
	_strlwr(a1);
	_strlwr(b1);
	r = strcmp(a1, b1);
	free(a1);
	free(b1);
//	printf( "strcasecmp end [%d]\n",r );
	return r;
}

static int _vprintf(const char *fmt, va_list ap)
{
	char buf[STR_LEN];
	wchar_t buf2[STR_LEN];
	int len;
	
	len = vsprintf(buf, fmt, ap);
	mbstowcs(buf2, buf, len + 1);
	OutputDebugString(buf2);

	return len;
}

#if _WIN32_WCE >= 300
int printf(const char *fmt, ...)
{
	va_list ap;
	int len;
	
	va_start(ap, fmt);
	len = _vprintf(fmt, ap);
	va_end(ap);

	return len;
}
#else
///////////////////////////////////////////
char *  strrchr(const char * buf, int chr)
{
	size_t cnt;
	char *p;

	if( (cnt = strlen(buf)) ==(size_t)0 ) return NULL;
	p =(char*)buf + cnt;
	while(p>=buf){
		if(*p == chr) return p;
		p--;
	}
	return NULL;
}
#endif
/*
 * emulator code
 */

static void checksaveslot(int slot)
{
	HMENU menu;

//	menu = (HMENU) SendMessage(cbar, SHCMBM_GETSUBMENU, 0, IDM_FILE);
	menu = CommandBar_GetMenu(cbar,0);
	CheckMenuRadioItem(menu, IDM_SAVE_SLOT_0, IDM_SAVE_SLOT_9,
					   IDM_SAVE_SLOT_0 + slot, MF_BYCOMMAND);
}

static void checkscreenmode(int mode)
{
	HMENU menu;

//	menu = (HMENU) SendMessage(cbar, SHCMBM_GETSUBMENU, 0, IDM_TOOLS);
	menu = CommandBar_GetMenu(cbar,0);
	CheckMenuRadioItem(menu, IDM_SCREEN_MODE_160X144,IDM_SCREEN_MODE_320X288,
					   IDM_SCREEN_MODE_160X144 + mode, MF_BYCOMMAND);
}

static void checkframeskip(int frameskip)
{
	HMENU menu;

//	menu = (HMENU) SendMessage(cbar, SHCMBM_GETSUBMENU, 0, IDM_TOOLS);
	menu = CommandBar_GetMenu(cbar,0);
	CheckMenuRadioItem(menu, IDM_FRAME_RATE_60, IDM_FRAME_RATE_10,
					   IDM_FRAME_RATE_60 + frameskip, MF_BYCOMMAND);
}

void *sys_timer()
{
	ULARGE_INTEGER *tm;

	SYSTEMTIME st;

	GetSystemTime(&st);
	tm = (ULARGE_INTEGER *) malloc(sizeof(ULARGE_INTEGER));
	SystemTimeToFileTime(&st, (FILETIME *) tm);

	return tm;
}

int sys_elapsed(void *prev)
{
	int usecs;

	SYSTEMTIME st;
	ULARGE_INTEGER tm, *pr;

	GetSystemTime(&st);
	SystemTimeToFileTime(&st, (FILETIME *) &tm);
	pr = (ULARGE_INTEGER *) prev;
	usecs = (int) (tm.QuadPart - pr->QuadPart) / 10;
	*pr = tm;

	return usecs;
}

extern void state_save(int n);			

void sys_quit()
{
	state_save(999);			
	pcm_close();
	vid_close();
	DestroyWindow(wnd);
	exit(0);
}

static void processmessage(MSG *msg)
{
	if (!TranslateAccelerator(msg->hwnd, accel, msg)) {
		TranslateMessage(msg);
		DispatchMessage(msg);
	}
}

static void pause(MSG *bdownmsg)
{
	RECT rt;
	MSG msg;
	int cmd;
	int key;
	int ret;
	int arg;
	char scmd[64];
//	event_t ev;

	vid_suspend();

	CommandBar_Show(cbar,true);

	paused = 1;
	GetClientRect(wnd, &rt);
	InvalidateRect(wnd, &rt, 1);
	UpdateWindow(wnd);

	checksaveslot(rc_getint("saveslot"));
	checkscreenmode(rc_getint("screenmode"));
	checkframeskip(rc_getint("frameskip"));
	processmessage(bdownmsg);

	while (GetMessage(&msg, NULL, 0, 0)) {
		processmessage(&msg);

		if (msg.message == WM_COMMAND) {
			cmd = LOWORD(msg.wParam);
			key = 0;
			ret = 0;
			switch (cmd) {
			case IDM_SAVE_SLOT_0:
			case IDM_SAVE_SLOT_1:
			case IDM_SAVE_SLOT_2:
			case IDM_SAVE_SLOT_3:
			case IDM_SAVE_SLOT_4:
			case IDM_SAVE_SLOT_5:
			case IDM_SAVE_SLOT_6:
			case IDM_SAVE_SLOT_7:
			case IDM_SAVE_SLOT_8:
			case IDM_SAVE_SLOT_9:
				arg = cmd - IDM_SAVE_SLOT_0;
				sprintf( scmd, "set saveslot %d",arg);
				rc_command(scmd);
				checksaveslot(arg);
				break;
			case IDM_SAVE:
				rc_command( "savestate" );
				ret = 1;
				break;
			case IDM_LOAD:
				rc_command( "loadstate" );
				ret = 1;
				break;
			case IDM_RESUME:
				ret = 1;
				break;
			case IDM_EXIT:
				rc_command( "quit" );
				ret = 1;
				break;
			case IDM_SCREEN_MODE_160X144:
			case IDM_SCREEN_MODE_240X216:
			case IDM_SCREEN_MODE_320X240:
			case IDM_SCREEN_MODE_320X288:
				arg = cmd - IDM_SCREEN_MODE_160X144;
				checkscreenmode(arg);
				vid_setscreenmode(arg);
				break;
			case IDM_FRAME_RATE_60:
			case IDM_FRAME_RATE_30:
			case IDM_FRAME_RATE_20:
			case IDM_FRAME_RATE_15:
			case IDM_FRAME_RATE_12:
			case IDM_FRAME_RATE_10:
				arg = cmd - IDM_FRAME_RATE_60;
				checkframeskip(arg);
				vid_setframeskip(arg);
				break;
			}

			if (ret) {
				vid_resume();
				break;
			}
//		}else if(msg.message == WM_LBUTTONDOWN) {
//			break;
		}
	}

	paused = 0;
	CommandBar_Show(cbar,false);
	GetClientRect(wnd, &rt);
	InvalidateRect(wnd, &rt, 1);
	UpdateWindow(wnd);
}

static void suspend(MSG *killfocusmsg)
{
	MSG msg;

	vid_suspend();
	processmessage(killfocusmsg);

	while (GetMessage(&msg, NULL, 0, 0)) {
		processmessage(&msg);

		if (msg.message == WM_SETFOCUS) {
			vid_resume();
			break;
		}
	}
}

void key_poll()
{
	MSG msg;

	/* ignore sleep duration us */

	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
		if (joy_process(&msg))
			continue;

		switch (msg.message) {
		case WM_PAINT:
			processmessage(&msg);
			break;
		case WM_LBUTTONDOWN:
			pause(&msg);
			break;
		case WM_KILLFOCUS:
			suspend(&msg);
			break;
		default:
			/* dispose message; is it OK? */
			break;
		}
	}
}


void sys_sleep(int us)
{
#if 0
//	int ms;
	MSG msg;

	/* ignore sleep duration us */

	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
		if (joy_process(&msg))
			continue;

		switch (msg.message) {
		case WM_PAINT:
			processmessage(&msg);
			break;
		case WM_LBUTTONDOWN:
			pause(&msg);
			break;
		case WM_KILLFOCUS:
			suspend(&msg);
			break;
		default:
			/* dispose message; is it OK? */
			break;
		}
	}
#endif 
}

void sys_checkdir(char *path, int flg)
{
	wchar_t path2[MAX_PATH];
	DWORD attr;
	char *p;
	DEBUGLOG( "sys_checkdir start [%s]\n" , path );	
	mbstowcs(path2, path, strlen(path) + 1);
	attr = GetFileAttributes(path2);
    if (attr == 0xFFFFFFFF) {
		p = strrchr(path, '\\');
		if (!p) die("descended to root trying to create dirs\n");
		*p = 0;
		sys_checkdir(path, flg);
		*p = '\\';
		if (!CreateDirectory(path2, NULL))
			die("cannot create %s: %lu\n", path, GetLastError());
	}
	DEBUGLOG( "sys_checkdir end\n" , path );	
}

void sys_initpath(char *exe)
{
	char *var[1];
	char *rcpath;
	char *exepath;
	char *end;
	int len;

	exepath = (char *) malloc(sizeof(char) * strlen(exe));
	if ((end = strrchr(exe, '\\')) == NULL)
		rcpath = DOTDIR;
	else {
		len = end - exe;
		strncpy(exepath, exe, len);
		exepath[len] = '\0';
		rcpath = (char *)
			malloc(sizeof(char) * (strlen(DOTDIR) + len + 2));
		sprintf(rcpath, "%s;" DOTDIR, exepath);
	}
	var[0] = rcpath;
	rc_setvar("rcpath", 1, var);

	var[0] = DOTDIR;
	rc_setvar("savedir", 1, var);

	free( rcpath );
	free( exepath );
}

void sys_sanitize(char *s)
{
}

#if 0
void die(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	_vfprintf(fp,fmt, ap);
	va_end(ap);
	fclose(fp);
	exit(1);
}
#endif

/*
 * initialization
 */

static LRESULT CALLBACK aboutbox(HWND dlg, UINT message,
								 WPARAM wpar, LPARAM lpar)
{
//	SHINITDLGINFO info;
	char version[STR_LEN];
	wchar_t version2[STR_LEN];

	switch (message) {
	case WM_INITDIALOG:
		sprintf(version, "Version %s", VERSION);
		mbstowcs(version2, version, strlen(version) + 1);
		SetWindowText(GetDlgItem(dlg, IDC_VERSION), version2);
/*		info.dwMask = SHIDIM_FLAGS;
		info.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN |
			SHIDIF_SIZEDLGFULLSCREEN;
		info.hDlg = dlg;
		SHInitDialog(&info);
*/		return 1; 
	case WM_COMMAND:
		if (LOWORD(wpar) == IDOK) {
			EndDialog(dlg, LOWORD(wpar));
			return 1;
		}
		break;
	}

    return 0;
}

static HWND createcommandbar(HWND wnd)
{
	HWND hcb;
	BOOL res;
	hcb = CommandBar_Create( inst, wnd, 1 );
	res = CommandBar_InsertMenubar( hcb, inst, IDM_MENU, 0 );	
	return hcb;
}

static LRESULT CALLBACK windowproc(HWND wnd, UINT message,
								   WPARAM wpar, LPARAM lpar)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rect;

	switch (message) {
	case WM_COMMAND:
		switch (LOWORD(wpar)) {	
		case IDM_ABOUT:
			DialogBox(inst, (LPCTSTR) IDD_ABOUTBOX, wnd, (DLGPROC) aboutbox);
			break;
		case IDOK:
			SendMessage(wnd, WM_ACTIVATE, MAKEWPARAM(WA_INACTIVE, 0), (LPARAM) wnd);
			SendMessage(wnd, WM_CLOSE, 0, 0);
			break;
		default:
			return DefWindowProc(wnd, message, wpar, lpar);
		}
		break;
	case WM_CREATE:
		cbar = createcommandbar(wnd);
/*		{
			HWND hwndTBar = FindWindow( _T("HHTaskBar"),NULL);
			ShowWindow(hwndTBar, SW_HIDE);
		}
*/
		break;
	case WM_PAINT: 
		hdc = BeginPaint(wnd, &ps);
		if (paused) {
			wchar_t str[STR_LEN];
			LoadString(inst, IDS_PAUSE, str, STR_LEN);
			SetBkColor(hdc, RGB(0, 0, 0));
			SetTextColor(hdc, RGB(255, 255, 255));
			GetClientRect(wnd, &rect);
			DrawText(hdc, str, _tcslen(str), &rect, 
					 DT_SINGLELINE | DT_VCENTER | DT_CENTER);
		}
		EndPaint(wnd, &ps);
		break; 
	case WM_DESTROY:
/*		CommandBar_Destroy(cbar);
		{
			HWND hwndTBar = FindWindow(_T("HHTaskBar"),NULL);
			ShowWindow(hwndTBar, SW_SHOW);
		}
*/
		PostQuitMessage(0);
		break;
	case WM_SETTINGCHANGE:
//		SHHandleWMSettingChange(wnd, wpar, lpar, &actinfo);
		break;
	default:
		return DefWindowProc(wnd, message, wpar, lpar);
   }

   return 0;
}

static ATOM registerclass(HINSTANCE inst, LPTSTR szWindowClass)
{
	WNDCLASS wclass;

    wclass.style = CS_HREDRAW | CS_VREDRAW ;
    wclass.lpfnWndProc = (WNDPROC) windowproc;
    wclass.cbClsExtra = 0;
    wclass.cbWndExtra = 0;
    wclass.hInstance = inst;
    wclass.hIcon = LoadIcon(inst, MAKEINTRESOURCE(IDI_GNUBOY));
    wclass.hCursor = 0;
    wclass.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);
    wclass.lpszMenuName = 0;
    wclass.lpszClassName = szWindowClass;

	return RegisterClass(&wclass);
}

static int initinstance(HINSTANCE inst1, int show)
{
	wchar_t	title[STR_LEN];
	wchar_t	wclass[STR_LEN];
	RECT rect;

	inst = inst1;
	LoadString(inst, IDC_GNUBOY, wclass, STR_LEN);
	LoadString(inst, IDS_APP_TITLE, title, STR_LEN);

	if (wnd = FindWindow(wclass, title)) {
		SetForegroundWindow((HWND) (((DWORD) wnd) | 0x01));    
		return 0;
	} 
	
	registerclass(inst, wclass);
	if (!(wnd = CreateWindow(wclass, title, WS_VISIBLE /*| WS_EX_TOPMOST*/,
							 CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
							 CW_USEDEFAULT, NULL, NULL, inst, NULL)))
		return 0;

	
	GetWindowRect(wnd, &rect);
//	rect.bottom -= MENU_HEIGHT;
	if (cbar)
		MoveWindow(wnd, rect.left, rect.top, rect.right, rect.bottom, 0);

//	SetWindowPos(wnd, HWND_TOPMOST,rect.left, rect.top, rect.right, rect.bottom,SWP_SHOWWINDOW);

	ShowWindow(wnd, show);
	UpdateWindow(wnd);

	setHWND(wnd);

	return 1;
}

int WINAPI WinMain(HINSTANCE inst, HINSTANCE previnst,
				   LPTSTR cmdline, int show)
{
//	MSG msg;
	int ret;
	int argc;
	char **argv;
	LPTSTR cmd;
	if (!initinstance(inst, show))
		return 0;
	accel = LoadAccelerators(inst, (LPCTSTR)IDC_GNUBOY);

	argc = 2;
	argv = (char **) malloc(sizeof(char *) * 2);

	cmd =(LPTSTR) malloc(256);
	argv[0] = (char*)malloc(256);
	ret = GetModuleFileName(inst,cmd,256);
	ret = wcstombs(argv[0],cmd,256); 
	free(cmd);

	if( wcslen(cmdline) ){
		argv[1] = (char*)malloc(256);
		ret = wcstombs(argv[1],cmdline,256); 
		DEBUGLOG( "cmdline ari argv[1]=%s \n", argv[1] ); 
	}else{
		DEBUGLOG( "cmdline nasi\n" ); 
		argv[1] = NULL;
	}
/*
	if ((argv[1] = getromname()) == NULL)
		return 0;
*/

#ifndef DEBUG
//	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_TIME_CRITICAL);
//	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_HIGHEST);
#endif

	CommandBar_Show(cbar,false);

	MAIN(argc, argv);

	return 0;
}

}
