/*---------------------------------------------------------------------------------
---------------------------------------------------------------------------------*/
#include <nds.h>
//#include <dswifi7.h>
#include <nds/fifocommon.h>
#include <nds/fifomessages.h>


//---------------------------------------------------------------------------------
//  GB audio driver
//---------------------------------------------------------------------------------
void apu_init()
{
}

void apu_play()
{
}

void apu_pause()
{
}

void apu_write(int adr, int data )
{
}

void apu_read( int adr )
{
}

//---------------------------------------------------------------------------------
//  GB apu FIFO driver
//---------------------------------------------------------------------------------
typedef enum {
	APU_INIT  = 0x80000000,
	APU_PLAY  = 0x40000000,
	APU_PAUSE = 0x20000000,
	APU_WRITE = 0x08000000,
	APU_READ  = 0x04000000,
} ApuCommands;

void apuCommandHandler(u32 command, void* userdata)
{
	int cmd  = (command & 0xFF000000 )     ;
	int data = (command & 0x000000FF )     ;
	int adr  = (command & 0x00FFFF00 ) >> 8;
	
	switch(cmd)
	{
	case APU_INIT:
		apu_init();
		break;
	case APU_PLAY:
		apu_play();
		break;
	case APU_PAUSE:
		apu_pause();
		break;
	case APU_WRITE:
		apu_write( adr, data );
		break;
	case APU_READ:
		apu_read( adr );
		break;
	default: 
		break;
	}
}

void installApu(){
//	fifoSetDatamsgHandler(FIFO_USER_01, soundDataHandler, 0);
	fifoSetValue32Handler(FIFO_USER_01, apuCommandHandler, 0);
}

//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
void VcountHandler() {
	inputGetAndSend();
}

//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
void VblankHandler(void) {
//	Wifi_Update();
}

//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
int main() {

	irqInit();
	fifoInit();

//	mmInstall(FIFO_MAXMOD);

	SetYtrigger(80);

//	installWifiFIFO();
//	installSoundFIFO();

	installApu();

	installSystemFIFO();
	
	irqSet(IRQ_VCOUNT, VcountHandler);
	irqSet(IRQ_VBLANK, VblankHandler);

	// Start the RTC tracking IRQ
	initClockIRQ();

	irqEnable( IRQ_VBLANK | IRQ_VCOUNT | IRQ_NETWORK);   

	// read User Settings from firmware
	readUserSettings();

	// Keep the ARM7 mostly idle
	while (1) swiWaitForVBlank();
}


