#ifndef __GRAPH_H__
#define __GRAPH_H__

#include <nds.h>

#define RGB16(a,r,g,b)  RGB15(r,g,b)|((a)<<15)
#define pset8( GFX, X,Y, COL )	(*((uint8* )(GFX) + ((Y)*256+(X)) ) = (COL) )
#define pset16( GFX, X,Y, COL )	(*((uint16*)(GFX) + ((Y)*256+(X)) ) = (COL) )

extern int clsColor8[2];
extern int clsColor16[2];

void LOG( char * str , ... );
void die(char *fmt, ...);
void iDeasDebug();
void iDeasMessage(char * str, ... );


void line8( uint8 * gfx , int x, int y, int w, int h, uint8 col );
void box8( uint8 * gfx, int x,int y,int w,int h, uint8 col );
void fill8( uint8 * gfx, int x,int y,int w,int h,uint8 col );
void cls8(int g);
void drawWindow8( uint8 * gfx, int x, int y , int w, int h );
void drawButton8( uint8 * gfx, int x, int y , int w, int h, u8 * buf );
void drawFont8( uint8 * gfx, u16 fx, u16 fy, u8 chr, u8 col, u8 bcol );
void drawFont8trans( uint8 * gfx, u16 fx, u16 fy, u8 chr, u8 col );
void drawText8( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col, u8 bcol );
void drawText8trans( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col );
void drawFontExt8( uint8 * gfx, u16 fx, u16 fy, u16 chr, u8 col, u8 bcol );
void drawFontExt8trans( uint8 * gfx, u16 fx, u16 fy, u16 chr, u8 col );
void drawTextExt8( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col, u8 bcol );
void drawTextExt8trans( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col );
void copyGraph8( uint8 * dgfx, u16 dx, u16 dy, uint8 * sgfx, u16 sx, u16 sy, u16 width, u16 height );
void drawIcon8( uint8 * gfx, int x, int y, int w, int h, u8 * buf );

void box16( uint16 * gfx, int x,int y,int w,int h,uint16 col );
void line16( uint16 * gfx, int x,int y,int w,int h,uint16 col );
void fill16( uint16 * gfx, int x,int y,int w,int h,uint16 col );
void drawFont16( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol );
void drawText16( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol );
int  loadFont( char * fn , int h, int wh, int wz );
void drawFontExt16( uint16 * gfx, u16 fx, u16 fy, u16 chr, u16 col, u16 bcol );
void drawTextExt16( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol );
void copyGraph16( uint16 * dgfx, u16 dx, u16 dy, uint16 * sgfx, u16 sx, u16 sy, u16 width, u16 height );
void drawIcon16( uint16 * gfx, int x, int y, int w, int h, u16 * buf );
void cls16( int g );
void drawWindow16( uint16 * gfx, int x, int y , int w, int h );
void drawButton16( uint16 * gfx, int x, int y , int w, int h ,u8 * buf);

#endif
