//////////////////////////////////////////////////////////////////////
// tgbdualDS
//////////////////////////////////////////////////////////////////////
#include <NDS.h>
#include <fat.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "loader.h"
#include "emu.h"
#include "vid.h"

#include "DSGraph.h"

//static bool sram_transfer_rest=false;
bool b_running=false;

void waitForVBlank(int cnt)
{
	int i;
	for(i=0;i<cnt;i++){
		swiWaitForVBlank();
	}
}


void HBlankHandler(void) __attribute__ ((no_instrument_function));
void VBlankHandler(void) __attribute__ ((no_instrument_function));
void VCountHandler(void) __attribute__ ((no_instrument_function));

void HBlankHandler(void)
{
/*
	if( IME ){
		if( IF & HBLANK ){
			FLG = 1;
		}
	}
*/
}

void VBlankHandler(void)
{
/*
	if( IME ){
		if( IF & VBLANK ){
			FLG = 1;
		}
	}
*/
}

void VCountHandler(void)
{
/*
	if( IME ){
		if( IF & VCOUNT ){
			FLG = 1;
		}
	}
*/
}

void KeysHandler(void)
{
}

void Timer0Handler(void)
{

}

void InitInterruptHandler()
{
//	irqInit();
//	irqSet(IRQ_HBLANK, HBlankHandler);
//	irqSet(IRQ_VBLANK, VBlankHandler);
//	irqSet(IRQ_VCOUNT, VCountHandler);
//	irqSet(IRQ_KEYS  , KeysHandler);
//	irqSet(IRQ_TIMER0, Timer0Handler);
//	irqEnable( IRQ_HBLANK | IRQ_VBLANK | IRQ_VCOUNT /*| IRQ_KEYS |IRQ_TIMER0 */);
}

void InitDS()
{
	int i;

    // ̃EFCgƎgp̐ݒ
//	REG_EXMEMCNT = 0xE880;

	//荞ݏ
	InitInterruptHandler();

	// VRAMoNݒ
	vramSetBankA(VRAM_A_MAIN_BG_0x06000000    );		// 128k
	vramSetBankB(VRAM_B_MAIN_SPRITE_0x06400000);		// 128k
	vramSetBankC(VRAM_C_SUB_BG_0x06200000     );		// 128k
	vramSetBankD(VRAM_D_SUB_SPRITE            );		// 128k 0x06600000
//	vramSetBankE(VRAM_E_TYPE e);		//  64k
//	vramSetBankF(VRAM_F_TYPE f);		//  16k
//	vramSetBankG(VRAM_G_TYPE g);		//  16k
//	vramSetBankH(VRAM_H_TYPE h);		//  32k
//	vramSetBankI(VRAM_I_TYPE i);		//  16k

	// LCD̃CƃTuւ
//	lcdSwap();

	//fBXvC[h̐ݒ(REG_DISPCNT)
	videoSetMode   (MODE_0_2D | DISPLAY_BG0_ACTIVE | DISPLAY_BG1_ACTIVE ); // | DISPLAY_BG2_ACTIVE | DISPLAY_BG3_ACTIVE); 
	videoSetModeSub(MODE_5_2D | DISPLAY_BG3_ACTIVE ); //| DISPLAY_BG1_ACTIVE);

	//obNOEh̐ݒ(REG_BGxCNT)
	BACKGROUND.control[0] = BG_32x32 | BG_COLOR_16 | BG_WRAP_ON  | BG_PRIORITY_1 | BG_MAP_BASE(0) | BG_TILE_BASE(1);  // BG
	BACKGROUND.control[1] = BG_32x32 | BG_COLOR_16 | BG_WRAP_OFF | BG_PRIORITY_0 | BG_MAP_BASE(0) | BG_TILE_BASE(1);  // WIN

//	BACKGROUND.control[2] = BG_32x32 | BG_COLOR_16 | BG_WRAP_ON  | BG_PRIORITY_2 | BG_MAP_BASE(2) | BG_TILE_BASE(1);  // map1
//	BACKGROUND.control[3] = BG_32x32 | BG_COLOR_16 | BG_WRAP_ON  | BG_PRIORITY_3 | BG_MAP_BASE(3) | BG_TILE_BASE(2);  // map2

	// \ʒu
	BACKGROUND.scroll[0].x = 0;
	BACKGROUND.scroll[0].y = 0;
	BACKGROUND.scroll[1].x = 0;
	BACKGROUND.scroll[1].y = 0;
	BACKGROUND.scroll[2].x = 0;
	BACKGROUND.scroll[2].y = 0;
	BACKGROUND.scroll[3].x = 0;
	BACKGROUND.scroll[3].y = 0;

	//TuʃobNOEhݒ
	BACKGROUND_SUB.control[2] = BG_BMP8_256x256;
	BACKGROUND_SUB.control[3] = BG_BMP8_256x256;

	// \ʒu
	BACKGROUND_SUB.bg2_rotation.xdx = (1 << 8);
	BACKGROUND_SUB.bg2_rotation.xdy = 0;
	BACKGROUND_SUB.bg2_rotation.ydx = 0;
	BACKGROUND_SUB.bg2_rotation.ydy = (1 << 8);
	BACKGROUND_SUB.bg2_rotation.dx  = 0;
	BACKGROUND_SUB.bg2_rotation.dy  = 0;

	BACKGROUND_SUB.bg3_rotation.xdx = (1 << 8);
	BACKGROUND_SUB.bg3_rotation.xdy = 0;
	BACKGROUND_SUB.bg3_rotation.ydx = 0;
	BACKGROUND_SUB.bg3_rotation.ydy = (1 << 8);
	BACKGROUND_SUB.bg3_rotation.dx  = 0;
	BACKGROUND_SUB.bg3_rotation.dy  = 0;


	// pbg`
	u16 pal[] = { ARGB16(1,29,29,29), ARGB16(1,15,15,15), ARGB16(1,10,10,10), ARGB16(0,0,0,0) };
//	u16 pal[] = { ARGB16(1,6,6,6), ARGB16(1,4,4,4), ARGB16(1,2,2,2), ARGB16(0,0,0,0) };
	for( i=0;i<4;i++ ) BG_PALETTE_SUB[i] = BG_PALETTE[i] = pal[i];

	// eAhX擾
	GB_MAP[0]     = (u16*)BG_MAP_RAM(0);			// BG MAP 0      -> BG_MAP_BASE(0)
	GB_MAP[1]     = (u16*)BG_MAP_RAM(1);			// BG MAP 1      -> BG_MAP_BASE(1)
	GB_TILE[0][0] = (u8*)BG_TILE_RAM(1);			// BANK 0 TILE 0 -> BG_TILE_BASE(1)
	GB_TILE[1][0] = (u8*)BG_TILE_RAM(1) + 0x4000;	// BANK 1 TILE 0 -> BG_TILE_BASE(1) + 0x4000;
	GB_TILE[0][1] = (u8*)BG_TILE_RAM(2);			// BANK 0 TILE 1 -> BG_TILE_BASE(2)
	GB_TILE[1][1] = (u8*)BG_TILE_RAM(2) + 0x4000;   // BANK 1 TILE 1 -> BG_TILE_BASE(2) + 0x4000;
	
	// BG MAP eXg
	u16 * map1=(u16*)BG_MAP_RAM(2);
	u16 * map2=(u16*)BG_MAP_RAM(3);
	for( i=0;i<256;i++ ){
		*map2 = *map1 = i;
		map1++;
		map2++;
	}

}

int InitFAT()
{
	int ret;
//LOG("InitFAT 1");
	ret = fatInitDefault();
	if( !ret ){
		LOG( "fatInitDefault() Error." );
	    while(1) waitForVBlank(1);
	}
//	LOG( "fatInitDefault() OK" );

	return true;
}

#define MAX_PATH 768
char rom_name[MAX_PATH];
char sav_name[MAX_PATH];
char rtc_name[MAX_PATH];


int OSDMenu( int flg )
{
	strcpy( rom_name, "fat:/mario.gb" );
	return 1;
}

int main(int ac, char*av[])
{
//	iDeasDebug();
//	iDeasMessage( "Start gnuboyDS Debug" );

	InitDS();		//DS
//LOG( "main 0" );
	InitFAT();		//t@CVXe

//	cygprofile_begin();
//	cygprofile_enable();
//LOG( "main 1" );

	while( OSDMenu( b_running ) ){
//LOG( "main 2" );
		loader_init(rom_name);
//LOG( "main 3" );
		emu_reset();
		emu_run();
	}
LOG( "main 4" );

	while(1) swiWaitForVBlank();
	return 0;
}

