#include <nds.h>
#include <string.h>

#include "defs.h"
#include "regs.h"
#include "lcd.h"
#include "hw.h"

#include "DSGraph.h"

un16 * GB_MAP[2];
un8  * GB_TILE[2][2];

/* GB LCDC
  Bit 7 - LCD \                        (0=Off, 1=On)
  Bit 6 - EBhE^C}bvAhX      (0=9800-9BFF, 1=9C00-9FFF)
  Bit 5 - EBhE\                  (0=Off, 1=On)
  Bit 4 - BG & EBhE^Cf[^AhX (0=8800-97FF, 1=8000-8FFF)
  Bit 3 - BG ^C}bvAhX             (0=9800-9BFF, 1=9C00-9FFF)
  Bit 2 - OBJ (XvCg)TCY              (0=8x8, 1=8x16)
  Bit 1 - OBJ (XvCg) \           (0=Off, 1=On)
  Bit 0 - BG \ (CGB͉LQ)         (0=Off, 1=On)
*/
void vid_set_LCDC(byte old ,byte b )
{
iDeasMessage( "vid_set_LCDC OLD:%2X -> NEW:%2X",old, b );
	byte chg = b ^ old;
	if( chg & 0x80 ){	// LCD disp
		if( b & 0x80 ){
			if( b & 0x01 ){
				videoBgEnable(0);
			}else{
				videoBgDisable(0);
			}
			if( b & 0x20 ){
				videoBgEnable(1);
			}else{
				videoBgDisable(1);
			}
			if( b & 0x02 ){
				REG_DISPCNT |= DISPLAY_SPR_ACTIVE;
			}else{
				REG_DISPCNT &= (~DISPLAY_SPR_ACTIVE);
			}
		}else{
			videoBgDisable(0);
			videoBgDisable(1);
			REG_DISPCNT &= (~DISPLAY_SPR_ACTIVE);
		}
	}else{
		if( chg & 0x01 ){
			if( b & 0x01 ){	// bg disp
				videoBgEnable(0);
			}else{
				videoBgDisable(0);
			}
		}
		if( chg  & 0x20  ){
			if( b & 0x20 ){	// win disp
				videoBgEnable(1);
			}else{
				videoBgDisable(1);
			}
		}
		if( chg & 0x02 ){
			if( b & 0x02 ){	// obj disp
				REG_DISPCNT |= DISPLAY_SPR_ACTIVE;
			}else{
				REG_DISPCNT &= (~DISPLAY_SPR_ACTIVE);
			}
		}
	}
	if( chg & 0x04 ){	// obj size
		// SXvCg̃TCYύX
		u16 * adr = (u16*)OAM;
		int i;
		int s = (b&0x04)?0xB000:0x0000;
		for(i=0;i<40;i++ ){
			adr[i*4] = ( adr[i*4] & 0xC000 ) | s;
		}
	}
	if( chg & 0x08 ){	// bg map adr
		REG_BG0CNT = (REG_BG0CNT & 0xE0FF) | ((b&0x08)?1:0)<<8;
	}
	if( chg & 0x10 ){	// bg & win tile data adr
		REG_BG0CNT = (REG_BG0CNT & 0xFFF3) | ((b&0x10)?1:2)<<2;
		REG_BG1CNT = (REG_BG1CNT & 0xFFF3) | ((b&0x10)?1:2)<<2;
	}
	if( chg & 0x40 ){	// win map adr
		REG_BG1CNT = (REG_BG1CNT & 0xE0FF) | ((b&0x40)?1:0)<<8;
	}
}


void vid_bg_write(int a, byte b)
{
	u16 *b0,*b1;
	u16 *s;
	u16 *m;
	u8 t1, t2;

// | GB TILE |      DS TILE
// |BNK0|BNK1|
// | A  |  D |     | A | C |
// | B  |  E |     | B | B |
// | C  |  F |     | D | F |
//                 | E | E |

	if( a < 0x1800 ){	// BG^C
		a &= 0xFFFE;
		t1 = lcd.vbank[R_VBK&1][a];
		t2 = lcd.vbank[R_VBK&1][a+1];

		if( a < 0x800 ){
			b0 = (u16*)GB_TILE[R_VBK&1][0] + a;
			b1 = (u16*)NULL;
			s  = (u16*)SPRITE_GFX          + a;
		}else if( a < 0x1000 ){
			b0 = (u16*)GB_TILE[R_VBK&1][0] + a;
			b1 = (u16*)GB_TILE[R_VBK&1][1] + a;
			s  = (u16*)SPRITE_GFX          + a;
		}else{
			a -= 0x1000;
			b0 = (u16*)GB_TILE[R_VBK&1][1] + a;
			b1 = (u16*)NULL;
			s  = (u16*)NULL;
		}
		*(b0  ) = ((t1&0x80)>>7) | ((t1&0x40)>>2) | ((t1&0x20)<<3) | ((t1&0x10)<<8) |
		 		  ((t2&0x80)>>6) | ((t2&0x40)>>1) | ((t2&0x20)<<4) | ((t2&0x10)<<9);
		*(b0+1) = ((t1&0x08)>>3) | ((t1&0x04)<<2) | ((t1&0x02)<<7) | ((t1&0x01)<<12)|
				  ((t2&0x08)>>2) | ((t2&0x04)<<3) | ((t2&0x02)<<8) | ((t2&0x01)<<13);
		if( b1 ){
			*(b1  ) = *(b0  );
			*(b1+1) = *(b0+1);
		}
		if( s ){
			*(s  ) = *(b0  );
			*(s+1) = *(b0+1);
		}
	}else{				// map , atr
		a -= 0x1800;
		if( a < 0x400 ){
			m = GB_MAP[0] +  a ;
		}else{
			m = GB_MAP[1] + (a-0x400);
		}

		// GB ATR :         RVH0BPPP
		// GB MAP :         NNNNNNNN
		// NDS    : 0PPPVH0BNNNNNNNN
		if( R_VBK&1 ){				// bank 1 (atr)
			*m = (*m&0x00FF) | (b&7<<12) | (b&8<<5) | (b&0x60<<5);
		}else{						// bank 0 (map)
			*m = (*m&0xFF00) | b;
		}
	}
}


//  0  
//  1  邢DF
//  2  ÂDF
//  3  
static int dmg_pal[4] = { ARGB16(1,25,25,25), ARGB16(1,18,18,18) , ARGB16(1,12,12,12), ARGB16(1,6,6,6) };

// GBBGpbgݒ
void vid_pal_write_bg(byte b)
{
	u16 * paladr =(u16*)BG_PALETTE;	// BG̃pbg 0
	paladr[0] = dmg_pal[( b    &0x03)];
	paladr[1] = dmg_pal[((b>>2)&0x03)];
	paladr[2] = dmg_pal[((b>>4)&0x03)];
	paladr[3] = dmg_pal[((b>>6)&0x03)];
}
// GBSPRpbgݒ
void vid_pal_write_obj(int p, byte b)
{
	u16 * paladr =(u16*)SPRITE_PALETTE + (p*16);	// SPR̃pbg 0 or 1
	paladr[0] = 0x0000;	// K
	paladr[1] = dmg_pal[((b>>2)&0x03)];
	paladr[2] = dmg_pal[((b>>4)&0x03)];
	paladr[3] = dmg_pal[((b>>6)&0x03)];
}

// GBCpbgݒ
void vid_pal_write_col(int i, byte b)
{
	u8 * paladr =(u8*)( (i<64) ? BG_PALETTE : SPRITE_PALETTE );
	int a = (i&0x38)<<2 | (i&0x7);
	if( a & 1 ) b | 0x80;	/* alpha bit */
	paladr[a] = b;
}
//	GB
//
//          Y(0-255)            
//
//          X(0-255)            
//
//          PAT(0-255)          
//
//PRHFVFPGBK   PLC    
//
//  Y   : YW
//  X   : XW
//  PAT : p^[
//  PR  : d
//  HF  : ] 
//  VF  : ]
//  PG  : pbg(GB)
//  BK  : oN 
//  PLC : pbg(GBC)
//
/*	DS
    
   0 SHP  CPMS MOD  OD 0          Y(0-255)            
    
   1 SIZ  HFVF                        X(0-511)            
    
   2   PAL          PRI                IDX(0-1023)            
    
   3                                                              
    
  SHP : OBJ ̌`             (0=lp,1=`,2=c`,3=֎~)
  CP  : F^pbg         (0=16F/16pbg, 1=256F/1pbg)
  MS  : OBJ UCN           (0=Off, 1=On)
  MOD : OBJ [h             (0=ʏ, 1=, 2=OBJEBhE, 3=֎~)
  OD  : OBJ \             (0=\, 1=\)  (bit8  0 ̎)
  Y   : Y W                 (0-255)
  SIZ : OBJTCY              (0..3, OBJ ̌`ɂقȂ )
                                TCY  lp          c
                                  0      8x 8    16x 8     8x16
                                  1     16x16    32x 8     8x32
                                  2     32x32    32x16    16x32
                                  3     64x64    64x32    32x64
  HF  : ]               (0=Normal, 1=Mirrored)   (When bit8 is 0)
  VF  : ]               (0=Normal, 1=Mirrored)   (When bit8 is 0)
  X   : X W                 (0-511)
  PAL : pbgԍ           (0-15)  (256F/1pbg͖gp)
  PRI : BGƂ̃vCIeB   (0-3; 0 ō)
  IDX : ^Cԍ             (0-1023)
*/
void vid_oam_write( int a , byte b )
{
	u16 * adr = (u16*)OAM + (a&0xFC);
//iDeasDebug();
//iDeasMessage( "OAM Write[%d] = %d", a, b );
	switch( a&0x03 ){
	case 0:		// Y W
		adr[0] = (adr[0] & 0xFF00) | (((int)b-16)&0xFF);
		break;
	case 1:		// X W
		adr[1] = (adr[1] & 0xFF00) | (((int)b-8)&0xFF);
		break;
	case 2:		// pat
		adr[2] = (adr[2]&0xFF00) | b;
		break;
	case 3:		// atr,pal,bank,pri
		adr[2] = (adr[2]&0xFEFF) | ((b&0x08)<<5);						// BANK
		adr[2] = (adr[2]&0x0FFF) | (hw.cgb?(b&0x07)<<12:(b&0x10)<<8);	// PAL(GBC or GB)
		adr[1] = (adr[1]&0xCFFF) | ((b&0x60)<<7);						// XY]
//		adr[2] = (adr[2]&0xF3FF) | ((b&0x80)<<3);						// PRI
		break;
	}
}

void vid_scroll_bg(byte r, byte b)
{
	switch( r ){
	case RI_SCY:
		BACKGROUND.scroll[0].y = b;
		break;
	case RI_SCX:
		BACKGROUND.scroll[0].x = b;
		break;
	case RI_WY:
		BACKGROUND.scroll[1].y = b;
		break;
	case RI_WX:
		BACKGROUND.scroll[1].x = b;
		break;
	}
}

