
#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "defs.h"
#include "regs.h"
#include "hw.h"
#include "lcd.h"

#include "vid.h"

struct lcd lcd;

void pal_write(int i, byte b)
{
	if (lcd.pal[i] == b) return;
	lcd.pal[i] = b;
	vid_pal_write_col( i, b );
}

void pal_dirty()
{
	if (!hw.cgb)
	{
		vid_pal_write_bg(R_BGP);
		vid_pal_write_obj(0, R_OBP0);
		vid_pal_write_obj(1, R_OBP1);
	}
}

void lcd_reset()
{
	memset(&lcd, 0, sizeof lcd);
	pal_dirty();
}

