

#include <stdlib.h>

#include "defs.h"
#include "hw.h"
#include "cpu.h"
#include "regs.h"
#include "lcd.h"

#include "vid.h"

#define C (cpu.lcdc)

/*
  GB STAT (FF41h) R/W
  
    LEOEVEHECF MOD  
  
  Bit 6 - LE - LYC=LY v荞          (1=) (ǂݏ)
  Bit 5 - OE - [h2 OAM 荞         (1=) (ǂݏ)
  Bit 4 - VE - [h1 V-Blank 荞     (1=) (ǂݏ)
  Bit 3 - HE - [h0 H-Blank 荞     (1=) (ǂݏ)
  Bit 2 - CF - vtO      (0:LYC<>LY, 1:LYC=LY) (ǂݍ݂̂)
  Bit 1-0 MOD- [htO           ([h 0-3) (ǂݍ݂̂)
            0: H-Blank
            1: V-Blank
            2: OAM-RAM T?
            3: LCDhCof[^]

LY(FF44h) R
  
                LY              
  
 Bit 7-0 LY - kbchCo[֓]Ăf[^ǂ̃C
     0`143 : ʂ̃C
   144`153 : VBlank
 LCDCWX^̃rbg7  1  0 ɂ LY ̒l 0 ɂȂB

LYC(FF45h) R/W
  
                LYC             
  
 Bit 7-0 LYC - v荞݂郉C
     0`143 : ʂ̃C
   144`153 : VBlank?
kxb͂kxƔr郌WX^[łkxƈvƂrs`sWX^[̈v
tOZbg܂B


// NDS //

  NDS DISPSTAT
  
            VC(0-?)                   CEHEVECFHFVF
  
  Bit   Expl.
  8-15  V-Count Setting            (0-?)
  6-7   Not used
  5     V-Counter IRQ Enable       (1=Enable)
  4     H-Blank IRQ Enable         (1=Enable)
  3     V-Blank IRQ Enable         (1=Enable)
  2     V-Counter flag (Read only) (1=Match )
  1     H-Blank flag   (Read only) (1=HBlank)
  0     V-Blank flag   (Read only) (1=VBlank)
*/

/*
 * stat_trigger updates the STAT interrupt line to reflect whether any
 * of the conditions set to be tested (by bits 3-6 of R_STAT) are met.
 * This function should be called whenever any of the following occur:
 * 1) LY or LYC changes.
 * 2) A state transition affects the low 2 bits of R_STAT (see below).
 * 3) The program writes to the upper bits of R_STAT.
 * stat_trigger also updates bit 2 of R_STAT to reflect whether LY=LYC.
 */

void stat_trigger()
{
	static const int condbits[4] = { 0x08, 0x30, 0x20, 0x00 };
	int flag = 0;

	if ((R_LY < 0x91) && (R_LY == R_LYC))
	{
		R_STAT |= 0x04;
		if (R_STAT & 0x40) flag = IF_STAT;
	}
	else R_STAT &= ~0x04;

	if (R_STAT & condbits[R_STAT&3]) flag = IF_STAT;

	if (!(R_LCDC & 0x80)) flag = 0;
	
	hw_interrupt(flag, IF_STAT);
}

void stat_write(byte b)
{
	R_STAT = (R_STAT & 0x07) | (b & 0x78);
	if (!hw.cgb && !(R_STAT & 2)) /* DMG STAT write bug => interrupt */
		hw_interrupt(IF_STAT, IF_STAT);
	stat_trigger();
}


/*
 * stat_change is called when a transition results in a change to the
 * LCD STAT condition (the low 2 bits of R_STAT).  It raises or lowers
 * the VBLANK interrupt line appropriately and calls stat_trigger to
 * update the STAT interrupt line.
 */

static void stat_change(int stat)
{
	stat &= 3;
	R_STAT = (R_STAT & 0x7C) | stat;

	if (stat != 1) hw_interrupt(0, IF_VBLANK);
	/* hw_interrupt((stat == 1) ? IF_VBLANK : 0, IF_VBLANK); */
	stat_trigger();
}


void lcdc_change(byte b)
{
	byte old = R_LCDC;
	R_LCDC = b;
	vid_set_LCDC(old, b);
	if ((R_LCDC ^ old) & 0x80) /* lcd on/off change */
	{
		R_LY = 0;
		stat_change(2);
		C = 40;
//		lcd_begin();
	}
}


void lcdc_trans()
{
	//LCD\
	if (!(R_LCDC & 0x80))
	{
		// LCDCJE^0ȉ̏ꍇAXe[^XύX
		while (C <= 0)
		{
			switch ((byte)(R_STAT & 3))
			{
			case 0:						// HBlankI
			case 1:						// VBlankI
				stat_change(2);			// AOAMANZXɃXe[^XύX
				C += 40;
				break;
			case 2:						// OAMANZXI
				stat_change(3);			// OAM ,VRAMANZXɃXe[^XύX
				C += 86;
				break;
			case 3:						// OAM ,VRAMANZXI
				stat_change(0);			// HBlankɕύX
				if (hw.hdma & 0x80)		// hdmaJnȂ hdmas
					hw_hdma();
				else
					C += 102;
				break;
			}
		}
		return;							// 2s(whileŌ)ړ
	}

	// LCD\
	while (C <= 0)
	{
		switch ((byte)(R_STAT & 3))
		{
		case 1:
			if (!(hw.ilines & IF_VBLANK))
			{
				C += 218;
				hw_interrupt(IF_VBLANK, IF_VBLANK);
				break;
			}
			if (R_LY == 0)
			{
				stat_change(2);
				C += 40;
				break;
			}
			else if (R_LY < 152)
				C += 228;
			else if (R_LY == 152)
				C += 28;
			else
			{
				R_LY = -1;
				C += 200;
			}
			R_LY++;
			stat_trigger();
			break;
		case 2:
			stat_change(3);
			C += 86;
			break;
		case 3:
			stat_change(0);
			if (hw.hdma & 0x80)
				hw_hdma();
			/* FIXME -- how much of the hblank does hdma use?? */
			/* else */
			C += 102;
			break;
		case 0:
			if (++R_LY >= 144)
			{
				if (cpu.halt)
				{
					hw_interrupt(IF_VBLANK, IF_VBLANK);
					C += 228;
				}
				else C += 10;
				stat_change(1);
				break;
			}
			stat_change(2);
			C += 40;
			break;
		}
	}
}







